/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     camera_exp_util.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintend    o
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 50270 $
 *---------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/types.h>
#include <nn/version.h>

#include <nn/camera.h>

#include <stdio.h>

#include "util.h"
#include "camera_manager.h"
#include "y2r_manager.h"
#include "tp_manager.h"
#include "key_manager.h"
#include "graphics.h"
#include "setting_menu.h"

#include "scene_setting.h"
#include "scene_manager.h"
#include "graphics.h"

#include "demo.h"
#include "demo/Render/demo_RenderSystemExt.h"

#define  debug_print    NN_LOG

// =============================================================================
// J̏o͉摜TCY
#define CAMERA_WIDTH    512
#define CAMERA_HEIGHT   384

// g~Ỏ摜̕ƍ
#define WIDTH           512
#define HEIGHT          384

// eNX`̃TCY
#define TEXTURE_WIDTH   512
#define TEXTURE_HEIGHT  512

//==============================================================================
namespace {
    
    struct DebugInfo_st
    {
        s32 stateCam1;
        s32 stateCam2;
        s32 errorCam1;
        s32 errorCam2;
        s32 stateY2r;
    };
    DebugInfo_st s_DebugInfo = { -1, -1, 0, 0, -1 };

    nn::fnd::TimeSpan s_Y2rTime;

} //namespace

//==============================================================================
namespace {

    /** ݂̐ݒ
     */

    nn::camera::CameraSelect s_CurrentCamera  = nn::camera::SELECT_OUT1_OUT2;// SELECT_NONE;
    nn::camera::Context      s_CurrentContext = nn::camera::CONTEXT_A;

    // \̏
    bool                     s_IsDrawHelp          = false;     // wv(L[oCh)\邩ǂ

    // Y2RϊWύX邩ǂ
    nn::y2r::StandardCoefficient s_Y2rCoefficient  = nn::y2r::COEFFICIENT_ITU_R_BT_709;// vÔƂƂ̒lƍ킹// COEFFICIENT_ITU_R_BT_601;

    //  (ǂ̉̔ʑ̂dȂ悤ɂ邩Œ)
    f32 s_Distance = 500.0f;
    f32 s_Parallax = 0.0f;

    // StopCapture ̒ɑXbh StartCapture Ă΂Ȃ悤ɔr
    nn::os::CriticalSection  sa_CsCapture[ 2 ];

    // Y2RϊY2R̐ݒύXȂ悤ɔr
    nn::os::CriticalSection  s_CsY2r;

    // Lu[Vf[^
    nn::camera::StereoCameraCalibrationData s_CalData;

    // Xbh
    void CameraThreadFunc( uptr param );
    void Y2rConversionThreadFunc( uptr param );
//    void PeriodicShutterThreadFunc( uptr param );

    enum
    {
        THREAD_CAMERA_1,
        THREAD_CAMERA_2,
        THREAD_Y2R,
//        THREAD_PERIODIC_SHUTTER,

        THREAD_MAX
    };

    nn::os::Thread   sa_Thread[ THREAD_MAX ];

    // XbhI炷߂̒ʒm
    nn::os::Event    sa_ThreadEndEvent[ THREAD_MAX ];

    // Y2RJn邽߂̒ʒm
    nn::os::Event    sa_Y2rStartEvent[ 2 ];

    // Y2RI邽߂̒ʒm
    nn::os::Event    s_Y2rForceEndEvent;

    // J̃Lv`ċN邽߂̒ʒm
    nn::os::Event    sa_CameraCaptureRestartEvent[ 2 ];

    // tTCYLv`Jn邽߂̒ʒm
    nn::os::Event    sa_CameraFullSizeCaptureStartEvent[ 2 ];

    // tTCYLv`̊̒ʒm
    nn::os::Event    sa_CameraFullSizeCaptureEndEvent[ 2 ];

    // tTCYLv`̎s̒ʒm
    nn::os::Event    sa_CameraFullSizeCaptureFailEvent[ 2 ];

    // tTCYLv`摜Y2RJn邽߂̒ʒm
    nn::os::Event    sa_Y2rFullSizeStartEvent[ 2 ];

    // tTCYLv`摜Y2R̊ʒm
    nn::os::Event    sa_Y2rFullSizeEndEvent[ 2 ];

    // tTCYLv`摜Y2RϊACK
    // (Y2RĊJȂ悤ɑ҂邽߂̂)
    nn::os::Event    s_Y2rFullSizeAckEvent;

    // Xbhp[^
    void ( * spa_ThreadFunc[ THREAD_MAX ] )( uptr arg ) =
    {
        CameraThreadFunc,
        CameraThreadFunc,
        Y2rConversionThreadFunc,
//        PeriodicShutterThreadFunc,
    };
    uptr sa_ThreadArg[ THREAD_MAX ] =
    {
        static_cast< uptr >( nn::camera::PORT_CAM1 ),
        static_cast< uptr >( nn::camera::PORT_CAM2 ),
        0,
//        0,
    };
    s32 sa_ThreadSize[ THREAD_MAX ] =
    {
        8192,
        8192,
        8192,
//        8192,
    };
    s32 sa_ThreadPriorityOffset[ THREAD_MAX ] =
    {
        -3,
        -3,
        -2,
//         0,
    };

    // t[JE^
    int s_Count = 1;

    // ʂɉ摜\p Texture ID
    GLuint s_TextureBottom[ 2 ] = { 0, 0 };

} //namespace

//==============================================================================
namespace
{
    //==============================================================================
    /** ݒ胂[h
     */
    enum
    {
        INITIALIZE_MODE_NORMAL = 0,

        INITLALIZE_MODE_MAX
    };
    s32 s_InitializeMode = INITIALIZE_MODE_NORMAL;

} //namespace

//==============================================================================
namespace {

    /** j[\NX
     */
    camera_exp::SettingMenu_cl< demo::RenderSystemExt, s32 > s_Menu;

    /** j[̗
     */
    enum
    {
        e_MENU_SIZE = 0,

        e_MENU_NUM,

        e_MENU_LIMIT      = 31   // tO̖肪邽32܂
    };

    /** j[̊eڂ̒`
     */
    // TCY
    const char *spa_SizeNameList[ nn::camera::CAMERA_SIZE_MAX ] =
    {
        "VGA  (640x480)",
    };

    const char *spa_DisplayModeList[ 4 ] =
    {
        "3D",
        "Blend",
        "OUT R",
        "OUT L",
    };

    /** j[̐ݒli[{
     */
    camera_exp::SettingMenuItem_st sa_MenuItem[ e_MENU_NUM ];

    /** j[̃ftHgl
     *  JCu Initialize ɃJW[邱ƂɂȂ̂
     *  Scene  Initialize ɖftHglɖ߂Kv
     */
    int menu_counter = 0;
    const camera_exp::SettingMenuItem_st sa_DefaultMenuItem[ e_MENU_NUM ] =
    {
        {0.f, 16.f+( 8*(menu_counter++) ), "Size      ", spa_SizeNameList, nn::camera::CAMERA_SIZE_MAX, false, 0, 0, 0, NULL,
            {
                { { { nn::camera::SIZE_DS_LCDx4, nn::camera::SIZE_DS_LCDx4, }, 
                    { nn::camera::SIZE_DS_LCDx4, nn::camera::SIZE_DS_LCDx4, } } },   // e_INDEX_OUT1
                { { { nn::camera::SIZE_DS_LCDx4, nn::camera::SIZE_DS_LCDx4, }, 
                    { nn::camera::SIZE_DS_LCDx4, nn::camera::SIZE_DS_LCDx4, } } },   // e_INDEX_IN1
                { { { nn::camera::SIZE_DS_LCDx4, nn::camera::SIZE_DS_LCDx4, }, 
                    { nn::camera::SIZE_DS_LCDx4, nn::camera::SIZE_DS_LCDx4, } } },   // e_INDEX_OUT2
            },
            true, true, true },

    }; //MenuItem_st sa_MenuItem[]

    //==============================================================================
    void SetCamera( void )
    {
        // v擾
        s32 request = s_Menu.GetRequest();
        s_Menu.SetRequest( 0 );

        if( request == 0 )
        {
            return;
        }
        // ݂̃JXgbvׂ|[g肷
        nn::camera::Port stoppedPort = camera_exp::GetPort( s_CurrentCamera );

        if( stoppedPort & nn::camera::PORT_CAM1 )
        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ 0 ] );

            nn::camera::StopCapture( nn::camera::PORT_CAM1 );
            while( nn::camera::IsBusy( nn::camera::PORT_CAM1 ) )
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
            }
        }
        if( stoppedPort & nn::camera::PORT_CAM2 )
        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ 1 ] );

            nn::camera::StopCapture( nn::camera::PORT_CAM2 );
            while( nn::camera::IsBusy( nn::camera::PORT_CAM2 ) )
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
            }
        }

        if( request & (1 << e_MENU_SIZE) )
        {
            nn::camera::Size arg = static_cast< nn::camera::Size >
                            ( s_Menu.GetContextItem( e_MENU_SIZE, 0, 0 ).decided );

            size_t trimWidth     = camera_exp::GetTrimmingWidthInTexture( arg );
            size_t trimHeight    = camera_exp::GetTrimmingHeightInTexture( arg );
            size_t textureWidth  = camera_exp::GetTextureWidth( arg );
            size_t textureHeight = camera_exp::GetTextureHeight( arg );

            // SJɔf
            for( int i=0; i < 2; i++ )
            {
                nn::camera::Port port = ( i == 0 ) ? nn::camera::PORT_CAM1 : nn::camera::PORT_CAM2;

                // I/F ̂ StartCapture Ȃ悤ɂĂ
                nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ i ] );

                // StartCapture Ă\̂Ŏ~߂
                nn::camera::StopCapture( port );
                while( nn::camera::IsBusy( port ) )
                {
                    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
                }

                camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( i );
                cm.SetSize( arg, trimWidth, trimHeight );
                cm.ClearBuffer();
            }

            // ݒ肪I܂ŕϊ̊Jn҂
            nn::os::CriticalSection::ScopedLock sl( s_CsY2r );

            camera_exp::Y2rManager_cl::ClearBuffer();
            camera_exp::Y2rManager_cl::SetSize(
                trimWidth, trimHeight,
                textureWidth, textureHeight,
                true, s_Y2rCoefficient, nn::y2r::OUTPUT_RGB_24, nn::y2r::BLOCK_8_BY_8 );
            camera_exp::Y2rManager_cl::ClearBuffer();
        }

        nn::Result result = nn::ResultSuccess();

        // ݂̃JĊJ|[g肷
        nn::camera::Port restartPort = camera_exp::GetPort( s_CurrentCamera );

        if( restartPort & nn::camera::PORT_CAM1 )
        {
            sa_CameraCaptureRestartEvent[ 0 ].Signal();
        }
        if( restartPort & nn::camera::PORT_CAM2 )
        {
            sa_CameraCaptureRestartEvent[ 1 ].Signal();
        }

    } //SetCamera()
} //namespace
//==============================================================================
namespace {

    //==============================================================================
    /** |[gƔzCfbNX̕ϊ
     */
    inline s32 GetPortIndex( nn::camera::Port port )
    {
        return ( (port == nn::camera::PORT_CAM1) ? 0 : 1 );
    }

    //==============================================================================
    /** JDMA]I̖{(nhXbhĂ΂)
     */
    void CameraDmaFunc( nn::camera::Port port )
    {
        camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( GetPortIndex( port ) );

        // ̃t[̂߂ɃJDMAċN
        cm.SwapBuffer();
        cm.StartDmaRecv();

        // Y2Rϊ˗
        if( port == nn::camera::PORT_CAM1 )
        {
            sa_Y2rStartEvent[ 0 ].Signal();
        }
        else
        {
            sa_Y2rStartEvent[ 1 ].Signal();
        }
    }

    //==============================================================================
    /** JG[荞݃nh̖{(nhXbhĂ΂)
     */
    void CameraErrorFunc( nn::camera::Port port )
    {
        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

            // Lv`~
            nn::camera::StopCapture( port );
            while( nn::camera::IsBusy( port ) )
            {
                debug_print( "busy polling %d.\n", (s32)( port ) );
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
            }
            nn::camera::ClearBuffer( port );
        }

        //debug_print( "camera_sample: error occured. port = %d.\n", static_cast<s32>( port ) );
        s32 & count = ( port == nn::camera::PORT_CAM1 ) ? s_DebugInfo.errorCam1 : s_DebugInfo.errorCam2;
        count++;

        // DMA ƃLv`̍ċN
        camera_exp::OcamManager_cl::GetCameraManager( GetPortIndex( port ) ).StartDmaRecv();
        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );
            nn::camera::StartCapture( port );
        }
    }

    //==============================================================================
    /** JVsync荞݃nh̖{(nhXbhĂ΂)
     */
    void CameraVsyncFunc( nn::camera::Port port )
    {
        camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( GetPortIndex( port ) );

        // Vsync̃^C~O擾
        cm.GetLatestVsyncTiming( 2 );

        // t[[ǧv
        cm.CalcFrameRate();

        return;
    }

    //==============================================================================
    /** J̃tTCYLv`(nhXbhĂ΂)
     */
    void CameraFullSizeCapture( nn::camera::Port port, nn::os::Event & endEvent, nn::os::Event & failEvent )
    {
        camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( GetPortIndex( port ) );

        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

            // tTCYLv`sȂ߂ɂ͓]TCY̕ύXKvȂ̂
            // Lv`~
            nn::camera::StopCapture( port );
            while( nn::camera::IsBusy( port ) )
            {
                debug_print( "busy polling %d.\n", static_cast< s32 >( port ) );
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
            }
            nn::camera::ClearBuffer( port );
        }

        // tTCYLv`̊Jn
        cm.ReadyFullSizeCapture();
        cm.StartDmaRecvFullSize();

        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

            nn::camera::StartCapture( port );
        }

        // Lv`҂
        nn::os::Event *pa_FullSizeEvent[ 2 ] =
        {
            cm.GetEventPointer( camera_exp::CameraManager_cl::e_EVENT_DMA ),
            cm.GetEventPointer( camera_exp::CameraManager_cl::e_EVENT_ERROR ),
        };
        s32 num = nn::os::WaitObject::WaitAny( 
                        reinterpret_cast<nn::os::WaitObject**>( pa_FullSizeEvent ),
                        2 );

        // ӂ̃Lv`ɖ߂߂ɍĂуLv`~߂ 
        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

            nn::camera::StopCapture( port );
            while( nn::camera::IsBusy( port ) )
            {
                debug_print( "busy polling %d.\n", static_cast< s32 >( port ) );
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
            }
            nn::camera::ClearBuffer( port );
        }

        // ʏ̓]ĊJ
        cm.ExitFullSizeCapture();
        cm.StartDmaRecv();

        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

            nn::camera::StartCapture( port );
        }

        // sʒm
        if( num == 0 )
        {
            endEvent.Signal();
        }
        else
        {
            failEvent.Signal();
        }
    } //CameraFullSizeCapture();

    //==============================================================================
    /** JDMA]/Vsync荞݃nhXbh
     */
    void CameraThreadFunc( uptr param )
    {
        nn::camera::Port port = static_cast<nn::camera::Port>( param );

        camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( GetPortIndex( port ) );

        // DMȀN
        cm.StartDmaRecv();

        // XbhICxg
        nn::os::Event & threadEndEvent = ( port == nn::camera::PORT_CAM1 )
                                         ? sa_ThreadEndEvent[ THREAD_CAMERA_1 ]
                                         : sa_ThreadEndEvent[ THREAD_CAMERA_2 ];
        threadEndEvent.Initialize( false );

        // DMA̍ċNCxg
        nn::os::Event & captureRestartEvent = sa_CameraCaptureRestartEvent[ GetPortIndex( port ) ];
        captureRestartEvent.Initialize( false );

        s32 & debugInfo = ( port == nn::camera::PORT_CAM1 )
                          ? s_DebugInfo.stateCam1 : s_DebugInfo.stateCam2;

        // tTCYLv`̊JnƏI
        nn::os::Event & fullStartEvent = sa_CameraFullSizeCaptureStartEvent[ GetPortIndex( port ) ];
        nn::os::Event & fullEndEvent   = sa_CameraFullSizeCaptureEndEvent[ GetPortIndex( port ) ];
        nn::os::Event & fullFailEvent  = sa_CameraFullSizeCaptureFailEvent[ GetPortIndex( port ) ];
        fullStartEvent.Initialize( false );
        fullEndEvent.Initialize( false );
        fullFailEvent.Initialize( false );

        while( 1 )
        {
            // {DMA]ƃG[/Vsync̃nhXbh𕪂
            // DMASetReceivingDMA]Ip̃Cxg}ςĂ܂
            // event->Wait() ő҂ĂƑ݂ȂCxgWaitĂ܂ƂN
            // ŃJDMAN/ċN\̂CxgɂĂ
            // WaitAny ő҂Ƃɂđ݂ȂCxgWaitP[XȂ

            nn::os::Event *pa_Event[ 5 ] =
            {
                cm.GetEventPointer( camera_exp::CameraManager_cl::e_EVENT_DMA ),
                cm.GetEventPointer( camera_exp::CameraManager_cl::e_EVENT_ERROR ),
                cm.GetEventPointer( camera_exp::CameraManager_cl::e_EVENT_VSYNC ),
                &fullStartEvent,
                &threadEndEvent,
            };
            s32 num = nn::os::WaitObject::WaitAny( 
                            reinterpret_cast<nn::os::WaitObject**>( pa_Event ),
                            5 );

            if( num == 4 )
            {
                // Lv`~߂ăXbhI邱Ƃ
                // ȍ~ StartCapture Ă΂Ȃ悤ɂB
                {
                    nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

                    nn::camera::StopCapture( port );
                    while( nn::camera::IsBusy( port ) )
                    {
                        debug_print( "busy polling %d.\n", static_cast< s32 >( port ) );
                        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1 ) );
                    }
                    nn::camera::ClearBuffer( port );
                }
                break;
            }

            // VuN荞ݏ
            if( num == 0 )
            {
                CameraDmaFunc( port );

                if( cm.GetEvent( camera_exp::CameraManager_cl::e_EVENT_VSYNC ).Wait( 0 ) )
                {
                    CameraVsyncFunc( port );

                    // G[JύXȂǂł̃Lv`ĊJ
                    if( captureRestartEvent.Wait( 0 ) )
                    {
                        cm.StartDmaRecv();
                        {
                            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

                            nn::camera::ClearBuffer( port );    // Ô
                            nn::camera::StartCapture( port );
                        }
                    }
                }
            }
            else if( num == 1 )
            {
                CameraErrorFunc( port );
            }
            else if( num == 2 )
            {
                debugInfo = 2;

                CameraVsyncFunc( port );

                // G[JύXȂǂł̃Lv`ĊJ
                if( captureRestartEvent.Wait( 0 ) )
                {
                    cm.StartDmaRecv();
                    {
                        nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ GetPortIndex( port ) ] );

                        nn::camera::ClearBuffer( port );    // Ô
                        nn::camera::StartCapture( port );
                    }
                }
                else if( cm.GetEvent( camera_exp::CameraManager_cl::e_EVENT_DMA ).Wait( 0 ) )
                {
                    CameraDmaFunc( port );
                }
            }
            else if( num == 3 )
            {
                // tTCYLv`
                CameraFullSizeCapture( port, fullEndEvent, fullFailEvent );
            }
            nn::os::Thread::Yield();
        } //while

        threadEndEvent.Finalize();
        captureRestartEvent.Finalize();
        fullStartEvent.Finalize();
        fullEndEvent.Finalize();
        fullFailEvent.Finalize();
        debug_print( "thread end cam %d.\n", static_cast< s32 >( port ) );
    } //CameraThreadFunc()

    //==============================================================================
    /** Y2Rϊ
     *  @arg [in] ǂ̃J
     *  @arg [in] tTCYϊǂ
     */
    void Y2rConversion( const s32 num, const bool isFullSize )
    {
        camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( num );

        s_DebugInfo.stateY2r = 1;

        size_t iw = 0;
        size_t ih = 0;
        size_t tw = 0;
        size_t th = 0;
        bool   isCenter = false;
        nn::y2r::StandardCoefficient coefficient = nn::y2r::COEFFICIENT_ITU_R_BT_709;// vÔƂƂ̒lƍ킹// COEFFICIENT_ITU_R_BT_601;COEFFICIENT_ITU_R_BT_601;
        nn::y2r::OutputFormat   format = nn::y2r::OUTPUT_RGB_24;
        nn::y2r::BlockAlignment alignment = nn::y2r::BLOCK_8_BY_8;

        // tTCYϊ̂ƂY2RݒύX
        if( isFullSize )
        {
            // ݂̐ݒޔ
            camera_exp::Y2rManager_cl::GetSize(
                &iw,
                &ih,
                &tw,
                &th,
                &isCenter,
                &coefficient,
                &format,
                &alignment );

            camera_exp::Y2rManager_cl::SetSize(
                cm.GetWidth(),
                cm.GetHeight(),
                cm.GetWidth(),
                cm.GetHeight(),
                false,
                s_Y2rCoefficient,
                nn::y2r::OUTPUT_RGB_24,
                nn::y2r::BLOCK_LINE );

        }

        nn::os::Tick prev = nn::os::Tick::GetSystemCurrent();

        {
            // ϊ͐ݒύXłȂ悤ɂ
            nn::os::CriticalSection::ScopedLock sl( s_CsY2r );

            // Y2RϊJn
            camera_exp::Y2rManager_cl::StartDmaConversion( 
                num,
                ( isFullSize ) ? cm.GetFullSizeCaptureBuffer() : cm.GetLatestBuffer() );

            s_DebugInfo.stateY2r = 2;

            // Y2RI҂
            nn::os::Event * pa_WaitEvents[ 2 ] =
            {
                camera_exp::Y2rManager_cl::GetEventPointer( camera_exp::Y2rManager_cl::e_EVENT_END ),
                &s_Y2rForceEndEvent,
            };
            s32 waitNum = nn::os::WaitObject::WaitAny(
                reinterpret_cast< nn::os::WaitObject ** >( pa_WaitEvents ), 2, nn::fnd::TimeSpan::FromMilliSeconds( 100 ) );

            if( waitNum < 0 )
            {
                debug_print( "y2r timeout.\n" );
                nn::y2r::StopConversion();
            }

            if( waitNum == 1 )
            {
                debug_print( "y2r force end.\n" );
                nn::y2r::StopConversion();
            }

            s_Y2rTime = ( nn::os::Tick::GetSystemCurrent() - prev ).ToTimeSpan();

            s_DebugInfo.stateY2r = 0;

            // I
            camera_exp::Y2rManager_cl::SwapBuffer();        // obt@؂ւ
            camera_exp::Y2rManager_cl::EndDmaConversion();
        }

        // tTCYLv`̏ꍇ, ̕ϊ̂߂ɐݒ߂Ă
        if( isFullSize )
        {
            camera_exp::Y2rManager_cl::SetSize(
                iw, ih, tw, th, /*isCenter*/ true, coefficient, format, alignment );
        }
    } //Y2rConversion()

    //==============================================================================
    /** Y2RnhXbh
     */
    void Y2rConversionThreadFunc( uptr param NN_IS_UNUSED_VAR )
    {
        nn::os::Event & threadEndEvent = sa_ThreadEndEvent[ THREAD_Y2R ];
        threadEndEvent.Initialize( false );
        s_Y2rForceEndEvent.Initialize( false );
        sa_Y2rStartEvent[ 0 ].Initialize( false );
        sa_Y2rStartEvent[ 1 ].Initialize( false );
        sa_Y2rFullSizeStartEvent[ 0 ].Initialize( false );
        sa_Y2rFullSizeStartEvent[ 1 ].Initialize( false );
        sa_Y2rFullSizeEndEvent[ 0 ].Initialize( false );
        sa_Y2rFullSizeEndEvent[ 1 ].Initialize( false );
        s_Y2rFullSizeAckEvent.Initialize( false );

        while( 1 )
        {
            nn::os::Event *pa_Event[ 5 ] =
            {
                &sa_Y2rStartEvent[ 0 ],
                &sa_Y2rStartEvent[ 1 ],
                &sa_Y2rFullSizeStartEvent[ 0 ],
                &sa_Y2rFullSizeStartEvent[ 1 ],
                &threadEndEvent,
            };
            s32 num = nn::os::WaitObject::WaitAny(
                        reinterpret_cast<nn::os::WaitObject**>( pa_Event ), 5 );

            if( num == 4 )
            {
                break;
            }

            switch( num )
            {
                // ʏ̃Lv`
            case 0:
            case 1:
                {
                    s32 current = ( num == 0 ) ? 0 : 1;
                    s32 another = ( num == 0 ) ? 1 : 0;

                    Y2rConversion( current, false );

                    // ̈˗ĂĂϊ
                    // (ĂȂƂǂ炩L\)
                    if( pa_Event[ ( num == 0 ) ? 1 : 0 ]->Wait(0) )
                    {
                        Y2rConversion( another, false );                        
                    }
                }
                break;

                // tTCYLv`
            case 2:
            case 3:
                {
                    s32 current = ( num == 2 ) ? 0 : 1;
                    s32 another = ( num == 2 ) ? 1 : 0;

                    Y2rConversion( current, true );
                    sa_Y2rFullSizeEndEvent[ current ].Signal();  // ʒm

                    // ACK ԂĂ܂Y2RĊJȂ
                    // (obt@Ă܂\邽)
                    s_Y2rFullSizeAckEvent.Wait();

                    // ̈˗ĂĂϊ
                    if( pa_Event[ ( num == 2 ) ? 3 : 2 ]->Wait(0) )
                    {
                        Y2rConversion( another, true );                        
                        sa_Y2rFullSizeEndEvent[ another ].Signal();  // ʒm

                        // ACK ԂĂ܂Y2RĊJȂ
                        // (obt@Ă܂\邽)
                        s_Y2rFullSizeAckEvent.Wait();
                    }

                    camera_exp::Y2rManager_cl::ClearBuffer();
                }
                break;
            } //switch
        } //while
        threadEndEvent.Finalize();
        sa_Y2rStartEvent[ 0 ].Finalize();
        sa_Y2rStartEvent[ 1 ].Finalize();
        s_Y2rForceEndEvent.Finalize();
        sa_Y2rFullSizeStartEvent[ 0 ].Finalize();
        sa_Y2rFullSizeStartEvent[ 1 ].Finalize();
        sa_Y2rFullSizeEndEvent[ 0 ].Finalize();
        sa_Y2rFullSizeEndEvent[ 1 ].Finalize();
        s_Y2rFullSizeAckEvent.Finalize();
        debug_print( "thread end y2r.\n" );
    } //Y2rConversionThreadFunc()

    //==============================================================================
    /** ݒ
     */
    void InitializeSetting( void )
    {
        nn::Result result = nn::ResultSuccess();

        debug_print( "Initialize mode %d.\n", s_InitializeMode );

        // TCY̓V[؂ւ̂тɐݒ肵Ȃ
        for( s32 i=0; i < camera_exp::SettingMenuCameraItem_st::e_INDEX_CAMERA_NUM; i++ )
        {
            for( s32 j=0; j < camera_exp::SettingMenuContextItem_st::e_INDEX_CONTEXT_NUM; j++ )
            {
                sa_MenuItem[ e_MENU_SIZE ].a_CameraItem[ i ].a_ContextItem[ j ].decided  = nn::camera::SIZE_VGA;// SIZE_DS_LCDx4;
                sa_MenuItem[ e_MENU_SIZE ].a_CameraItem[ i ].a_ContextItem[ j ].changing = nn::camera::SIZE_VGA;// SIZE_DS_LCDx4;
            }
        }

        // JN
        if( nn::camera::Activate( s_CurrentCamera ).IsFailure() )
        {
            NN_PANIC( "failed nn::camera::Activate().\n" );
        }
    } //InitializeSetting()

    //==============================================================================
    /** I
     */
    void FinalizeSetting( void )
    {
    }

    //==============================================================================
    /** NX̏
     */
    void InitializeManagers( void )
    {
        // OCAMNX̏
        camera_exp::OcamManager_cl::Initialize();
        debug_print( "OcamManager is initialized.\n" );

        // Y2RNX̏
        camera_exp::Y2rManager_cl::Initialize( 
            s_CameraHeap,
            WIDTH,
            HEIGHT,
            TEXTURE_WIDTH,
            TEXTURE_HEIGHT,
            true,
            nn::y2r::COEFFICIENT_ITU_R_BT_709,// vÔƂƂ̒lƍ킹// COEFFICIENT_ITU_R_BT_601;COEFFICIENT_ITU_R_BT_601,
            nn::y2r::OUTPUT_RGB_24,
            nn::y2r::BLOCK_8_BY_8 );
        debug_print( "Y2rManager is initialized.\n" );

        // JX̐NX̏
        for( s32 i=0; i < 2; i++ )
        {
            nn::camera::Port port = (i == 0) ? nn::camera::PORT_CAM1 : nn::camera::PORT_CAM2;

            camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( i );

            cm.Initialize(
                port,
                s_CameraHeap,
                3,
                CAMERA_WIDTH,
                CAMERA_HEIGHT,
                WIDTH,
                HEIGHT );
            debug_print( "CameraManager %d is initialized.\n", i );
        } // for

    } //InitializeManagers()

    //==============================================================================
    /** NX̏I
     */
    void FinalizeManagers( void )
    {
//        camera_exp::SdFileManager_cl::Finalize();
        for( s32 i=0; i < 2; i++ )
        {
            camera_exp::CameraManager_cl & cm = camera_exp::OcamManager_cl::GetCameraManager( i );
            cm.Finalize( s_CameraHeap );
        }
        camera_exp::Y2rManager_cl::Finalize( s_CameraHeap );
        camera_exp::OcamManager_cl::Finalize();
    }

    //==============================================================================
    /** Xbh̏
     */
    void InitializeThreads( void )
    {
        for( s32 i=0; i < THREAD_MAX; i++ )
        {
            sa_Thread[ i ].StartUsingAutoStack(
                spa_ThreadFunc[ i ],
                sa_ThreadArg[ i ],
                sa_ThreadSize[ i ],
                static_cast< s32 >( nn::os::Thread::GetCurrentPriority() ) + sa_ThreadPriorityOffset[ i ] );

            // Xbh̑҂܂Ŏsł悤ɏ𖾂n
            nn::os::Thread::Yield();
        }
    }

    //==============================================================================
    /** Xbh̏I
     */
    void FinalizeThreads( void )
    {
        // XbhɏIʒm
        for( s32 i = 0; i < THREAD_MAX; i++ )
        {
            sa_ThreadEndEvent[ i ].Signal();
            
            sa_Thread[ i ].WaitOne();
            sa_Thread[ i ].Detach();
            sa_Thread[ i ].Finalize();
        }
    }
}

//==============================================================================
namespace {

    void DrawDisplay0Stereo( void );
    void DrawDisplay1( void );
    void DrawFrame( void );

    void DrawSettingMenu( void );
    void DrawHelp( void );

    //==============================================================================
    void DrawDisplay0Stereo( void )
    {
        // 
        if(     camera_exp::KeyManager_cl::IsTrigger( camera_exp::KeyManager_cl::e_AK_LEFT )
            ||  camera_exp::KeyManager_cl::IsRepeat(  camera_exp::KeyManager_cl::e_AK_LEFT ) )
        {
//            s_Distance -= 1.0f;
            s_Parallax  = nn::camera::GetParallax( s_CalData, s_Distance * 0.001f );
        }
        if(     camera_exp::KeyManager_cl::IsTrigger( camera_exp::KeyManager_cl::e_AK_RIGHT )
            ||  camera_exp::KeyManager_cl::IsRepeat(  camera_exp::KeyManager_cl::e_AK_RIGHT ) )
        {
//            s_Distance += 1.0f;
            s_Parallax  = nn::camera::GetParallax( s_CalData, s_Distance * 0.001f );
        }

        SetDrawingStereoCamera(
            false,
            &s_CalData,
            false,
            s_Distance,
            false,
            nn::y2r::OUTPUT_RGB_24,
            nn::y2r::BLOCK_8_BY_8 );

        DrawDisplay0StereoCommon( s_CurrentCamera );
    }

    //==============================================================================
    void DrawDisplay1( void )
    {
        s_RenderSystem.SetRenderTarget(NN_GX_DISPLAY1);
        glViewport(0, 0, nn::gx::DISPLAY1_WIDTH, nn::gx::DISPLAY1_HEIGHT);

        s_RenderSystem.Clear();
        s_RenderSystem.SetColor( 1.0f, 1.0f, 1.0f );
        s_RenderSystem.SetFontSize(8.0f);

        if( camera_exp::TpManager_cl::IsTrigger() )
        {
            s_IsDrawHelp = !s_IsDrawHelp;
        }

        if( s_IsDrawHelp )
        {
            s_RenderSystem.SetColor( 1.0f, 1.0f, 0.0f );    // yellow
            s_RenderSystem.DrawText( 16.0f, 80.0f, "Return: touch" );

            DrawHelp();
        }
        // ʏ̐ݒ
        else
        {
            s_RenderSystem.SetColor( 1.0f, 1.0f, 0.0f );    // yellow
            s_RenderSystem.DrawText( 16.0f, 80.0f, "Help: touch" );

            DrawSettingMenu();
        }
        s_RenderSystem.Transfer();
        s_RenderSystem.SwapBuffers();
    } //DrawDisplay1()

    //==============================================================================
    void DrawFrame( void )
    {
        s_RenderSystem.SetClearColor( NN_GX_DISPLAY_BOTH, 0.0f, 0.0f, 0.0f, 1.0f );
        // ڂƉEڂ̗̊G`
        DrawDisplay0Stereo();

        // ʕ`
        DrawDisplay1();

        s_Count++;

        s_RenderSystem.WaitVsync(NN_GX_DISPLAY_BOTH);
    }

    //==============================================================================
    void DrawSettingMenu( void )
    {
        s_RenderSystem.SetColor( 1.0f, 1.0f, 1.0f );    // white

        // fobO̕\
        {
            s32 y = 24;

            s_RenderSystem.DrawText( 0, y+=8, "Display Mode: %s", spa_DisplayModeList[ s_DisplayMode ] );
            //  (ǂ̋Ŕʑ̂dȂ邩)
            s_RenderSystem.DrawText( 0, y+=8, "Parallax: %f pixel on VGA", s_Parallax );
            s_RenderSystem.DrawText( 0, y+=8, "Distance: %f mm", s_Distance );
        }

        // Vsync
        if(    camera_exp::OcamManager_cl::IsEnableManualVsyncSync()
            && ( ( s_CurrentCamera == nn::camera::SELECT_OUT1_OUT2 ) || ( s_CurrentCamera == nn::camera::SELECT_IN1_OUT2 ) )
            && camera_exp::KeyManager_cl::IsTrigger( camera_exp::KeyManager_cl::e_BUTTON_L ) )
        {
            nn::os::CriticalSection::ScopedLock sl1( sa_CsCapture[ 0 ] );
            nn::os::CriticalSection::ScopedLock sl2( sa_CsCapture[ 1 ] );

            nn::camera::StopCapture( nn::camera::PORT_BOTH );
            while( nn::camera::IsBusy( nn::camera::PORT_CAM1 ) || nn::camera::IsBusy( nn::camera::PORT_CAM2 ) )
            {
            }

            nn::camera::CameraSelect cam1 = ( s_CurrentCamera & nn::camera::SELECT_OUT1 )
                                                ? nn::camera::SELECT_OUT1 : nn::camera::SELECT_IN1;

            if( nn::camera::SynchronizeVsyncTiming( cam1, nn::camera::SELECT_OUT2 ).IsFailure() )
            {
                NN_PANIC( "failed nn::camera::SynchronizeVsyncTiming().\n" );
            }

            sa_CameraCaptureRestartEvent[ 0 ].Signal();
            sa_CameraCaptureRestartEvent[ 1 ].Signal();
        }
/* TODO:MacAddress̒l̂ 00 ɂȂĂ܂̂ňURgAEgBʕ\ĂbgȂȂB
        s_RenderSystem.SetColor( 1.0f, 0.0f, 1.0f );    // purple
        s_RenderSystem.DrawText( 184.0f, 0.0f,
                                    "%02X:%02X:%02X:%02X:%02X:%02X",
                                    s_MacAddress[ 0 ], s_MacAddress[ 1 ], s_MacAddress[ 2 ],
                                    s_MacAddress[ 3 ], s_MacAddress[ 4 ], s_MacAddress[ 5 ] );
*/
        s_RenderSystem.SetColor( 1.0f, 1.0f, 1.0f );    // white

        s_Menu.Draw( s_CurrentCamera, s_CurrentContext );
        SetCamera();

        if( s_CurrentCamera & nn::camera::SELECT_OUT2 )
        {
            // 摜ׂĕ\
            // 512x384̉摜512x512̃obt@̐^ɓĂ̂ŉ摜ʂɎ܂悤1/8ɂĂ
            DrawImage(
                s_TextureBottom[ 1 ],
                  0.0f,
                120.0f - 20.0f,
                160.0f,
                160.0f,
                camera_exp::Y2rManager_cl::GetTextureBuffer( 1 ),
                camera_exp::Y2rManager_cl::GetTextureWidth(),
                camera_exp::Y2rManager_cl::GetTextureHeight() );
        }
        if( s_CurrentCamera & nn::camera::SELECT_IN1_OUT1 )
        {
            DrawImage(
                s_TextureBottom[ 0 ],
                160.0f,
                120.0f - 20.0f,
                160.0f,
                160.0f,
                camera_exp::Y2rManager_cl::GetTextureBuffer( 0 ),
                camera_exp::Y2rManager_cl::GetTextureWidth(),
                camera_exp::Y2rManager_cl::GetTextureHeight() );
        }
    } //DrawSettingMenu()
    //==============================================================================
    void DrawHelp( void )
    {
        s_RenderSystem.SetColor( 0.0f, 1.0f, 1.0f );    // cyan
        s_RenderSystem.DrawText( 8.0f, 0.0, "Help" );
        DrawLineFrame( 8.0f, 8.0f, 304.0f, 224.0f );

        s_RenderSystem.SetColor( 1.0f, 1.0f, 1.0f );    // white

        f32 y = 8.0f;

// ͂łȂ悤Ɍł߂Ă܂        s_RenderSystem.DrawText( 16.0f, y += 8.0f, "stick left/right : change parallax" );
        s_RenderSystem.DrawText( 16.0f, y += 8.0f, "stick up/down    : switch LCD MODE" );
//TODO:B{^Ŗ߂@\̎܂CO        s_RenderSystem.DrawText( 16.0f, y += 8.0f, "hold B : return initial menu" );
    } //DrawHelp()
} //namespace

//==============================================================================
void SceneSetting_cl::Initialize( uptr arg  )
{
    InitializeGx( s_CameraHeap );

    s_InitializeMode = static_cast< s32 >( arg );

    s_RenderSystem.SetLcdMode(NN_GX_DISPLAYMODE_STEREO);

    sa_CsCapture[ 0 ].Initialize();
    sa_CsCapture[ 1 ].Initialize();
    s_CsY2r.Initialize();

    //nn::camera::Initialize();
    nn::camera::InitializeHardwareCheck();
    nn::y2r::Initialize();

    // Lv`Ȃ炢~߂
    for( s32 i = 0; i < 2; i++ )
    {
        nn::camera::Port port = ( i == 0 ) ? nn::camera::PORT_CAM1 : nn::camera::PORT_CAM2;

        {
            nn::os::CriticalSection::ScopedLock sl( sa_CsCapture[ i ] );

            nn::camera::StopCapture( port );
            while( nn::camera::IsBusy( port ) )
            {
                debug_print( "busy polling camera.\n" );
            }
            nn::camera::ClearBuffer( port );
        }
    }

    s_Y2rCoefficient = nn::y2r::COEFFICIENT_ITU_R_BT_709;// vÔƂƂ̒lƍ킹// COEFFICIENT_ITU_R_BT_601;COEFFICIENT_ITU_R_BT_601;

    // j[̏
    memcpy( sa_MenuItem, sa_DefaultMenuItem, sizeof( camera_exp::SettingMenuItem_st ) * e_MENU_NUM );
    s_Menu.Initialize( &s_RenderSystem, sa_MenuItem, e_MENU_NUM );

    // }l[W̏ƃXbh̐
    InitializeManagers();
    InitializeThreads();

    InitializeSetting();

    // Lv`̊Jn
    nn::camera::Port port = camera_exp::GetPort( s_CurrentCamera );
    //nn::camera::Port port = camera_exp::GetPort( nn::camera::SELECT_OUT1_OUT2 );
    if( port != nn::camera::PORT_NONE )
    {
        nn::os::CriticalSection::ScopedLock  sl_1( sa_CsCapture[ 0 ] );
        nn::os::CriticalSection::ScopedLock  sl_2( sa_CsCapture[ 1 ] );

        nn::camera::StartCapture( port );
    }
    debug_print("camera_sample: start\n");
} //SceneSetting_cl::Initialize()

//==============================================================================
void SceneSetting_cl::Finalize( void )
{
//    FinalizeRegisterDumper();

    FinalizeSetting();

    FinalizeThreads();
    FinalizeManagers();

    nn::camera::Activate( nn::camera::SELECT_NONE );

    nn::camera::FinalizeHardwareCheck();
    //nn::camera::Finalize();
    nn::y2r::Finalize();

    if( s_TextureBottom[ 0 ] != 0 )
    {
        s_RenderSystem.DeleteTexture( s_TextureBottom[ 0 ] );
        s_TextureBottom[ 0 ] = 0;
    }
    if( s_TextureBottom[ 1 ] != 0 )
    {
        s_RenderSystem.DeleteTexture( s_TextureBottom[ 1 ] );
        s_TextureBottom[ 1 ] = 0;
    }

    sa_CsCapture[ 0 ].Finalize();
    sa_CsCapture[ 1 ].Finalize();

    s_RenderSystem.SetLcdMode(NN_GX_DISPLAYMODE_NORMAL);
    FinalizeGx( s_CameraHeap );
} //SceneSetting_cl::Finalize()

//==============================================================================
void SceneSetting_cl::Ready( void )
{
    // Lu[Vf[^̎擾
    nn::camera::GetStereoCameraCalibrationData( &s_CalData );

    SetDrawingStereoCamera(
        false,
        &s_CalData,
        false,
        s_Distance,
        false,
        nn::y2r::OUTPUT_RGB_24,
        nn::y2r::BLOCK_8_BY_8 );

    s_Parallax = nn::camera::GetParallax( s_CalData, s_Distance * 0.001f );

} //SceneSetting_cl::Ready()

//==============================================================================
uptr SceneSetting_cl::Draw( void )
{
    DrawFrame();
    return 0;

} //SceneSetting_cl::Draw()
