/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     camera_exp_util.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 20432 $
 *---------------------------------------------------------------------------*/

#ifndef SCENE_MANAGER_H_
#define SCENE_MANAGER_H_

#include <nn.h>
#include <nn/types.h>

#include "key_manager.h"
#include "demo.h"
#include "demo/Render/demo_RenderSystemExt.h"
#include "graphics.h"

#include "scene.h"

#include "sys.h"

extern nn::fnd::ExpHeap s_CameraHeap;

//==============================================================================
/** V[̊ǗNX
 */
class SceneManager_cl
{
private:
    Scene_cl  ** mpa_Scene;
    uptr      *  ma_SceneArg;
    s32       m_CurrentScene;
    s32       m_Selecting;

public:
    void Initialize( Scene_cl ** pa_Scene, uptr * a_SceneArg )
    {
        mpa_Scene      = pa_Scene;
        ma_SceneArg    = a_SceneArg;
        m_CurrentScene = -1;
        m_Selecting    = 0;

        InitializeGx( s_CameraHeap );
    }

    void Finalize( void )
    {
        if( m_CurrentScene < 0 )
        {
            FinalizeGx( s_CameraHeap );
        }
    }

    void SwitchScene( s32 scene )
    {
        // ÕV[̏I
        if( m_CurrentScene >= 0 )
        {
            mpa_Scene[ m_CurrentScene ]->Finalize();
        }
        else
        {
            FinalizeGx( s_CameraHeap );
        }

        // ̃V[̊Jn
        if( scene >= 0 )
        {
            mpa_Scene[ scene ]->Initialize( ma_SceneArg[ scene ] );
            mpa_Scene[ scene ]->Ready();
        }
        else
        {
            InitializeGx( s_CameraHeap );
        }
        NN_LOG( "scene %d -> %d.\n", m_CurrentScene, scene );
        m_CurrentScene = scene;
    }

    s32 GetCurrentScene( void )
    {
        return m_CurrentScene;
    }

    void DrawScene( s32 scene )
    {
        mpa_Scene[ scene ]->Draw();
    }

    void DrawCurrentScene( void )
    {
        // V[I
        if( m_CurrentScene >= 0 )
        {
            DrawScene( m_CurrentScene );

            // V[؂ւʂɖ߂
            static s32 holdCount = 0;
            if( camera_exp::KeyManager_cl::IsHold( camera_exp::KeyManager_cl::e_BUTTON_B ) )
            {
                holdCount++;
            }
            if( ( holdCount > 60 ) && !mpa_Scene[ m_CurrentScene ]->IsLockSceneChange() )
            {
                SwitchScene( -1 );      // V[Iɖ߂
                holdCount = 0;
            }
        }
        else
        {
            if( camera_exp::KeyManager_cl::IsTrigger( camera_exp::KeyManager_cl::e_BUTTON_A ) )
            {
                NN_LOG( "m_Selecting %d \n", m_Selecting );
                SwitchScene( m_Selecting );
            }

            // ʂ̃NA
            s_RenderSystem.SetRenderTarget(NN_GX_DISPLAY0);
            glViewport(0, 0, nn::gx::DISPLAY0_WIDTH, nn::gx::DISPLAY0_HEIGHT);

            s_RenderSystem.Clear();
            s_RenderSystem.Transfer();

            if( s_RenderSystem.GetLcdMode() == NN_GX_DISPLAYMODE_STEREO )
            {
                s_RenderSystem.SetRenderTarget(NN_GX_DISPLAY0_EXT);
                glViewport(0, 0, nn::gx::DISPLAY0_WIDTH, nn::gx::DISPLAY0_HEIGHT);
                s_RenderSystem.Clear();
                s_RenderSystem.Transfer();
            }
            s_RenderSystem.SwapBuffers();

            // ʂɃV[Ij[\
            s_RenderSystem.SetRenderTarget(NN_GX_DISPLAY1);
            glViewport(0, 0, nn::gx::DISPLAY1_WIDTH, nn::gx::DISPLAY1_HEIGHT);
            s_RenderSystem.Clear();
            s_RenderSystem.SetColor( 1.0f, 1.0f, 1.0f );
            s_RenderSystem.SetFontSize(8.0f);

            s_RenderSystem.SetColor( 0.0f, 1.0f, 1.0f );    // cyan
            s_RenderSystem.DrawText(
                0.0f,
                0.0f,
                "Select scene" );

            s32 y = 16;
            s_RenderSystem.SetColor( 1.0f, 1.0f, 0.0f );    // yellow
            s_RenderSystem.DrawText( 0.0f, static_cast< f32 >( y + 8 ), "> %s", "Preview and capturing" );
            s_RenderSystem.Transfer();
            s_RenderSystem.SwapBuffers();
        }
    } //DrawCurrentScene
}; //Scene_cl

#endif //#ifndef SCENE_MANAGER_H_
