/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     camera_exp_util.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 18921 $
 *---------------------------------------------------------------------------*/

#ifndef SCENE_H_
#define SCENE_H_

#include <nn.h>
#include <nn/types.h>

//==============================================================================
/** V[̒ۃNX
 */
class Scene_cl
{
public:
    virtual void Initialize( uptr arg )  = 0;
    virtual void Ready( void )           = 0;
    virtual uptr Draw( void )            = 0;
    virtual void Finalize( void )        = 0;

    // V[؂ւ̃bN
    // Kvȏꍇ͎邱
    virtual bool IsLockSceneChange( void )
    {
        return false;
    }
}; //Scene_cl

#endif //#ifndef SCENE_H_
