/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     polygon_manager.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 18253 $
 *---------------------------------------------------------------------------*/

#ifndef MODEL_MANAGER_H_
#define MODEL_MANAGER_H_

#include <nn/gx.h>
#include <nn/math.h>

namespace camera_exp {

    //==============================================================================
    /** |SfNX
     */
    class ModelManager_cl
    {
    public:
        enum
        {
            e_INDEX_X = 0,
            e_INDEX_Y,
            e_INDEX_Z,

            e_INDEX_MAX
        };

    public:
        ModelManager_cl()
        {
            InitPosition();
        }
        
    public:
        /** lɖ߂
         */
        void InitPosition()
        {
            for( s32 i=0; i < e_INDEX_MAX; i++ )
            {
                m_Rot[ i ]    = 0.0f;
                m_RotAcc[ i ] = 0.1f;
                m_Trans[ i ]  = 0.0f;
                m_Scale[ i ]  = 1.0f;
            }
        }
        /** i
         */
        void Trans( f32 x, f32 y, f32 z )
        {
            m_Trans[ e_INDEX_X ] += x;
            m_Trans[ e_INDEX_Y ] += y;
            m_Trans[ e_INDEX_Z ] += z;
        }

        /** i𒼂Ɏw
         */
        void SetTrans( s32 index, f32 trans )
        {
            m_Trans[ index ] = trans;
        }

        /** i܂Ƃ߂ĒɎw
         */
        void SetTrans( f32 x, f32 y, f32 z )
        {
            m_Trans[ e_INDEX_X ] = x;
            m_Trans[ e_INDEX_Y ] = y;
            m_Trans[ e_INDEX_Z ] = z;
        }

        /** iʂԂ
         */
        f32 GetTrans( s32 index )
        {
            return m_Trans[ index ];
        }

        /** ixNgŕԂ
         */
        nn::math::VEC3 GetTransVector( void )
        {
            nn::math::VEC3 vec( m_Trans[ e_INDEX_X ], m_Trans[ e_INDEX_Y ], m_Trans[ e_INDEX_Z ] );
            return vec;
        }

        /** isŕԂ
         */
        nn::math::MTX34 GetTransMatrix34( void )
        {
            nn::math::MTX34 mtx;
            nn::math::MTX34Translate( &mtx, GetTransVector() );
            return mtx;
        }

        /** ]
         */
        void Rot( s32 index, f32 rot )
        {
            m_Rot[ index ] += rot;
        }

        /** ]𒼂Ɏw
         */
        void SetRot( s32 index, f32 rot )
        {
            m_Rot[ index ] = rot;
        }

        /** ]ʂԂ
         */
        f32 GetRot( s32 index )
        {
            return m_Rot[ index ];
        }

        /** ]sŕԂ
         */
        nn::math::MTX34 GetRotMatrix34( void )
        {
            nn::math::MTX34 mtx;
            nn::math::MTX34RotXYZDeg( &mtx, m_Rot[ e_INDEX_X ], m_Rot[ e_INDEX_Y ], m_Rot[ e_INDEX_Z ] );
            return mtx;
        }

        /** gk
         */
        void Scale( f32 x, f32 y, f32 z )
        {
            m_Scale[ e_INDEX_X ] += x;
            m_Scale[ e_INDEX_Y ] += y;
            m_Scale[ e_INDEX_Z ] += z;
        }

        /** gk ʎw
         */
        void Scale( s32 index, f32 scale )
        {
            m_Scale[ index ] += scale;
        }

        /** gk𒼂Ɏw
         */
        void SetScale( s32 index, f32 scale )
        {
            m_Scale[ index ] = scale;
        }

        /** XP[Ԃ
         */
        f32 GetScale( s32 index )
        {
            return m_Scale[ index ];
        }

        /** XP[xNgŕԂ
         */
        nn::math::VEC3 GetScaleVector( void )
        {
            nn::math::VEC3 vec( m_Scale[ e_INDEX_X ], m_Scale[ e_INDEX_Y ], m_Scale[ e_INDEX_Z ] );
            return vec;
        }

        /** XP[sŕԂ
         */
        nn::math::MTX34 GetScaleMatrix34( void )
        {
            nn::math::MTX34 mtx;
            nn::math::MTX34Scale( &mtx, GetScaleVector() );
            return mtx;
        }

    private:
        // ]p
        f32 m_Rot[ e_INDEX_MAX ];

        // ]̉x
        f32 m_RotAcc[ e_INDEX_MAX ];

        // iړ
        f32 m_Trans[ e_INDEX_MAX ];

        // gk
        f32 m_Scale[ e_INDEX_MAX ];

    }; // class ModelManager_cl

} //namespace camera_exp

#endif //#ifndef MODEL_MANAGER_H_
