/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     main.cpp

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 50270 $
 *---------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/gxlow/CTR/gxlow_LcdApi.h>
#include <nn/gxlow/CTR/gxlow_LcdIpc.h>
#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>
#include <nn/y2r.h>
#include <nn/uds.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <string.h>

#include "key_manager.h"
#include "tp_manager.h"
#include "graphics.h"
#include "scene_setting.h"
#include "scene_manager.h"

#define  debug_print    NN_LOG

// =============================================================================
nn::fnd::ExpHeap s_AppHeap;

// UDSの初期化ができない環境があるのでMACアドレスの取得をするかどうかを
// ビルドスイッチで切り替える
#define  GET_MAC_ADDRESS

// 一意なファイル名のために時刻とMACアドレスを取得する
nn::fnd::DateTime s_DateTime;
bit8              s_MacAddress[ 6 ];

// =============================================================================
namespace
{
    SceneSetting_cl      s_SceneSetting;

    // シーン
    Scene_cl * spa_Scene[] =
    {
        &s_SceneSetting,
    };

    // シーンの初期化時に渡す引数
    uptr sa_SceneArg[] =
    {
        0,
    };
    
    // シーン管理クラス
    SceneManager_cl  s_SceneManager;
}

//==============================================================================
/** 本体
 */
void nnnMain( void )
{
    nn::Result result;

    nn::fs::Initialize();
//    (void)nn::fs::MountSdmc();
    
    nn::applet::Enable();

    // 動的確保用のヒープ
    s_AppHeap.Initialize(
        nn::os::GetDeviceMemoryAddress(),
        nn::os::GetDeviceMemorySize(),
        nn::os::ALLOCATE_OPTION_LINEAR );

    // ROMアーカイブのマウント
    const size_t ROMFS_BUFFER_SIZE = 1024 * 64;
    static char buffer[ROMFS_BUFFER_SIZE];
    NN_UTIL_PANIC_IF_FAILED(
        nn::fs::MountRom(16, 16, buffer, ROMFS_BUFFER_SIZE));

    // hid の初期化 (パッド準備)
    result = nn::hid::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);
    nn::hid::PadReader padReader;
    nn::hid::PadStatus padStatus;
    nn::hid::TouchPanelReader tpReader;
    nn::hid::TouchPanelStatus tpStatus;

    camera_exp::KeyManager_cl::Initialize( &padReader, &padStatus );
    camera_exp::TpManager_cl::Initialize( &tpReader, &tpStatus );

    // 撮影画像のファイル名を決めるために起動した時刻とMACアドレスを取得する
    s_DateTime = nn::fnd::DateTime::GetNow();

    memset( s_MacAddress, 0, 6 );

    NN_TLOG_( "MAC ADDRESS %02X:%02X:%02X:%02X:%02X:%02X\n",
                    s_MacAddress[ 0 ],
                    s_MacAddress[ 1 ],
                    s_MacAddress[ 2 ],
                    s_MacAddress[ 3 ],
                    s_MacAddress[ 4 ],
                    s_MacAddress[ 5 ] );

    s_SceneManager.Initialize( spa_Scene, sa_SceneArg );

    while(1)
    {
        camera_exp::KeyManager_cl::Read();
        camera_exp::TpManager_cl::Read();

        s_SceneManager.DrawCurrentScene();
    }

} //nnMain()
