/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     key_manager.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 19180 $
 *---------------------------------------------------------------------------*/

#ifndef KEY_MANAGER_H_
#define KEY_MANAGER_H_

#include <nn/hid.h>

namespace camera_exp {

    //==============================================================================
    /** L[ǗNX : static
     */
    class KeyManager_cl
    {
    public:
        enum
        {
            e_BUTTON_A      = nn::hid::BUTTON_A,
            e_BUTTON_B      = nn::hid::BUTTON_B,
            e_BUTTON_Y      = nn::hid::BUTTON_Y,
            e_BUTTON_X      = nn::hid::BUTTON_X,
            e_BUTTON_L      = nn::hid::BUTTON_L,
            e_BUTTON_R      = nn::hid::BUTTON_R,
            e_BUTTON_START  = nn::hid::BUTTON_START,
            e_BUTTON_RIGHT  = nn::hid::BUTTON_RIGHT,
            e_BUTTON_LEFT   = nn::hid::BUTTON_LEFT,
            e_BUTTON_UP     = nn::hid::BUTTON_UP,
            e_BUTTON_DOWN   = nn::hid::BUTTON_DOWN,

            e_AK_UP         = 1 << 17,
            e_AK_DOWN       = 1 << 18,
            e_AK_RIGHT      = 1 << 19,
            e_AK_LEFT       = 1 << 20,

            e_KEY_MAX       = 21
        };

    public:
        KeyManager_cl()
        {}

    public:
        static void Initialize( nn::hid::PadReader *p_Reader, nn::hid::PadStatus *p_Status )
        {
            mp_PadReader  = p_Reader;
            mp_PadStatus  = p_Status;
            m_AkX         = 0.0f;
            m_AkY         = 0.0f;
            m_AkX_Back    = 0.0f;
            m_AkY_Back    = 0.0f;
            m_AkThreshold = 0.5f;
            m_Trigger   = 0;
            m_Release   = 0;
            m_Repeat    = 0;
            m_Hold      = 0;
            m_Hold_Back = 0;
            m_RepeatStart    = 12;
            m_RepeatInterval = 2;

            for( s32 i=0; i < e_KEY_MAX; i++ )
            {
                ma_RepeatCount[ i ] = 0;
            }
        }

    public:
        /** [hXV
         */
        static void Read( void );

        /** L[
         */
        static bool IsTrigger( u32 key );
        static bool IsRelease( u32 key );
        static bool IsRepeat( u32 key );
        static bool IsHold( u32 key );

        /** AiOL[̒lԂ
         */
        static f32 GetAkX( void )
        {
            return m_AkX;
        }
        static f32 GetAkY( void )
        {
            return m_AkY;
        }

        /** s[gݒύX
         */
        static void SetRepeat( u8 repeatStart, u8 repeatInterval )
        {
            m_RepeatStart    = repeatStart;
            m_RepeatInterval = repeatInterval;
        }

    private:
        /** L[XV
         */
        static void UpdateTrigger( void );
        static void UpdateRelease( void );
        static void UpdateHold( void );
        static void UpdateRepeat( void );

    private:
        // L[擾
        static nn::hid::PadReader * mp_PadReader;
        static nn::hid::PadStatus * mp_PadStatus;

        // AiOL[̒l
        static f32 m_AkX;
        static f32 m_AkY;
        static f32 m_AkX_Back;
        static f32 m_AkY_Back;

        // AiOL[ꂽƔ肷臒l
        static f32 m_AkThreshold;

        // ꂽ̘aW
        static u32 m_Trigger;
        static u32 m_Release;
        static u32 m_Repeat;
        static u32 m_Hold;
        static u32 m_Hold_Back;

        // s[gĂ鐔̃JE^
        static u8  ma_RepeatCount[ e_KEY_MAX ];

        // s[gƂ݂ȂJnt[ƊԊut[
        static u8  m_RepeatStart;
        static u8  m_RepeatInterval;

    }; // KeyManager_cl

} //namespace camera_exp

#endif //#ifndef KEY_MANAGER_H_

