/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     camera_exp_util.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 36187 $
 *---------------------------------------------------------------------------*/

#ifndef GRAPHICS_H_
#define GRAPHICS_H_

#include <nn.h>
#include <nn/types.h>
#include <nn/camera.h>
#include <nn/y2r.h>

#include "demo.h"
#include "demo/Render/demo_RenderSystemExt.h"

extern demo::RenderSystemExt s_RenderSystem;

// ʕ\[h
extern s32 s_DisplayMode;

//==============================================================================
int  InitializeGx( nn::fnd::ExpHeap & heap );
void FinalizeGx( nn::fnd::ExpHeap & heap );

//==============================================================================
/** J摜̕\JX^}CY
 *
 *  @arg [in] J摜ł͂ȂRGB摜\邩
 *  @arg [in] Lf[^
 *  @arg [in] `[gŃsg悤ɂ邩
 *  @arg [in] `[gŃsg킹Ȃꍇ̃sg킹鋗
 *  @arg [in] J؂Ȃ悤ɉ摜Eɂ炷ǂ
 *  @arg [in] eNX`ɂJ摜̃tH[}bg
 *  @arg [in] eNX`ɂJ摜̃ubNtH[}bg
 */
void SetDrawingStereoCamera(
        bool isDrawRgbImage,
        nn::camera::StereoCameraCalibrationData * p_CalData,
        bool isParallax,
        f32  distance,
        bool isShiftRight,
        nn::y2r::OutputFormat format,
        nn::y2r::BlockAlignment alignment );

//==============================================================================
/** RGB摜\ꍇRGB摜Zbg
 *
 *  @arg [in] E摜
 *  @arg [in] 摜
 *  @arg [in] 摜f[^̕
 *  @arg [in] 摜f[^̍
 *  @arg [in] 摜f[^Ɋ܂܂ĂJ摜̕
 *  @arg [in] 摜f[^Ɋ܂܂ĂJ摜̍
 */
/*
void SetDrawingRgbImage(
                 u8       * image_R,
                 u8       * image_L,
                 size_t   textureWidth,
                 size_t   textureHeight,
                 size_t   originalWidth,
                 size_t   originalHeight );
*/
//==============================================================================
/** J摜\
 *
 *  @arg [in] eNX`ԍ (0:E, 1:)
 *  @arg [in] E摜ĕ\邩ǂ
 */
void DrawStereoCamera( s32 index, bool isBlend );

//==============================================================================
/** ʕ\̋ʉ
 *  ʂȕ\Ȃꍇ, ̊֐gp
 */
void DrawDisplay0StereoCommon( nn::camera::CameraSelect currentCamera );

//==============================================================================
/** g̕`
 */
void DrawLineFrame( const f32 sx, const f32 sy, const f32 width, const f32 height );

//==============================================================================
/** Obh̕`
 */
//void DrawGrid( const s32 nh, const s32 nv, const f32 width, const f32 height, const f32 lineWidth );

//==============================================================================
/** RenderSystem g摜2D`
 */

void DrawImage(
    GLuint & textureId, const f32 sx, const f32 sy, const f32 width, const f32 height,
    void * p_Image, const s32 imageWidth, const s32 imageHeight );

#endif //#ifndef GRAPHICS_H_
