/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     camera_manager.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 20866 $
 *---------------------------------------------------------------------------*/

#include <nn/camera/CTR/camera_Api.h>
//#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>

#include "camera_manager.h"
#include "util.h"

#define  debug_print    NN_TLOG_

using namespace camera_exp;

namespace camera_exp {

    //==============================================================================
    /** 摜TCYɍ킹ăJ I/F ݒ肷
     */
    void SetCameraSizeInterface(
            nn::camera::CameraSelect  camera,
            size_t        cameraWidth,
            size_t        cameraHeight,
            size_t        trimWidth,
            size_t        trimHeight )
    {
        nn::camera::Port port = GetPort( camera );

        // JI/F̐ݒ
        size_t transferBytes = nn::camera::GetMaxBytes( trimWidth, trimHeight );
        nn::camera::SetTransferBytes( port, transferBytes, trimWidth, trimHeight );
        debug_print( "SetTransferBytes (port %d) %d. (Image size : %d, %d. Bytes : %d.)\n",
                        static_cast< s32 >( port ),
                        transferBytes, trimWidth, trimHeight,
                        nn::camera::GetFrameBytes( trimWidth, trimHeight ) );

        debug_print( "GetTransferBytes (port %d) returns %d. (Image size : %d, %d. Bytes : %d.)\n",
                        static_cast< s32 >( port ),
                        nn::camera::GetTransferBytes( port ), trimWidth, trimHeight,
                        nn::camera::GetFrameBytes( trimWidth, trimHeight ) );

        // g~O̐ݒ
        if( ( trimWidth < cameraWidth ) || ( trimHeight < cameraHeight ) )
        {
            nn::camera::SetTrimming( port, true );
            nn::camera::SetTrimmingParamsCenter( port, trimWidth, trimHeight,
                                     cameraWidth, cameraHeight );
        }
        else
        {
            nn::camera::SetTrimming( port, false );
        }
    }

    //==============================================================================
    void SetCameraSize(
            nn::camera::CameraSelect  camera,
            size_t        cameraWidth,
            size_t        cameraHeight,
            size_t        trimWidth,
            size_t        trimHeight )
    {
        // I/F ̐ݒ
        SetCameraSizeInterface( camera, cameraWidth, cameraHeight, trimWidth, trimHeight );

        // 摜TCY̕ύX
        // zg4:3ȂƂ̂ŃNbvTCYύX
        if( nn::camera::SetDetailSize( camera, cameraWidth, cameraHeight ).IsFailure() )
        {
            NN_PANIC( "failed nn::camera::SetDetailSize().\n" );
        }

    } //SetCameraSize

    //==============================================================================
    void SetCameraSize(
            nn::camera::CameraSelect  camera,
            nn::camera::Size          size,
            size_t        trimWidth,
            size_t        trimHeight )
    {
        // I/F ̐ݒ
        SetCameraSizeInterface( camera,
                                GetCameraWidth( size ),
                                GetCameraHeight( size ),
                                trimWidth, trimHeight );

        // 摜TCY̕ύX
        if( nn::camera::SetSize( camera, size ).IsFailure() )
        {
            NN_PANIC( "failed nn::camera::SetSize().\n" );
        }
    }

} //namespace camera_exp


//==============================================================================
bool             OcamManager_cl::m_IsEnableManualVsyncSync;
nn::os::Event    OcamManager_cl::ma_Events[ OcamManager_cl::e_EVENT_NUM ];
CameraManager_cl OcamManager_cl::ma_CameraManagers[ 2 ];


//==============================================================================
void CameraManager_cl::SwapBuffer( void )
{
    nn::os::CriticalSection::ScopedLock sl( m_CsSet );

    // ŐṼLv`ς݃obt@XV
    m_LatestCapturedPos = m_CapturingPos;

    // ǂݏõobt@XLbvĎ̃Lv`pobt@߂
    do
    {
        m_CapturingPos = (m_CapturingPos + 1) % m_BufferNum;
    }
    while( m_CapturingPos == m_ReadingPos );
}

//==============================================================================
u8 * CameraManager_cl::GetLatestBuffer( void )
{
    {
        nn::os::CriticalSection::ScopedLock sl( m_CsSet );
        
        // ǂݏõobt@XV
        m_ReadingPos = m_LatestCapturedPos;
    }
    return mpa_YuvBuffers[ m_ReadingPos ];
}

//==============================================================================
u8 * CameraManager_cl::GetWorkBuffer( void )
{
    return mpa_YuvBuffers[ m_CapturingPos ];
}

//==============================================================================
void CameraManager_cl::StartDmaRecv( void )
{
    nn::os::CriticalSection::ScopedLock sl( m_CsDma );

    SetReceiving(
        &ma_Events[ e_EVENT_DMA ],
        GetWorkBuffer(),
        m_Port,
        m_OutputSize,
        m_TransferUnit );
    //NN_TLOG_("StartDmaRecv %d, %d, %d.\n", m_Port, m_OutputSize, m_TransferUnit);
}

//==============================================================================
void CameraManager_cl::StartDmaRecvFullSize( void )
{
    nn::os::CriticalSection::ScopedLock sl( m_CsDma );

    SetReceiving(
        &ma_Events[ e_EVENT_DMA ],
        mp_YuvBufferFull,               // tTCYLv`pobt@
        m_Port,
        m_OutputSizeFull,
        m_TransferUnitFull );
    //NN_TLOG_("StartDmaRecvFullSize %d, %d, %d.\n", m_Port, m_OutputSize, m_TransferUnit);
}

