
/********************************************************************
J̃V[PXĂяo
********************************************************************/

#include <string.h>
#include <nn.h>
#include <nn/gx.h>
#include <nn/camera.h>
#include <nn/y2r.h>
#include <string.h>
#include "sys.h"
#include "../sys/sys_SoundPlayer.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/TestList.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "TestCamera.h"
#include "SeqInCamera.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace uji::eva;
using namespace uji::seq;

enum State{
    State_Start=0,
    State_ZoomOut=0,
    State_LeftTop,
    State_RightTop,
    State_LeftBottom,
    State_RightBottom,
    State_End
};


/************************************************************************
bZ[W\
  ************************************************************************/
static void ShowIndicator( uji::sys::GraphicsDrawing* gfx, State state )
{
    gfx->BeginDrawingShape();
    gfx->SetColor(nn::util::Color8::WHITE);

    switch(state)
    {
    case State_ZoomOut:
        gfx->DrawWidth1Rectangle( 0,   0, 16,  16 );
        gfx->DrawWidth1Rectangle( 20,  0, 16,  16 );
        gfx->DrawWidth1Rectangle( 0,  20, 16,  16 );
        gfx->DrawWidth1Rectangle( 20, 20, 16, 16 );
        break;
    case State_LeftTop:
        gfx->DrawWidth1Rectangle( 0,   0, 16,  16 );
        gfx->FillRectangle( 20,  0, 16,  16 );
        gfx->FillRectangle( 0,  20, 16,  16 );
        gfx->FillRectangle( 20, 20, 16, 16 );
        break;
    case State_RightTop:
        gfx->FillRectangle( 0,   0, 16,  16 );
        gfx->DrawWidth1Rectangle( 20,  0, 16,  16 );
        gfx->FillRectangle( 0,  20, 16,  16 );
        gfx->FillRectangle( 20, 20, 16, 16 );
        break;
    case State_LeftBottom:
        gfx->FillRectangle( 0,   0, 16,  16 );
        gfx->FillRectangle( 20,  0, 16,  16 );
        gfx->DrawWidth1Rectangle( 0,  20, 16,  16 );
        gfx->FillRectangle( 20, 20, 16, 16 );
        break;


    case State_RightBottom:
        gfx->FillRectangle( 0,   0, 16,  16 );
        gfx->FillRectangle( 20,  0, 16,  16 );
        gfx->FillRectangle( 0,  20, 16,  16 );
        gfx->DrawWidth1Rectangle( 20, 20, 16, 16 );
        break;
    }

}

/************************************************************************
bZ[W\
  ************************************************************************/
static void ShowMessage( uji::sys::GraphicsDrawing* gfx, char *str1, char *str2 )
{
    gfx->BeginDrawingString();
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_V);
    gfx->m_TextWriter.SetTextColor(nn::util::Color8::YELLOW, nn::util::Color8::RED);
    gfx->m_TextWriter.SetCursor(20, 100);
    gfx->m_TextWriter.Print( str1 );
    gfx->m_TextWriter.SetCursor(20, 150);
    gfx->m_TextWriter.Print( str2 );
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_NONE);
    gfx->EndDrawingString();
}

/************************************************************************
hmJ
  ************************************************************************/
bool uji::eva::camera::TestInCameraChart(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 2000;

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    SoundPlayer *sp = new SoundPlayer;
    uji::seq::Config config;

    TestCamera *camera = new TestCamera;
    camera->Initialize();


    //Lv`

    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_IN1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );

    s8 sharpness = (s8)(config.Get().ChartSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    //Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Chart test", "Push A,L,R,DOWN to take picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN)  )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();

    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);

    Config lcdConfig;
    Config::Member lcdMember = lcdConfig.Get();
	int waitTime = lcdMember.LcdTimeWait;			// ʕ\mFp҂

    //mF
    State state = State_Start;

    do{
        pad.UpdatePad();
        if( waitTime>0 ) waitTime--;

		if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime==0 )
        {
            if( state < State_End ) state = (State)((u8)state+1);
            waitTime = lcdMember.LcdTimeWait;
        }
        if( pad.IsButtonDown(Pad::BUTTON_B) )
        {
            if( state > State_Start ) state = (State)((u8)state-1);
            waitTime = lcdMember.LcdTimeWait;
        }

        switch(state)
        {
        case State_ZoomOut:
            camera->EnableZoomOut();
            camera->SetScroll( -80, 0 );
            break;
        case State_LeftTop:
            camera->DesableZoomOut();
            camera->SetScroll( -40, 0 );
            break;
        case State_RightTop:
            camera->DesableZoomOut();
            camera->SetScroll( 280, 0 );
            break;
        case State_LeftBottom:
            camera->DesableZoomOut();
            camera->SetScroll( -40, 240 );
            break;
        case State_RightBottom:
            camera->DesableZoomOut();
            camera->SetScroll( 280, 240 );
            break;
        }

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );

#if 0   // NGSDJ[hւ̏o͂𑣂[h
        // RȂYSDgݍݎw
        if( pad.IsButtonPress(Pad::BUTTON_R) && pad.IsButtonDown(Pad::BUTTON_Y) )
        {
            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
            jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();

            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( !nn::fs::IsSdmcInserted() );

            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Now", "Saving..." );
            ShowIndicator( gfx, state );
            gfx->m_DrawFramework->SwapBuffers();

            int cam_result = camera->SavePng( "sdmc:/icam_chart.png");

            jpegDrawer->OpenPicture(L"rom:/jpeg/removeSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();
            
            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( nn::fs::IsSdmcInserted() );
            
            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
            
            if( cam_result == 0 )
            {
                jpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->SwapBuffers();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );
                // 摜
                jpegDrawer->ClosePicture();
                delete jpegDrawer;
                while(1)
                {
                    // ͔oȂ
                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
                }
            }
            else if( cam_result == 1 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
                ShowIndicator( gfx, state );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 2 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Mount", "Failed." );
                ShowIndicator( gfx, state );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 7 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Locked", "Failed." );
                ShowIndicator( gfx, state );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else
            {
                char cam_temp[1];
                sprintf( cam_temp,"%d", cam_result ); 
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
                ShowIndicator( gfx, state );
                gfx->m_DrawFramework->SwapBuffers();
            }
            // 摜
            jpegDrawer->ClosePicture();
            delete jpegDrawer;

        }
        else if( pad.IsButtonDown(Pad::BUTTON_A) )
        {
            gfx->m_DrawFramework->Clear();
            ::ShowMessage( gfx, "Watch! Push A to next.", "Push R and Y when NG." );
            ShowIndicator( gfx, state );
            gfx->m_DrawFramework->SwapBuffers();
        }
#endif
#if 1   // ʏ̌͂
        gfx->m_DrawFramework->Clear();
        ::ShowMessage( gfx, "Watch", "Push A to next." );
        ShowIndicator( gfx, state );
        gfx->m_DrawFramework->SwapBuffers();
#endif
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }
    while( state != State_End );


    pad.ClearTriggerFlag();
    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
hmJ݌
  ************************************************************************/
bool uji::eva::camera::TestInCameraDust(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 2000;

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    TestCamera *camera = new TestCamera;
    camera->Initialize();


    //Lv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_IN1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );


    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    //Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN to take picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Watch", "Push A to next." );
    gfx->m_DrawFramework->SwapBuffers();

    Config lcdConfig;
    Config::Member lcdMember = lcdConfig.Get();
    int waitTime = lcdMember.LcdTimeWait;           // ʕ\mFp҂

    //mF
    do{
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.UpdatePad();

#if 0   // NGSDJ[hւ̏o͂𑣂[h
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Watch! Push A to next.", "Push R and Y when NG." );
        gfx->m_DrawFramework->SwapBuffers();
        // RȂYSDgݍݎw
        if( pad.IsButtonPress(Pad::BUTTON_R) && pad.IsButtonDown(Pad::BUTTON_Y) )
        {
            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
            jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();

            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( !nn::fs::IsSdmcInserted() );

            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Now", "Saving." );
            gfx->m_DrawFramework->SwapBuffers();
            int cam_result = camera->SavePng( "sdmc:/icam_white.png");
            
            jpegDrawer->OpenPicture(L"rom:/jpeg/removeSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();

            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( nn::fs::IsSdmcInserted() );
            
            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

            if( cam_result == 0 )
            {
                jpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->SwapBuffers();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );
                // 摜
                jpegDrawer->ClosePicture();
                delete jpegDrawer;
                while(1)
                {
                    // ͔oȂ
                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
                }
            }
            else if( cam_result == 1 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 2 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Mount", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 7 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Locked", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else
            {
                char cam_temp[1];
                sprintf( cam_temp,"%d", cam_result ); 
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
                gfx->m_DrawFramework->SwapBuffers();
            }
            // 摜
            jpegDrawer->ClosePicture();
            delete jpegDrawer;
        }
#endif
        if( waitTime>0 ) waitTime--;
        if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime == 0 )	break;
    }while( 1 );
    pad.ClearTriggerFlag();

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ntsJiEj݌
  ************************************************************************/
bool uji::eva::camera::TestOutRightCameraDust(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 2000;

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();
    // {̂Ԃŉo悤ɂ܂
    nn::snd::SetHeadphoneOutOnShellClose(false);

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;
    sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 1 );

	TestCamera *camera = new TestCamera;
    camera->Initialize();


    //Lv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );


    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    //Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN to take picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Watch", "Push A to next." );
    gfx->m_DrawFramework->SwapBuffers();

    Config lcdConfig;
    Config::Member lcdMember = lcdConfig.Get();
    int waitTime = lcdMember.LcdTimeWait;           // ʕ\mFp҂

    //mF
    do{
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.UpdatePad();
        
#if 0   // NGSDJ[hւ̏o͂𑣂[h
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Watch! Push A to next.", "Push R and Y when NG." );
        gfx->m_DrawFramework->SwapBuffers();
        // RȂYSDgݍݎw
        if( pad.IsButtonPress(Pad::BUTTON_R) && pad.IsButtonDown(Pad::BUTTON_Y) )
        {
            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
            jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();

            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( !nn::fs::IsSdmcInserted() );

            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Now", "Saving." );
            gfx->m_DrawFramework->SwapBuffers();
            
            int cam_result = camera->SavePng( "sdmc:/ocam_R_white.png");
            
            jpegDrawer->OpenPicture(L"rom:/jpeg/removeSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();
            
            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( nn::fs::IsSdmcInserted() );
            
            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
            
            if( cam_result == 0 )
            {
                jpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->SwapBuffers();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );
                // 摜
                jpegDrawer->ClosePicture();
                delete jpegDrawer;
                while(1)
                {
                    // ͔oȂ
                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
                }
            }
            else if( cam_result == 1 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 2 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Mount", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 7 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Locked", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else
            {
                char cam_temp[1];
                sprintf( cam_temp,"%d", cam_result ); 
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
                gfx->m_DrawFramework->SwapBuffers();
            }
            // 摜
            jpegDrawer->ClosePicture();
        }
#endif

        if( waitTime>0 ) waitTime--;
		if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime == 0 )	break;
    }while( 1 );
    pad.ClearTriggerFlag();

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ntsJij݌
  ************************************************************************/
bool uji::eva::camera::TestOutLeftCameraDust(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 2000;

    // {̂Ԃŉo悤ɂ܂
    nn::snd::SetHeadphoneOutOnShellClose(false);

	uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    TestCamera *camera = new TestCamera;
    camera->Initialize();


    //Lv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );


    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    //Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Dust test", "Push A,L,R,DOWN to take picture." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Watch", "Push A to next." );
    gfx->m_DrawFramework->SwapBuffers();

    Config lcdConfig;
    Config::Member lcdMember = lcdConfig.Get();
	int waitTime = lcdMember.LcdTimeWait;			// ʕ\mFp҂

    //mF
    do{
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.UpdatePad();
        
#if 0   // NGSDJ[hւ̏o͂𑣂[h
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Watch! Push A to next.", "Push R and Y when NG." );
        gfx->m_DrawFramework->SwapBuffers();
        // RȂYSDgݍݎw
        if( pad.IsButtonPress(Pad::BUTTON_R) && pad.IsButtonDown(Pad::BUTTON_Y) )
        {
            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
            jpegDrawer->OpenPicture(L"rom:/jpeg/setSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();

            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( !nn::fs::IsSdmcInserted() );

            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

            gfx->m_DrawFramework->Clear();
            ::ShowMessage ( gfx, "Now", "Saving." );
            gfx->m_DrawFramework->SwapBuffers();
            
            int cam_result = camera->SavePng( "sdmc:/ocam_L_white.png");
            
            jpegDrawer->OpenPicture(L"rom:/jpeg/removeSD.jpg");
            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();
            
            //SDJ[h܂Ń[v
            do
            {
                // C҂Ԃ
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }while( nn::fs::IsSdmcInserted() );
            
            // ::ShowMessageg߂̐ݒ
            gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
            
            if( cam_result == 0 )
            {
                jpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->SwapBuffers();
                sp->UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );
                // 摜
                jpegDrawer->ClosePicture();
                delete jpegDrawer;
                while(1)
                {
                    // ͔oȂ
                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
                }
            }
            else if( cam_result == 1 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD not Inserted", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 2 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Mount", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else if( cam_result == 7 )
            {
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "SD Locked", "Failed." );
                gfx->m_DrawFramework->SwapBuffers();
            }
            else
            {
                char cam_temp[1];
                sprintf( cam_temp,"%d", cam_result ); 
                gfx->m_DrawFramework->Clear();
                ::ShowMessage ( gfx, "PNG Save Failed %d", cam_temp );
                gfx->m_DrawFramework->SwapBuffers();
            }
            // 摜
            jpegDrawer->ClosePicture();
            delete jpegDrawer;
        }
#endif
        if( waitTime>0 ) waitTime--;
		if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime == 0 )	break;
    }while( 1 );
    pad.ClearTriggerFlag();

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ntsJijLv`ʒumF
  ************************************************************************/
bool uji::eva::camera::CheckOutLeftCameraCapture(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 100;

    // {̂Ԃŉo悤ɂ܂
    nn::snd::SetHeadphoneOutOnShellClose(false);

	uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

    TestCamera *camera = new TestCamera;
    camera->Initialize();


    //Lv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT2 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );


    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    sp->UjiSoundPlayer( "rom:/SoundPlayer/wihaho_16bit_fs22kHz_1ch.wav", 1000 );
    //Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Keep the Position", "Push A,L,R,DOWN to go next." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Keep the Position", "Push A to next." );
    gfx->m_DrawFramework->SwapBuffers();
	
    Config lcdConfig;
    Config::Member lcdMember = lcdConfig.Get();
	int waitTime = WAIT_TIME;			// ʕ\mFp҂

    //mF
    /*
    do{
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.UpdatePad();
        if( waitTime>0 ) waitTime--;
		if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime == 0 )	break;
    }while( 1 );
    */
    pad.ClearTriggerFlag();

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ntsJiEjLv`ʒumF
  ************************************************************************/
bool uji::eva::camera::CheckOutRightCameraCapture(TestResult &result)
{
    //҂(mS)
    s64 WAIT_TIME = 100;

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();
    // {̂Ԃŉo悤ɂ܂
    nn::snd::SetHeadphoneOutOnShellClose(false);

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;
    SoundPlayer *sp = new SoundPlayer;

	TestCamera *camera = new TestCamera;
    camera->Initialize();


    //Lv`
    camera->EnableZoomOut();
    camera->SetScroll( -80, 0 );
    camera->Start( nn::camera::CTR::SELECT_OUT1 );
    camera->FlipImage( nn::camera::CTR::FLIP_NONE );
    camera->SetPhotoMode( nn::camera::CTR::PHOTO_MODE_NORMAL );


    s8 sharpness = (s8)(config.Get().DustSharpness);
    if( sharpness > 9 )         sharpness = 9;
    else if( sharpness < 0 )    sharpness = 0;  //RtBO̒lL͈͂Ɋۂߍ
    sharpness -=4;
    camera->SetSharpness( sharpness );

    bool isCaptured = false;
    bool isTimerStart = false;
    nn::os::Tick startTick;

    sp->UjiSoundPlayer( "rom:/SoundPlayer/yoshi_16bit_fs16kHz_1ch.wav", 1000 );
    //Be
    do
    {
        camera->Update();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        ::ShowMessage ( gfx, "Keep the Position", "Push A,L,R,DOWN to go next." );
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 40.0f, 240.0f );
        gfx->m_DrawFramework->FillRectangle( 360.0f, 0.0f, 40.0f, 240.0f );
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
        if( pad.IsButtonDown(Pad::BUTTON_A) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) || pad.IsButtonDown(Pad::BUTTON_DOWN) )
        {
            sp->UjiSoundPlayer( "rom:/SoundPlayer/HOUSECHH.wav", 50 );
            isTimerStart = true;
            startTick = nn::os::Tick::GetSystemCurrent();
        }

        if( isTimerStart )
        {
            nn::os::Tick nowTick;
            if( (nn::os::Tick::GetSystemCurrent()-startTick).ToTimeSpan().GetMilliSeconds() > WAIT_TIME )
            {
                isCaptured = true;
            }
        }

    }
    while( isCaptured == false );
    camera->Stop();
    nn::camera::CTR::PlayShutterSound(nn::camera::CTR::SHUTTER_SOUND_TYPE_NORMAL);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    ::ShowMessage ( gfx, "Keep the Position", "Push A to next." );
    gfx->m_DrawFramework->SwapBuffers();
	
    Config lcdConfig;
    Config::Member lcdMember = lcdConfig.Get();
	int waitTime = WAIT_TIME;			// ʕ\mFp҂

    //mF
    /*
    do{
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        pad.UpdatePad();
        if( waitTime>0 ) waitTime--;
		if( pad.IsButtonDown(Pad::BUTTON_A) && waitTime == 0 )	break;
    }while( 1 );
    */
    pad.ClearTriggerFlag();

    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete sp;

    result.m_Result = true;
    return result.m_Result;
}

