
/********************************************************************
J̃V[PXĂяo
********************************************************************/

#include <string.h>
#include <nn.h>
#include <nn/gx.h>
#include <nn/camera.h>
#include <nn/y2r.h>
#include <nn/uds.h>
#include <string.h>
#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include "sys.h"
#include "../sys/sys_GetSerialNumber.h"
#include "../seq/Reception_camera.h"
#include "../seq/Reception_board_interface.h"
#include "../seq/Config.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "TestCamera.h"
#include "CameraRegister.h"
#include "CameraCalTypes.h"
#include "CameraPositionCalTypes.h"
#include "SeqCamera.h"
#include "../eva/mcu/TestMcu.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace uji::eva;
using namespace uji::seq;
using namespace nn::camera;

static uji::eva::camera::CalData s_CalData;
const s16 MAX_AWB_CCM_L = 511;
const s16 MAX_AWB_CCM   =  78;

struct LogElements{
    int ProcessType;
    char Date[11];
    char Time[6];
    char BoxId[7];
};



/*---------------------------------------------------------------------------
 [Tv]f[^[q̃I[v`FbN(AND)
---------------------------------------------------------------------------*/
static u8 CalcAnd( u8 *buffer, int size ){
    u8 answer=0xFF;

    while(size--)
    {
        answer &= *buffer;
        buffer++;
    }
    return answer;
}

/*---------------------------------------------------------------------------
 [Tv]f[^[q̃I[v`FbN(OR)
---------------------------------------------------------------------------*/
static u8 CalcOr( u8 *buffer, int size ){
    u8 answer=0;

    while(size--)
    {
        answer |= *buffer;
        buffer++;
    }
    return answer;
}

/*---------------------------------------------------------------------------
 [Tv]f[^[q̃V[g`FbN

 ̃rbgmɓlǂ`FbN܂
---------------------------------------------------------------------------*/
extern bool ShortCheck( u8 *buffer, int size, char *str ){
    typedef union{
        struct {
            u8 d0 : 1;
            u8 d1 : 1;
            u8 d2 : 1;
            u8 d3 : 1;
            u8 d4 : 1;
            u8 d5 : 1;
            u8 d6 : 1;
            u8 d7 : 1;
        }map;

        u8 data;
    } CAM_SHORT_CHECK;
    CAM_SHORT_CHECK temp,x[7];

    u8 result;

    // x[]̏
    for( int i=0; i<7; i++ )
    {
        x[i].data = 0x00;
    }

    for( int i=0;i<size; i++)
    {
        temp.data = buffer[i];

        x[0].map.d1 |= (temp.map.d0 ^ temp.map.d1);
        x[0].map.d2 |= (temp.map.d0 ^ temp.map.d2);
        x[0].map.d3 |= (temp.map.d0 ^ temp.map.d3);
        x[0].map.d4 |= (temp.map.d0 ^ temp.map.d4);
        x[0].map.d5 |= (temp.map.d0 ^ temp.map.d5);
        x[0].map.d6 |= (temp.map.d0 ^ temp.map.d6);
        x[0].map.d7 |= (temp.map.d0 ^ temp.map.d7);

        x[1].map.d2 |= (temp.map.d1 ^ temp.map.d2);
        x[1].map.d3 |= (temp.map.d1 ^ temp.map.d3);
        x[1].map.d4 |= (temp.map.d1 ^ temp.map.d4);
        x[1].map.d5 |= (temp.map.d1 ^ temp.map.d5);
        x[1].map.d6 |= (temp.map.d1 ^ temp.map.d6);
        x[1].map.d7 |= (temp.map.d1 ^ temp.map.d7);

        x[2].map.d3 |= (temp.map.d2 ^ temp.map.d3);
        x[2].map.d4 |= (temp.map.d2 ^ temp.map.d4);
        x[2].map.d5 |= (temp.map.d2 ^ temp.map.d5);
        x[2].map.d6 |= (temp.map.d2 ^ temp.map.d6);
        x[2].map.d7 |= (temp.map.d2 ^ temp.map.d7);

        x[3].map.d4 |= (temp.map.d3 ^ temp.map.d4);
        x[3].map.d5 |= (temp.map.d3 ^ temp.map.d5);
        x[3].map.d6 |= (temp.map.d3 ^ temp.map.d6);
        x[3].map.d7 |= (temp.map.d3 ^ temp.map.d7);

        x[4].map.d5 |= (temp.map.d4 ^ temp.map.d5);
        x[4].map.d6 |= (temp.map.d4 ^ temp.map.d6);
        x[4].map.d7 |= (temp.map.d4 ^ temp.map.d7);

        x[5].map.d6 |= (temp.map.d5 ^ temp.map.d6);
        x[5].map.d7 |= (temp.map.d5 ^ temp.map.d7);

        x[6].map.d7 |= (temp.map.d6 ^ temp.map.d7);

    }

    sprintf(str,"  1234567\n"
                "0 %c%c%c%c%c%c%c\n"
                "1 -%c%c%c%c%c%c\n"
                "2 --%c%c%c%c%c\n"
                "3 ---%c%c%c%c\n"
                "4 ----%c%c%c\n"
                "5 -----%c%c\n"
                "6 ------%c\n",
                x[0].map.d1?'O':'X',x[0].map.d2?'O':'X',x[0].map.d3?'O':'X',x[0].map.d4?'O':'X',x[0].map.d5?'O':'X',x[0].map.d6?'O':'X',x[0].map.d7?'O':'X',
                x[1].map.d2?'O':'X',x[1].map.d3?'O':'X',x[1].map.d4?'O':'X',x[1].map.d5?'O':'X',x[1].map.d6?'O':'X',x[1].map.d7?'O':'X',
                x[2].map.d3?'O':'X',x[2].map.d4?'O':'X',x[2].map.d5?'O':'X',x[2].map.d6?'O':'X',x[2].map.d7?'O':'X',
                x[3].map.d4?'O':'X',x[3].map.d5?'O':'X',x[3].map.d6?'O':'X',x[3].map.d7?'O':'X',
                x[4].map.d5?'O':'X',x[4].map.d6?'O':'X',x[4].map.d7?'O':'X',
                x[5].map.d6?'O':'X',x[5].map.d7?'O':'X',
                x[6].map.d7?'O':'X'  );

    //ʔ
    if( (x[0].data&0xfe)==0xfe &&
        (x[1].data&0xfc)==0xfc &&
        (x[2].data&0xf8)==0xf8 &&
        (x[3].data&0xf0)==0xf0 &&
        (x[4].data&0xe0)==0xe0 &&
        (x[5].data&0xc0)==0xc0 &&
        (x[6].data&0x80)==0x80 )
    {
        return true;
    }else{
        return false;
    }

}

/************************************************************************
JI[vV[g
  ************************************************************************/
static bool TestOpencheck_Common(TestResult &result, nn::camera::CTR::CameraSelect select )
{
    char shortString[0x100];
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    TestCamera *camera = new TestCamera;
    camera->Initialize();

    //Lv`
    if( !camera->TryStart( result, select ))
    {
        camera->Stop();
        camera->Finalize();
        delete camera;
        return result.m_Result;
    }
    for( int i=0 ; i< 60 ; i++ )
    {
        camera->Update();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }

    u8 andAnswer = CalcAnd( (u8*)camera->GetYuv(), TestCamera::CAMERA_WIDTH*TestCamera::CAMERA_HEIGHT*sizeof(u16) );
    u8 orAnswer = CalcOr( (u8*)camera->GetYuv(), TestCamera::CAMERA_WIDTH*TestCamera::CAMERA_HEIGHT*sizeof(u16) );
    bool shortAnswer = ShortCheck( (u8*)camera->GetYuv(), TestCamera::CAMERA_WIDTH*TestCamera::CAMERA_HEIGHT*sizeof(u16), shortString );


    camera->Stop();
    camera->Finalize();
    delete camera;
    
    uji::eva::mcu::CameraLedPinkOff( result );

    sprintf( result.m_String, "AND=%02X OR=%02X\nSHORT\n%s", (int)andAnswer, (int)orAnswer, shortString );
    result.m_Result = ( andAnswer==0 && orAnswer==0xff && shortAnswer==true )?true:false;

    return result.m_Result;

}

bool uji::eva::camera::TestOpencheckICAM(TestResult &result)
{
    return TestOpencheck_Common( result, nn::camera::CTR::SELECT_IN1 );
}

bool uji::eva::camera::TestOpencheckOCAM1(TestResult &result)
{
    return TestOpencheck_Common( result, nn::camera::CTR::SELECT_OUT1 );
}
bool uji::eva::camera::TestOpencheckOCAM2(TestResult &result)
{
    return TestOpencheck_Common( result, nn::camera::CTR::SELECT_OUT2 );
}

/************************************************************************
JShc擾
  ************************************************************************/
bool uji::eva::camera::TestCameraGetAllId(TestResult &result)
{
    u16 sendBuffer[3];

    enum{
        ICAM,
        OCAM1,
        OCAM2
    };


    nn::Result nnr;

    TestCamera *camera = new TestCamera;
    camera->Initialize();

    camera->Start( SELECT_IN1 );
    nnr = ReadRegisterI2cExclusive( &sendBuffer[ICAM], SELECT_IN1, R_K22A_CHIP_ID );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read register" );
    camera->Stop();

    camera->Start( SELECT_OUT1 );
    nnr = ReadRegisterI2cExclusive( &sendBuffer[OCAM1], SELECT_OUT1, R_K22A_CHIP_ID );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read register" );
    camera->Stop();

    camera->Start( SELECT_OUT2 );
    nnr = ReadRegisterI2cExclusive( &sendBuffer[OCAM2], SELECT_OUT2, R_K22A_CHIP_ID );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read register" );
    camera->Stop();

    camera->Finalize();
    delete camera;

    g_CommC2T->WriteDpramBinary( (u8*)sendBuffer, sizeof(sendBuffer) );

    sprintf( result.m_String, "ICAM  ID=%04X\nOCAM1 ID=%04X\nOCAM2 ID=%04X\n",
                sendBuffer[ICAM], sendBuffer[OCAM1], sendBuffer[OCAM2] );
    result.m_Result=true;
    return result.m_Result;

}

/************************************************************************
JEJp
  ************************************************************************/

static TestCamera *s_Camera = NULL;     //JCX^X
static bool s_IsAverageMode = false;    //ϒl[hۂ
static int s_CaptureCount   = 200;      //Lv`b

/************************************************************************
J
  ************************************************************************/
bool uji::eva::camera::TestInitialize(TestResult &result)
{
    if( s_Camera==NULL )
    {
        s_Camera = new TestCamera;
        s_Camera->Initialize();
    }else{
        s_Camera->Finalize();
        s_Camera->Initialize();
    }
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
JLv`Ԑݒ
  ************************************************************************/
bool uji::eva::camera::TestSetCaptureCount(TestResult &result)
{
    int retValue;
    if( sscanf( result.m_String, "%d", &retValue )!=EOF )
    {
        result.m_Result = true;
        s_CaptureCount  = retValue;
    }else{
        result.m_Result = false;
    }

    sprintf( result.m_String, "CAPTURE_COUNT=%d", s_CaptureCount );
    result.m_Result = true;
    return result.m_Result;
}
/************************************************************************
JI
  ************************************************************************/
bool uji::eva::camera::TestSelect(TestResult &result)
{
    nn::camera::CameraSelect select;
    //͕Result.m_StringɊi[Ă\B

    switch( result.m_String[0] )
    {
    case '0':
        select=nn::camera::CTR::SELECT_NONE;
        break;
    case '1':
        select=nn::camera::CTR::SELECT_OUT1;
        break;
    case '2':
        select=nn::camera::CTR::SELECT_IN1;
        break;
    case '3':
        select=nn::camera::CTR::SELECT_OUT2;
        break;
    default:
        select=nn::camera::CTR::SELECT_OUT1;
        break;
    }

    sprintf( result.m_String, "SELECT_CAM=%d", select );
    s_Camera->Start( select );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
JBe
  ************************************************************************/
bool uji::eva::camera::TestCapture(TestResult &result)
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    s_IsAverageMode = false;
    s_Camera->EnableZoomOut();
    s_Camera->SetScroll( -80, 0 );
    for( int i=0 ; i<s_CaptureCount ; i++ )
    {
        Menu::m_WindowManager.Update();
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();

        s_Camera->Update();

        s_Camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );

    }
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
JBeiω摜j
  ************************************************************************/
bool uji::eva::camera::TestCaptureAverage(TestResult &result)
{
    const int CAPTURE_COUNT = 300;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    s_IsAverageMode = true;
    s_Camera->EnableZoomOut();
    s_Camera->SetScroll( -80, 0 );
    for( int i=0 ; i<CAPTURE_COUNT ; i++ )
    {
        Menu::m_WindowManager.Update();
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();

        s_Camera->Update();

        s_Camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );

    }
    s_Camera->UpdateToAverage();
    s_Camera->Draw( gfx->m_DrawFramework );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );

    result.m_Result = true;
    return result.m_Result;
}



/************************************************************************
JrcJ[hɕۑ
  ************************************************************************/
bool uji::eva::camera::TestSave(TestResult &result)
{
    s_Camera->Stop();
    if( s_IsAverageMode )
    {
        result.m_Result = s_Camera->SaveAverage();
    }else{
        result.m_Result = s_Camera->Save();
    }
    return result.m_Result;
}


/************************************************************************
l`bAhX𑗐M
  ************************************************************************/
bool uji::eva::camera::TestGetMacAddress(TestResult &result)
{
    bit8 mac[6]={0,0,0,0,0,0};
    uji::sys::GetMacAddress( mac );

    sprintf( result.m_String, "%02X%02X%02X%02X%02X%02X", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5] );
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
J̉摜𑗐M

udlŁAehenJE^ňCɑđv
  ************************************************************************/
bool uji::eva::camera::TestSend(TestResult &result)
{
    s_Camera->Stop();
    u32 transSize;
    u32 residualQuantity = TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *2;

    u8 *current;
    if( s_IsAverageMode )
    {
        current = (u8 *)s_Camera->GetYuvAverage();
    }else{
        current = (u8 *)s_Camera->GetYuv();
    }

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *2 );
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
J̉摜alo`őM
  ************************************************************************/
static void ShowProgress(u32 fifoCount, u32 residualQuantity)
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
    gfx->BeginDrawingString();
    gfx->m_TextWriter.SetTextColor(nn::util::Color8::YELLOW);
    gfx->m_TextWriter.SetCursor(0, 0);
    gfx->m_TextWriter.Printf( "FIFOCNT=%d/RESIDUAL QUANTITY=%d", fifoCount, residualQuantity );
    gfx->EndDrawingString();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

bool uji::eva::camera::TestSendBmp(TestResult &result)
{
    s_Camera->Stop();
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    u32 bmpSize = (TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *3 );
    u8 *buffer = (u8*)sysApp->Allocate( bmpSize );
    BmpTexture *bt = new BmpTexture;
    bt->ConvertTextureToBmp( buffer, (u8*)s_Camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    uji::seq::Config  *config = new uji::seq::Config;
    g_CommPacketCamera->Initialize( static_cast<CommCamera::SpiType>(config->Get().CspiMode) );
    delete config;

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1));
    }

    //wb_M
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpFileHeader, sizeof(BitmapFileHeader) );
    g_CommPacketCamera->m_CommCamera.WriteDataFifo( (u8*)bmpInfoHeader, sizeof(BitmapInfoHeader) );

    delete bmpInfoHeader;
    delete bmpFileHeader;

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1));
    }


    //alof[^ehenɑ
    u32 transSize;
    u32 fifoCount;
    u32 residualQuantity = bmpSize;
    const u8 *current = buffer;


    while( residualQuantity != 0)
    {

        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();
        transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;

        //]Pʂ16oCgPʂɂ
        transSize = transSize & 0xfff0;
        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            residualQuantity -= transSize;
        }
    }

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1));
    }

    sysApp->Free( buffer );
    result.m_Result = true;
    return result.m_Result;
}


/************************************************************************
Lu[V𕶎񂩂\̂֊i[Ȃ
  ************************************************************************/
bool ParseParallaxCal( uji::eva::camera::CalibrationDataCore *cal, const char *string )
{
    const int CAL_BYTES = 36;
    union{
        uji::eva::camera::CalibrationDataCore cal;
        u8 raw[CAL_BYTES];
    } converter;
    //ϊ̕񒷃`FbN
    if( strlen(string) != CAL_BYTES*2 ) return false;

    for( int i=0 ; i<CAL_BYTES ; i++ )
    {
        //lɕϊ
        int val = CommandUtil::ConvertNumFromString(&string[i*2], 2);
        if( val == -1 ) return false;
        converter.raw[i]=(u8)val;
    }


    //ϊjIgpĈꊇϊ
    *cal = converter.cal;

    return true;

}


/************************************************************************
Lu[Vlݒ
  ************************************************************************/
bool uji::eva::camera::TestCameraSetCal(TestResult &result)
{
    using namespace nn::drivers::cal::CTR;

    uji::seq::Config c;

    nn::fs::FileOutputStream ofile;

    uji::eva::camera::CalibrationDataCore cal;

    Calibration calOut;
    CameraCalDataCore cameraCalData;

    //ϊ
    result.m_Result= ParseParallaxCal( &cal, result.m_String );
    if( !result.m_Result )
    {
        strcpy( result.m_String, "ParseParallaxCal fail" );
        return result.m_Result;
        // goto FINALLY;
    }

    if( c.Get().EnableDebugOut )
    {
        //t@CI[v
        if( nn::fs::MountSdmc().IsFailure() )
        {
            strcpy( result.m_String, "MountSdmc fail" );
            return result.m_Result;
        }
        // SYS_PANIC( "FAIL TO MOUNT SDMC" );

        nn::fs::TryCreateDirectory(L"sdmc:/uji" );
        nn::fs::TryCreateDirectory(L"sdmc:/uji/camera" );

        if( ofile.TryInitialize( L"sdmc:/uji/camera/parallax.txt", true ).IsSuccess() )
        {
            //t@CɃZ[u
            char str[100];
            sprintf( str, "%s\n", result.m_String );
            ofile.Write( str, strlen(str) );
            sprintf( str, "\nflags=%d\n", (int)cal.flags );
            ofile.Write( str, strlen(str) );
            sprintf( str, "scale=%f\n", cal.scale );
            ofile.Write( str, strlen(str) );
            sprintf( str, "rotationZ=%f\n", cal.rotationZ );
            ofile.Write( str, strlen(str) );
            sprintf( str, "translationX=%f\n", cal.translationX );
            ofile.Write( str, strlen(str) );
            sprintf( str, "translationY=%f\n", cal.translationY );
            ofile.Write( str, strlen(str) );
            sprintf( str, "rotationX=%f\n", cal.rotationX );
            ofile.Write( str, strlen(str) );
            sprintf( str, "rotationY=%f\n", cal.rotationY );
            ofile.Write( str, strlen(str) );
            sprintf( str, "angleOfViewRight=%f\n", cal.angleOfViewRight );
            ofile.Write( str, strlen(str) );
            sprintf( str, "angleOfViewLeft=%f\n", cal.angleOfViewLeft );
            ofile.Write( str, strlen(str) );
            ofile.Finalize();
        }
        nn::fs::Unmount("sdmc:");
    }

    //b`kɏ
    calOut.Initialize();
    if( !calOut.Get(&cameraCalData, CAL_DATA_CAMERA) )
    {
        strcpy( result.m_String, "calOut.Get fail" );
        return result.m_Result;
    }
    // SYS_PANIC( "CAL FAIL" );

    cameraCalData.position.flags            = cal.flags;
    cameraCalData.position.scale            = cal.scale;
    cameraCalData.position.rotationZ        = cal.rotationZ;
    cameraCalData.position.translationX     = cal.translationX;
    cameraCalData.position.translationY     = cal.translationY;
    cameraCalData.position.rotationX        = cal.rotationX;
    cameraCalData.position.rotationY        = cal.rotationY;
    cameraCalData.position.angleOfViewRight = cal.angleOfViewRight;
    cameraCalData.position.angleOfViewLeft  = cal.angleOfViewLeft;
    cameraCalData.position.distanceToChart  = 250.0f;
    cameraCalData.position.distanceCameras  = 35.0f;
    cameraCalData.position.imageWidth       = 640;
    cameraCalData.position.imageHeight      = 480;
    for( int i=0 ; i<4 ; i++ ) cameraCalData.position.reserved[i]=0;

    if( !calOut.Set(&cameraCalData, CAL_DATA_CAMERA))
    {
        strcpy( result.m_String, "calOut.Set fail" );
        return result.m_Result;
    }
    // SYS_PANIC( "CAL FAIL" );
    if( !calOut.Flush() )
    {
        strcpy( result.m_String, "calOut.Flush fail" );
        return result.m_Result;
    }
    // SYS_PANIC( "CAL FAIL" );

    result.m_Result=true;

FINALLY:
    strcpy( result.m_String, "" );
    return result.m_Result;
}


/************************************************************************
O
  ************************************************************************/
char* GetTestName()
{
#if defined( EVA_COMPOSITE )
    uji::seq::Config c;
    if     ( c.GetAlternative().TestList==TESTLIST_ID_OCAM )    { return "Ocam";     }
    else if( c.GetAlternative().TestList==TESTLIST_ID_PARALLAX ){ return "Parallax"; }
    else                                                        { return "Unknown";  }
#elif defined(EVA_PARALLAX)
    return "Parallax";
#elif defined(EVA_OCAM)
    return "Ocam";
#else
    return "Unknown";
#endif
}

void ParseLogElements( LogElements *logElements, const char *inString )
{
    logElements->ProcessType = inString[0]-'0';
    memcpy( logElements->Date, &inString[2], 10 );
    logElements->Date[10]='\0';
    memcpy( logElements->Time, &inString[13], 5 );
    logElements->Time[5]='\0';
    memcpy( logElements->BoxId, & inString[19], 6 );
    logElements->BoxId[6]='\0';
}

bool uji::eva::camera::TestCameraLogStart(TestResult &result)
{
    LogElements logElements;
    ParseLogElements( &logElements, result.m_String );

    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    pdl->Add_1Line( logElements.ProcessType,
                    GetTestName(),
                    "START",
                    VERSION_STRING,
                    logElements.Date,
                    logElements.Time,
                    logElements.BoxId,
                    "" );
    delete pdl;

    strcpy( result.m_String, "" );
    result.m_Result = true;
    return result.m_Result;
}

bool uji::eva::camera::TestCameraLogPass(TestResult &result)
{
    LogElements logElements;
    ParseLogElements( &logElements, result.m_String );

    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    pdl->Add_1Line( logElements.ProcessType,
                    GetTestName(),
                    "OK",
                    VERSION_STRING,
                    logElements.Date,
                    logElements.Time,
                    logElements.BoxId,
                    "" );
    delete pdl;

    strcpy( result.m_String, "" );
    result.m_Result = true;
    return result.m_Result;
}


/************************************************************************
VAio[ǂݏo

iJ͑z蒷𒴂ƈُ퓮삷̂
z蒷𒴂Ȃ悤ɂKv

  ************************************************************************/
bool uji::eva::camera::TestCameraGetId(TestResult &result)
{
    const int SERIAL_NUMBER_OUTPUT_LEN = 11;

    char str[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];

    //VAio[擾
    uji::sys::GetSerialNumber(str);

    //o͍ő啶Ńg~O
    strncpy( result.m_String, str, SERIAL_NUMBER_OUTPUT_LEN );
    result.m_String[SERIAL_NUMBER_OUTPUT_LEN]='\0';

    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc0(TestResult &result)
{
    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc1(TestResult &result)
{
    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc2(TestResult &result)
{
    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc3(TestResult &result)
{
    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc4(TestResult &result)
{
    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc5(TestResult &result)
{
    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc6(TestResult &result)
{
    const int TIME_OUT = 600;
    const int STABLE   = 60;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    nn::Result nnr;
    u16 awb_mode;

    //JN
    s_Camera->Start( SELECT_OUT2 );

    //zCgoXݒ
    s_Camera->SetWhiteBalance( WHITE_BALANCE_AUTO );

    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbGain_BPre, SELECT_OUT2, V_AWB_GAIN_B );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbSteadyGainInMax, SELECT_OUT2, V_AWB_STEADY_B_GAIN_IN_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbSteadyGainOutMax, SELECT_OUT2, V_AWB_STEADY_B_GAIN_OUT_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );

    u16 gainInMax = s_CalData.cam2.awbSteadyGainInMax;
    if( s_CalData.cam2.awbGain_BPre >= gainInMax )
    {
        gainInMax = s_CalData.cam2.awbGain_BPre+10;
        if( gainInMax > 0xfe ) gainInMax = 0xfe;
        nnr = WriteMcuVariableI2c( SELECT_OUT2, V_AWB_STEADY_B_GAIN_IN_MAX, gainInMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }
    if( gainInMax >= s_CalData.cam2.awbSteadyGainOutMax )
    {
        u16 gainOutMax = gainInMax+10;
        if( gainOutMax > 0xff ) gainOutMax = 0xff;
        nnr = WriteMcuVariableI2c( SELECT_OUT2, V_AWB_STEADY_B_GAIN_OUT_MAX, gainOutMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }

    //҂
    s_CalData.cam2.awbStableTime=0;
    int stableCounter=0;
    do
    {
        if( ++s_CalData.cam2.awbStableTime >= TIME_OUT )
        {
            sprintf( result.m_String, "1" );
            result.m_Result=false;
            return result.m_Result;

        }
        s_Camera->Update();
        nnr = ReadMcuVariableI2cExclusive( &awb_mode, SELECT_OUT2, V_AWB_MODE );   //suspect!!
        if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
        if( ( awb_mode & 0x01 )==0 ){
            stableCounter=0;
        }else{
            stableCounter++;
        }

        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }while( stableCounter<STABLE );

    //ep[^擾
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.ccm9, SELECT_OUT2, V_CCM9  );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.ccm10,SELECT_OUT2, V_CCM10 );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbGain_R,    SELECT_OUT2, V_AWB_GAIN_R     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbGain_B,    SELECT_OUT2, V_AWB_GAIN_B     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    s_Camera->Stop();



    //Lu[VlZiľܓj
    double ccm9      = (double)s_CalData.cam2.ccm9;
    double ccm10     = (double)s_CalData.cam2.ccm10;
    double awbGain_R = (double)s_CalData.cam2.awbGain_R;
    double awbGain_B = (double)s_CalData.cam2.awbGain_B;

    s_CalData.awbCcmL9_OCAM2 = (u16)( ( (ccm9  * awbGain_R)/128.0 )+ 0.5 );
    s_CalData.awbCcmL10_OCAM2= (u16)( ( (ccm10 * awbGain_B)/128.0 )+ 0.5 );

    //͈̓G[
    if( s_CalData.awbCcmL9_OCAM2<=MAX_AWB_CCM_L && s_CalData.awbCcmL10_OCAM2<=MAX_AWB_CCM_L )
    {
        sprintf( result.m_String, "0" );
        result.m_Result=true;
    }else{
        sprintf( result.m_String, "2" );
        result.m_Result=false;
    }
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc7(TestResult &result)
{
    const int TIME_OUT = 600;
    const int STABLE   = 60;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    nn::Result nnr;
    u16 awb_mode;

    //JN
    s_Camera->Start( SELECT_OUT1 );

    //zCgoXݒ
    s_Camera->SetWhiteBalance( WHITE_BALANCE_AUTO );

    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbGain_BPre, SELECT_OUT1, V_AWB_GAIN_B );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbSteadyGainInMax, SELECT_OUT1, V_AWB_STEADY_B_GAIN_IN_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbSteadyGainOutMax, SELECT_OUT1, V_AWB_STEADY_B_GAIN_OUT_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );

    u16 gainInMax = s_CalData.cam1.awbSteadyGainInMax;
    if( s_CalData.cam1.awbGain_BPre >= gainInMax )
    {
        gainInMax = s_CalData.cam1.awbGain_BPre+10;
        if( gainInMax > 0xfe ) gainInMax = 0xfe;
        nnr = WriteMcuVariableI2c( SELECT_OUT1, V_AWB_STEADY_B_GAIN_IN_MAX, gainInMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }
    if( gainInMax >= s_CalData.cam1.awbSteadyGainOutMax )
    {
        u16 gainOutMax = gainInMax+10;
        if( gainOutMax > 0xff ) gainOutMax = 0xff;
        nnr = WriteMcuVariableI2c( SELECT_OUT1, V_AWB_STEADY_B_GAIN_OUT_MAX, gainOutMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }

    //҂
    s_CalData.cam1.awbStableTime=0;
    int stableCounter=0;
    do
    {
        if( ++s_CalData.cam1.awbStableTime>=TIME_OUT )
        {
            sprintf( result.m_String, "1" );
            result.m_Result=false;
            return result.m_Result;

        }
        s_Camera->Update();
        nnr = ReadMcuVariableI2cExclusive( &awb_mode, SELECT_OUT1, V_AWB_MODE );
        if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );

        if( ( awb_mode & 0x01 )==0 ){
            stableCounter=0;
        }else{
            stableCounter++;
        }

        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }while( stableCounter<STABLE );

    //ep[^擾
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.ccm9, SELECT_OUT1, V_CCM9  );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.ccm10,SELECT_OUT1, V_CCM10 );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbGain_R,    SELECT_OUT1, V_AWB_GAIN_R     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbGain_B,    SELECT_OUT1, V_AWB_GAIN_B     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    s_Camera->Stop();

    //Lu[VlZiľܓj
    double ccm9      = (double)s_CalData.cam1.ccm9;
    double ccm10     = (double)s_CalData.cam1.ccm10;
    double awbGain_R = (double)s_CalData.cam1.awbGain_R;
    double awbGain_B = (double)s_CalData.cam1.awbGain_B;

    s_CalData.awbCcmL9_OCAM1 = (u16)( ( (ccm9  * awbGain_R)/128.0 )+ 0.5 );
    s_CalData.awbCcmL10_OCAM1= (u16)( ( (ccm10 * awbGain_B)/128.0 )+ 0.5 );

    //͈̓G[
    if( s_CalData.awbCcmL9_OCAM1<=MAX_AWB_CCM_L && s_CalData.awbCcmL10_OCAM1<=MAX_AWB_CCM_L )
    {
        sprintf( result.m_String, "0" );
        result.m_Result=true;
    }else{
        sprintf( result.m_String, "2" );
        result.m_Result=false;
    }
    return result.m_Result;
}

/************************************************************************
b`kp
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc8(TestResult &result)
{
    const char TERMINATOR[]="</DATA>\n";

    nn::fs::FileOutputStream ofile;
    nn::Result nnr;
    char str[0x100];

    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
    GetMacAddress( mac );

    //t@CI[vď{
    if( nn::fs::MountSdmc().IsFailure() ) SYS_PANIC( "FAIL TO MOUNT SDMC" );
    nn::fs::TryCreateDirectory(L"sdmc:/uji" );
    nn::fs::TryCreateDirectory(L"sdmc:/uji/camera" );
    nnr = ofile.TryInitialize( L"sdmc:/uji/camera/CameraCaldata.xml", true );
    if( nnr.IsFailure()  )
    {
        strcpy( result.m_String, "3" );
        result.m_Result=false;
        return result.m_Result;
    }
    if( ofile.GetSize()==0 )
    {
        sprintf( str, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DATA>\n" );
        if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    }else{
        //ǋL
        ofile.Seek( ofile.GetSize()-strlen(TERMINATOR), nn::fs::POSITION_BASE_BEGIN );  //I[s폜
    }

    //wb_
    sprintf( str, "<CAMERACALDATA>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;

    //l`bAhX
    sprintf( str, "<MAC_ADDRESS>%02X-%02X-%02X-%02X-%02X-%02X</MAC_ADDRESS>\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5] );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;

    //b`lP
    sprintf( str, "<CAM1>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_CURRENTY>%d</C1_CURRENTY>\n", s_CalData.cam1.currenty );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_AWB_GAIN_B_PRE>%d</C1_AWB_GAIN_B_PRE>\n", s_CalData.cam1.awbGain_BPre );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_AWB_STEADY_GAIN_IN_MAX>%d</C1_AWB_STEADY_GAIN_IN_MAX>\n", s_CalData.cam1.awbSteadyGainInMax );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_AWB_STEADY_GAIN_OUT_MAX>%d</C1_AWB_STEADY_GAIN_OUT_MAX>\n", s_CalData.cam1.awbSteadyGainOutMax );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_CCM9>%d</C1_CCM9>\n<C1_CCM10>%d</C1_CCM10>\n",
            s_CalData.cam1.ccm9, s_CalData.cam1.ccm10 );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_AWB_GAIN_R>%d</C1_AWB_GAIN_R>\n<C1_AWB_GAIN_B>%d</C1_AWB_GAIN_B>\n",
            s_CalData.cam1.awbGain_R, s_CalData.cam1.awbGain_B );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C1_AE_STABLE_TIME>%d</C1_AE_STABLE_TIME>\n<C1_AWB_STABLE_TIME>%d</C1_AWB_STABLE_TIME>\n",
            s_CalData.cam1.aeStableTime, s_CalData.cam1.awbStableTime );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "</CAM1>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;

    //b`lQ
    sprintf( str, "<CAM2>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_CURRENTY>%d</C2_CURRENTY>\n", s_CalData.cam2.currenty );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_AWB_GAIN_B_PRE>%d</C2_AWB_GAIN_B_PRE>\n", s_CalData.cam2.awbGain_BPre );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_AWB_STEADY_GAIN_IN_MAX>%d</C2_AWB_STEADY_GAIN_IN_MAX>\n", s_CalData.cam2.awbSteadyGainInMax );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_AWB_STEADY_GAIN_OUT_MAX>%d</C2_AWB_STEADY_GAIN_OUT_MAX>\n", s_CalData.cam2.awbSteadyGainOutMax );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_CCM9>%d</C2_CCM9>\n<C2_CCM10>%d</C2_CCM10>\n",
            s_CalData.cam2.ccm9, s_CalData.cam2.ccm10 );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_AWB_GAIN_R>%d</C2_AWB_GAIN_R>\n<C2_AWB_GAIN_B>%d</C2_AWB_GAIN_B>\n",
            s_CalData.cam2.awbGain_R, s_CalData.cam2.awbGain_B );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<C2_AE_STABLE_TIME>%d</C2_AE_STABLE_TIME>\n<C2_AWB_STABLE_TIME>%d</C2_AWB_STABLE_TIME>\n",
            s_CalData.cam2.aeStableTime, s_CalData.cam2.awbStableTime );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "</CAM2>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;

    //b`k
    sprintf( str, "<CALIBRATION>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<AE_BASE_TARGET>%d</AE_BASE_TARGET>\n", s_CalData.aeBaseTarget );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<CAM1_AWB_CCM_L9>%d</CAM1_AWB_CCM_L9>\n", s_CalData.awbCcmL9_OCAM1 );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<CAM1_AWB_CCM_L10>%d</CAM1_AWB_CCM_L10>\n", s_CalData.awbCcmL10_OCAM1 );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<CAM2_AWB_CCM_L9>%d</CAM2_AWB_CCM_L9>\n", s_CalData.awbCcmL9_OCAM2 );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "<CAM2_AWB_CCM_L10>%d</CAM2_AWB_CCM_L10>\n", s_CalData.awbCcmL10_OCAM2 );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, "</CALIBRATION>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;


    //tb^
    sprintf( str, "</CAMERACALDATA>\n" );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;
    sprintf( str, TERMINATOR );
    if( ofile.Write( str, strlen(str) ) != strlen(str) )    goto ERROR;

    //N[Y
    ofile.Finalize();
    nn::fs::Unmount("sdmc:");
    result.m_Result=true;
    strcpy( result.m_String, "0" );
    return result.m_Result;

ERROR:
    //N[Y
    ofile.Finalize();
    nn::fs::Unmount("sdmc:");
    result.m_Result = false;
    strcpy( result.m_String, "3" );
    return result.m_Result;
}

/************************************************************************
 b`kɕ␳lۑ
  ************************************************************************/
bool uji::eva::camera::TestCameraExtraFunc9(TestResult &result)
{
    using namespace nn::drivers::cal::CTR;

    Calibration cal;
    CameraCalDataCore cameraCalData;
    CameraCalAppendCore cameraCalAppend;

    cal.Initialize();

    //̃Lf[^ǂݏo
    if( !cal.Get(&cameraCalData,    CAL_DATA_CAMERA) )          SYS_PANIC( "CAL FAIL" );
    if( !cal.Get(&cameraCalAppend,  CAL_DATA_CAMERA_APPEND) )   SYS_PANIC( "CAL FAIL" );

    //߂lݒ
    cameraCalData.quality.aeBaseTarget  = 0;
    cameraCalData.quality.kRL           = 0;
    cameraCalData.quality.kGL           = 0;
    cameraCalData.quality.kBL           = 0;
    cameraCalData.quality.ccmPosition   = 0;

    cameraCalAppend.awbCcmL9Right   = s_CalData.awbCcmL9_OCAM1;
    cameraCalAppend.awbCcmL9Left    = s_CalData.awbCcmL9_OCAM2;
    cameraCalAppend.awbCcmL10Right  = s_CalData.awbCcmL10_OCAM1;
    cameraCalAppend.awbCcmL10Left   = s_CalData.awbCcmL10_OCAM2;
    cameraCalAppend.awbX0Right      = 0;
    cameraCalAppend.awbX0Left       = 0;

    // lۑ
    if( !cal.Set(&cameraCalData,    CAL_DATA_CAMERA))       SYS_PANIC( "CAL FAIL" );
    if( !cal.Set(&cameraCalAppend,  CAL_DATA_CAMERA_APPEND))SYS_PANIC( "CAL FAIL" );
    if( !cal.Flush() )                                      SYS_PANIC( "CAL FAIL" );

    strcpy( result.m_String, "0" );
    result.m_Result=true;
    return result.m_Result;
}

/************************************************************************
 SDWB CALlfo@before
  ************************************************************************/
bool uji::eva::camera::TestCameraWBtoSD(TestResult &result)
{
    using namespace nn::drivers::cal::CTR;

    Calibration cal;
    CameraCalAppendCore cameraCalAppend;

    cal.Initialize();

    //̃Lf[^ǂݏo
    if( !cal.Get(&cameraCalAppend,  CAL_DATA_CAMERA_APPEND) )   SYS_PANIC( "CAL FAIL" );

    nn::fs::FileOutputStream ofile;
    nn::Result nnr;
    char str[256];

    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
    GetMacAddress( mac );

    //t@CI[vď{
    if( nn::fs::MountSdmc().IsFailure() )
    {
        sprintf( result.m_String, "FAIL TO MOUNT SDMC" );
        result.m_Result=false;
        return result.m_Result;
    }
    nn::fs::TryCreateDirectory(L"sdmc:/uji" );
    nn::fs::TryCreateDirectory(L"sdmc:/uji/camera" );
    nnr = ofile.TryInitialize( L"sdmc:/uji/camera/CameraWBCaldata.csv", true );
    if( nnr.IsFailure()  )
    {
        strcpy( result.m_String, "3" );
        result.m_Result=false;
        return result.m_Result;
    }
    if( ofile.GetSize()==0 )
    {
        sprintf( str, "before/after,MAC ADDRESS,CTR_awbCcmL9_OCAM1,CTR_awbCcmL9_OCAM2,CTR_awbCcmL10_OCAM1,CTR_awbCcmL10_OCAM2,before/after,Simple_awbCcmL9_OCAM1,Simple_awbCcmL9_OCAM2,Simple_awbCcmL10_OCAM1,Simple_awbCcmL10_OCAM2\n" );
        if( ofile.Write( str, strlen(str), true ) != strlen(str) )    goto ERROR;
    }else{
        //ǋL
        ofile.Seek( 0, nn::fs::POSITION_BASE_END );
    }

    //t@CɃZ[u
    sprintf( str, "before,%02X-%02X-%02X-%02X-%02X-%02X,%d,%d,%d,%d,",
            mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],
            // s_CalData.awbCcmL9_OCAM1, s_CalData.awbCcmL9_OCAM2, s_CalData.awbCcmL10_OCAM1, s_CalData.awbCcmL10_OCAM2 );// ł̓WX^lǂ݁HȂ̂Œl肵Ȃ
            cameraCalAppend.awbCcmL9Right, cameraCalAppend.awbCcmL9Left, cameraCalAppend.awbCcmL10Right, cameraCalAppend.awbCcmL10Left );
    if( ofile.Write( str, strlen(str), true ) != strlen(str) )    goto ERROR;

    //N[Y
    ofile.Finalize();
    nn::fs::Unmount("sdmc:");
    result.m_Result=true;
    strcpy( result.m_String, "0" );
    return result.m_Result;

ERROR:
    //N[Y
    ofile.Finalize();
    nn::fs::Unmount("sdmc:");
    result.m_Result = false;
    strcpy( result.m_String, "3" );
    return result.m_Result;
}

/************************************************************************
 SDWB CALlfo@after
  ************************************************************************/
bool uji::eva::camera::TestCameraWBtoSD2(TestResult &result)
{
    using namespace nn::drivers::cal::CTR;

    Calibration cal;
    CameraCalAppendCore cameraCalAppend;

    cal.Initialize();

    //̃Lf[^ǂݏo
    if( !cal.Get(&cameraCalAppend,  CAL_DATA_CAMERA_APPEND) )   SYS_PANIC( "CAL FAIL" );

    nn::fs::FileOutputStream ofile;
    nn::Result nnr;
    char str[100];

    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
    GetMacAddress( mac );

    //t@CI[vď{
    if( nn::fs::MountSdmc().IsFailure() )
    {
        sprintf( result.m_String, "FAIL TO MOUNT SDMC" );
        result.m_Result=false;
        return result.m_Result;
    }
    nn::fs::TryCreateDirectory(L"sdmc:/uji" );
    nn::fs::TryCreateDirectory(L"sdmc:/uji/camera" );
    nnr = ofile.TryInitialize( L"sdmc:/uji/camera/CameraWBCaldata.csv", true );
    if( nnr.IsFailure()  )
    {
        strcpy( result.m_String, "3" );
        result.m_Result=false;
        return result.m_Result;
    }
    if( ofile.GetSize()==0 )
    {
        sprintf( str, "before/after,MAC ADDRESS,awbCcmL9_OCAM1,awbCcmL9_OCAM2,awbCcmL10_OCAM1,awbCcmL10_OCAM2\n" );
        if( ofile.Write( str, strlen(str), true ) != strlen(str) )    goto ERROR;
    }else{
        //ǋL
        ofile.Seek( 0, nn::fs::POSITION_BASE_END );
    }

    //t@CɃZ[u
/*
    sprintf( str, "after,%d,%d,%d,%d\n",
            // mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],
            // s_CalData.awbCcmL9_OCAM1, s_CalData.awbCcmL9_OCAM2, s_CalData.awbCcmL10_OCAM1, s_CalData.awbCcmL10_OCAM2 );// ł̓WX^lǂ݁HȂ̂Œl肵Ȃ
            cameraCalAppend.awbCcmL9Right, cameraCalAppend.awbCcmL9Left, cameraCalAppend.awbCcmL10Right, cameraCalAppend.awbCcmL10Left );
*/
    //t@CɃZ[u
    sprintf( str, "after,%02X-%02X-%02X-%02X-%02X-%02X,%d,%d,%d,%d\n",
            mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],
            cameraCalAppend.awbCcmL9Right, cameraCalAppend.awbCcmL9Left, cameraCalAppend.awbCcmL10Right, cameraCalAppend.awbCcmL10Left );

    if( ofile.Write( str, strlen(str), true ) != strlen(str) )    goto ERROR;

    //N[Y
    ofile.Finalize();
    nn::fs::Unmount("sdmc:");
    result.m_Result=true;
    strcpy( result.m_String, "0" );
    return result.m_Result;

ERROR:
    //N[Y
    ofile.Finalize();
    nn::fs::Unmount("sdmc:");
    result.m_Result = false;
    strcpy( result.m_String, "3" );
    return result.m_Result;
}

/************************************************************************
 zCgoX␳@CAM1iSDJ[hɃOcŁj
  ************************************************************************/
bool uji::eva::camera::TestCameraCalWB_CAM1(TestResult &result)
{
    const int TIME_OUT = 600;
    const int STABLE   = 60;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    nn::Result nnr;
    u16 awb_mode;

    //JN
    s_Camera->Start( SELECT_OUT1 );

    //zCgoXݒ
    s_Camera->SetWhiteBalance( WHITE_BALANCE_AUTO );

    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbGain_BPre, SELECT_OUT1, V_AWB_GAIN_B );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbSteadyGainInMax, SELECT_OUT1, V_AWB_STEADY_B_GAIN_IN_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbSteadyGainOutMax, SELECT_OUT1, V_AWB_STEADY_B_GAIN_OUT_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );

    u16 gainInMax = s_CalData.cam1.awbSteadyGainInMax;
    if( s_CalData.cam1.awbGain_BPre >= gainInMax )
    {
        gainInMax = s_CalData.cam1.awbGain_BPre+10;
        if( gainInMax > 0xfe ) gainInMax = 0xfe;
        nnr = WriteMcuVariableI2c( SELECT_OUT1, V_AWB_STEADY_B_GAIN_IN_MAX, gainInMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }
    if( gainInMax >= s_CalData.cam1.awbSteadyGainOutMax )
    {
        u16 gainOutMax = gainInMax+10;
        if( gainOutMax > 0xff ) gainOutMax = 0xff;
        nnr = WriteMcuVariableI2c( SELECT_OUT1, V_AWB_STEADY_B_GAIN_OUT_MAX, gainOutMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }

    int stableCounter;
    //҂
    s_CalData.cam1.awbStableTime = 0;
    stableCounter = 0;
    do
    {
        if( ++s_CalData.cam1.awbStableTime>=TIME_OUT )
        {
            nn::fs::FileOutputStream ofile;
            char str[100];
            bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
            GetMacAddress( mac );

            //t@CI[vď{
            if( nn::fs::MountSdmc().IsFailure() )
            {
                sprintf( result.m_String, "FAIL TO MOUNT SDMC" );
                result.m_Result=false;
                return result.m_Result;
            }
            nn::fs::TryCreateDirectory(L"sdmc:/uji" );
            nn::fs::TryCreateDirectory(L"sdmc:/uji/camera" );
            nnr = ofile.TryInitialize( L"sdmc:/uji/camera/CameraWBCaldata.csv", true );
            if( ofile.GetSize()==0 )
            {
                sprintf( str, "before/after,MAC ADDRESS,awbCcmL9_OCAM1,awbCcmL9_OCAM2,awbCcmL10_OCAM1,awbCcmL10_OCAM2\n" );
                ofile.Write( str, strlen(str) );
            }else{
                //ǋL
                ofile.Seek( 0, nn::fs::POSITION_BASE_END );
            }
            //t@CɃZ[u
            sprintf( str, "after,%02X-%02X-%02X-%02X-%02X-%02X,TIMEOUT\n", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5] );
            ofile.Write( str, strlen(str) );

            //N[Y
            ofile.Finalize();
            nn::fs::Unmount("sdmc:");

            sprintf( result.m_String, "WhiteBalance Unstable" );
            result.m_Result=false;
            return result.m_Result;
        }
        s_Camera->Update();
        nnr = ReadMcuVariableI2cExclusive( &awb_mode, SELECT_OUT1, V_AWB_MODE );
        if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );

        if( ( awb_mode & 0x01 )==0 ){
            stableCounter=0;
        }else{
            stableCounter++;
        }
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }while( stableCounter<STABLE );

    //ep[^擾
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.ccm9, SELECT_OUT1, V_CCM9  );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.ccm10,SELECT_OUT1, V_CCM10 );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbGain_R,    SELECT_OUT1, V_AWB_GAIN_R     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam1.awbGain_B,    SELECT_OUT1, V_AWB_GAIN_B     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    s_Camera->Stop();

    //Lu[VlZiľܓj
    double ccm9      = (double)s_CalData.cam1.ccm9;
    double ccm10     = (double)s_CalData.cam1.ccm10;
    double awbGain_R = (double)s_CalData.cam1.awbGain_R;
    double awbGain_B = (double)s_CalData.cam1.awbGain_B;

    s_CalData.awbCcmL9_OCAM1 = (u16)( ( (ccm9  * awbGain_R)/128.0 )+ 0.5 );
    s_CalData.awbCcmL10_OCAM1= (u16)( ( (ccm10 * awbGain_B)/128.0 )+ 0.5 );

    //͈̓G[
    if( s_CalData.awbCcmL9_OCAM1<=MAX_AWB_CCM && s_CalData.awbCcmL10_OCAM1<=MAX_AWB_CCM )
    {
        sprintf( result.m_String, "0" );
        result.m_Result=true;
    }
    else
    {
        sprintf( result.m_String, "WB is Out of Range! CcmL9_1=%d Ccm10_1=%d", s_CalData.awbCcmL9_OCAM1, s_CalData.awbCcmL10_OCAM1 );
        result.m_Result=false;
    }
    return result.m_Result;
}

/************************************************************************
 zCgoX␳@CAM2iSDJ[hɃOcŁj
  ************************************************************************/
bool uji::eva::camera::TestCameraCalWB_CAM2(TestResult &result)
{
    const int TIME_OUT = 600;
    const int STABLE   = 60;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    nn::Result nnr;
    u16 awb_mode;

    //JN
    s_Camera->Start( SELECT_OUT2 );

    //zCgoXݒ
    s_Camera->SetWhiteBalance( WHITE_BALANCE_AUTO );

    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbGain_BPre, SELECT_OUT2, V_AWB_GAIN_B );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbSteadyGainInMax, SELECT_OUT2, V_AWB_STEADY_B_GAIN_IN_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbSteadyGainOutMax, SELECT_OUT2, V_AWB_STEADY_B_GAIN_OUT_MAX );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );

    u16 gainInMax = s_CalData.cam2.awbSteadyGainInMax;
    if( s_CalData.cam2.awbGain_BPre >= gainInMax )
    {
        gainInMax = s_CalData.cam2.awbGain_BPre+10;
        if( gainInMax > 0xfe ) gainInMax = 0xfe;
        nnr = WriteMcuVariableI2c( SELECT_OUT2, V_AWB_STEADY_B_GAIN_IN_MAX, gainInMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }
    if( gainInMax >= s_CalData.cam2.awbSteadyGainOutMax )
    {
        u16 gainOutMax = gainInMax+10;
        if( gainOutMax > 0xff ) gainOutMax = 0xff;
        nnr = WriteMcuVariableI2c( SELECT_OUT2, V_AWB_STEADY_B_GAIN_OUT_MAX, gainOutMax );
        if( nnr.IsFailure() )SYS_PANIC( "Fail to set variable");
    }

    int stableCounter;
    //҂
    s_CalData.cam2.awbStableTime = 0;
    stableCounter = 0;
    do
    {
        if( ++s_CalData.cam2.awbStableTime >= TIME_OUT )
        {
            nn::fs::FileOutputStream ofile;
            char str[100];
            bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
            GetMacAddress( mac );
            //t@CI[vď{
            if( nn::fs::MountSdmc().IsFailure() )
            {
                sprintf( result.m_String, "FAIL TO MOUNT SDMC" );
                result.m_Result=false;
                return result.m_Result;
            }
            nn::fs::TryCreateDirectory(L"sdmc:/uji" );
            nn::fs::TryCreateDirectory(L"sdmc:/uji/camera" );
            nnr = ofile.TryInitialize( L"sdmc:/uji/camera/CameraWBCaldata.csv", true );
            if( ofile.GetSize()==0 )
            {
                sprintf( str, "before/after,MAC ADDRESS,awbCcmL9_OCAM1,awbCcmL9_OCAM2,awbCcmL10_OCAM1,awbCcmL10_OCAM2\n" );
                ofile.Write( str, strlen(str) );
            }else{
                //ǋL
                ofile.Seek( 0, nn::fs::POSITION_BASE_END );
            }
            //t@CɃZ[u
            sprintf( str, "after,%02X-%02X-%02X-%02X-%02X-%02X,TIMEOUT\n", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5] );
            ofile.Write( str, strlen(str) );

            //N[Y
            ofile.Finalize();
            nn::fs::Unmount("sdmc:");

            sprintf( result.m_String, "WhiteBalance Unstable" );
            result.m_Result=false;
            return result.m_Result;
        }
        s_Camera->Update();
        nnr = ReadMcuVariableI2cExclusive( &awb_mode, SELECT_OUT2, V_AWB_MODE );   //suspect!!
        if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
        if( ( awb_mode & 0x01 )==0 ){
            stableCounter=0;
        }else{
            stableCounter++;
        }
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }while( stableCounter<STABLE );

    //ep[^擾
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.ccm9, SELECT_OUT2, V_CCM9  );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.ccm10,SELECT_OUT2, V_CCM10 );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbGain_R,    SELECT_OUT2, V_AWB_GAIN_R     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    nnr = ReadMcuVariableI2cExclusive( &s_CalData.cam2.awbGain_B,    SELECT_OUT2, V_AWB_GAIN_B     );
    if( nnr.IsFailure() ) SYS_PANIC( "Fail to read variable" );
    s_Camera->Stop();

    //Lu[VlZiľܓj
    double ccm9      = (double)s_CalData.cam2.ccm9;
    double ccm10     = (double)s_CalData.cam2.ccm10;
    double awbGain_R = (double)s_CalData.cam2.awbGain_R;
    double awbGain_B = (double)s_CalData.cam2.awbGain_B;

    s_CalData.awbCcmL9_OCAM2 = (u16)( ( (ccm9  * awbGain_R)/128.0 )+ 0.5 );
    s_CalData.awbCcmL10_OCAM2= (u16)( ( (ccm10 * awbGain_B)/128.0 )+ 0.5 );

    //͈̓G[
    if( s_CalData.awbCcmL9_OCAM2<=MAX_AWB_CCM && s_CalData.awbCcmL10_OCAM2<=MAX_AWB_CCM )
    {
        sprintf( result.m_String, "0" );
        result.m_Result=true;
    }
    else
    {
        sprintf( result.m_String, "WB is Out of Range! CcmL9_2=%d Ccm10_2=%d", s_CalData.awbCcmL9_OCAM2, s_CalData.awbCcmL10_OCAM2 );
        result.m_Result=false;
    }
    return result.m_Result;
}

/************************************************************************
vOo[W擾
  ************************************************************************/
bool uji::eva::camera::GetProgramVersion(TestResult &result)
{
    strcpy( result.m_String, "Ver." UJI_APPVER_PARALLAX );
    result.m_Result = true;
    return result.m_Result;
}


/************************************************************************
rc̉摜[hĕ\
  ************************************************************************/

bool uji::eva::camera::TestSendExtra(TestResult &result)
{
    if( nn::fs::MountSdmc().IsFailure() ) SYS_PANIC( "FAIL TO MOUNT SDMC" );

    nn::fs::FileReader file( L"sdmc:/uji/camera/camera.bmp" );
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();

    size_t fileSize = file.GetSize();
    NN_LOG("  fileSize = %d (Byte)\n", fileSize);
    if ( fileSize == 0 )
    {
        NN_LOG("Failed to open File.\n");
        NN_ASSERT(0);
        result.m_Result = false;
        return false;
    }

    u8 *buffer = (u8*)sysApp->Allocate(fileSize);
    s32 readSize = file.Read(buffer, fileSize);
    NN_LOG("  readSize = %d (Byte)\n", readSize);
    if ( readSize == 0 )
    {
        NN_LOG("Failed to open bmpRomFilename.\n");
        NN_ASSERT(0);
        result.m_Result = false;
        return false;
    }

    //alof[^ehenɑ
    u32 transSize;
    u32 residualQuantity = fileSize;
    u32 fifoCount;
    const u8 *current = buffer;

    while( residualQuantity != 0)
    {

        //̓]ʌ
        fifoCount = g_CommPacketCamera->m_CommCamera.GetDataFifoCount();
        transSize = uji::seq::CommCamera::FIFO_SIZE - fifoCount;

        //]Pʂ16oCgPʂɂ
        transSize = transSize & 0xfff0;
        if( transSize > residualQuantity ) transSize = residualQuantity; //Ō̓]ʍ킹

        //]
        if( transSize != 0 )
        {
            g_CommPacketCamera->m_CommCamera.WriteDataFifo( current, transSize );
            current += transSize;
            residualQuantity -= transSize;

        }
    }

    //ehenȂȂ܂ő҂
    while( g_CommPacketCamera->m_CommCamera.GetDataFifoCount()!=0 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    sysApp->Free( buffer );
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
  zCgoX␳
  ************************************************************************/
bool uji::eva::camera::TestWbCal(TestResult &result)
{

    using namespace nn::drivers::cal::CTR;

    // J
    TestInitialize(result);
    if( !result.m_Result )
    {
        strcpy( result.m_String, "TestInitialize fail" );
        return result.m_Result;
    }
    // WB ␳
    TestCameraCalWB_CAM1(result);
    if( !result.m_Result )
    {
        // G[bZ[W͊֐œĂ
        // strcpy( result.m_String, "TestCameraCalWB_CAM1 fail" );
        return result.m_Result;
    }
    TestInitialize(result);
    if( !result.m_Result )
    {
        strcpy( result.m_String, "TestInitialize fail" );
        return result.m_Result;
    }
    TestCameraCalWB_CAM2(result);
    if( !result.m_Result )
    {
        // G[bZ[W͊֐œĂ
        // strcpy( result.m_String, "TestCameraCalWB_CAM2 fail" );
        return result.m_Result;
    }
    // CAL l{̂ɏ
    TestCameraExtraFunc9(result);
    if( !result.m_Result )
    {
        strcpy( result.m_String, "TestCameraExtraFunc9 fail" );
        return result.m_Result;
    }
    // WB ␳͂ŏI

    // ȉA␳ WB X|XƂĕԂ߂̏
    
    Calibration cal;
    CameraCalAppendCore cameraCalAppend;

    cal.Initialize();

    // Lf[^ǂݏo
    if( !cal.Get(&cameraCalAppend,  CAL_DATA_CAMERA_APPEND) )
    {
        strcpy( result.m_String, "CAL FAIL" );
        result.m_Result=false;
        return result.m_Result;
    }

    // X|Xɕ␳l
    sprintf( result.m_String, "awbCcmL9Right:%d,awbCcmL9Left:%d,awbCcmL10Right:%d,awbCcmL10Left:%d",
            cameraCalAppend.awbCcmL9Right, cameraCalAppend.awbCcmL9Left, cameraCalAppend.awbCcmL10Right, cameraCalAppend.awbCcmL10Left );

    //N[Y
    result.m_Result=true;
    return result.m_Result;
}

