/********************************************************************
JJ][`
********************************************************************/

#include <nn.h>
#include <nn/gx.h>
#include <nn/camera.h>
#include <nn/y2r.h>
#include <nn/camera/CTR/camera_ApiForHardwareCheck.h>
#include <string.h>
#include "sys.h"
#include "TestCamera.h"
#include "CameraRegister.h"
#include "EvaCamera.h"

#include "StereoCameraChecker/key_manager.h"
#include "StereoCameraChecker/tp_manager.h"
#include "StereoCameraChecker/graphics.h"
#include "StereoCameraChecker/scene_setting.h"
#include "StereoCameraChecker/scene_manager.h"

using namespace uji;
using namespace uji::sys;
using namespace uji::eva;
using namespace uji::eva::camera;
using namespace nn::camera;

static char *SELECT_STR[]={ "OUT1-CAM", "OUT2-CAM", "IN-CAM",  NULL };
static char *POSITION_STR[]= { "LEFT-TOP", "RIGHT-TOP", "CENTER", "LEFT-BOTTOM", "RIGHT-BOTTOM", "ZOOM-OUT", NULL };
static char *WHITEBALANCE_STR[]={ "AUTO", "3200K", "4150K", "5200K", "6000K", "7000K", NULL };
enum { CURSOR_CAMERA_SELECT, CURSOR_CAMERA_POSITION, CURSOR_CAMERA_WHITEBALANCE, CURSOR_CAMERA_MAX };

struct CameraConfig
{
public:
    CameraConfig():m_Select(0),m_Position(0), m_Cursor(0), m_IsPause(false), m_WhiteBalance(0){}
    u32 m_Select;           //JI
    u32 m_Position;         //\WI
    int m_Cursor;           //J[\ʒu
    bool m_IsPause;         //Be^|[Y؂ւ
    u32 m_WhiteBalance;     //zCgoX
};

namespace
{
    double s_AveB = 0.0f;
    double s_AveR = 0.0f;
}


nn::fnd::ExpHeap s_CameraHeap;



/************************************************************************
Tuʂւ̃j[\
  ************************************************************************/

static void ShowMenu( CameraConfig *cameraConfig )
{
    Menu::m_SubWindow->Printf("\f");
    Menu::m_SubWindow->Printf("<CAMERA EVA.>\n");
    Menu::m_SubWindow->SetTextColor( ( cameraConfig->m_Cursor == CURSOR_CAMERA_SELECT )?ATTR_COLOR_YELLOW:ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("CAM SELECT:%-10s\n", SELECT_STR[cameraConfig->m_Select] );
    Menu::m_SubWindow->SetTextColor( ( cameraConfig->m_Cursor == CURSOR_CAMERA_POSITION )?ATTR_COLOR_YELLOW:ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("POSITION  :%-10s\n", POSITION_STR[cameraConfig->m_Position] );
    Menu::m_SubWindow->SetTextColor( ( cameraConfig->m_Cursor == CURSOR_CAMERA_WHITEBALANCE )?ATTR_COLOR_YELLOW:ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("WB        :%-10s\n", WHITEBALANCE_STR[cameraConfig->m_WhiteBalance] );
    Menu::m_SubWindow->SetTextColor( ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("\n");
    Menu::m_SubWindow->Printf("XLR: Pause/Capture\n");
    Menu::m_SubWindow->Printf("Y:   Save to SD\n");
    Menu::m_SubWindow->Printf("B:   Exit");
}

/************************************************************************
Tuʂւ̃j[\irbpj
  ************************************************************************/

static void ShowMenuForService( CameraConfig *cameraConfig )
{
    Menu::m_SubWindow->Printf("\f");
    Menu::m_SubWindow->Printf("<CAMERA EVA.>\n");
    Menu::m_SubWindow->SetTextColor( ( cameraConfig->m_Cursor == CURSOR_CAMERA_SELECT )?ATTR_COLOR_YELLOW:ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("CAM SELECT:%-10s\n", SELECT_STR[cameraConfig->m_Select] );
    Menu::m_SubWindow->SetTextColor( ( cameraConfig->m_Cursor == CURSOR_CAMERA_POSITION )?ATTR_COLOR_YELLOW:ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("POSITION  :%-10s\n", POSITION_STR[cameraConfig->m_Position] );
    Menu::m_SubWindow->SetTextColor( ( cameraConfig->m_Cursor == CURSOR_CAMERA_WHITEBALANCE )?ATTR_COLOR_YELLOW:ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("WB        :%-10s\n", WHITEBALANCE_STR[cameraConfig->m_WhiteBalance] );
    Menu::m_SubWindow->SetTextColor( ATTR_COLOR_WHITE );
    Menu::m_SubWindow->Printf("\n");
    Menu::m_SubWindow->Printf("X: Pause/Capture\n");
    Menu::m_SubWindow->Printf("B: Exit");
}
/************************************************************************
WX^\
  ************************************************************************/

static void ShowRegisters( TextWindow *w )
{
    u16 icam, ocam1, ocam2;

    w->Printf("\f");
    w->Printf("        :ICAM OCM1 OCM2\n");

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_MODE );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_MODE );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_MODE );
    w->Printf("MODE    :%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_AE_STATUS );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_AE_STATUS );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_AE_STATUS );
    w->Printf("AE_STAT :%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_CURRENTY );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_CURRENTY );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_CURRENTY );
    w->Printf("CURRENTY:%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_CCM9 );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_CCM9 );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_CCM9 );
    w->Printf("CCM9    :%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_CCM10 );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_CCM10 );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_CCM10 );
    w->Printf("CCM1   0:%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_AWB_GAIN_R );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_AWB_GAIN_R );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_AWB_GAIN_R );
    w->Printf("AWBGAINR:%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_AWB_GAIN_B );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_AWB_GAIN_B );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_AWB_GAIN_B );
    w->Printf("AWBGAINB:%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_AWB_MODE );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_AWB_MODE );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_AWB_MODE );
    w->Printf("AWB_MODE:%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_AWB_STEADY_B_GAIN_OUT_MAX );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_AWB_STEADY_B_GAIN_OUT_MAX );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_AWB_STEADY_B_GAIN_OUT_MAX );
    w->Printf("0x035e  :%04X %04X %04X\n", icam, ocam1, ocam2 );

    ReadMcuVariableI2cExclusive( &icam,  SELECT_IN1,  V_AWB_STEADY_B_GAIN_IN_MAX );
    ReadMcuVariableI2cExclusive( &ocam1, SELECT_OUT1, V_AWB_STEADY_B_GAIN_IN_MAX );
    ReadMcuVariableI2cExclusive( &ocam2, SELECT_OUT2, V_AWB_STEADY_B_GAIN_IN_MAX );
    w->Printf("0x0360  :%04X %04X %04X\n", icam, ocam1, ocam2 );



}


/************************************************************************
fBXvCP̃Abvf[g
  ************************************************************************/
static void UpdateDisplay1(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.UpdatePad(pad);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();        
    Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 
}

/************************************************************************
J]
  ************************************************************************/
void uji::eva::EvaluateCamera(void)
{
    nn::Result nnResult;
    uji::sys::Pad pad;
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    CameraConfig *cameraConfig = new CameraConfig;
    TestCamera *camera = new TestCamera;

    uji::sys::TextWindow *win;
    win = new TextWindow( 24, 15, 12 );
    win->SetTitle( "REGISTERS" );
    Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY1, 160, 00 );        


    camera->Initialize();
    camera->Start();

    int x=0;
    int y=0;
    bool isCameraSelectChanged =false;
    bool isWhiteBalanceChanged =false;

    do
    {
        ShowMenu( cameraConfig );
        ShowRegisters( win );

        //pbhXV
        pad.UpdatePad();
                        
        //EChE
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.UpdatePad(pad);        


        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();


        //Lv`^|[Y؂ւ
#if 0
        if( pad.IsButtonDown(Pad::BUTTON_X ) || pad.IsButtonDown(Pad::BUTTON_L) || pad.IsButtonDown(Pad::BUTTON_R) )
#endif
        if( pad.IsButtonDown(Pad::BUTTON_X ) )
        {
            cameraConfig->m_IsPause = !cameraConfig->m_IsPause;
            camera->Pause( cameraConfig->m_IsPause );

            //|[Y͕ω摜o
            if( cameraConfig->m_IsPause == true )
            {
                camera->UpdateToAverage();
            }
        }

        //debug
        if( pad.IsButtonDown(Pad::BUTTON_L ) )
        {
            nnResult=WriteMcuVariableI2c( SELECT_OUT1, V_CCM_POSITION, 0 );
            if( nnResult.IsFailure() ) SYS_PANIC( "ERROR:WriteMcuVariableI2c" );
            nnResult=WriteMcuVariableI2c( SELECT_OUT2, V_CCM_POSITION, 0 );
            if( nnResult.IsFailure() ) SYS_PANIC( "ERROR:WriteMcuVariableI2c" );

            NN_LOG( "CCM POSITION WRITE\n" );

        }

        if( pad.IsButtonDown(Pad::BUTTON_R ) )
        {
            //Ƃ肠`qƂ`aZ
            u32 bmpSize = (TestCamera::CAMERA_WIDTH * TestCamera::CAMERA_HEIGHT *3 );
            u8 *buffer = (u8*)sysApp->Allocate( bmpSize );
            BmpTexture *bt = new BmpTexture;
            bt->ConvertTextureToBmp( buffer, (u8*)camera->GetCameraTexture(), TestCamera::CAMERA_WIDTH, TestCamera::CAMERA_HEIGHT );

            s_AveR = 0.0f;
            s_AveB = 0.0f;
            for( int i=0 ; i<32 ; i++ )
            {
                for( int j=0 ; j<32 ; j++ )
                {
                    u8 blue1 = buffer[( (47+j)+ (479-31-i)*640)*3]; //Blue Area1
                    u8 red1  = buffer[( (47+j)+ (479-31-i)*640)*3+2]; //Red Area1

                    u8 blue2 = buffer[( (303+j)+ (479-103-i)*640)*3]; //Blue Area2
                    u8 red2  = buffer[( (303+j)+ (479-103-i)*640)*3+2]; //Red Area2

                    s_AveB += (double)blue1 * 0.6f + (double)blue2 * 0.4f;
                    s_AveR += (double)red1  * 0.6f + (double)blue2 * 0.4f;

                }
            }

            s_AveB /= (double)(32.0f*32.0f);
            s_AveR /= (double)(32.0f*32.0f);


            sysApp->Free( buffer );
            delete bt;
        }

        //Z[u
        if( pad.IsButtonDown(Pad::BUTTON_Y ) )
        {

            Menu::m_SubWindow->Printf("\fNow Saving...");
            {
                UpdateDisplay1();//P̍XVł͂܂\Ȃꍇ̂ŁAR[h
            }
                UpdateDisplay1();


            if( camera->Save() )
            {
                Menu::m_SubWindow->Printf("\fPASS");

            }else{
                Menu::m_SubWindow->Printf("\fFAIL");
            }
            {
                UpdateDisplay1();//P̍XVł͂܂\Ȃꍇ̂ŁAR[h
            }

            UpdateDisplay1();


            pad.WaitAnyKey();
            pad.WaitReleaseKey();
        }

        //ݒ؂ւ
        if( pad.IsButtonRepeat(Pad::BUTTON_DOWN ) )
        {
            cameraConfig->m_Cursor++;
            if( cameraConfig->m_Cursor>=CURSOR_CAMERA_MAX ) cameraConfig->m_Cursor=0;
        }
        if( pad.IsButtonRepeat(Pad::BUTTON_UP ) )
        {
            cameraConfig->m_Cursor--;
            if( cameraConfig->m_Cursor<0 ) cameraConfig->m_Cursor=CURSOR_CAMERA_MAX-1;
        }

        if( pad.IsButtonDown(Pad::BUTTON_A ) )
        {
            switch( cameraConfig->m_Cursor )
            {
              case CURSOR_CAMERA_SELECT:
                cameraConfig->m_Select++;
                if( SELECT_STR[cameraConfig->m_Select]==NULL ) cameraConfig->m_Select=0;
                isCameraSelectChanged = true;
                isWhiteBalanceChanged = true;
                break;
              case CURSOR_CAMERA_POSITION:
                cameraConfig->m_Position++;
                if( POSITION_STR[cameraConfig->m_Position]==NULL ) cameraConfig->m_Position=0;
                break;
              case CURSOR_CAMERA_WHITEBALANCE:
                cameraConfig->m_WhiteBalance++;
                if( WHITEBALANCE_STR[cameraConfig->m_WhiteBalance]==NULL ) cameraConfig->m_WhiteBalance=0;
                isWhiteBalanceChanged = true;
                break;
              default:
                break;
            }
        }

        //J؂ւ
        if( isCameraSelectChanged )
        {
            switch( cameraConfig->m_Select )
            {
            case 0:
                camera->Stop();
                camera->Start( nn::camera::CTR::SELECT_OUT1 );
                break;
            case 1:
                camera->Stop();
                camera->Start( nn::camera::CTR::SELECT_OUT2 );
                break;
            case 2:
                camera->Stop();
                camera->Start( nn::camera::CTR::SELECT_IN1 );
                break;

            default:
                break;
            }
            isCameraSelectChanged = false;
        }

        //zCgoX؊
        if( isWhiteBalanceChanged )
        {
            camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(cameraConfig->m_WhiteBalance) );
            isWhiteBalanceChanged = false;
        }

        switch( cameraConfig->m_Position )
        {
          case 0:   x=0;    y=0;    break;
          case 1:   x=240;  y=0;    break;
          case 2:   x=120;  y=120;  break;
          case 3:   x=0;    y=240;  break;
          case 4:   x=240;  y=240;  break; 
          case 5:   x=-80;  y=0;    break;
          default:                  break;
        }

        if( cameraConfig->m_Position==5 )
        {
            camera->EnableZoomOut();
        }else{
            camera->DesableZoomOut();
        }

        //|[Y̓J摜̃Abvf[gȂ
        if( !cameraConfig->m_IsPause ) camera->Update();
        camera->SetScroll( x, y );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    Menu::m_WindowManager.DestroyWindow( win );        
    delete win;

    pad.ClearTriggerFlag();
    camera->Stop();
    camera->Finalize();
    delete camera;
    delete cameraConfig;
}

/************************************************************************
J]irbpj
  ************************************************************************/
void uji::eva::EvaluateCameraForService(void)
{
    nn::Result nnResult;
    uji::sys::Pad pad;
    uji::sys::SysApp *sysApp = uji::sys::SysApp::GetInstance();
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    CameraConfig *cameraConfig = new CameraConfig;
    TestCamera *camera = new TestCamera;


    camera->Initialize();
    camera->Start();

    int x=0;
    int y=0;
    bool isCameraSelectChanged =false;
    bool isWhiteBalanceChanged =false;

    cameraConfig->m_Position=5;    //ynnlntsX^[g 
    do
    {
        ShowMenuForService( cameraConfig );

        //pbhXV
        pad.UpdatePad();
                        
        //EChE
        Menu::m_WindowManager.Update();
        Menu::m_WindowManager.UpdatePad(pad);        


        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        

        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();


        //Lv`^|[Y؂ւ
        if( pad.IsButtonDown(Pad::BUTTON_X ) )
        {
            cameraConfig->m_IsPause = !cameraConfig->m_IsPause;
            camera->Pause( cameraConfig->m_IsPause );
        }

        //ݒ؂ւ
        if( pad.IsButtonRepeat(Pad::BUTTON_DOWN ) )
        {
            cameraConfig->m_Cursor++;
            if( cameraConfig->m_Cursor>=CURSOR_CAMERA_MAX ) cameraConfig->m_Cursor=0;
        }
        if( pad.IsButtonRepeat(Pad::BUTTON_UP ) )
        {
            cameraConfig->m_Cursor--;
            if( cameraConfig->m_Cursor<0 ) cameraConfig->m_Cursor=CURSOR_CAMERA_MAX-1;
        }

        if( pad.IsButtonDown(Pad::BUTTON_A ) )
        {
            switch( cameraConfig->m_Cursor )
            {
              case CURSOR_CAMERA_SELECT:
                cameraConfig->m_Select++;
                if( SELECT_STR[cameraConfig->m_Select]==NULL ) cameraConfig->m_Select=0;
                isCameraSelectChanged = true;
                isWhiteBalanceChanged = true;
                break;
              case CURSOR_CAMERA_POSITION:
                cameraConfig->m_Position++;
                if( POSITION_STR[cameraConfig->m_Position]==NULL ) cameraConfig->m_Position=0;
                break;
              case CURSOR_CAMERA_WHITEBALANCE:
                cameraConfig->m_WhiteBalance++;
                if( WHITEBALANCE_STR[cameraConfig->m_WhiteBalance]==NULL ) cameraConfig->m_WhiteBalance=0;
                isWhiteBalanceChanged = true;
                break;
              default:
                break;
            }
        }

        //J؂ւ
        if( isCameraSelectChanged )
        {
            switch( cameraConfig->m_Select )
            {
            case 0:
                camera->Stop();
                camera->Start( nn::camera::CTR::SELECT_OUT1 );
                break;
            case 1:
                camera->Stop();
                camera->Start( nn::camera::CTR::SELECT_OUT2 );
                break;
            case 2:
                camera->Stop();
                camera->Start( nn::camera::CTR::SELECT_IN1 );
                break;

            default:
                break;
            }
            isCameraSelectChanged = false;
        }

        //zCgoX؊
        if( isWhiteBalanceChanged )
        {
            camera->SetWhiteBalance( static_cast<nn::camera::WhiteBalance>(cameraConfig->m_WhiteBalance) );
            isWhiteBalanceChanged = false;
        }

        switch( cameraConfig->m_Position )
        {
          case 0:   x=0;    y=0;    break;
          case 1:   x=240;  y=0;    break;
          case 2:   x=120;  y=120;  break;
          case 3:   x=0;    y=240;  break;
          case 4:   x=240;  y=240;  break; 
          case 5:   x=-80;  y=0;    break;
          default:                  break;
        }

        if( cameraConfig->m_Position==5 )
        {
            camera->EnableZoomOut();
        }else{
            camera->DesableZoomOut();
        }

        //|[Y̓J摜̃Abvf[gȂ
        if( !cameraConfig->m_IsPause ) camera->Update();
        camera->SetScroll( x, y );
        camera->Draw( gfx->m_DrawFramework );
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    pad.ClearTriggerFlag();
    camera->Stop();
    camera->DeleteTexture( gfx->m_DrawFramework );
    camera->Finalize();
    delete camera;
    delete cameraConfig;
}


/************************************************************************
XeIJ]iSC FTRpj
  ************************************************************************/
void uji::eva::StereoCameraCheck(void)
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::sys::Pad pad;

    SceneSetting_cl      s_SceneSetting;

    // V[
    Scene_cl * spa_Scene[] =
    {
        &s_SceneSetting,
    };

    const s32 s_SceneNum = 1;//sizeof( spa_Scene ) / sizeof( Scene_cl * );

    // V[̏ɓn
    uptr sa_SceneArg[] =
    {
        0,
    };
    
    // V[Iʂł̖O
    char * spa_SceneName[] =
    {
        "Preview and capturing",
    };

    // V[ǗNX
    SceneManager_cl  s_SceneManager;

    // ӂȃt@Ĉ߂ɎMACAhX擾
    nn::fnd::DateTime s_DateTime;
    bit8              s_MacAddress[ 6 ];

    nn::Result result;

    nn::fs::Initialize();
//    nn::applet::Enable();

    // Imۗp̃q[v
    s_CameraHeap.Initialize(
        nn::os::GetDeviceMemoryAddress(),
        nn::os::GetDeviceMemorySize(),
        nn::os::ALLOCATE_OPTION_LINEAR );

    nn::hid::PadReader padReader;
    nn::hid::PadStatus padStatus;
    nn::hid::TouchPanelReader tpReader;
    nn::hid::TouchPanelStatus tpStatus;

    camera_exp::KeyManager_cl::Initialize( &padReader, &padStatus );
    camera_exp::TpManager_cl::Initialize( &tpReader, &tpStatus );

    // Be摜̃t@C߂邽߂ɋNMACAhX擾
    s_DateTime = nn::fnd::DateTime::GetNow();

    memset( s_MacAddress, 0, 6 );
    uji::sys::GetMacAddress( s_MacAddress );

    NN_TLOG_( "MAC ADDRESS %02X:%02X:%02X:%02X:%02X:%02X\n",
                    s_MacAddress[ 0 ], s_MacAddress[ 1 ], s_MacAddress[ 2 ],
                    s_MacAddress[ 3 ], s_MacAddress[ 4 ], s_MacAddress[ 5 ] );

    // demo::RenderSystemExtŊmۂĂobt@̂ŁAm_DrawFrameworkFinalizeĂ
    gfx->m_DrawFramework->Finalize();

    // TODO:̂̏͂Ƃꂢɂ܂Ƃ߂
    // spa_Scenełǂ̃V[NXgn߂ɃV[}l[W[
        s_SceneManager.Initialize( spa_Scene, sa_SceneArg );
        s_SceneManager.DrawCurrentScene();
        s_SceneManager.Finalize();

    spa_Scene[ 0 ]->Initialize( sa_SceneArg[ 0 ] );
    spa_Scene[ 0 ]->Ready();

    // TODO:B{^ŔSCp]j[ɖ߂悤ɂ
    while(1)// do
    {
        //pbhXV
        pad.UpdatePad();
        camera_exp::KeyManager_cl::Read();
        camera_exp::TpManager_cl::Read();

//        s_SceneManager.DrawCurrentScene();
        s_SceneManager.DrawScene( 0 );
    }// while( !pad.IsButtonDown(Pad::BUTTON_B) );

    // demo::RenderSystemExtŊmۂĂobt@̂ŁAs_SceneManagerFinalizeĂ
    spa_Scene[ 0 ]->Finalize();
//    s_SceneManager.Finalize();

    // OtBbNX̏I
    //TODO:Ă΂ȂƏ߂ɊmۂmۂĂȂCBǌĂԂƗB
    GraphicsDrawing::GetInstance()->Finalize();

    uptr m_FcramAddress = reinterpret_cast<uptr>( AllocDeviceMemory( uji::sys::GraphicsDrawing::GRAPHICS_MEMORY_SIZE, 4 ) );
    gfx->m_DrawFramework->Initialize( m_FcramAddress, uji::sys::GraphicsDrawing::GRAPHICS_MEMORY_SIZE);

}

