/********************************************************************
̏̑ޔƕ
********************************************************************/

#include <nn.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/detail/cfg_SecureInfo.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1
#include "sys.h"
#include "../../sys/sys_GetSerialNumber.h"
#include "../seq/Config.h"
#include "../seq/TesterLog/InspectLog.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../sec/CalMenu.h"
#include "TestBackup.h"
#include "../eva/import/TcpComm.h"

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;


/************************************************************************
rcJ[h̊mFi}ACgveNgAceʃ`FbNj
************************************************************************/
bool uji::eva::backup::TestSdCardWritable(uji::seq::TestResult &result)
{

    //rcJ[h̑}mF
    if( !nn::fs::IsSdmcInserted() )
    {
        strcpy( result.m_String, "NO SD CARD" );
        result.m_Micro = MICRO_CODE_NO_SD_CARD;
        result.m_Result = false;
        return result.m_Result;
    }

    //CgveNgmF
    if( !nn::fs::IsSdmcWritable() )
    {
        strcpy( result.m_String, "WRITE PROTECTED" );
        result.m_Micro = MICRO_CODE_WRITE_PROTECTED;
        result.m_Result = false;
        return result.m_Result;
    }

    result.m_Micro  = MICRO_CODE_PASS;
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
rcJ[h̊mFi}Aceʃ`FbNj
************************************************************************/
bool uji::eva::backup::TestSdCardAvailable(uji::seq::TestResult &result)
{

    //rcJ[h̑}mF
    if( !nn::fs::IsSdmcInserted() )
    {
        strcpy( result.m_String, "NO SD CARD" );
        result.m_Micro = MICRO_CODE_NO_SD_CARD;
        result.m_Result = false;
        return result.m_Result;
    }

    result.m_Micro  = MICRO_CODE_PASS;
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
fBNg쐬
************************************************************************/
bool uji::eva::backup::MakeDirectory(uji::seq::TestResult &result)
{
    s64 totalSize;
    s64 freeSize;


    char dirName[0x100];
    char fileName[0x100];
    nn::fs::Directory dir;
    nn::fs::FileOutputStream ofile;
    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];

    result.m_Micro  = MICRO_CODE_PASS;
    result.m_Result = false;


    // SDJ[h}Eg
    if( nn::fs::MountSdmc().IsFailure() )
    {
        result.m_Micro = MICRO_CODE_MOUNT;
        result.m_Result = false;
        return result.m_Result;
    }

    //̓}Egꂽԁ

    //ceʃ`FbN
    if( nn::fs::GetFileSystemSize( &totalSize, &freeSize, nn::fs::MEDIA_TYPE_SDMC ).IsFailure() )
    {
        result.m_Micro = MICRO_CODE_FAIL_NN_RESULT;
        goto UNMOUNT;
    }

    if( freeSize < uji::eva::backup::MIN_FREE_SPACE )
    {
        sprintf( result.m_String ,"LACK OF FREE SPACE [%dKByte]", (int)(freeSize/1024) );
        result.m_Micro =    MICRO_CDDE_LACK_OF_FREE_SPACE;
        goto UNMOUNT;
    }

    //l`bAhXtH_쐬
    GetMacAddress( mac );
    sprintf( dirName, "sdmc:/uji/backup/%02X%02X%02X%02X%02X%02X",
                mac[0], mac[1], mac[2], mac[3], mac[4], mac[5] );

    if( dir.TryInitialize( dirName ).IsFailure() )
    {
        //fBNg쐬
        nn::fs::TryCreateDirectory( "sdmc:/uji" );
        nn::fs::TryCreateDirectory( "sdmc:/uji/backup" );
        nn::fs::TryCreateDirectory( dirName );

        //߂đ݊mF
        if( dir.TryInitialize( dirName ).IsFailure() )
        {
            result.m_Micro = MICRO_CODE_DIR;
            goto UNMOUNT;
        }
    }

    //VAio[t@C쐬it@CAgɃVAio[j
    //VAio[擾
    char serial[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    uji::sys::GetSerialNumber(serial);

    sprintf( fileName, "%s/%s.txt", dirName, serial );

    if( ofile.TryInitialize( fileName, true ).IsFailure() )
    {
        result.m_Micro = MICRO_CODE_WRITE;
        goto UNMOUNT;
    }

    ofile.Write( serial, strlen(serial) );

    result.m_Result = true;

UNMOUNT:
    // SDJ[h̃A}Eg
    if( nn::fs::Unmount("sdmc:").IsFailure() )
    {
        result.m_Micro = MICRO_CODE_UNMOUNT;
        result.m_Result = false;
    }
    return result.m_Result;

}

/************************************************************************
b`k̑ޔ
************************************************************************/
bool uji::eva::backup::BackupCal(uji::seq::TestResult &result)
{
    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
    GetMacAddress( mac );

    nn::drivers::cal::CTR::Calibration cal;
    cal.Initialize();

    char fileName[0x100];
    sprintf( fileName, "sdmc:/uji/backup/%02X%02X%02X%02X%02X%02X/%02X%02X%02X%02X%02X%02X.Ver%d.cal",
                    mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
                    mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
                    (int)cal.GetVersion() );

    result.m_Result = uji::sec::cal::SaveToSd( fileName );
    return result.m_Result;
}

/************************************************************************
b`k̕
************************************************************************/
bool uji::eva::backup::RestoreCal(uji::seq::TestResult &result)
{
    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];
    GetMacAddress( mac );

    nn::drivers::cal::CTR::Calibration cal;
    cal.Initialize();

    char fileName[0x100];
    sprintf( fileName, "sdmc:/uji/backup/%02X%02X%02X%02X%02X%02X/%02X%02X%02X%02X%02X%02X.Ver%d.cal",
                    mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
                    mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
                    (int)cal.GetVersion() );

    result.m_Result = uji::sec::cal::LoadFromSd( fileName );
    return result.m_Result;
}

/************************************************************************
InspectLog̑ޔ
************************************************************************/
bool uji::eva::backup::BackupInspectLog(uji::seq::TestResult &result)
{
    LogResult lr;
    result.m_Result = false;

    InspectLog * il = new InspectLog;
    il->Initialize();
    lr = il->Backup();
    delete il;

    if ( LogResultCode::SUCCESS == lr)
    {
        result.m_Result = true;
    }

    return result.m_Result;
}

/************************************************************************
InspectLog̕
************************************************************************/
bool uji::eva::backup::RestoreInspectLog(uji::seq::TestResult &result)
{
    LogResult lr;
    result.m_Result = false;

    InspectLog * il = new InspectLog;
    il->primaryInit();
    NN_LOG("--- before load ---\n");
    il->Dump();

    lr = il->Restore();
    NN_LOG("--- after load ---\n");
    il->Dump();

    delete il;

    if ( LogResultCode::SUCCESS == lr)
    {
        result.m_Result = true;
    }

    return result.m_Result;
}

/************************************************************************
ProductLog̑ޔ
************************************************************************/
bool uji::eva::backup::BackupProductLog(uji::seq::TestResult &result)
{
    ProductionLog * pl = new ProductionLog;
    pl->Initialize();
    pl->Backup();
    delete pl;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
ProductLog̕
************************************************************************/
bool uji::eva::backup::RestoreProductLog(uji::seq::TestResult &result)
{
    LogResult lr;
    result.m_Result = false;

    ProductionLog * pl = new ProductionLog;
    pl->primaryInit();
    lr = pl->Restore();
    delete pl;

    if ( LogResultCode::SUCCESS == lr)
    {
        result.m_Result = true;
    }

    return result.m_Result;
}
/************************************************************************
SerialNumber̕
************************************************************************/
bool uji::eva::backup::RestoreSerialNumber(uji::seq::TestResult &result)
{
    LogResult lr;
    result.m_Result = false;

    InspectLog * il = new InspectLog;
    lr = il->Initialize();

    if ( LogResultCode::SUCCESS != lr)
    {
        delete il;
        result.m_Result = false;
        result.m_Micro = MICRO_CDDE_INSPECTLOG_INIT_FAILURE;
        return result.m_Result;
    }

    // VANO inspect.log擾
    std::string serno;
    serno = il->Get_SerialNumber();
    delete il;

    // ̃VANO{̂ɐݒ
    TcpComm   * tc = new TcpComm;
    CommPack  cp;
    std::memset(cp.Arg, 0x00, MAX_ARG_NUM);
    std::memcpy(cp.Arg, serno.c_str(), nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN);

    if ( false == tc->SetSerialNumber(cp))
    {
        result.m_Micro  = MICRO_CDDE_SET_SERNO_FAILURE;
        result.m_Result = false;
    }
    delete tc;

    result.m_Result = true;
    return result.m_Result;
}
