/*--------------------------------------------------------------------------*
 Project:
 File: BackLightTest.h


*--------------------------------------------------------------------------*/
#ifndef BACKLIGHTTEST_H_INCLUDED
#define BACKLIGHTTEST_H_INCLUDED

#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"
#include "sys_Pad.h"
#include "../seq/TestResult.h"

#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

// CPUŃftHgCALlQƂ邽߂include
#include <nn/drivers/cal/cal_default.h>         // CTR   CAL ftHgl

namespace uji {
namespace eva {


// WindowNXpVvȃNX
class BackLightTest : public sys::Window
{
public:
    /*
        RXgN^
        mgr : j[}l[W̃CX^X̃AhX
    */
    BackLightTest(sys::WindowManager& mgr, s32 width, s32 height)
    : Window("SIMPLE WINDOW", width, height), m_MesgCount(0), m_FrameCount(0),
      m_WindowManager(mgr), m_MessageLogWindow(0), m_TextWindow(0)
    {}
    virtual ~BackLightTest(){}

    // o͐̃eLXgEChEݒ肵܂
    void SetTextWindow(sys::TextWindow& wnd) { m_TextWindow = &wnd; }
    // o͐̃bZ[WOEChEݒ肵܂
    void SetMessageLogWindow(sys::MessageLogWindow& wnd) { m_MessageLogWindow = &wnd; }

protected:
    // eI[o[ChƎ̏܂
//    virtual void OnDraw(sys::GraphicsDrawing* gfx);
//    virtual void OnUpdatePad(const sys::Pad& pad);
//    virtual void OnUpdate();

private:
    int m_MesgCount;
    int m_FrameCount;

    sys::WindowManager&     m_WindowManager;
    sys::MessageLogWindow*  m_MessageLogWindow;
    sys::TextWindow*        m_TextWindow;
};

// EChEfNX
class DemoBackLight
{
public:
    DemoBackLight()
    :
        m_frameCount(0),
        /*
            eLXgEChE
            1ʂɉ23~c8\\BtHgTCY16B
        */
        m_TextWindow(23, 8, 16),

        /*
            bZ[WOEChE
            1ʂɉ20~c10\\B100s̃obt@BtHgTCY14B
            EChEɃtH[JXꍇ́AXN[\B
        */
        m_MessageLogWindow(20, 10, 100, 14),

        /*
            EChEhVvEChE
            TCY200dot~140dotB
        */
        m_BackLightTest(this->m_WindowManager, 200, 140)
    {}
    virtual ~DemoBackLight(){}

    void TestBackLightOnOff();


private:
    int m_frameCount;

    sys::WindowManager      m_WindowManager;
    sys::TextWindow         m_TextWindow;
    sys::MessageLogWindow   m_MessageLogWindow;
    BackLightTest           m_BackLightTest;
};


namespace backlight {
    extern bool SetMaxBrightness( uji::seq::TestResult &result );           // 49-001
    extern bool SetMinBrightness( uji::seq::TestResult &result );           // 49-002
    extern bool SetActiveBackLightOn( uji::seq::TestResult &result );       // 49-003
    extern bool SetActiveBackLightOff( uji::seq::TestResult &result );      // 49-004
    extern bool SetLcdOn( uji::seq::TestResult &result );                   // 49-006
    extern bool SetLcdOff( uji::seq::TestResult &result );                  // 49-007
    extern bool SetLcdOff_NEC( uji::seq::TestResult &result );              // 49-008
    extern bool SetLcdOn_NEC( uji::seq::TestResult &result );               // 49-009
    extern void ChangeLightLevel(void);
    extern int UpLightLevel( int light_level );
    extern int DownLightLevel( int light_level );
}

}
}

#endif

