/*--------------------------------------------------------------------------*
 Project:
 File: BackLightTest.cpp

*--------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/fnd.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>  // EVA_SDK_0_14_1
#include <nn/fs/fs_Api.h>
#include <nn/gx.h>
#include <nn/gx/CTR/gx_LcdBacklight.h>
#include <nn/gx/CTR/gx_LcdPowerManager.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_HidBase.h>
#include <nn/mcu.h>
#include <nn/os.h>
#include <nn/os/os_Thread.h>
#include <nn/srv.h>
#include <nn/uds.h>
#include <nw/types.h>
#include <stdlib.h>
#include <vector>

#include "BackLightTest.h"
#include "sys_App.h"
#include "sys_Pad.h"
#include "../mcu/McuInitializer.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestListManager.h"
#include "../seq/TestResult.h"
#include "../seq/TestSequencer.h"
#include "../sys/sys_SoundPlayer.h"


using namespace nn::gx;
using namespace nn;
using namespace nn::dbg::detail;
using namespace nn::os;
using namespace nn::svc;
using nn::Handle;

using namespace uji::eva::mcu;
using namespace uji::seq;
using namespace uji::sys;


namespace uji {
namespace eva {


namespace
{

    // {^̎擾
    class ButtonHandler : public nn::srv::NotificationHandler
    {
    public:
        virtual void HandleNotification(bit32 message)
        {
            switch( message )
            {
              case nn::srv::NOTIFICATION_SHELL_OPEN:
                Printf("[HwCheck]: Shell is opened\n");
                break;
              case nn::srv::NOTIFICATION_SHELL_CLOSE:
                Printf("[HwCheck]: Shell is closed\n");
                break;
              case nn::srv::NOTIFICATION_HOME_BUTTON:
                Printf("[HwCheck]: Home button is pushed\n");
                break;
              case nn::srv::NOTIFICATION_WIFI_BUTTON:
                Printf("[HwCheck]: Wifi button is pushed\n");
                break;

            }
        }
    };

    ButtonHandler     s_ShellOpenHandler;
    ButtonHandler     s_ShellCloseHandler;
    ButtonHandler     s_HomeButtonHandler;
    ButtonHandler     s_WifiButtonOpenHandler;

}


//---------------------------------------------------------------------------
//   tobNCgR{^x1`5őPxɐݒ肵܂
//---------------------------------------------------------------------------
void uji::eva::backlight::ChangeLightLevel(void)
{
    static u32 brightness_level = 0;

    brightness_level++;

    // Pxx1菬A܂5傫ꍇ͋PxxPɂ
    if(brightness_level < 1) brightness_level = 1;
    if(brightness_level > 5) brightness_level = 1;

    // obNCgPxő
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, brightness_level);

    // ANeBuobNCgOFF
    nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    return;
}


//---------------------------------------------------------------------------
//   tobNCg̋Pxxグ܂
//---------------------------------------------------------------------------
int uji::eva::backlight::UpLightLevel( int brightness_level )
{
    brightness_level++;

    // Pxx5傫ꍇ͋Pxx5ɂ
    if(brightness_level > 5) brightness_level = 5;

    // obNCgPxݒ
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, brightness_level);

    return brightness_level;
}


//---------------------------------------------------------------------------
//   tobNCg̋Pxx܂
//---------------------------------------------------------------------------
int uji::eva::backlight::DownLightLevel( int brightness_level )
{
    brightness_level--;

    // Pxx1菬ꍇ͋PxxPɂ
    if(brightness_level < 1) brightness_level = 1;

    // obNCgPxݒ
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, brightness_level);

    return brightness_level;
}


//---------------------------------------------------------------------------
// CTR:85-001  NTR:49-001  MAX BRIGHTNESS
// tobNCgőPxɐݒ肵܂ (ANeBuobNCg@\͖)
//---------------------------------------------------------------------------
bool uji::eva::backlight::SetMaxBrightness(TestResult &result)
{
    // obNCgPxő
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, 5);

    // ANeBuobNCgOFF
    nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);

    // 500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result.m_Result = true;

    return result.m_Result;
}


//---------------------------------------------------------------------------
// CTR:85-002  NTR:49-002  MIN BRIGHTNESS
//  tobNCgŏPxɐݒ肵܂ (ANeBuobNCg@\͖)
//---------------------------------------------------------------------------
bool uji::eva::backlight::SetMinBrightness(TestResult &result)
{
    // obNCgPxŏ
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, 1);

    // ANeBuobNCgOFF
    nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);

    // 500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result.m_Result = true;

    return result.m_Result;
}


//---------------------------------------------------------------------------
// CTR:85-003  NTR:49-003  ACTIVE BACKLIGHT ON
// ANeBuobNCg@\Lɐݒ肵܂  (Pxő)
//---------------------------------------------------------------------------
bool uji::eva::backlight::SetActiveBackLightOn(TestResult &result)
{
    // obNCgPxő
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, 5);

    // ANeBuobNCgON
    nn::gx::CTR::Backlight::EnableActiveBl(nn::gx::CTR::LCD_BOTH);

    // 500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result.m_Result = true;

    return result.m_Result;
}


//---------------------------------------------------------------------------
// CTR:85-004  NTR:49-004  ACTIVE BACKLIGHT OFF
// ANeBuobNCg@\𖳌ɐݒ肵܂ (Pxő)
//---------------------------------------------------------------------------
bool uji::eva::backlight::SetActiveBackLightOff(TestResult &result)
{
    // obNCgPxő
    nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, 5);

    // ANeBuobNCgOFF
    nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);

    // 500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result.m_Result = true;

    return result.m_Result;
}


//-----------------------------------------------------------------------------
// CTR:80-003  NTR:49-006  SET LCD OFF   팟LCDIt[hֈڍs
//-----------------------------------------------------------------------------
bool uji::eva::backlight::SetLcdOff(TestResult &result)
{
    nn::gx::CTR::LcdPowerManager::TurnOffAll();

    // 1500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1500));

    result.m_Result = true;

    return result.m_Result;
}


//---------------------------------------------------------------------------
// CTR:80-004  NTR:49-007 SET LCD ON   팟LCDI[hֈڍs
//---------------------------------------------------------------------------
bool uji::eva::backlight::SetLcdOn(TestResult &result)
{
    nn::gx::CTR::LcdPowerManager::TurnOnAll();

    // 1000msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));

    result.m_Result = true;

    return result.m_Result;
}


//-----------------------------------------------------------------------------
// CTR:80-012  NTR:49-008  SET LCD OFF   팟LCDIt[hֈڍs
//-----------------------------------------------------------------------------
bool uji::eva::backlight::SetLcdOff_NEC(TestResult &result)
{
    nn::gx::CTR::LcdPowerManager::TurnOffAll();

    result.m_Result = true;

    return result.m_Result;
}


//---------------------------------------------------------------------------
// CTR:80-013  NTR:49-009 SET LCD ON   팟LCDI[hֈڍs
//---------------------------------------------------------------------------
bool uji::eva::backlight::SetLcdOn_NEC(TestResult &result)
{
    nn::gx::CTR::LcdPowerManager::TurnOnAll();

    result.m_Result = true;

    return result.m_Result;
}


/*---------------------------------------------------------------------------*
  ANeBuobNCgON/OFF  obNCgPxeXg֐
 *---------------------------------------------------------------------------*/
void DemoBackLight::TestBackLightOnOff()
{
    uji::sys::Point cursorPos;    // J[\ʒup
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;
    TestResult test_result;
    u8 first_flag = 1;
    static s16 lcd_level = 3;
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    do
    {
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->BeginDrawingString();
//        gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_V);
        gfx->m_TextWriter.SetTextColor(nn::util::Color8::BLACK, nn::util::Color8::BLACK);
        gfx->SetFixedWidthFont(16);
        gfx->m_TextWriter.SetCursor(10, 20);

        (void)gfx->m_TextWriter.Printf( "               BACKLIGHT TEST"
                                        "\nUP   :lcd_level UP      DOWN:lcd_level DOWN"
                                        "\nRIGHT:SetMaxBrightness  LEFT:SetMinBrightness"
                                        "\nA    :EnableActiveBl    B   :DisableActiveBl"
                                        "\nX    :TurnOnLCD         Y   :TurnOffLCD"
                                        "\nR    :Return To Menu\n\n" );

        // j[
        if( first_flag == 1 )
        {
            gfx->EndDrawingString();
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            first_flag = 0;
            gfx->BeginDrawingString();
        }

        while(1)
        {
            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // {^
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
            {
                lcd_level++;
                if( lcd_level > 5 )lcd_level = 5;
                nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, lcd_level);
                (void)gfx->m_TextWriter.Printf( "\n\n lcd_level:%d",lcd_level );
                break;
            }

            // {^
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
            {
                lcd_level--;
                if( lcd_level < 1 )lcd_level = 1;
                nn::gx::CTR::Backlight::SetLuminanceLevel(LCD_BOTH, lcd_level);
                (void)gfx->m_TextWriter.Printf( "\n\n lcd_level:%d",lcd_level );
                break;
            }

            // E{^  LCD̋Pxő ANeBuobNCgOFF 
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
            {
                uji::eva::backlight::SetMaxBrightness(test_result);
                (void)gfx->m_TextWriter.Printf( "\n\n SetMaxBrightness (DisableActiveBl)" );
                break;
            }

            // {^   LCD̋Pxŏ ANeBuobNCgOFF 
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
            {
                uji::eva::backlight::SetMinBrightness(test_result);
                (void)gfx->m_TextWriter.Printf( "\n\n SetMinBrightness (DisableActiveBl)" );
                break;
            }

            // A{^  ANeBuobNCgON
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
            {
                //
                nn::gx::CTR::Backlight::EnableActiveBl(LCD_BOTH);
                (void)gfx->m_TextWriter.Printf( "\n\n EnableActiveBl" );
                break;
            }

            // B{^  ANeBuobNCgOFF
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_B))
            {
                nn::gx::CTR::Backlight::DisableActiveBl(LCD_BOTH);
                (void)gfx->m_TextWriter.Printf( "\n\n DisableActiveBl" );
                break;
            }

            // X{^ LCD ONԂɂ
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
            {
                uji::eva::backlight::SetLcdOn(test_result);
                (void)gfx->m_TextWriter.Printf( "\n\n TurnOnAll" );
                break;
            }

            // Y{^ LCD OFFԂɂ
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_Y))
            {
                uji::eva::backlight::SetLcdOff(test_result);
                (void)gfx->m_TextWriter.Printf( "\n\n TurnOffAll" );
                break;
            }

            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_R))
            {
                break;
            }

        };

        gfx->EndDrawingString();
        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^ꂽꍇ͌rłj[ɖ߂
    } while( ! (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) );

    NN_LOG("end...\n");

}


}   // usingnamespace eva
}   // usingnamespace uji

