
#include "TestExecuteAnalogStick.h"

using namespace uji;

namespace uji {
namespace eva {

/*---------------------------------------------------------------------------
  Desc: ʂi[
---------------------------------------------------------------------------*/
static void ShiftTestResult( CalAnalogStick* p, seq::TestResult &result )
{
    // ʂRs[
    result.m_Result = p->m_TestResult.m_Result;
    result.m_Micro  = p->m_TestResult.m_Micro;
    sprintf(result.m_String, p->m_TestResult.m_String);
    
    // oϐ
    p->m_TestResult.m_Result = false;
    p->m_TestResult.m_Micro  = 0;
    sprintf(p->m_TestResult.m_String, "");
}

/*---------------------------------------------------------------------------
  Desc: TestListp
---------------------------------------------------------------------------*/
bool TestExecuteInitialize( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    result.m_Result = p->ExecuteInitialize();
    return result.m_Result;
}

bool TestExecuteOnYourMark( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteOnYourMark();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteSampling( seq::TestResult &result )
{
#ifdef EVA_SP_AND_TP
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(120));
#endif
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteSampling();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteCalibrate( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteCalibrate();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteCheckMaxOutputWidth( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteCheckMaxOutputWidth();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteCheckAutoRestoration( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteCheckAutoRestoration();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteWriteData2SD( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    
    // ̊֐Ă΂̂́AǑS PASS Ăꍇ̂
    // iȊȌꍇ́A ExecuteWriteData2SD() Ă΂j
    // ܂ł̌ʂOoׁ͂AU m_Result = true 
    p->m_TestResult.m_Result = true;
    
    result.m_Result = p->ExecuteWriteData2SD();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteSetCalAnalogStick( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteSetCalAnalogStick();
    
    ShiftTestResult( p, result );
    return result.m_Result;
}
bool TestExecuteFinalize( seq::TestResult &result )
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    result.m_Result = p->ExecuteFinalize();
    return result.m_Result;
}

} // namespace eva
} // namespace uji
