/*--------------------------------------------------------------------------*
 Project:
 File: TestAnalogStick.h
 

*--------------------------------------------------------------------------*/
#ifndef TESTANALOGSTICK_H_INCLUDED
#define TESTANALOGSTICK_H_INCLUDED

#include <nn/math.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hid/CTR/hid_AnalogStickCalibrator.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <string>
#include "sys.h"
#include "sys_GraphicsDrawing.h"
#include "../seq/TestResult.h" 

using namespace std;

namespace uji {
namespace eva {
    
    // AiOL[̃eXg
    extern bool TestCalAnalogStick(seq::TestResult &result);
    extern bool SetCalAnalogStick(seq::TestResult &result);


    // ------------------------------------------------------------
    //  DP1.5 p
    // ------------------------------------------------------------
    const char TITLE[512] = "MacAddress,"
                            "Xraw(MAX),"
                            "Xraw(min),"
                            "Yraw(MAX),"
                            "Yraw(min),"
                            "Xcenter,"
                            "Ycenter,"
                            "Xscale,"
                            "Yscale,"
                            "Xcheck(MAX),"
                            "Xcheck(min),"
                            "Ycheck(MAX),"
                            "Ycheck(min),"
                            "Xraw(U->C),"
                            "Yraw(U->C),"
                            "Xraw(R->C),"
                            "Yraw(R->C),"
                            "Xraw(D->C),"
                            "Yraw(D->C),"
                            "Xraw(L->C),"
                            "Yraw(L->C),"
                            "X(U->C),"
                            "Y(U->C),"
                            "X(R->C),"
                            "Y(R->C),"
                            "X(D->C),"
                            "Y(D->C),"
                            "X(L->C),"
                            "Y(L->C),"
                            "Result,"
                            "\n";

class TestAnalogStick// : public TestKey
{
    /* ----------------------------------------------------------------------
     *   o֐
     * -------------------------------------------------------------------- */
public:
    TestAnalogStick() 
     : m_Type(0), 
       m_ModeId(1), m_ModeSubId(1),
       m_UnusableZone_X_Max(UNUSABLE_ZONE_MAX), m_UnusableZone_X_Min(UNUSABLE_ZONE_MIN),
       m_UnusableZone_Y_Max(UNUSABLE_ZONE_MAX), m_UnusableZone_Y_Min(UNUSABLE_ZONE_MIN),
       m_IsOutParamValid(0), m_IsInParamValid(0), m_IsSpecialParamValid(0), m_IsInButtonDiagonal(0), 
       m_IsOver60Volts(0), m_IsInRange(0), 
       m_IsSamplingRawDataFlag(0), m_WasSampledFlag(SAMPLING_NONCOMPLETION), 
       m_CalcX(0), m_CalcY(0), m_CalcCheckMaxX(0), m_CalcCheckMaxY(0), m_CalcCheckMinX(0), m_CalcCheckMinY(0)
    {
        m_Update = true;
        
        m_RawMaxX = static_cast<s16>(CALMAX);
        m_RawMinX = static_cast<s16>(CALMIN);
        m_RawMaxY = static_cast<s16>(CALMAX);
        m_RawMinY = static_cast<s16>(CALMIN);
        
        m_CenterX = RAWMAX >> 1;
        m_CenterY = RAWMAX >> 1;
        
        m_ScaleX = 1.f;
        m_ScaleY = 1.f;
        
        for(int i=0; i<5; ++i)
        {
            m_RawFreeX[i] = 0;
            m_RawFreeY[i] = 0;
            m_CalcFreeX[i] = 0;
            m_CalcFreeY[i] = 0;
        }
        
        sprintf(m_TestResult, "");
        
        m_AsStatusMaxX = static_cast<s16>(0);
        m_AsStatusMinX = static_cast<s16>(0);
        m_AsStatusMaxY = static_cast<s16>(0);
        m_AsStatusMinY = static_cast<s16>(0);
    }
    virtual ~TestAnalogStick(){};
    
    // vO
    s32  ExecuteSetCalAnalogStick();
    bool ExecuteTestAnalogStick();
    
    // AiOXeBbN̓͂ƒ_LumFp
    void ExecuteCheckAnalogStick();
    
    
private:
#if 0
    void InitializeLayoutResource();
    void InitializeAnalogStickArray();
#endif
    void InitializeCommon();
    void FinalizeCommon();
    void SetDefaultBackGroundColor();
    s16  IsOutParamValid(s16 Rx, s16 Ry, s16 button);
    s16  IsInParamValid(s16 Rx, s16 Ry);
    s16  IsInButtonDiagonal(s16 button);
    s16  IsOutParamValidStringentCriterion(s16 x, s16 y, s16 button);
    s16  IsSpecialParamValid(s16 Rx, s16 Ry, s16 button);
    
    // DP1.5p
    void CreateDirectorySdmc(const wchar_t* path);
    void WriteData2SD(const wchar_t* path, string line);
    void DrawAnimation(s16 mode, s16 modeSub);
    
    void DrawCross(nn::hid::PadStatus * pBuf);
    void DrawRawAndCalib(nn::hid::AnalogStickStatus* pRaw, 
                         nn::hid::CTR::AnalogStickCalData* pCal);
    
    void SetInformationWindow();
    void DrawTestAnalogStick();
    void DrawCheckAnalogStick(nn::hid::PadStatus ps, 
                              nn::hid::AnalogStickStatus* raw,
                              nn::hid::CTR::AnalogStickCalData* cal,
                              s16 checksum);
    
    void ThreadSamplingRawData();
    void StartSamplingRawData();
    void StopSamplingRawData();
    
    void OutputNNLog(int scene, int i);
    void OutputData();
    
    /* ----------------------------------------------------------------------
     *   oϐ
     * -------------------------------------------------------------------- */
    // XChpbh̎
    s16 m_Type;
    
    // e탂[hID
    s16 m_ModeId;
    s16 m_ModeSubId;
    
    // lőŏ
    s16 m_RawMaxX;
    s16 m_RawMinX;
    s16 m_RawMaxY;
    s16 m_RawMinY;
    
    // _␳l
    s16 m_CenterX;
    s16 m_CenterY;
    
    // x␳W
    f32 m_ScaleX;
    f32 m_ScaleY;
    
    // sэőŏ
    s16 m_UnusableZone_X_Max;
    s16 m_UnusableZone_X_Min;
    s16 m_UnusableZone_Y_Max;
    s16 m_UnusableZone_Y_Min;
    
    // sуeXgl
    s16 m_RawFreeX[5];
    s16 m_RawFreeY[5];
    
    // sуeXg\t
    s16 m_CalcFreeX[5];
    s16 m_CalcFreeY[5];
    
    // ێp
    bool m_Update;
    s16 m_IsOutParamValid;
    s16 m_IsInParamValid;
    s16 m_IsSpecialParamValid;
    s16 m_IsInButtonDiagonal;
    s16 m_IsOver60Volts;
    s16 m_IsInRange;
    
    // lpXe[^X
    nn::hid::AnalogStickStatus m_AsStatusRaw;
    
    // Xbh
    nn::os::Thread m_ThreadSmplRawData;
    bool m_IsSamplingRawDataFlag;
    
    // EBhEp
    sys::WindowManager  m_WindowManager;
    sys::TextWindow*    m_InformationWindow;
    
    // `FbN[hp
    s16 m_CalCheckSum;
    
    // ʊi[p
    char m_TestResult[11];
    
    // Lu[VtO
    bool m_WasSampledFlag;
    
    // lőŏ
    s16 m_AsStatusMaxX;
    s16 m_AsStatusMinX;
    s16 m_AsStatusMaxY;
    s16 m_AsStatusMinY;
    
    // XChpbhXe[^Xp
    //nn::hid::PadReader m_PadReader;
    //nn::hid::PadStatus m_PadStatus;
    
    // lϊl
    s16 m_CalcX;
    s16 m_CalcY;
    
    // ʊJҗp̊֐Ŏ擾łl
    s16 m_CalcCheckMaxX;
    s16 m_CalcCheckMaxY;
    s16 m_CalcCheckMinX;
    s16 m_CalcCheckMinY;
    
    /* ----------------------------------------------------------------------
     *   ÓIo
     * -------------------------------------------------------------------- */
    
    // ֐
    static void WrappingThreadSamplingRawData(void* param);
    
    // 萔
    static const s16 RAWMAX = 4096;
    static const f32 DELTA  = 0.065f;
    static const f32 CALMAX = RAWMAX * (0.8f - DELTA);  // 80%}6.5% -> Œł73.5%
    static const f32 CALMIN = RAWMAX * (0.2f + DELTA);  // 20%}6.5% -> ōł26.5%
    static const f32 DELTA_MAX = RAWMAX * (0.5f + DELTA);
    static const f32 DELTA_MIN = RAWMAX * (0.5f - DELTA);
    static const s16 UNUSABLE_ZONE_MAX = 48;
    static const s16 UNUSABLE_ZONE_MIN = -48;
    static const f32 VOLTAGE_MIN = RAWMAX * 0.60f;
    static const f32 RANGE = RAWMAX * 0.60f;
    static const s16 LIMIT_MAX  = nn::hid::LIMIT_OF_STICK_CLAMP_MAX;		// 150
    static const s16 MIN_CROSS  = nn::hid::MIN_OF_STICK_CLAMP_MODE_CROSS;	// 38
    static const s16 MIN_CIRCLE = nn::hid::MIN_OF_STICK_CLAMP_MODE_CIRCLE;	// 50
    
    static const bool SAMPLING_NONCOMPLETION = false;
    static const bool SAMPLING_COMPLETION    = true;
    
    // TvO[v
    static const u8 SAMPLING_LOOP_NUM = 2;
    
    
};


}
}

#endif  // TESTANALOGSTICK_H_INCLUDED

