
#include <nn.h>
#include <nn/gx.h>
#include <nn/hid.h>
#include <nn/fnd.h>
#include <nw/ut.h>
#include <nn/uds.h>
#include <string>
#include "TestAnalogStick.h"
#include "../seq/TesterLog/ProductionLog.h"

using namespace uji;
using namespace uji::sys;
using namespace nn::math;

#define ANALOGSTICK_DEBUG_FLAG      1
#define OUTPUT_TO_SD                1
#define CLOCKWISE                   1

#define CLAMP_MODE_CIRCLE           0
#if CLAMP_MODE_CIRCLE==0
#define CLAMP_MODE_CROSS            1
#endif


namespace uji {
namespace eva {

    // modeId
    enum
    {
        OUT_PARAM_SAMPLING = 1,
        CALIBRATION,
        OUT_PARAM_CHECK,
        IN_PARAM_CHECK,
        TEST_ERROR,
        TEST_PASS,
        MODE_ID_MAX
    };

    // modeSubId
    enum
    {
        CT = 0,
#if CLOCKWISE   // v
        UP = 1,
        UR,
        RT,
        DR,
        DW,
        DL,
        LT,
        UL,
#else           // v
        UP = 1,
        UL,
        LT,
        DL,
        DW,
        DR,
        RT,
        UR,
#endif
        MODE_SUB_ID_MAX
    };

    static nn::drivers::cal::CTR::AnalogStickCalDataCore   s_CalDataCore;
    static nn::drivers::cal::CTR::AnalogStickCalAppendCore s_CalAppendCore;

//=========================================================================================
//=========================================================================================
#if 0   // Ƃ肠͎֌WȂ̂ŃRgAEg
//=========================================================================================
//=========================================================================================
// ----------------------------------------------------------------------------------
//  Desc: CAEg\[X̏
// ----------------------------------------------------------------------------------
void TestAnalogStick::InitializeLayoutResource()
{
    nw::lyt::Initialize(&memAllocator, &devMemAllocator);

    m_pLayout = new nw::lyt::Layout();

    // CAEg̃oCi\[X(A[JCu)ǂݍ݁B
    demo::File fileLayout;
    if (!fileLayout.Read(NW_DEMO_FILE_PATH(L"key/layout.arc"), devMemAllocator))
    {
        NW_FATAL_ERROR("can not open layout archive.\n");
    }

    // oCi\[X̃[gfBNgw肵ă\[XANZT𐶐B
    m_pResAccessor = new nw::lyt::ArcResourceAccessor;
    if (!m_pResAccessor->Attach(fileLayout.Buffer(), "."))
    {
        NW_FATAL_ERROR("can not attach layout archive.\n");
    }

    // CAEg\[X̓ǂݍ
    {
        const void* lytRes = m_pResAccessor->GetResource(0, "AnalogStick.bclyt");
        NW_NULL_ASSERT(lytRes);
        m_pLayout->Build(lytRes, m_pResAccessor);
    }

    // Aj[V\[X̓ǂݍ
    {
        const void* lpaRes = m_pResAccessor->GetResource(0, "AnalogStick.bclan");
        NW_NULL_ASSERT(lpaRes);
        m_AnimRes.Set(lpaRes);
    }

    // Aj[VLݒAAj[Vԃ^O̊֘AO[v
    // lAj[ṼoChs܂B
    m_pLayout->BindAnimationAuto(m_AnimRes, m_pResAccessor);

    // Layout::BindAnimationAuto() ŃoChAj[V͖ɂȂĂ܂B
    // Ŝ̃Aj[VLɂ܂B
    m_pLayout->GetRootPane()->SetAnimationEnable(m_AnimRes, true, true);

    // O[oȃ\[Xt@Cǂݍ݂܂B
    {
        m_GraphicsResource.StartSetup();
        const wchar_t* resourcePath = 0;
        for (int i = 0;
             (resourcePath = m_GraphicsResource.GetResourcePath(i)) != NULL;
             ++i)
        {
            u32 fileSize = 0;
            demo::File file;
            if (!file.Read(resourcePath, memAllocator))
            {
                NW_FATAL_ERROR("can not open lyt resource file.");
            }
            m_GraphicsResource.SetResource(i, file.Buffer(), file.Size());
        }
        m_GraphicsResource.FinishSetup();
    }

    m_DrawInfo.SetGraphicsResource(&m_GraphicsResource);
}

// ----------------------------------------------------------------------------------
//  Desc: {^z̏
// ----------------------------------------------------------------------------------
void TestAnalogStick::InitializeAnalogStickArray()
{
    m_ButtonArray.PushBack(new Button("box_gray_00",  nn::hid::CTR::BUTTON_EMULATION_UP                                         ));
    m_ButtonArray.PushBack(new Button("box_gray_01",  nn::hid::CTR::BUTTON_EMULATION_UP   | nn::hid::CTR::BUTTON_EMULATION_RIGHT));
    m_ButtonArray.PushBack(new Button("box_gray_02",                                        nn::hid::CTR::BUTTON_EMULATION_RIGHT));
    m_ButtonArray.PushBack(new Button("box_gray_03",  nn::hid::CTR::BUTTON_EMULATION_DOWN | nn::hid::CTR::BUTTON_EMULATION_RIGHT));
    m_ButtonArray.PushBack(new Button("box_gray_04",  nn::hid::CTR::BUTTON_EMULATION_DOWN                                       ));
    m_ButtonArray.PushBack(new Button("box_gray_05",  nn::hid::CTR::BUTTON_EMULATION_DOWN | nn::hid::CTR::BUTTON_EMULATION_LEFT ));
    m_ButtonArray.PushBack(new Button("box_gray_06",                                        nn::hid::CTR::BUTTON_EMULATION_LEFT ));
    m_ButtonArray.PushBack(new Button("box_gray_07",  nn::hid::CTR::BUTTON_EMULATION_UP   | nn::hid::CTR::BUTTON_EMULATION_LEFT ));
}
//=========================================================================================
//=========================================================================================
#endif
//=========================================================================================
//=========================================================================================

/*---------------------------------------------------------------------------
  Desc: ʂ̏
---------------------------------------------------------------------------*/
void TestAnalogStick::InitializeCommon()
{
    SetDefaultBackGroundColor();

    // \pm_InformationWindowp
    const int FONT_SIZE = 12;
    m_InformationWindow = new TextWindow( 52, 20, FONT_SIZE );
    (void)m_WindowManager.CreateWindow(m_InformationWindow, NN_GX_DISPLAY1, 0, 0);
    m_InformationWindow->SetTitle("Information");
}
/*---------------------------------------------------------------------------
  Desc: ʂ̏I
---------------------------------------------------------------------------*/
void TestAnalogStick::FinalizeCommon()
{
    m_WindowManager.DestroyWindow(m_InformationWindow);
    SetDefaultBackGroundColor();
}
/*---------------------------------------------------------------------------
  Desc: wiftHg
---------------------------------------------------------------------------*/
void TestAnalogStick::SetDefaultBackGroundColor()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
}

/*---------------------------------------------------------------------------
  Desc: 菈
---------------------------------------------------------------------------*/
s16 TestAnalogStick::IsOutParamValid(s16 x, s16 y, s16 button)
{
    s16 ret = 0;

    switch(button)
    {
    case UP:    ret = ((y >= CALMAX) ? 1 : 0);   break;
    case RT:    ret = ((x >= CALMAX) ? 1 : 0);   break;
    case DW:    ret = ((y <= CALMIN) ? 1 : 0);   break;
    case LT:    ret = ((x <= CALMIN) ? 1 : 0);   break;
    }

    return ret;
}
s16 TestAnalogStick::IsInParamValid(s16 x, s16 y)
{
    s16 ret = 0;

    if(m_UnusableZone_X_Min <= x && x <= m_UnusableZone_X_Max &&
       m_UnusableZone_Y_Min <= y && y <= m_UnusableZone_Y_Max)
    {
        ret = 1;
    }

    return ret;
}
s16 TestAnalogStick::IsInButtonDiagonal(s16 button)
{
    s16 ret = 0;

    uji::sys::Pad pad;

    /*
    // \Nv
    nn::hid::PadReader::StickClampMode clampMode = m_PadReader.STICK_CLAMP_MODE_CROSS;
    int clampMin = nn::hid::CTR::MIN_OF_STICK_CLAMP_MODE_CROSS;
    int clampMax = nn::hid::CTR::LIMIT_OF_STICK_CLAMP_MAX;
    m_PadReader.SetStickClampMode(clampMode);
    m_PadReader.SetStickClamp(clampMin, clampMax);
    */

    pad.UpdatePad();

    switch(button)
    {
    case UR:
        if(pad.IsButtonPress(Pad::BUTTON_EMULATION_UP) &&
           pad.IsButtonPress(Pad::BUTTON_EMULATION_RIGHT))
        {
            ret = 1;
        }
        break;
    case DR:
        if(pad.IsButtonPress(Pad::BUTTON_EMULATION_DOWN) &&
           pad.IsButtonPress(Pad::BUTTON_EMULATION_RIGHT))
        {
            ret = 1;
        }
        break;
    case DL:
        if(pad.IsButtonPress(Pad::BUTTON_EMULATION_DOWN) &&
           pad.IsButtonPress(Pad::BUTTON_EMULATION_LEFT))
        {
            ret = 1;
        }
        break;
    case UL:
        if(pad.IsButtonPress(Pad::BUTTON_EMULATION_UP) &&
           pad.IsButtonPress(Pad::BUTTON_EMULATION_LEFT))
        {
            ret = 1;
        }
        break;
    }

    return ret;
}
s16 TestAnalogStick::IsOutParamValidStringentCriterion(s16 x, s16 y, s16 button)
{
    s16 ret = 0;

    switch(button)
    {
    case UP:
        if(y >=   LIMIT_MAX - 5 )
        {
            ret = 1;
            m_CalcCheckMaxY = y;
        }
        break;
    case RT:
        if(x >=   LIMIT_MAX - 5 )
        {
            ret = 1;
            m_CalcCheckMaxX = x;
        }
        break;
    case DW:
        if(y <= -(LIMIT_MAX - 5))
        {
            ret = 1;
            m_CalcCheckMinY = y;
        }
        break;
    case LT:
        if(x <= -(LIMIT_MAX - 5))
        {
            ret = 1;
            m_CalcCheckMinX = x;
        }
        break;
    }

    return ret;
}
s16 TestAnalogStick::IsSpecialParamValid(s16 x, s16 y, s16 button)
{
    s16 ret = 0;

    switch(button)
    {
    case UP:    ret = (( 60 <= y  && y <=  80) ? 1 : 0);   break;
    case RT:    ret = (( 60 <= x  && x <=  80) ? 1 : 0);   break;
    case DW:    ret = ((-80 <= y  && y <= -60) ? 1 : 0);   break;
    case LT:    ret = ((-80 <= x  && x <= -60) ? 1 : 0);   break;
    }

    return ret;
}

/*******************************************************************************
 *******************************************************************************

                                  DP1.5 p

*******************************************************************************
*******************************************************************************/

/*---------------------------------------------------------------------------
  Desc: fBNgJȂꍇ͐VK쐬

  Args: path        Ώۃt@C̃tpX

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void TestAnalogStick::CreateDirectorySdmc(const wchar_t* path)
{
    nn::fs::Directory dir;
    nn::Result result = dir.TryInitialize( path );

    // fBNgȂꍇ͐VK쐬
    if(result.IsFailure())
    {
        NN_LOG("@ Can't Initialize! So Create Directory... \n");

        result = nn::fs::TryCreateDirectory( path );

        if(result.IsFailure())
        {
            NN_LOG("* Warning: No Create Directory! \n");
        }
    }
    else
    {
        dir.Finalize();
    }
}

/*---------------------------------------------------------------------------
  Desc: Ώۃt@CɃf[^݂܂

  Args: path        Ώۃt@C̃tpX
        strBuf      ރf[^

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void TestAnalogStick::WriteData2SD(const wchar_t* path, string strBuf)
{
    // t@C݂߂̃IuWFNg쐬
    nn::fs::FileStream fos;
    nn::Result result = fos.TryInitialize(path, nn::fs::OPEN_MODE_READ   |
                                                nn::fs::OPEN_MODE_WRITE  |
                                                nn::fs::OPEN_MODE_CREATE );
    if(result.IsSuccess())
    {
        s64 size = fos.GetSize();
        NN_LOG("FILE_SIZE= %lld\n", size);

        if(size == 0)
        {
            // ̂
            fos.Write(TITLE, strlen(TITLE));
        }
        else
        {
            // ڈȍ~
            fos.Seek( -1, nn::fs::POSITION_BASE_END );
        }
        fos.Write(strBuf.c_str(), strlen(strBuf.c_str()));
        fos.Write("@", 1);
    }

    // t@C
    fos.Finalize();
}

/* ----------------------------------------------------------------------------------
  Desc: DP1.5p XChpbhʁiʂ̂݁j

  Args: mode            OUT_PARAM_SAMPLING  őlEŏl߂
                        CALIBRATION         Lu[V
                        OUT_PARAM_CHECK     őlEŏl̊mF
                        IN_PARAM_CHECK      Z^[A\
                        TEST_ERROR          mf
                        TEST_PASS           o`rr
        modeSub         ͕

  Rtns: Ȃ
 ---------------------------------------------------------------------------------- */
void TestAnalogStick::DrawAnimation(s16 mode, s16 modeSub)
{
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->BeginDrawingShape();

    const nn::math::VEC2 BACK_SCREEN = nn::math::VEC2(static_cast<f32>(gfx->DISPLAY0_WIDTH),
                                                      static_cast<f32>(gfx->DISPLAY0_HEIGHT));
    const nn::math::VEC2 VIEW_SCREEN = nn::math::VEC2(240.f, 240.f);

    //
    // OUT_PARAM_SAMPLING, CALIBRATION, OUT_PARAM_CHECKp
    const f32 ST = (BACK_SCREEN.x - VIEW_SCREEN.x) / 2;
    const f32 SIZE = VIEW_SCREEN.x / 3;
    const nn::math::VEC2 sizeAll = nn::math::VEC2(SIZE, SIZE);
    const nn::math::VEC2 posUpAndLeft    = nn::math::VEC2(ST,           0.f);
    const nn::math::VEC2 posUp           = nn::math::VEC2(ST + SIZE,    0.f);
    const nn::math::VEC2 posUpAndRight   = nn::math::VEC2(ST + 2*SIZE,  0.f);
    const nn::math::VEC2 posLeft         = nn::math::VEC2(ST,           SIZE);
    const nn::math::VEC2 posCenter       = nn::math::VEC2(ST + SIZE,    SIZE);
    const nn::math::VEC2 posRight        = nn::math::VEC2(ST + 2*SIZE,  SIZE);
    const nn::math::VEC2 posDownAndLeft  = nn::math::VEC2(ST,           2*SIZE);
    const nn::math::VEC2 posDown         = nn::math::VEC2(ST + SIZE,    2*SIZE);
    const nn::math::VEC2 posDownAndRight = nn::math::VEC2(ST + 2*SIZE,  2*SIZE);

    gfx->SetColor(nw::ut::Color8::BLACK);
    gfx->FillRectangle( 0.f, 0.f, BACK_SCREEN.x, BACK_SCREEN.y );
    gfx->SetColor(nw::ut::Color8::WHITE);
    gfx->FillRectangle( (BACK_SCREEN.x - VIEW_SCREEN.x) / 2 ,
                        (BACK_SCREEN.y - VIEW_SCREEN.y) / 2 ,
                        VIEW_SCREEN.x, VIEW_SCREEN.y );

    //
    // IN_PARAM_CHECKp
    f32 outFrameWidth     = 80 * 2 * 240 / 300;
    f32 inFrameWidth      = 60 * 2 * 240 / 300;
    f32 unusableZoneWidth = 40 * 2 * 240 / 300;
    nn::math::VEC2 outFrameCoordinate =
        nn::math::VEC2((VIEW_SCREEN.x - outFrameWidth) / 2 + ST,
                       (VIEW_SCREEN.y - outFrameWidth) / 2);
    nn::math::VEC2 inFrameCoordinate  =
        nn::math::VEC2((VIEW_SCREEN.x - inFrameWidth) / 2 + ST,
                       (VIEW_SCREEN.y - inFrameWidth) / 2);
    nn::math::VEC2 unusableZoneCoordinate =
        nn::math::VEC2((VIEW_SCREEN.x - unusableZoneWidth ) / 2 + ST,
                       (VIEW_SCREEN.y - unusableZoneWidth ) / 2);
    nn::math::VEC2 modifyScreen = nn::math::VEC2(VIEW_SCREEN.x / RAWMAX, VIEW_SCREEN.y / RAWMAX);
    s16 modifyCalcX = m_CalcX * modifyScreen.x;
    s16 modifyCalcY = m_CalcY * modifyScreen.y;


    switch(mode)
    {
    // X-Y̍őlEŏl擾
    case OUT_PARAM_SAMPLING:
        gfx->SetColor(nw::ut::Color8::YELLOW);
        switch(modeSub)
        {
        case UP:    gfx->FillRectangle(posUp, sizeAll);                 break;
        case RT:    gfx->FillRectangle(posRight, sizeAll);              break;
        case DW:    gfx->FillRectangle(posDown, sizeAll);               break;
        case LT:    gfx->FillRectangle(posLeft, sizeAll);               break;
        case UR:    gfx->FillRectangle(posUpAndRight, sizeAll);         break;
        case DR:    gfx->FillRectangle(posDownAndRight, sizeAll);       break;
        case DL:    gfx->FillRectangle(posDownAndLeft, sizeAll);        break;
        case UL:    gfx->FillRectangle(posUpAndLeft, sizeAll);          break;
        }
        gfx->SetColor(nw::ut::Color8::BLACK);
        gfx->DrawWidth1Rectangle(posUpAndLeft   , sizeAll);
        gfx->DrawWidth1Rectangle(posUp          , sizeAll);
        gfx->DrawWidth1Rectangle(posUpAndRight  , sizeAll);
        gfx->DrawWidth1Rectangle(posLeft        , sizeAll);
        gfx->DrawWidth1Rectangle(posCenter      , sizeAll);
        gfx->DrawWidth1Rectangle(posRight       , sizeAll);
        gfx->DrawWidth1Rectangle(posDownAndLeft , sizeAll);
        gfx->DrawWidth1Rectangle(posDown        , sizeAll);
        gfx->DrawWidth1Rectangle(posDownAndRight, sizeAll);
        break;

    // Lu[V
    case CALIBRATION:
        gfx->SetColor(nw::ut::Color8::BLACK);
        gfx->DrawWidth1Rectangle(posUpAndLeft   , sizeAll);
        gfx->DrawWidth1Rectangle(posUp          , sizeAll);
        gfx->DrawWidth1Rectangle(posUpAndRight  , sizeAll);
        gfx->DrawWidth1Rectangle(posLeft        , sizeAll);
        gfx->DrawWidth1Rectangle(posCenter      , sizeAll);
        gfx->DrawWidth1Rectangle(posRight       , sizeAll);
        gfx->DrawWidth1Rectangle(posDownAndLeft , sizeAll);
        gfx->DrawWidth1Rectangle(posDown        , sizeAll);
        gfx->DrawWidth1Rectangle(posDownAndRight, sizeAll);
        break;

    // X-Y̍őlEŏl`FbN
    case OUT_PARAM_CHECK:
        gfx->SetColor(nw::ut::Color8::YELLOW);
        switch(modeSub)
        {
        case UP:    gfx->FillRectangle(posUp, sizeAll);                 break;
        case RT:    gfx->FillRectangle(posRight, sizeAll);              break;
        case DW:    gfx->FillRectangle(posDown, sizeAll);               break;
        case LT:    gfx->FillRectangle(posLeft, sizeAll);               break;
        case UR:    gfx->FillRectangle(posUpAndRight, sizeAll);         break;
        case DR:    gfx->FillRectangle(posDownAndRight, sizeAll);       break;
        case DL:    gfx->FillRectangle(posDownAndLeft, sizeAll);        break;
        case UL:    gfx->FillRectangle(posUpAndLeft, sizeAll);          break;
        }
        gfx->SetColor(nw::ut::Color8::BLACK);
        gfx->DrawWidth1Rectangle(posUpAndLeft   , sizeAll);
        gfx->DrawWidth1Rectangle(posUp          , sizeAll);
        gfx->DrawWidth1Rectangle(posUpAndRight  , sizeAll);
        gfx->DrawWidth1Rectangle(posLeft        , sizeAll);
        gfx->DrawWidth1Rectangle(posCenter      , sizeAll);
        gfx->DrawWidth1Rectangle(posRight       , sizeAll);
        gfx->DrawWidth1Rectangle(posDownAndLeft , sizeAll);
        gfx->DrawWidth1Rectangle(posDown        , sizeAll);
        gfx->DrawWidth1Rectangle(posDownAndRight, sizeAll);
        break;

    // s
    case IN_PARAM_CHECK:

        if(modeSub%2==0)
        {
            gfx->SetColor(nw::ut::Color8::CYAN);
            gfx->FillRectangle(unusableZoneCoordinate,  nn::math::VEC2(unusableZoneWidth, unusableZoneWidth));

            // g
            gfx->SetColor(nw::ut::Color8::BLACK);
            gfx->DrawWidth1Rectangle(unusableZoneCoordinate,    nn::math::VEC2(unusableZoneWidth, unusableZoneWidth));
        }
        else
        {
            gfx->SetColor(nw::ut::Color8::GRAY);
            if(modeSub==1 &&  60 <= m_CalcY && m_CalcY <=  80)  gfx->SetColor(nw::ut::Color8::YELLOW);
            if(modeSub==3 &&  60 <= m_CalcX && m_CalcX <=  80)  gfx->SetColor(nw::ut::Color8::YELLOW);
            if(modeSub==5 && -80 <= m_CalcY && m_CalcY <= -60)  gfx->SetColor(nw::ut::Color8::YELLOW);
            if(modeSub==7 && -80 <= m_CalcX && m_CalcX <= -60)  gfx->SetColor(nw::ut::Color8::YELLOW);

            gfx->FillRectangle(outFrameCoordinate,  nn::math::VEC2(outFrameWidth, outFrameWidth));
            gfx->SetColor(nw::ut::Color8::WHITE);
            gfx->FillRectangle(inFrameCoordinate,   nn::math::VEC2(inFrameWidth, inFrameWidth));

            // g
            gfx->SetColor(nw::ut::Color8::BLACK);
            gfx->DrawWidth1Rectangle(outFrameCoordinate,    nn::math::VEC2(outFrameWidth, outFrameWidth));
            gfx->DrawWidth1Rectangle(inFrameCoordinate, nn::math::VEC2(inFrameWidth, inFrameWidth));

            gfx->SetColor(nw::ut::Color8::RED);
            switch(modeSub)
            {
            case 1: gfx->FillRectangle(ST+100,  10, 40, 10);    break;
            case 3: gfx->FillRectangle(ST+220, 100, 10, 40);    break;
            case 5: gfx->FillRectangle(ST+100, 220, 40, 10);    break;
            case 7: gfx->FillRectangle(ST+ 10, 100, 10, 40);    break;
            }
        }
        break;

    // NG
    case TEST_ERROR:
        gfx->SetColor(nw::ut::Color8::RED);
        gfx->FillRectangle( (BACK_SCREEN.x - VIEW_SCREEN.x) / 2 ,
                            (BACK_SCREEN.y - VIEW_SCREEN.y) / 2 ,
                            VIEW_SCREEN.x, VIEW_SCREEN.y );
        break;

    // OK
    case TEST_PASS:
        gfx->SetColor(nw::ut::Color8::GREEN);
        gfx->FillRectangle( (BACK_SCREEN.x - VIEW_SCREEN.x) / 2 ,
                            (BACK_SCREEN.y - VIEW_SCREEN.y) / 2 ,
                            VIEW_SCREEN.x, VIEW_SCREEN.y );
        break;
    }


}

/*******************************************************************************
 *******************************************************************************

                                    

*******************************************************************************
*******************************************************************************/

/*---------------------------------------------------------------------------
  Desc: WϊA\`

  Args: pBuf

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void TestAnalogStick::DrawCross(nn::hid::PadStatus * pBuf)
{
    f32 crossSize = 10.f;

    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->BeginDrawingShape();

    nn::math::VEC2 center = nn::math::VEC2(static_cast<f32>(gfx->DISPLAY0_WIDTH  >> 1),
                                           static_cast<f32>(gfx->DISPLAY0_HEIGHT >> 1));

    gfx->SetColor(nw::ut::Color8::GREEN);
    gfx->SetLineWidth(2.0f);

    //ʕ\pɏCW
    f32 modifyX =   pBuf->stick.x  + center.x;
    f32 modifyY = -(pBuf->stick.y) + center.y;

    //\̍W
    f32 crossX1 = modifyX-crossSize;
    f32 crossX2 = modifyX+crossSize;
    f32 crossY1 = modifyY-crossSize;
    f32 crossY2 = modifyY+crossSize;

    //\`
    gfx->DrawLine(crossX1, modifyY, crossX2, modifyY);
    gfx->DrawLine(modifyX, crossY1, modifyX, crossY2);

    //_̃C`
    gfx->DrawLine(center.x, center.y, modifyX, modifyY);

}

/*---------------------------------------------------------------------------
  Desc: lẅ̗TCY( 240*240 )ɕϊĉʕ\

  Args: pRaw    lp
        pCal    ␳̒_p

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void TestAnalogStick::DrawRawAndCalib(nn::hid::AnalogStickStatus* pRaw, nn::hid::CTR::AnalogStickCalData* pCal)
{
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->BeginDrawingShape();

    // ----------------------------------------------
    // wi

    const nn::math::VEC2 BACK_SCREEN = nn::math::VEC2(static_cast<f32>(gfx->DISPLAY0_WIDTH),
                                                      static_cast<f32>(gfx->DISPLAY0_HEIGHT));
    const nn::math::VEC2 VIEW_SCREEN = nn::math::VEC2(240.f, 240.f);

    gfx->SetColor(nw::ut::Color8::BLACK);
    gfx->FillRectangle( 0.f, 0.f, BACK_SCREEN.x, BACK_SCREEN.y );
    gfx->SetColor(nw::ut::Color8::WHITE);
    gfx->FillRectangle( (BACK_SCREEN.x - VIEW_SCREEN.x) / 2 ,
                        (BACK_SCREEN.y - VIEW_SCREEN.y) / 2 ,
                        VIEW_SCREEN.x, VIEW_SCREEN.y );

    // ----------------------------------------------
    // 臒l

    // ʕ\p̏CW
    nn::math::VEC2 modifyScreen = nn::math::VEC2(VIEW_SCREEN.x / RAWMAX, VIEW_SCREEN.y / RAWMAX);
    f32 modifyDisplay;
    if(BACK_SCREEN.x == static_cast<f32>(gfx->DISPLAY0_WIDTH))
    {
        modifyDisplay = 80.f;
    }
    else if(BACK_SCREEN.x == static_cast<f32>(gfx->DISPLAY1_WIDTH))
    {
        modifyDisplay = 40.f;
    }

    f32 f_a = ( CALMAX - CALMIN ) / ( nn::math::FSqrt(2.f) + 1 );
    f32 foo1 = CALMIN + (( nn::math::FSqrt(2.f) * f_a ) / 2);
    f32 foo2 = CALMIN + (( nn::math::FSqrt(2.f) * f_a ) / 2) + f_a;
    nn::math::VEC2 v2_a = nn::math::VEC2( foo1   * modifyScreen.x + modifyDisplay, CALMIN * modifyScreen.y );
    nn::math::VEC2 v2_b = nn::math::VEC2( foo2   * modifyScreen.x + modifyDisplay, CALMIN * modifyScreen.y );
    nn::math::VEC2 v2_c = nn::math::VEC2( CALMAX * modifyScreen.x + modifyDisplay, foo1   * modifyScreen.y );
    nn::math::VEC2 v2_d = nn::math::VEC2( CALMAX * modifyScreen.x + modifyDisplay, foo2   * modifyScreen.y );
    nn::math::VEC2 v2_e = nn::math::VEC2( foo2   * modifyScreen.x + modifyDisplay, CALMAX * modifyScreen.y );
    nn::math::VEC2 v2_f = nn::math::VEC2( foo1   * modifyScreen.x + modifyDisplay, CALMAX * modifyScreen.y );
    nn::math::VEC2 v2_g = nn::math::VEC2( CALMIN * modifyScreen.x + modifyDisplay, foo2   * modifyScreen.y );
    nn::math::VEC2 v2_h = nn::math::VEC2( CALMIN * modifyScreen.x + modifyDisplay, foo1   * modifyScreen.y );

    gfx->SetColor(nw::ut::Color8::BLACK);
    gfx->DrawLine(v2_a, v2_b);
    gfx->DrawLine(v2_b, v2_c);
    gfx->DrawLine(v2_c, v2_d);
    gfx->DrawLine(v2_d, v2_e);
    gfx->DrawLine(v2_e, v2_f);
    gfx->DrawLine(v2_f, v2_g);
    gfx->DrawLine(v2_g, v2_h);
    gfx->DrawLine(v2_h, v2_a);

    // ----------------------------------------------
    // Lu[V̒S

    f32 squairHalfSize = 5.f;

    if( pCal->center_x != 0 || pCal->center_y != 0 )
    {
        gfx->SetColor(nw::ut::Color8::RED);

        // ʕ\pɏCW
        f32 modifyCalX = pCal->center_x * modifyScreen.x;
        f32 modifyCalY = pCal->center_y * modifyScreen.y;

        // [̍W
        f32 squairCalX = modifyCalX - squairHalfSize + modifyDisplay;
        f32 squairCalY = VIEW_SCREEN.y - (modifyCalY - squairHalfSize);

        // l`
        gfx->FillRectangle(squairCalX, squairCalY, 2*squairHalfSize, 2*squairHalfSize);
    }

    // ----------------------------------------------
    // l

    gfx->SetColor(nw::ut::Color8::BLUE);

    // ʕ\pɏCW
    f32 modifyRawX = pRaw->x * modifyScreen.x;
    f32 modifyRawY = pRaw->y * modifyScreen.y;

    // [̍W
    f32 squairRawX = modifyRawX - squairHalfSize + modifyDisplay;
    f32 squairRawY = VIEW_SCREEN.y - (modifyRawY - squairHalfSize);

    // l`
    gfx->FillRectangle(squairRawX, squairRawY, 2*squairHalfSize, 2*squairHalfSize);
}

/*---------------------------------------------------------------------------
  Desc: [hp InformationWindow ̐ݒ
---------------------------------------------------------------------------*/
void TestAnalogStick::SetInformationWindow()
{
    m_InformationWindow->Gotoxy(0,0);
    m_InformationWindow->SetTitle("Information");
    m_InformationWindow->SetTextColor(ATTR_COLOR_WHITE);
    m_InformationWindow->Printf("Mode:%d-%d\n", m_ModeId, m_ModeSubId);
    m_InformationWindow->Printf("%d/%d/%d/%d/%d/%d\n",  m_IsOutParamValid,
                                                        m_IsInButtonDiagonal,
                                                        m_IsSpecialParamValid,
                                                        m_IsOver60Volts,
                                                        m_IsInRange,
                                                        m_IsInParamValid);
    m_InformationWindow->Printf("\n");
    m_InformationWindow->Printf("Raw(%d):\n", m_Update);
    m_InformationWindow->Printf("  -> X: Max:%5d, Min:%5d\n", m_RawMaxX, m_RawMinX);
    m_InformationWindow->Printf("  -> Y: Max:%5d, Min:%5d\n", m_RawMaxY, m_RawMinY);
    m_InformationWindow->Printf("  -> Center: (%5d, %5d)\n", m_CenterX, m_CenterY);
    m_InformationWindow->Printf("  -> Scale : (%7.5f, %7.5f)\n", m_ScaleX, m_ScaleY);
    m_InformationWindow->Printf("\n");
    m_InformationWindow->Printf("Check slidepad for position.:\n");
    for(int i=1; i<5; ++i)
    {
        m_InformationWindow->Printf("  -> %d:(%5d, %5d)\n", i, m_CalcFreeX[i], m_CalcFreeY[i]);
    }
}

/*---------------------------------------------------------------------------
  Desc: XChpbȟʁiS̕\j
---------------------------------------------------------------------------*/
void TestAnalogStick::DrawTestAnalogStick()
{
    // ------------------------------------------------------------
    //  t
    // ------------------------------------------------------------
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->BeginDrawingShape();

    // ------------------------------------------------------------
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);

    // ʍXV
    DrawAnimation(m_ModeId, m_ModeSubId);


    // t\
    gfx->m_DrawFramework->SwapBuffers();

    // ------------------------------------------------------------

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

    // EBhEXV
    m_WindowManager.Update();
    m_WindowManager.DrawDisplay1();

    // t\
    gfx->m_DrawFramework->SwapBuffers();

    // ------------------------------------------------------------
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*---------------------------------------------------------------------------
  Desc: XChpbh̊mFʁiS̕\j

  Args: ps          pbhXeC^X
        raw         lp
        cal         ␳̒_p
        checksum    `FbNT

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void TestAnalogStick::DrawCheckAnalogStick(
        nn::hid::PadStatus ps,
        nn::hid::AnalogStickStatus* raw,
        nn::hid::CTR::AnalogStickCalData* cal,
        s16 checksum)
{
    /*
    s16 Rx = static_cast<s16>(raw->x);
    s16 Ry = static_cast<s16>(raw->y);
    s16 Cy = static_cast<s16>(RAWMAX/2);
    s16 Ky = static_cast<s16>((CALMAX-Cy) * nn::math::FSqrt(2.f));
    */

    // p[^EBhE
    m_InformationWindow->Gotoxy(0,0);
    m_InformationWindow->SetTitle("Information");
    m_InformationWindow->SetTextColor(ATTR_COLOR_WHITE);
    m_InformationWindow->Printf("PAD:(%5d,%5d)\n", ps.stick.x, ps.stick.y);
    m_InformationWindow->Printf("RAW:(%5d,%5d)\n", raw->x, raw->y);
    m_InformationWindow->Printf("CAL:(%5d,%5d)\n", cal->center_x, cal->center_y);
    m_InformationWindow->Printf("-------------------\n");

    ATTR_TEXT_COLOR fontColor[8];

    for(int i=0; i<8; ++i)
    {
        (checksum >> i & 0x01) ? fontColor[i] = ATTR_COLOR_CYAN :
                                 fontColor[i] = ATTR_COLOR_WHITE;
    }

    m_InformationWindow->SetTextColor(fontColor[0]);    m_InformationWindow->Printf("1.Y[%5d]<=%5d\n", raw->y, static_cast<s16>(CALMIN));
    m_InformationWindow->SetTextColor(fontColor[1]);    m_InformationWindow->Printf("2.X[%5d]>=%5d\n", raw->x, static_cast<s16>(CALMAX));
    m_InformationWindow->SetTextColor(fontColor[2]);    m_InformationWindow->Printf("3.Y[%5d]>=%5d\n", raw->y, static_cast<s16>(CALMAX));
    m_InformationWindow->SetTextColor(fontColor[3]);    m_InformationWindow->Printf("4.X[%5d]<=%5d\n", raw->x, static_cast<s16>(CALMIN));
    m_InformationWindow->SetTextColor(fontColor[4]);    m_InformationWindow->Printf("5.UR\n");
    m_InformationWindow->SetTextColor(fontColor[5]);    m_InformationWindow->Printf("6.DR\n");
    m_InformationWindow->SetTextColor(fontColor[6]);    m_InformationWindow->Printf("7.DL\n");
    m_InformationWindow->SetTextColor(fontColor[7]);    m_InformationWindow->Printf("8.UL\n");

    m_InformationWindow->SetTextColor(ATTR_COLOR_WHITE);
    m_InformationWindow->Printf("-------------------\n");
    m_InformationWindow->Printf("CheckSum = 0x%02X", m_CalCheckSum);

    // ------------------------------------------------------------
    //  `n
    // ------------------------------------------------------------
    // ʂɍWG\
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->BeginDrawingShape();

    // ------------------------------------------------------------
    //  t
    // ------------------------------------------------------------
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);

    // lyуLu[V̒S\
    DrawRawAndCalib(raw, cal);

    // XChpbh̕ϊW\
    DrawCross(&ps);

    gfx->m_DrawFramework->SwapBuffers();

    // ------------------------------------------------------------
    // t
    // ------------------------------------------------------------
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);

    // EBhEXV
    m_WindowManager.Update();
    m_WindowManager.DrawDisplay1();

    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}


/*---------------------------------------------------------------------------
  Desc: (Wrapper) ThreadSamplingRawData ̃bp[
---------------------------------------------------------------------------*/
void TestAnalogStick::WrappingThreadSamplingRawData(void* param)
{
    TestAnalogStick* pTas = reinterpret_cast< TestAnalogStick* >( param );
    pTas->ThreadSamplingRawData();
}

/*---------------------------------------------------------------------------
  Desc: (Thread) XChpbhl̍őŏlz[h
---------------------------------------------------------------------------*/
void TestAnalogStick::ThreadSamplingRawData()
{
    NN_LOG("@ Create Thread: ThreadSamplingRawData \n");

    m_IsSamplingRawDataFlag = true;

    nn::hid::AnalogStickCalibrator* pAsCal = new nn::hid::AnalogStickCalibrator();

    nn::hid::Pad& hidPad = nn::hid::GetPad();
    nn::fnd::TimeSpan timeout = nn::fnd::TimeSpan::FromMilliSeconds(8);


    while(m_IsSamplingRawDataFlag)
    {
        // XChpbh̐l擾
        pAsCal->ReadRaw(&m_AsStatusRaw);
        s16 Rx = m_AsStatusRaw.x;
        s16 Ry = m_AsStatusRaw.y;
        m_CalcX = static_cast<s16>(m_ScaleX * (Rx - m_CenterX) / 8);
        m_CalcY = static_cast<s16>(m_ScaleY * (Ry - m_CenterY) / 8);

        if(m_Update)
        {
            if(Rx > m_RawMaxX)   m_RawMaxX = Rx;
            if(Rx < m_RawMinX)   m_RawMinX = Rx;
            if(Ry > m_RawMaxY)   m_RawMaxY = Ry;
            if(Ry < m_RawMinY)   m_RawMinY = Ry;
        }

        if(!hidPad.WaitSampling(timeout))
        {
            NN_LOG("* Warning: Sampling Time Out! \n");
        }
    }

    delete pAsCal;

    NN_LOG("@ Exit Thread: ThreadSamplingRawData \n");
}

/*---------------------------------------------------------------------------
  Desc: XChpbh̐lTvOJn
---------------------------------------------------------------------------*/
void TestAnalogStick::StartSamplingRawData()
{
    const s32 SMPL_THREAD_STACK_SIZE = 4096;
    const s32 SMPL_THREAD_PRIORITY = 2;

    m_ThreadSmplRawData.StartUsingAutoStack(
        WrappingThreadSamplingRawData,
        this,
        SMPL_THREAD_STACK_SIZE,
        SMPL_THREAD_PRIORITY);
}

/*---------------------------------------------------------------------------
  Desc: XChpbh̐lTvO~
---------------------------------------------------------------------------*/
void TestAnalogStick::StopSamplingRawData()
{
    m_IsSamplingRawDataFlag = false;
    m_ThreadSmplRawData.Join();             // XbhI҂
    m_ThreadSmplRawData.Finalize();         // Xbhj
}


/*---------------------------------------------------------------------------
  Desc: oϐ NN_LOG ܂Ƃ߂֐
---------------------------------------------------------------------------*/
inline void TestAnalogStick::OutputNNLog(int scene, int i)
{
    switch(scene)
    {
    case 0:
        NN_LOG("Constant Check: \n");
        NN_LOG("  CALMAX = %f," , CALMAX);
        NN_LOG("  CALMIN = %f\n", CALMIN);
        NN_LOG("  DELTA_MAX = %f," , DELTA_MAX);
        NN_LOG("  DELTA_MIN = %f\n", DELTA_MIN);
        NN_LOG("  UNUSABLE_ZONE_MAX = %f," , UNUSABLE_ZONE_MAX);
        NN_LOG("  UNUSABLE_ZONE_MIN = %f\n", UNUSABLE_ZONE_MIN);
        NN_LOG("  VOLTAGE_MIN = %f\n", VOLTAGE_MIN);
        NN_LOG("Variable Check: \n");
        NN_LOG("  m_RawMaxX = %d," , m_RawMaxX);
        NN_LOG("  m_RawMinX = %d\n", m_RawMinX);
        NN_LOG("  m_UnusableZone_X_Max = %d," , m_UnusableZone_X_Max);
        NN_LOG("  m_UnusableZone_X_Min = %d\n", m_UnusableZone_X_Min);
    break;

    case 1:
        NN_LOG("Finish Calibrate:\n");
        NN_LOG("  X:Max:%d, Min:%d, Max-Min=%d\n", m_RawMaxX, m_RawMinX, m_RawMaxX - m_RawMinX);
        NN_LOG("  Y:Max:%d, Min:%d, Max-Min=%d " , m_RawMaxY, m_RawMinY, m_RawMaxY - m_RawMinY);
        NN_LOG("--> (%d, %d)\n", m_CenterX, m_CenterY);
        NN_LOG("  Xscale:%f\n", m_ScaleX);
        NN_LOG("  Yscale:%f\n", m_ScaleY);
        NN_LOG("  %d <= Unusable Zone(X) <= %d\n",m_UnusableZone_X_Min, m_UnusableZone_X_Max);
        NN_LOG("  %d <= Unusable Zone(Y) <= %d\n",m_UnusableZone_Y_Min, m_UnusableZone_Y_Max);
    break;

    case 2:
        NN_LOG("%d: RawFree :(%d, %d)", i, m_RawFreeX[i],  m_RawFreeY[i] );
        NN_LOG("    CalcFree:(%d, %d)\n",  m_CalcFreeX[i], m_CalcFreeY[i]);
    break;

    case 3:
        NN_LOG("Results:%s", m_TestResult);
    break;
    }
}

/*---------------------------------------------------------------------------
  Desc: f[^o͊֐
---------------------------------------------------------------------------*/
void TestAnalogStick::OutputData()
{
    // ------------------------------------------------------------
    //  DP1.5 p
    // ------------------------------------------------------------
    // p[^o͐
    const wchar_t* SLIDEPAD_SD_DIR          = L"sdmc:/uji/SlidePad";
    const wchar_t* SLIDEPAD_SD_PATH_DP_1_5  = L"sdmc:/uji/SlidePad/SlidePad_DP_2.csv";

    string line;
    string strMsgRawFree;
    string strMsgCalcFree;
    char strMsgMac[32]      = "";
    char strMsgRaw[32]      = "";
    char strMsgCalc[256]    = "";
    char strMsgCalcCheck[32]= "";
    char strMsgRslt[16]     = "";
    char strBreak[2]        = "\n";
    char strBuf[64]         = "";

    // MacAhX擾
    bit8 mac[6]={0,0,0,0,0,0};
    uji::sys::GetMacAddress(mac);

    sprintf(strMsgMac,  "%02X::%02X::%02X::%02X::%02X::%02X,", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    sprintf(strMsgRaw,  "%d,%d,%d,%d,", m_RawMaxX, m_RawMinX, m_RawMaxY, m_RawMinY);
    sprintf(strMsgCalc, "%d,%d,%f,%f,", m_CenterX, m_CenterY, m_ScaleX, m_ScaleY);
    sprintf(strMsgCalcCheck,  "%d,%d,%d,%d,", m_CalcCheckMaxX, m_CalcCheckMinX, m_CalcCheckMaxY, m_CalcCheckMinY);
    for(int i=1; i<5; ++i)
    {
        sprintf(strBuf, "%d,%d,", m_RawFreeX[i], m_RawFreeY[i]);
        strMsgRawFree += static_cast<string>(strBuf);
    }
    for(int i=1; i<5; ++i)
    {
        sprintf(strBuf, "%d,%d,", m_CalcFreeX[i], m_CalcFreeY[i]);
        strMsgCalcFree += static_cast<string>(strBuf);
    }
    sprintf(strMsgRslt, "%s", m_TestResult);

    line = static_cast<string>(strMsgMac)
         + static_cast<string>(strMsgRaw)
         + static_cast<string>(strMsgCalc)
         + static_cast<string>(strMsgCalcCheck)
         + strMsgRawFree
         + strMsgCalcFree
         + static_cast<string>(strMsgRslt)
         + static_cast<string>(strBreak);


    // SD ɏo
    #if OUTPUT_TO_SD
    CreateDirectorySdmc( SLIDEPAD_SD_DIR );
    WriteData2SD( SLIDEPAD_SD_PATH_DP_1_5, line );
    #endif

    NN_LOG("MacAddress: %s\n", strMsgMac);
    NN_LOG("Raw: Xmax:%4d, Xmin:%4d\n", m_RawMaxX, m_RawMinX);
    NN_LOG("Raw: Ymax:%4d, Ymin:%4d\n", m_RawMaxY, m_RawMinY);
    NN_LOG("Center(%4d, %4d)\n", m_CenterX, m_CenterY);
    NN_LOG("Scale(%f, %f)\n", m_ScaleX, m_ScaleY);

}

/*---------------------------------------------------------------------------
  Desc: b`kւ̏
---------------------------------------------------------------------------*/
s32 TestAnalogStick::ExecuteSetCalAnalogStick()
{
    using namespace nn::drivers::cal::CTR;

    enum ERROR_SEQ {
        PASS        =  0,
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };

    Calibration cal;
    AnalogStickCalDataCore   calDataCore;
    AnalogStickCalAppendCore calAppendCore;

    // CAL ̏
    cal.Initialize();

    // l̎擾
    if( !cal.Get(&calDataCore,  CAL_DATA_ANALOG_STICK))         { return ERROR_GET; }
    if( !cal.Get(&calAppendCore,CAL_DATA_ANALOG_STICK_APPEND))  { return ERROR_GET; }

    calDataCore.center_x    = s_CalDataCore.center_x;
    calDataCore.center_y    = s_CalDataCore.center_y;
#if NN_VERSION_REVISION==22048
//SDK 0.11 PEE
    calDataCore.in          = 0;
    calDataCore.out         = 0;
#else
//SDK 0.12 PEE
    for( int i=0; i<1; i++ ) calDataCore.reserve[i]=0;
#endif

    calAppendCore.scale_x   = s_CalAppendCore.scale_x;
    calAppendCore.scale_y   = s_CalAppendCore.scale_y;
    calAppendCore.max_x     = s_CalAppendCore.max_x;
    calAppendCore.min_x     = s_CalAppendCore.min_x;
    calAppendCore.max_y     = s_CalAppendCore.max_y;
    calAppendCore.min_y     = s_CalAppendCore.min_y;
    calAppendCore.type      = s_CalAppendCore.type;
    for( int i=0; i<3; i++ ) calAppendCore.reserve[i]=0;

    // l̐ݒ
    if( !cal.Set(&calDataCore,  CAL_DATA_ANALOG_STICK))         { return ERROR_SET; }
    if( !cal.Set(&calAppendCore,CAL_DATA_ANALOG_STICK_APPEND))  { return ERROR_SET; }

    // t@Cɕۑ
    if( !cal.Flush() )  { return ERROR_FLUSH; }

    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: XChpbhvO
---------------------------------------------------------------------------*/
bool TestAnalogStick::ExecuteTestAnalogStick()
{
    bool blResults = false;
    s16 ng_major = 30;
    s16 ng_minor = 0;
    s16 ng_micro = 0;
    nn::Result result;

    char strWarningMsg[50] = "";

    nn::os::Tick start   = nn::os::Tick(0);
    nn::os::Tick current = nn::os::Tick(0);
    const s64 __TIMEOUT  = 10000;
    const s64 __SPECIAL_TIMEOUT  = 60000;

    #if ANALOGSTICK_DEBUG_FLAG
    // Oo
    NN_LOG("----------------------------------------------------\n");
    OutputNNLog(0, 0);
    NN_LOG("----------------------------------------------------\n");
    #endif

    uji::sys::Pad pad;

    // 
    InitializeCommon();

    int loop = 0;

    // lTvOXbhN
    m_Update = true;
    StartSamplingRawData();


    nn::hid::AnalogStickCalibrator* pAsCal = new nn::hid::AnalogStickCalibrator();
    nn::hid::CTR::AnalogStickCalData asCalData;
    pAsCal->StartCalibration();


    while(true)
    {
        pad.UpdatePad();

        // ʂ`
        SetInformationWindow();
        DrawTestAnalogStick();

        switch(m_ModeId)
        {
        // ------------------------------------------------------------
        //  ̎񐔃XChpbh]čőŏl߂
        // ------------------------------------------------------------
        case OUT_PARAM_SAMPLING:

            if(m_ModeSubId%2==1)
            {
                //
                // *1 ㉺E臒l𒴂Ă邱

                // 
                if(start == nn::os::Tick(0))
                {
                    m_IsOutParamValid = 0;
                    start = nn::os::Tick::GetSystemCurrent();
                }
                // 
                m_IsOutParamValid += IsOutParamValid(m_AsStatusRaw.x, m_AsStatusRaw.y, m_ModeSubId);
                // ^CAEg
                current = nn::os::Tick::GetSystemCurrent();
                if((current-start).ToTimeSpan().GetMilliSeconds() > __TIMEOUT)
                {
                    sprintf(strWarningMsg, "* Warning: TimeOut!!(IsOutParamValid)");
                    ng_minor = m_ModeId;
                    ng_micro = m_ModeSubId;
                    m_ModeId = TEST_ERROR;
                    break;
                }
                // I
                if(m_IsOutParamValid > 50)
                {
                    ++m_ModeSubId;
                    start = nn::os::Tick(0);
                }
            }
            else
            {
                //
                // *2 ΂ߕ̃G~[g͂邱

                // 
                if(start == nn::os::Tick(0))
                {
                    m_IsInButtonDiagonal = 0;
                    start = nn::os::Tick::GetSystemCurrent();
                }
                // 
                m_IsInButtonDiagonal += IsInButtonDiagonal(m_ModeSubId);
                // ^CAEg
                current = nn::os::Tick::GetSystemCurrent();
                if( (current-start).ToTimeSpan().GetMilliSeconds() > __TIMEOUT )
                {
                    sprintf(strWarningMsg, "* Warning: TimeOut!!(IsInButtonDiagonal)");
                    ng_minor = m_ModeId;
                    ng_micro = m_ModeSubId;
                    m_ModeId = TEST_ERROR;
                    break;
                }
                // I
                if(m_IsInButtonDiagonal > 5)
                {
                    ++m_ModeSubId;
                    start = nn::os::Tick(0);
                }
            }

            // Lu[V[hɈڍs
            if(m_ModeSubId>=MODE_SUB_ID_MAX)
            {
                if(++loop>=SAMPLING_LOOP_NUM)
                {
                    loop=0;
                    m_ModeId = CALIBRATION;
                }
                m_ModeSubId=1;
            }
            break;

        // ------------------------------------------------------------
        //  Lu[Vyяo͕
        // ------------------------------------------------------------
        case CALIBRATION:

            // őŏl̍XVI
            m_Update = false;
            StopSamplingRawData();

            // Lu[VI
            result = pAsCal->StopCalibration(true);
            if(result.IsFailure())
            {
                NN_LOG("* Warning: Fail to Stop Calibration! \n");
            }

            pAsCal->GetCalibrateParam(&asCalData);

            if(asCalData.center_x != (m_RawMaxX + m_RawMinX) >> 1)
            {
                NN_LOG("* Warning: asCalData.center_x != (m_RawMaxX + m_RawMinX) >> 1\n");
            }
            if(asCalData.center_y != (m_RawMaxY + m_RawMinY) >> 1)
            {
                NN_LOG("* Warning: asCalData.center_y != (m_RawMaxY + m_RawMinY) >> 1\n");
            }
            if(asCalData.scale_x != RANGE / (m_RawMaxX - m_RawMinX))
            {
                NN_LOG("* Warning: asCalData.scale_x != RANGE / (m_RawMaxX - m_RawMinX)\n");
            }
            if(asCalData.scale_y != RANGE / (m_RawMaxY - m_RawMinY))
            {
                NN_LOG("* Warning: asCalData.scale_y != RANGE / (m_RawMaxY - m_RawMinY)\n");
            }

            m_CenterX = asCalData.center_x;
            m_CenterY = asCalData.center_y;
            m_ScaleX  = asCalData.scale_x;
            m_ScaleY  = asCalData.scale_y;

            #if ANALOGSTICK_DEBUG_FLAG
            NN_LOG("----------------------------------------------------\n");
            OutputNNLog(1, 0);
            NN_LOG("----------------------------------------------------\n");
            #endif

            //
            // *3 o͕60%𒴂Ă邱

            // 
            m_IsOver60Volts = (((m_RawMaxX - m_RawMinX > VOLTAGE_MIN) &&
                                (m_RawMaxY - m_RawMinY > VOLTAGE_MIN)) ? 1 : 0);
            if( m_IsOver60Volts==0 )
            {
                // do͕XybN𖞂Ȃ
                sprintf(strWarningMsg, "* Warning: Voltage is low level!!");
                ng_minor = m_ModeId;
                ng_micro = 0;
                m_ModeId = TEST_ERROR;
                break;
            }

            //
            // *4 m_CenterX,m_CenterY ̒l RAWMAX * (50%}6.5%) ͈͓̔ł邱

            // 
            m_IsInRange = ((m_CenterX > DELTA_MIN && m_CenterX < DELTA_MAX &&
                            m_CenterY > DELTA_MIN && m_CenterY < DELTA_MAX) ? 1 : 0);
            if( m_IsInRange==0 )
            {
                // ␳̒SlXybNOĂ
                sprintf(strWarningMsg, "* Warning: CAL Center is Out of Spec!!");
                ng_minor = m_ModeId;
                ng_micro = 1;
                m_ModeId = TEST_ERROR;
                break;
            }

            // őŏlmF[hɈڍs
            {
                m_ModeId = OUT_PARAM_CHECK;
                m_WasSampledFlag = SAMPLING_COMPLETION;

                // lTvOXbhĊJ
                StartSamplingRawData();
            }
            break;

        // ------------------------------------------------------------
        //  XChpbhXe[^Xōőŏl擾ł邩mF
        // ------------------------------------------------------------
        case OUT_PARAM_CHECK:

            if(m_ModeSubId%2==1)
            {
                //
                // *5 *1Ƃقړl

                // 
                if(start == nn::os::Tick(0))
                {
                    m_IsOutParamValid = 0;
                    start = nn::os::Tick::GetSystemCurrent();
                }
                // 
                m_IsOutParamValid += IsOutParamValidStringentCriterion(m_CalcX, m_CalcY, m_ModeSubId);
                // ^CAEg
                current = nn::os::Tick::GetSystemCurrent();
                if((current-start).ToTimeSpan().GetMilliSeconds() > __TIMEOUT)
                {
                    sprintf(strWarningMsg, "* Warning: TimeOut!!(IsOutParamValid)");
                    ng_minor = m_ModeId;
                    ng_micro = m_ModeSubId;
                    m_ModeId = TEST_ERROR;
                    break;
                }
                // I
                if(m_IsOutParamValid > 10)
                {
                    ++m_ModeSubId;
                    start = nn::os::Tick(0);
                }
            }
            else
            {
                //
                // *6 *2Ɠl

                // 
                if(start == nn::os::Tick(0))
                {
                    m_IsInButtonDiagonal = 0;
                    start = nn::os::Tick::GetSystemCurrent();
                }
                // 
                m_IsInButtonDiagonal += IsInButtonDiagonal(m_ModeSubId);
                // ^CAEg
                current = nn::os::Tick::GetSystemCurrent();
                if( (current-start).ToTimeSpan().GetMilliSeconds() > __TIMEOUT )
                {
                    sprintf(strWarningMsg, "* Warning: TimeOut!!(IsInButtonDiagonal)");
                    ng_minor = m_ModeId;
                    ng_micro = m_ModeSubId;
                    m_ModeId = TEST_ERROR;
                    break;
                }
                // I
                if(m_IsInButtonDiagonal > 5)
                {
                    ++m_ModeSubId;
                    start = nn::os::Tick(0);
                }
            }

            // Z^[A\[hɈڍs
            if(m_ModeSubId>=MODE_SUB_ID_MAX)
            {
                m_ModeId = IN_PARAM_CHECK;
                m_ModeSubId=0;  // Z^[A\Jn̓pbhZ^[ɖ߂
            }
            break;

        // ------------------------------------------------------------
        //  Z^[A\isьj
        // ------------------------------------------------------------
        case IN_PARAM_CHECK:

            // Z^[A̐lyѕϊl
            m_RawFreeX[loop] = m_AsStatusRaw.x;
            m_RawFreeY[loop] = m_AsStatusRaw.y;
            m_CalcFreeX[loop] = static_cast<s16>(m_ScaleX * (m_RawFreeX[loop] - m_CenterX) / 8);
            m_CalcFreeY[loop] = static_cast<s16>(m_ScaleY * (m_RawFreeY[loop] - m_CenterY) / 8);

            if(m_ModeSubId==0)
            {
                // UXChpbh̓͂Z^[i͏ԁjɖ߂
                if(pad.IsButtonDown(Pad::BUTTON_A) &&
                   IsInParamValid(m_CalcFreeX[loop], m_CalcFreeY[loop])==1)
                {
                    ++m_ModeSubId;
                    ++loop;
                }
            }
            else if(m_ModeSubId%2==1)
            {
                //
                // *7 臒l̓͂邱

                // 
                if(start == nn::os::Tick(0))
                {
                    m_IsSpecialParamValid = 0;
                    start = nn::os::Tick::GetSystemCurrent();
                }
                // 
                m_IsSpecialParamValid += IsSpecialParamValid(m_CalcX, m_CalcY, m_ModeSubId);
                // ^CAEg
                current = nn::os::Tick::GetSystemCurrent();
                if( (current-start).ToTimeSpan().GetMilliSeconds() > __SPECIAL_TIMEOUT )
                {
                    sprintf(strWarningMsg, "* Warning: TimeOut!!(IsSpecialParamValid)");
                    ng_minor = m_ModeId;
                    ng_micro = m_ModeSubId;
                    m_ModeId = TEST_ERROR;
                    break;
                }
                // I
                if(m_IsSpecialParamValid > 50)  // ͈҂
                {
                    ++m_ModeSubId;
                    start = nn::os::Tick(0);
                }
            }
            else
            {
                //
                // *8 ͎ɕsї̈ɓĂ邱

                // 
                if(start == nn::os::Tick(0))
                {
                    m_IsInParamValid = 0;
                    start = nn::os::Tick::GetSystemCurrent();
                }
                // 
                if(pad.IsButtonDown(Pad::BUTTON_A))
                {
                    m_IsInParamValid += IsInParamValid(m_CalcFreeX[loop], m_CalcFreeY[loop]);
                    if( m_IsInParamValid==0 )
                    {
                        sprintf(strWarningMsg, "* Warning: Out of unusable zone!"
                                               "(%d, %d)", m_RawFreeX[loop], m_RawFreeY[loop]);
                        ng_minor = m_ModeId;
                        ng_micro = m_ModeSubId;
                        m_ModeId = TEST_ERROR;
                        break;
                    }
                    ++loop;
                }
                // ^CAEg
                current = nn::os::Tick::GetSystemCurrent();
                if( (current-start).ToTimeSpan().GetMilliSeconds() > __TIMEOUT )
                {
                    sprintf(strWarningMsg, "* Warning: TimeOut!!(IsSpecialParamValid)");
                    ng_minor = m_ModeId;
                    ng_micro = m_ModeSubId;
                    m_ModeId = TEST_ERROR;
                    break;
                }
                // I
                if(m_IsInParamValid > 0)
                {
                    ++m_ModeSubId;
                    start = nn::os::Tick(0);
                }
            }

            // io`rrj
            if(m_ModeSubId>=MODE_SUB_ID_MAX)
            {
                m_ModeId = TEST_PASS;
                m_ModeSubId = 1;
                loop = 0;
            }
            break;

        // ------------------------------------------------------------
        //  NG
        // ------------------------------------------------------------
        case TEST_ERROR:

            blResults = false;
            sprintf(m_TestResult, "%02d-%03d-%03d", ng_major, ng_minor, ng_micro);
            goto Finalize;

        // ------------------------------------------------------------
        //  OK
        // ------------------------------------------------------------
        case TEST_PASS:

            blResults = true;
            sprintf(m_TestResult, "PASS");
            goto Finalize;
        }
    }


Finalize:

    if(m_IsSamplingRawDataFlag)
    {
        StopSamplingRawData();
    }
    OutputData();

    #if ANALOGSTICK_DEBUG_FLAG
    // Oo
    NN_LOG("----------------------------------------------------\n");
    for(int i=1; i<5; ++i)
    {
        OutputNNLog(2, i);
    }
    OutputNNLog(3, 0);
    if(blResults)
    {
        NN_LOG("\n");
    }
    else
    {
        NN_LOG(" :%s\n", strWarningMsg);
    }
    NN_LOG("----------------------------------------------------\n");
    #endif

    // CAL
    s_CalDataCore.center_x      = m_CenterX;
    s_CalDataCore.center_y      = m_CenterY;
#if NN_VERSION_REVISION==22048
    s_CalDataCore.in            = 0;
    s_CalDataCore.out           = 0;
#else
    for( int i=0; i<1; i++ ) s_CalDataCore.reserve[i]=0;
#endif

    s_CalAppendCore.scale_x     = m_ScaleX;
    s_CalAppendCore.scale_y     = m_ScaleY;
    s_CalAppendCore.max_x       = m_RawMaxX;
    s_CalAppendCore.min_x       = m_RawMinX;
    s_CalAppendCore.max_y       = m_RawMaxY;
    s_CalAppendCore.min_y       = m_RawMinY;
    s_CalAppendCore.type        = m_Type;
    for( int i=0; i<3; i++ ) s_CalAppendCore.reserve[i]=0;


    // I
    FinalizeCommon();

    return blResults;

}

/*---------------------------------------------------------------------------
  Desc: XChpbh̓mFiXbhgpŁj
---------------------------------------------------------------------------*/
void TestAnalogStick::ExecuteCheckAnalogStick()
{
    nn::Result result;

    uji::sys::Pad pad;
    nn::hid::PadReader padReader;
    nn::hid::PadStatus padStatus;

    // 
    InitializeCommon();

#if CLAMP_MODE_CIRCLE
    //~`Nv
    nn::hid::PadReader::StickClampMode clampMode = padReader.STICK_CLAMP_MODE_CIRCLE;
    int clampMin = nn::hid::CTR::MIN_OF_STICK_CLAMP_MODE_CIRCLE;
    int clampMax = nn::hid::CTR::LIMIT_OF_STICK_CLAMP_MAX;
#else
#if CLAMP_MODE_CROSS
    //\Nv
    nn::hid::PadReader::StickClampMode clampMode = padReader.STICK_CLAMP_MODE_CROSS;
    int clampMin = nn::hid::CTR::MIN_OF_STICK_CLAMP_MODE_CROSS;
    int clampMax = nn::hid::CTR::LIMIT_OF_STICK_CLAMP_MAX;
#endif
#endif
    padReader.SetStickClampMode(clampMode);
    padReader.SetStickClamp(clampMin, clampMax);

    nn::hid::AnalogStickCalibrator* pAsCal = new nn::hid::AnalogStickCalibrator();
    nn::hid::AnalogStickStatus* pAsStatusRaw = new nn::hid::AnalogStickStatus;
    nn::hid::CTR::AnalogStickCalData* pAsCalData = new nn::hid::CTR::AnalogStickCalData;

    m_CalCheckSum = 0x00;

    s16 loopcounter=0;
    s16 i=0;

    pAsCal->GetCalibrateParam(pAsCalData);

    do
    {
        ++loopcounter;

        pad.UpdatePad();

        // ------------------------------------------------------------
        //  LuJn
        // ------------------------------------------------------------
        if(m_CalCheckSum==0x0)
        {
            pAsCal->StartCalibration();
        }

        // XChpbh̕ϊW擾i1j
        if(!padReader.ReadLatest(&padStatus))
        {
            NN_LOG("%d:%d\n", ++i, loopcounter );
        }

        // XChpbh̐l擾
        pAsCal->ReadRaw(pAsStatusRaw);
        s16 Rx = static_cast<s16>(pAsStatusRaw->x);
        s16 Ry = static_cast<s16>(pAsStatusRaw->y);

        // Lu`FbN
        s16 resetCheckSum = 0;
        s16 Cy = static_cast<s16>(RAWMAX/2);
        bool blUR = (pad.IsButtonPress(Pad::BUTTON_EMULATION_UP) &&
                     pad.IsButtonPress(Pad::BUTTON_EMULATION_RIGHT));
        bool blDR = (pad.IsButtonPress(Pad::BUTTON_EMULATION_DOWN) &&
                     pad.IsButtonPress(Pad::BUTTON_EMULATION_RIGHT));
        bool blDL = (pad.IsButtonPress(Pad::BUTTON_EMULATION_DOWN) &&
                     pad.IsButtonPress(Pad::BUTTON_EMULATION_LEFT));
        bool blUL = (pad.IsButtonPress(Pad::BUTTON_EMULATION_UP) &&
                     pad.IsButtonPress(Pad::BUTTON_EMULATION_LEFT));

        if(Ry >= CALMAX)    {   resetCheckSum |= 0x01;      m_CalCheckSum |= 0x01;  }
        if(Rx >= CALMAX)    {   resetCheckSum |= 0x02;      m_CalCheckSum |= 0x02;  }
        if(Ry <= CALMIN)    {   resetCheckSum |= 0x04;      m_CalCheckSum |= 0x04;  }
        if(Rx <= CALMIN)    {   resetCheckSum |= 0x08;      m_CalCheckSum |= 0x08;  }
        if(blUR)            {   resetCheckSum |= 0x10;      m_CalCheckSum |= 0x10;  }
        if(blDR)            {   resetCheckSum |= 0x20;      m_CalCheckSum |= 0x20;  }
        if(blDL)            {   resetCheckSum |= 0x40;      m_CalCheckSum |= 0x40;  }
        if(blUL)            {   resetCheckSum |= 0x80;      m_CalCheckSum |= 0x80;  }

        // ------------------------------------------------------------
        //  LuI
        // ------------------------------------------------------------
        if( m_CalCheckSum == 0xFF )
        {
            result = pAsCal->StopCalibration(false);
            pAsCal->GetCalibrateParam(pAsCalData);
            NN_LOG("center(raw) = (%d, %d)\n", pAsCalData->center_x, pAsCalData->center_y);

            // `FbNT
            m_CalCheckSum = 0x00;
        }

        // ʕ`
        DrawCheckAnalogStick(padStatus, pAsStatusRaw, pAsCalData, resetCheckSum);

    }while(!pad.IsButtonDown(Pad::BUTTON_B));

    delete pAsCalData;
    delete pAsStatusRaw;
    delete pAsCal;

    // I
    FinalizeCommon();
}

/*
  Desc: XChpbh̓eXg
*/
bool TestCalAnalogStick(seq::TestResult &result)
{
    TestAnalogStick* p = new TestAnalogStick;

    result.m_Result = p->ExecuteTestAnalogStick();

    delete p;

    return result.m_Result;
}


/*
  Desc: XChpbhb`k
*/
bool SetCalAnalogStick(seq::TestResult &result)
{
    TestAnalogStick* p = new TestAnalogStick;

    if( p->ExecuteSetCalAnalogStick()<0 )
    {
        result.m_Result = false;

        switch( p->ExecuteSetCalAnalogStick() )
        {
        case -1: sprintf(result.m_String, "Fail to get CAL.");
        case -2: sprintf(result.m_String, "Fail to set CAL.");
        case -3: sprintf(result.m_String, "Fail to flush CAL.");
        }
    }
    else
    {
        result.m_Result = true;
    }

    delete p;

    return result.m_Result;
}


} // namespace eva
} // namespace uji
