/*--------------------------------------------------------------------------*
 Project:
 File: LytAnalogStick.h


*--------------------------------------------------------------------------*/
#ifndef LYTANALOGSTICK_H_INCLUDED
#define LYTANALOGSTICK_H_INCLUDED

#include <nw/lyt.h>
#include <nw/ut/ut_MoveArray.h>

#include "sys.h"
#include "ModeAnalogStick.h"

using namespace std;
using namespace uji::sys;
using namespace nn::math;

namespace uji {
namespace eva {

/*
  EXChpbh̃Lu[VɁAKChAj[V\
  E͒l𖞂ꍇɁAyCtH[JXꂽƂ݂Ȃ
*/
static const int MAX_PANE_NUM_ANALOGSTICK = 34;  // yC

// {^Aj[Vԍ
typedef enum {
    PANE_ANIM_DEFAULT,   // ʏ
    PANE_ANIM_ROTATE,    // ]
    PANE_ANIM_VISIBLE,   // 
    PANE_ANIM_INVISIBLE  // s
} PaneAnimation;

//===========================================================================
//===========================================================================
//   yCNX
//===========================================================================
//===========================================================================
class PaneAnalogStick
{
public:
    // RXgN^EfXgN^
    PaneAnalogStick(char* paneName, bit32 paneBit)
    : m_PaneName(paneName), m_PaneBit(paneBit), m_PaneAnim(PANE_ANIM_DEFAULT)
    {}
    virtual ~PaneAnalogStick(){}

    // yC̎擾
    char* GetPaneName() { return m_PaneName; }
    // yC`̎擾
    bit32 GetPaneBit()  { return m_PaneBit; }

    // Aj[Vԍ̐ݒE擾
    void SetPaneAnimation(PaneAnimation pane_anim)
    {
        m_PaneAnim = pane_anim;
    }
    PaneAnimation GetPaneAnimation()
    {
        return m_PaneAnim;
    }

private:
    char*           m_PaneName;     // yC
    bit32           m_PaneBit;      // yC`
    PaneAnimation   m_PaneAnim;     // Aj[Vԍ

};
//===========================================================================
//===========================================================================


// Œ蒷̔zNXƂă{^`
typedef nw::ut::FixedSizeArray<PaneAnalogStick*, MAX_PANE_NUM_ANALOGSTICK> PaneArray;

//===========================================================================
//===========================================================================
//   CAEgNX
//===========================================================================
//===========================================================================
class LytAnalogStick
{
    friend class CalAnalogStick;

    enum PaneNumAnalogStick
    {
        GUIDE_ARROW =  0,
        CIRCLE01    =  1,
        CIRCLE02    =  2,
        CIRCLE03    =  3,
        CIRCLE04    =  4,
        CIRCLE05    =  5,
        CIRCLE06    =  6,
        CIRCLE07    =  7,
        CIRCLE08    =  8,
        CIRCLE09    =  9,
        CIRCLE10    = 10,
        CIRCLE11    = 11,
        CIRCLE12    = 12,
        FRAME       = 13,
        BLOCK01     = 14,
        BLOCK02     = 15,
        BLOCK03     = 16,
        BLOCK04     = 17,
        BLOCK05     = 18,
        BLOCK06     = 19,
        BLOCK07     = 20,
        BLOCK08     = 21,
        BLOCK09     = 22,
        BLOCK10     = 23,
        BLOCK11     = 24,
        BLOCK12     = 25,
        BLOCK13     = 26,
        BLOCK14     = 27,
        BLOCK15     = 28,
        BLOCK16     = 29,
        BLOCK17     = 30,
        BLOCK18     = 31,
        BLOCK19     = 32,
        BLOCK20     = 33,

        MAX_PANE_NUM= 34    // ̒lύX MAX_PANE_NUM_ANALOGSTICK ύX邱
    };

public:
    LytAnalogStick()
     :
       m_zDegree(0.f), m_Progress(0.f)
    {}
    virtual ~LytAnalogStick(){}

private:
    uji::sys::DemoAllocator             memAllocator;
    uji::sys::DemoDeviceMemoryAllocator devMemAllocator;

    nw::lyt::Group*                 m_pGroup_Arrow;
    nw::lyt::Group*                 m_pGroup_Circle;
    nw::lyt::Group*                 m_pGroup_Progress;

    nw::lyt::Layout*                m_pLayout;
    nw::lyt::ArcResourceAccessor*   m_pResAccessor;
    nw::lyt::DrawInfo               m_DrawInfo;
    nw::lyt::GraphicsResource       m_GraphicsResource;
    nw::lyt::Drawer                 m_Drawer;

    PaneArray m_PaneArray;

    f32 m_zDegree;
    f32 m_Progress;

private:
    nw::ut::MoveArray<u8> LoadFile(nw::os::IAllocator* allocator, const wchar_t* filePath, u32 align = 32);

    void InitializePaneArray();
    void InitializeLayoutResource();
    void FinalizeLayoutResource();
    void Initialize();
    void Finalize();

    // yC̃Aj[Vԍ̎擾Eݒ
    PaneAnimation GetPaneAnimation(nw::lyt::Pane* pPane);
    void SetPaneAnimation(nw::lyt::Pane* pPane, PaneAnimation keyAnim);

    // L[͂yC̃Aj[Vݒ
    void SetPaneInputAnimation( AnalogStickTestMode mode );

    // wyC̃Aj[VXV
    void UpdateAnimationFrame(nw::lyt::Pane* pPane);

    // O[ṽyCXV
    void UpdatePane(nw::lyt::Group* pGroup);

    //
    void UpdateLayout( AnalogStickTestMode mode );

    // sN`yC̒_J[̐ؑ
    void ColorYellow( nw::lyt::Pane* pPane );
    void ColorAqua( nw::lyt::Pane* pPane );
    void ColorLimeGreen( nw::lyt::Pane* pPane );
    void ColorGray( nw::lyt::Pane* pPane );

    // 萔
    static const f32 CLOCKWISE            = -1.f;              // v
    static const f32 COUNTER_CLOCKWISE    = -1 * CLOCKWISE;    // v
    static const f32 ROTATION_DIRECTION   = CLOCKWISE;         // ]
};
//===========================================================================
//===========================================================================

}
}

#endif  // LYTANALOGSTICK_H_INCLUDED

