
#include "LytAnalogStick.h"
//#include "../seq/TestSequencer.h" 

//using namespace uji;
//using namespace uji::sys;
//using namespace nn::math;


namespace uji {
namespace eva {

typedef nw::ut::MoveArray<u8> moveArrayFile;
#define TEST_SLIDEPAD_FILE_PATH(name) (L"rom:/" name)

//===========================================================================
//===========================================================================
//                            For LayoutEditor
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: fr[sƎˉesݒ肵܂

  Args: drawInfo    - `
        layout      - CAEg

  Rtns: Ȃ
---------------------------------------------------------------------------*/
extern void SetupCamera(nw::lyt::DrawInfo& drawInfo, const nw::lyt::Layout& layout);

/*---------------------------------------------------------------------------
  Desc: AnimationLink܂
        w肵Aj[V\[XyC}eAɃoChĂ
        nw::lyt::AnimationLink AŏɌ̂Ԃ܂B
        w肳ꂽyC̎q܂߂Č܂B

  Args: pPane   - Ώۂ̃[gƂȂyCł
        animRes - Aj[V\[X

  Rtns: ꍇ́Anw::lyt::AnimationLink ̃|C^Ԃ܂B
        Ȃꍇ́ANULL Ԃ܂B
---------------------------------------------------------------------------*/ 
extern nw::lyt::AnimationLink* FindLayoutAnimationLink(nw::lyt::Pane* pPane, const nw::lyt::AnimResource& animRes);

/*---------------------------------------------------------------------------
  Desc: Aj[V\[X̃t[lݒ肵܂
        w肵Aj[V\[X݂̌̃t[lSēɐݒ肵܂B
        w肳ꂽyC̎q܂߂čs܂B

  Args: pPane   - ΏۂƂȂyC̃[gƂȂyC
        animRes - Aj[V\[X
        frame   - ݒ肷t[l

  Rtns: Ȃ
---------------------------------------------------------------------------*/
extern void SetAnimationFrame(nw::lyt::Pane* pPane, const nw::lyt::AnimResource& animRes, f32 frame);

/*---------------------------------------------------------------------------
  Desc: t@C[h܂

  Args: allocator - AP[^ł
        filePath  - t@CpXł
        align     - ACgł
        
  Rtns: [ht@C̃obt@Ԃ܂
---------------------------------------------------------------------------*/  
nw::ut::MoveArray<u8> LytAnalogStick::LoadFile(
    nw::os::IAllocator* allocator,
    const wchar_t* filePath,
    u32 align /* = 32 */
)
{
    nn::fs::FileReader fileReader;

  #ifdef NW_PLATFORM_CTR
    nn::Result nnResult = fileReader.TryInitialize(filePath);
    if (nnResult.IsFailure())
    {
        return nw::ut::MoveArray<u8>();
    }
  #else
    fileReader.Initialize(filePath);
  #endif
    s32 fileSize = static_cast<s32>(fileReader.GetSize());

    void* memory = allocator->Alloc(fileSize, static_cast<u8>(align));
    nw::ut::MoveArray<u8> buffer(memory, fileSize, allocator);
    buffer.resize(fileSize);

    fileReader.Read(&buffer.front(), fileSize);

    fileReader.Finalize();

    // ReiԂĂ܂Aobt@̓Rs[܂B
    // Lړ܂B
    return buffer;
}

/*---------------------------------------------------------------------------
  Desc: CAEg\[X̏
---------------------------------------------------------------------------*/  
void LytAnalogStick::InitializeLayoutResource()
{
    nw::lyt::Initialize(&memAllocator, &devMemAllocator);
    
    m_pLayout = new nw::lyt::Layout();

    // CAEg̃oCi\[X(A[JCu)ǂݍ݁B
    moveArrayFile fileLayout = LoadFile(
        &devMemAllocator, TEST_SLIDEPAD_FILE_PATH(L"slidepad/slidepad.arc"), 128);
    if (fileLayout.empty())
    {
        NW_FATAL_ERROR("can not open layout archive.\n");
    }
    
    // oCi\[X̃[gfBNgw肵ă\[XANZT𐶐B
    m_pResAccessor = new nw::lyt::ArcResourceAccessor;
    if (!m_pResAccessor->Attach(fileLayout.begin(), "."))
    {
        NW_FATAL_ERROR("can not attach layout archive.\n");
    }

    // CAEg\[X̓ǂݍ
    {
        const void* lytRes = m_pResAccessor->GetResource(0, "slidepad.bclyt");
        NW_NULL_ASSERT(lytRes);
        m_pLayout->Build(lytRes, m_pResAccessor);
    }
    
    // O[oȃ\[Xt@Cǂݍ݂܂B
    {
        m_GraphicsResource.StartSetup();
        const wchar_t* resourcePath = 0;
        for (int i = 0;
             (resourcePath = m_GraphicsResource.GetResourcePath(i)) != NULL;
             ++i)
        {
            moveArrayFile file = LoadFile(&memAllocator, resourcePath);

            if (file.empty())
            {
                NW_FATAL_ERROR("can not open lyt resource file.");
            }

            m_GraphicsResource.SetResource(i, file.begin(), file.size(), false);
        }
        m_GraphicsResource.FinishSetup();
    }

    m_DrawInfo.SetGraphicsResource(&m_GraphicsResource);
}

/*---------------------------------------------------------------------------
  Desc: {^z̏
---------------------------------------------------------------------------*/
void LytAnalogStick::InitializePaneArray()
{
    m_PaneArray.PushBack(new PaneAnalogStick("guide_arrow", GUIDE_ARROW));
    m_PaneArray.PushBack(new PaneAnalogStick("circle01",    CIRCLE01));
    m_PaneArray.PushBack(new PaneAnalogStick("circle02",    CIRCLE02));
    m_PaneArray.PushBack(new PaneAnalogStick("circle03",    CIRCLE03));
    m_PaneArray.PushBack(new PaneAnalogStick("circle04",    CIRCLE04));
    m_PaneArray.PushBack(new PaneAnalogStick("circle05",    CIRCLE05));
    m_PaneArray.PushBack(new PaneAnalogStick("circle06",    CIRCLE06));
    m_PaneArray.PushBack(new PaneAnalogStick("circle07",    CIRCLE07));
    m_PaneArray.PushBack(new PaneAnalogStick("circle08",    CIRCLE08));
    m_PaneArray.PushBack(new PaneAnalogStick("circle09",    CIRCLE09));
    m_PaneArray.PushBack(new PaneAnalogStick("circle10",    CIRCLE10));
    m_PaneArray.PushBack(new PaneAnalogStick("circle11",    CIRCLE11));
    m_PaneArray.PushBack(new PaneAnalogStick("circle12",    CIRCLE12));
    m_PaneArray.PushBack(new PaneAnalogStick("frame",       FRAME));
    m_PaneArray.PushBack(new PaneAnalogStick("block01",     BLOCK01));
    m_PaneArray.PushBack(new PaneAnalogStick("block02",     BLOCK02));
    m_PaneArray.PushBack(new PaneAnalogStick("block03",     BLOCK03));
    m_PaneArray.PushBack(new PaneAnalogStick("block04",     BLOCK04));
    m_PaneArray.PushBack(new PaneAnalogStick("block05",     BLOCK05));
    m_PaneArray.PushBack(new PaneAnalogStick("block06",     BLOCK06));
    m_PaneArray.PushBack(new PaneAnalogStick("block07",     BLOCK07));
    m_PaneArray.PushBack(new PaneAnalogStick("block08",     BLOCK08));
    m_PaneArray.PushBack(new PaneAnalogStick("block09",     BLOCK09));
    m_PaneArray.PushBack(new PaneAnalogStick("block10",     BLOCK10));
    m_PaneArray.PushBack(new PaneAnalogStick("block11",     BLOCK11));
    m_PaneArray.PushBack(new PaneAnalogStick("block12",     BLOCK12));
    m_PaneArray.PushBack(new PaneAnalogStick("block13",     BLOCK13));
    m_PaneArray.PushBack(new PaneAnalogStick("block14",     BLOCK14));
    m_PaneArray.PushBack(new PaneAnalogStick("block15",     BLOCK15));
    m_PaneArray.PushBack(new PaneAnalogStick("block16",     BLOCK16));
    m_PaneArray.PushBack(new PaneAnalogStick("block17",     BLOCK17));
    m_PaneArray.PushBack(new PaneAnalogStick("block18",     BLOCK18));
    m_PaneArray.PushBack(new PaneAnalogStick("block19",     BLOCK19));
    m_PaneArray.PushBack(new PaneAnalogStick("block20",     BLOCK20));
}

/*---------------------------------------------------------------------------
  Desc: CAEg\[X̏I
---------------------------------------------------------------------------*/  
void LytAnalogStick::FinalizeLayoutResource()
{
    m_GraphicsResource.Finalize();
    
    delete m_pLayout;
    delete m_pResAccessor;
}

/*---------------------------------------------------------------------------
  Desc: ܂Ƃ
---------------------------------------------------------------------------*/  
void LytAnalogStick::Initialize()
{
    InitializeLayoutResource();
    InitializePaneArray();
    
    // sN`yCo^ĂO[ṽ|C^擾܂B
    m_pGroup_Arrow    = m_pLayout->GetGroupContainer()->FindGroupByName("Group_Arrow");
    m_pGroup_Circle   = m_pLayout->GetGroupContainer()->FindGroupByName("Group_Circle");
    m_pGroup_Progress = m_pLayout->GetGroupContainer()->FindGroupByName("Group_Progress");
    
    /*
        InitGX() ̓e
    */
#ifdef NW_PLATFORM_CTR    
    GLenum curCmdGenMode = 0;
    nngxGetCommandGenerationMode(&curCmdGenMode);

    if (curCmdGenMode != NN_GX_CMDGEN_MODE_UNCONDITIONAL)
    {
        // NN_GX_STATE_OTHER Xe[g̃R}hɔs܂B
        nngxSetCommandGenerationMode(NN_GX_CMDGEN_MODE_UNCONDITIONAL);
    }
#endif
    
    {
        glDisable(GL_CULL_FACE);
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_SCISSOR_TEST);
        glDisable(GL_STENCIL_TEST);
        glDisable(GL_POLYGON_OFFSET_FILL);
        glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
        glDepthMask(GL_TRUE);
#ifdef NW_PLATFORM_CTR
        glDisable(GL_EARLY_DEPTH_TEST_DMP);
#endif
    }

#ifdef NW_PLATFORM_CTR
    // R}hs[hɖ߂܂B
    if (curCmdGenMode != NN_GX_CMDGEN_MODE_UNCONDITIONAL)
    {
        nngxSetCommandGenerationMode(curCmdGenMode);
    }

    // NN_GX_STATE_OTHERS ȊÕXe[g̓of[gɂR}h𔭍s܂B
    const GLbitfield stateMask =
        NN_GX_STATE_TRIOFFSET |
        NN_GX_STATE_SCISSOR |
        NN_GX_STATE_FBACCESS;

    nngxUpdateState(stateMask);
    NW_LYT_DRAWER_VALIDATE(stateMask);
#endif
    
#ifdef NW_PLATFORM_CTR
    // `NX̏
    m_Drawer.Initialize(m_GraphicsResource);
    nngxUpdateState(NN_GX_STATE_ALL);
#endif
    
    NW_GL_ASSERT();

}

/*---------------------------------------------------------------------------
  Desc: I܂Ƃ
---------------------------------------------------------------------------*/  
void LytAnalogStick::Finalize()
{
    FinalizeLayoutResource();
}

/*---------------------------------------------------------------------------
  Desc: yC̃L[Aj[Vԍ擾

  Args: pPane   - ΏۂƂȂyC

  Rtns: Aj[Vԍ
---------------------------------------------------------------------------*/
PaneAnimation LytAnalogStick::GetPaneAnimation(nw::lyt::Pane* pPane)
{
    for (PaneArray::iterator itr = m_PaneArray.begin(); itr != m_PaneArray.end(); itr++)
    {    
        if (std::strcmp((*itr)->GetPaneName(), pPane->GetName()) == 0)
        {
             return (*itr)->GetPaneAnimation();   
        }
    }
    
    NN_ASSERTMSG(false, "No PushBack pane to m_PaneArray!\n");   
    return PANE_ANIM_DEFAULT; // ɂ͗܂
}

/*---------------------------------------------------------------------------
  Desc: yC̃L[Aj[Vԍݒ肷

  Args: pPane   - ΏۂƂȂyC
        keyAnim - Aj[Vԍ

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void LytAnalogStick::SetPaneAnimation(nw::lyt::Pane* pPane, PaneAnimation keyAnim)
{
    for (PaneArray::iterator itr = m_PaneArray.begin(); itr != m_PaneArray.end(); itr++)
    {    
        if (std::strcmp((*itr)->GetPaneName(), pPane->GetName()) == 0)
        {
            (*itr)->SetPaneAnimation(keyAnim);   
        }
    }    
}

/*---------------------------------------------------------------------------
  Desc: yC̃L[Aj[Vԍݒ肷
---------------------------------------------------------------------------*/
void LytAnalogStick::SetPaneInputAnimation( AnalogStickTestMode mode )
{
    using namespace nn::math;
    
    for (PaneArray::iterator itr = m_PaneArray.begin(); itr != m_PaneArray.end(); itr++)
    {
        bit32 paneBit = (*itr)->GetPaneBit();
        switch( mode )
        {
        case MODE_INITIALIZE: 
        case MODE_ON_YOUR_MARK: 
            if( GUIDE_ARROW <= paneBit && paneBit <= CIRCLE12 ) {  (*itr)->SetPaneAnimation(PANE_ANIM_VISIBLE);  }
            else                                                {  (*itr)->SetPaneAnimation(PANE_ANIM_INVISIBLE);}
            break;
            
        case MODE_SAMPLING: 
            if     ( paneBit == GUIDE_ARROW )   {  (*itr)->SetPaneAnimation(PANE_ANIM_ROTATE);   }
            else if( paneBit == CIRCLE12 )      {  (*itr)->SetPaneAnimation(PANE_ANIM_DEFAULT);  }
            else if( CIRCLE01 <= paneBit && paneBit<= CIRCLE11  && 
                     paneBit <= static_cast<int>(FFloor(m_zDegree/30))%12 )
                                                {  (*itr)->SetPaneAnimation(PANE_ANIM_VISIBLE);  }
            else                                {  (*itr)->SetPaneAnimation(PANE_ANIM_INVISIBLE);}
            break;
            
        case MODE_CALIBRATION: 
            break;
            
        case MODE_CHECK_MAX_OUTPUT_WIDTH: 
            if     ( paneBit == GUIDE_ARROW )   {  (*itr)->SetPaneAnimation(PANE_ANIM_ROTATE);   }
            else if( paneBit == CIRCLE12 )      {  (*itr)->SetPaneAnimation(PANE_ANIM_DEFAULT);  }
            else if( CIRCLE01 <= paneBit && paneBit<= CIRCLE11  && 
                     paneBit <= static_cast<int>(FFloor(m_zDegree/30))%12 )
                                                {  (*itr)->SetPaneAnimation(PANE_ANIM_VISIBLE);  }
            else                                {  (*itr)->SetPaneAnimation(PANE_ANIM_INVISIBLE);}
            break;
            
        case MODE_CHECK_AUTO_RESTORATION_CT0: 
        case MODE_CHECK_AUTO_RESTORATION_CT1: 
        case MODE_CHECK_AUTO_RESTORATION_CT2: 
        case MODE_CHECK_AUTO_RESTORATION_CT3: 
        case MODE_CHECK_AUTO_RESTORATION_CT4: 
        case MODE_CHECK_AUTO_RESTORATION_UP:  
        case MODE_CHECK_AUTO_RESTORATION_RT:  
        case MODE_CHECK_AUTO_RESTORATION_UN:  
        case MODE_CHECK_AUTO_RESTORATION_LT:  
            if( (  1 <= m_Progress && paneBit == BLOCK01) ||
                (  6 <= m_Progress && paneBit == BLOCK02) ||
                ( 11 <= m_Progress && paneBit == BLOCK03) ||
                ( 16 <= m_Progress && paneBit == BLOCK04) ||
                ( 21 <= m_Progress && paneBit == BLOCK05) ||
                ( 26 <= m_Progress && paneBit == BLOCK06) ||
                ( 31 <= m_Progress && paneBit == BLOCK07) ||
                ( 36 <= m_Progress && paneBit == BLOCK08) ||
                ( 41 <= m_Progress && paneBit == BLOCK09) ||
                ( 46 <= m_Progress && paneBit == BLOCK10) ||
                ( 51 <= m_Progress && paneBit == BLOCK11) ||
                ( 56 <= m_Progress && paneBit == BLOCK12) ||
                ( 61 <= m_Progress && paneBit == BLOCK13) ||
                ( 66 <= m_Progress && paneBit == BLOCK14) ||
                ( 71 <= m_Progress && paneBit == BLOCK15) ||
                ( 76 <= m_Progress && paneBit == BLOCK16) ||
                ( 81 <= m_Progress && paneBit == BLOCK17) ||
                ( 86 <= m_Progress && paneBit == BLOCK18) ||
                ( 91 <= m_Progress && paneBit == BLOCK19) ||
                ( 96 <= m_Progress && paneBit == BLOCK20) ||
                ( paneBit == FRAME))    {  (*itr)->SetPaneAnimation(PANE_ANIM_VISIBLE);  }
            else                        {  (*itr)->SetPaneAnimation(PANE_ANIM_INVISIBLE);}
            break;
            
        }
    }
}
    
/*---------------------------------------------------------------------------
  Desc: Aj[V̏ԂXV

  Args: pPane   - Aj[VXVyCKw̃[gƂȂyC

  Rtns: Ȃ
---------------------------------------------------------------------------*/ 
void LytAnalogStick::UpdateAnimationFrame( nw::lyt::Pane* pPane )
{
    switch (GetPaneAnimation(pPane))
    {
    case PANE_ANIM_ROTATE:
        pPane->SetRotate(nn::math::VEC3(0.f, 0.f, ROTATION_DIRECTION * m_zDegree));
        break;
    
    case PANE_ANIM_VISIBLE:
        pPane->SetVisible(true);
        break;
    
    case PANE_ANIM_INVISIBLE:
        pPane->SetVisible(false);
        break;
        
    case PANE_ANIM_DEFAULT:
        break;
    }
    
    /*
        XChpbh]ɂăKCh̐Fς
        PځFFAQځFFARTځFΐF
        
        ToDo: pxŏ͂߂悢EEE
    */
    if((std::strcmp("guide_arrow", pPane->GetName()) == 0) ||
       (std::strcmp("circle01", pPane->GetName()) == 0) ||
       (std::strcmp("circle02", pPane->GetName()) == 0) ||
       (std::strcmp("circle03", pPane->GetName()) == 0) ||
       (std::strcmp("circle04", pPane->GetName()) == 0) ||
       (std::strcmp("circle05", pPane->GetName()) == 0) ||
       (std::strcmp("circle06", pPane->GetName()) == 0) ||
       (std::strcmp("circle07", pPane->GetName()) == 0) ||
       (std::strcmp("circle08", pPane->GetName()) == 0) ||
       (std::strcmp("circle09", pPane->GetName()) == 0) ||
       (std::strcmp("circle10", pPane->GetName()) == 0) ||
       (std::strcmp("circle11", pPane->GetName()) == 0))
    {
             if(m_zDegree==0.0f)      {   ColorGray(pPane);        }  // TvOJn
        else if(m_zDegree<=360.0f)    {   ColorYellow(pPane);      }  // P
        else if(m_zDegree<=720.0f)    {   ColorAqua(pPane);        }  // Q
        else                          {   ColorLimeGreen(pPane);   }  // R
    }
    else if((std::strcmp("circle12", pPane->GetName()) == 0))
    {
             if(m_zDegree<360.0f)     {   ColorGray(pPane);        }  // TvOJn`P
        else if(m_zDegree<720.0f)     {   ColorYellow(pPane);      }  // Q
        else if(m_zDegree<1080.0f)    {   ColorAqua(pPane);        }  // R
        else                          {   ColorLimeGreen(pPane);   }  // TvOI
    }
}

void LytAnalogStick::ColorYellow( nw::lyt::Pane* pPane )
{
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LT, nw::ut::Color8(255, 255,   0, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RT, nw::ut::Color8(255, 255,   0, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LB, nw::ut::Color8(255, 255,   0, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RB, nw::ut::Color8(255, 255,   0, 255));
}
void LytAnalogStick::ColorAqua( nw::lyt::Pane* pPane )
{
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LT, nw::ut::Color8(  0, 255, 255, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RT, nw::ut::Color8(  0, 255, 255, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LB, nw::ut::Color8(  0, 255, 255, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RB, nw::ut::Color8(  0, 255, 255, 255));
}
void LytAnalogStick::ColorLimeGreen( nw::lyt::Pane* pPane )
{
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LT, nw::ut::Color8(  0, 255,   0, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RT, nw::ut::Color8(  0, 255,   0, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LB, nw::ut::Color8(  0, 255,   0, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RB, nw::ut::Color8(  0, 255,   0, 255));
}
void LytAnalogStick::ColorGray( nw::lyt::Pane* pPane )
{
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LT, nw::ut::Color8(200, 200, 200, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RT, nw::ut::Color8(200, 200, 200, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_LB, nw::ut::Color8(200, 200, 200, 255));
    pPane->SetVtxColor(nw::lyt::VERTEXCOLOR_RB, nw::ut::Color8(200, 200, 200, 255));
}

/*---------------------------------------------------------------------------
  Desc: eyC̏ԂXV

  Args: pGroup  - XVΏۂ̃yCo^ĂO[v

  Rtns: Ȃ
---------------------------------------------------------------------------*/  
void LytAnalogStick::UpdatePane( nw::lyt::Group* pGroup )
{
    // O[vɓo^ĂyC̏
    nw::lyt::PaneLinkList& paneList = pGroup->GetPaneList();
    for (nw::lyt::PaneLinkList::Iterator it = paneList.GetBeginIter(); it != paneList.GetEndIter(); ++it)
    {
        // O[vɓo^ĂyC
        nw::lyt::Pane *const pPane = it->target;
        
        // Aj[VXV
        UpdateAnimationFrame(pPane);
    }
}

/*---------------------------------------------------------------------------
  Desc: KChAj[V
---------------------------------------------------------------------------*/
void LytAnalogStick::UpdateLayout( AnalogStickTestMode mode )
{
    // Aj[Vԍ̐ݒ
    SetPaneInputAnimation( mode );
    
    // O[v m_pGroup_Arrow ̃yCXV
    UpdatePane(m_pGroup_Arrow);
    
    // O[v m_pGroup_Circle ̃yCXV
    UpdatePane(m_pGroup_Circle);
    
    // O[v m_pGroup_Progress ̃yCXV
    UpdatePane(m_pGroup_Progress);
    
    SetupCamera( m_DrawInfo, *m_pLayout );

    m_pLayout->Animate();
    m_pLayout->CalculateMtx( m_DrawInfo );
#ifdef NW_PLATFORM_CTR
    NW_LYT_DRAWER_VALIDATE(NN_GX_STATE_ALL);
    m_Drawer.DrawBegin( m_DrawInfo );
    m_Drawer.Draw     ( m_pLayout, m_DrawInfo );
    m_Drawer.DrawEnd  ( m_DrawInfo );
    nngxUpdateState(NN_GX_STATE_ALL);
#else
    m_pLayout->Draw( m_DrawInfo );
#endif
}


} // namespace eva
} // namespace uji
