/*--------------------------------------------------------------------------*
 Project:
 File: EvaAnalogStick.cpp


*--------------------------------------------------------------------------*/

#include "EvaAnalogStick.h"
#include "TestAnalogStick.h"
#include "CalAnalogStick.h"

using namespace uji::sys;

namespace uji {
namespace eva {

namespace
{
    uji::sys::GraphicsDrawing *gfx = GraphicsDrawing::GetInstance();
    sys::WindowManager  WindowManager;
    sys::TextWindow*    DebugWindow;
}

static void Eva_CreateDebugWindow()
{
    // 
    // \p Window p
    const int FONT_SIZE = 14;
    DebugWindow = new TextWindow( 45, 20, FONT_SIZE );
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    (void)WindowManager.CreateWindow(DebugWindow, NN_GX_DISPLAY1, 0, 0);
    DebugWindow->SetTitle("Debug");
}
static void Eva_UpdateDebugWindow()
{
    WindowManager.Update();
    WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}
static void Eva_DestroyDebugWindow()
{
    // Window j
    WindowManager.DestroyWindow(DebugWindow);
}
static void Eva_WaitInputA()
{
    // 
    // ʊmFp
    uji::sys::Pad pad;
    do {
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    } while(!pad.IsButtonDown(Pad::BUTTON_A));
    
}
static bool Eva_WaitInputAB()
{
    // 
    // ʊmFp
    uji::sys::Pad pad;
    do {
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        if( pad.IsButtonDown(Pad::BUTTON_B) )
        {
          return false;
        }
    } while(!pad.IsButtonDown(Pad::BUTTON_A));
    return true;
}

static void Eva_OldTestAnalogStick()
{
    TestAnalogStick* p = new TestAnalogStick;
    p->ExecuteTestAnalogStick();
    p->ExecuteSetCalAnalogStick();
    delete p;
}

static void Eva_OldCheckAnalogStick()
{
    TestAnalogStick* p = new TestAnalogStick;
    p->ExecuteCheckAnalogStick();
    delete p;
}

static void Eva_NewTestAnalogStick()
{
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteCalAnalogStick();
}

static void Eva_SmplAndCalibAnalogStick()
{
    // ̕]j[ LINE [ĥݎs\
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_RED);
        DebugWindow->Printf("\f");
        DebugWindow->Printf("Change to LINE mode!\n");
        Eva_UpdateDebugWindow();
        Eva_WaitInputA();
        Eva_DestroyDebugWindow();
        return;
    }
    
    // bZ[W
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf(" - TEST -\n");
        DebugWindow->Printf("1. Slide up SLIDEPAD and start within 10sec.\n");
        DebugWindow->Printf("2. Rotate SLIDEPAD 3times.\n");
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("-----------------\n");
        DebugWindow->Printf("START  : A_BUTTON\n");
        DebugWindow->Printf("CANCEL : B_BUTTON\n");
        Eva_UpdateDebugWindow();
        bool ret = Eva_WaitInputAB(); // A{^ȂtrueAB{^Ȃfalse
        DebugWindow->Printf("\f");
        if( !ret )
        {
            return;
        }
    }
    
    // e
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteInitialize();
    p->ExecuteOnYourMark();
    if( p->m_TestResult.m_Result==true ) p->ExecuteSampling();
    if( p->m_TestResult.m_Result==true ) p->ExecuteCalibrate();
    if( p->m_TestResult.m_Result==true ) p->ExecuteFinalize();
    
    // IbZ[W
    {
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf(" - RESULT -\n");
    }
    if( p->m_TestResult.m_Result==true )
    {
        DebugWindow->SetTextColor(ATTR_COLOR_GREEN);
        DebugWindow->Printf("Passed.\n");
    }
    else
    {
        DebugWindow->SetTextColor(ATTR_COLOR_RED);
        DebugWindow->Printf("%s\n", p->m_TestResult.m_String);
    }
    {
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("Finish when push (A) button.\n");
        Eva_UpdateDebugWindow();
        Eva_WaitInputA();
        Eva_DestroyDebugWindow();
    }
}

static void Eva_CheckMOWAnalogStick()
{
    uji::seq::Config config;
    
    // bZ[W
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf("\f");
        DebugWindow->Printf(" - TEST -\n");
        DebugWindow->Printf("1. Slide up SLIDEPAD and start within 10sec.\n");
        DebugWindow->Printf("2. Rotate SLIDEPAD 1times.\n");
        DebugWindow->Printf("\n");
        DebugWindow->Printf(" - THRESHOLD -\n");
        DebugWindow->Printf("%d\n", 
            nn::hid::LIMIT_OF_STICK_CLAMP_MAX - config.Get().TestMarginMaxOutputWidth);
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("-----------------\n");
        DebugWindow->Printf("START  : A_BUTTON\n");
        DebugWindow->Printf("CANCEL : B_BUTTON\n");
        Eva_UpdateDebugWindow();
        bool ret = Eva_WaitInputAB(); // A{^ȂtrueAB{^Ȃfalse
        DebugWindow->Printf("\f");
        if( !ret )
        {
            return;
        }
    }
    
    // e
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteInitialize();
    p->SetParameterFromCAL();
    p->ExecuteOnYourMark();
    if( p->m_TestResult.m_Result==true ) p->ExecuteCheckMaxOutputWidth();
    if( p->m_TestResult.m_Result==true ) p->ExecuteFinalize();
    
    // IbZ[W
    {
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf(" - RESULT -\n");
    }
    if( p->m_TestResult.m_Result==true )
    {
        DebugWindow->SetTextColor(ATTR_COLOR_GREEN);
        DebugWindow->Printf("Passed.\n");
    }
    else
    {
        DebugWindow->SetTextColor(ATTR_COLOR_RED);
        DebugWindow->Printf("%s\n", p->m_TestResult.m_String);
    }
    {
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("Finish when push (A) button.\n");
        Eva_UpdateDebugWindow();
        Eva_WaitInputA();
        Eva_DestroyDebugWindow();
    }
}

static void Eva_CheckARAnalogStick()
{
    // bZ[W
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf("\f");
        DebugWindow->Printf(" - TEST -\n");
        DebugWindow->Printf("1. Move SLIDEPAD in a specified direction.\n");
        DebugWindow->Printf("2. Free SLIDEPAD.\n");
        DebugWindow->Printf("3. Repeat this sequence 4times.\n");
        DebugWindow->Printf("\n");
        DebugWindow->Printf(" - THRESHOLD -\n");
        uji::seq::Config config;
        DebugWindow->Printf("%d\n", config.Get().UnusableZone);
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("-----------------\n");
        DebugWindow->Printf("START  : A_BUTTON\n");
        DebugWindow->Printf("CANCEL : B_BUTTON\n");
        Eva_UpdateDebugWindow();
        bool ret = Eva_WaitInputAB(); // A{^ȂtrueAB{^Ȃfalse
        DebugWindow->Printf("\f");
        if( !ret )
        {
            return;
        }
    }
    
    // e
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    p->ExecuteInitialize();
    p->SetParameterFromCAL();
    p->ExecuteCheckAutoRestoration();
    if( p->m_TestResult.m_Result==true ) p->ExecuteFinalize();

    // IbZ[W
    {
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf(" - RESULT -\n");
    }
    for( int i=1; i<5; ++i )
    {
        DebugWindow->Printf("Center%d(%4d,%4d)\n", 
            i, p->ReadConvSdkRawX_AR(i), p->ReadConvSdkRawY_AR(i));
    }
    if( p->m_TestResult.m_Result==true )
    {
        DebugWindow->SetTextColor(ATTR_COLOR_GREEN);
        DebugWindow->Printf("Passed.\n");
    }
    else
    {
        DebugWindow->SetTextColor(ATTR_COLOR_RED);
        DebugWindow->Printf("%s\n", p->m_TestResult.m_String);
    }
    {
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("Finish when push (A) button.\n");
        Eva_UpdateDebugWindow();
        Eva_WaitInputA();
        Eva_DestroyDebugWindow();
    }
}

static void Eva_EvaluateTester()
{
    uji::seq::Config config;
    
    // bZ[W
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf("\f");
        DebugWindow->Printf(" - AGING MODE -\n");
        DebugWindow->Printf("1. %dms * %dtimes * %dLoops Sampling.\n", config.GetAlternative().SamplingLapTime, 
                                                                       config.GetAlternative().SamplingRound, 
                                                                       config.Get().EvaTesterLoopCount);
        DebugWindow->Printf("2. Logs is Written to SD Card.\n");
        
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("-----------------\n");
        DebugWindow->Printf("START  : A_BUTTON\n");
        DebugWindow->Printf("CANCEL : B_BUTTON\n");
        Eva_UpdateDebugWindow();
        bool ret = Eva_WaitInputAB(); // A{^ȂtrueAB{^Ȃfalse
        DebugWindow->Printf("\f");
        if( !ret )
        {
            return;
        }
    }
    
    // e
    CalAnalogStick* p = CalAnalogStick::GetInstance();
    
    for( int i=0; i<config.Get().EvaTesterLoopCount; i++ )
    {
        p->ExecuteInitialize();
        p->ExecuteOnYourMark();
        if( p->m_TestResult.m_Result==true ) p->ExecuteEvaluateTester();
        
        // Ƃ̃^C~Op
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(config.Get().EvaTesterIdleTime));
        
        if( p->m_TestResult.m_Result==true ) p->ExecuteCheckMaxOutputWidth();
        
        if( p->m_TestResult.m_Result==false ) break;
        
        wchar_t fileName[0x100];
        std::swprintf( fileName, sizeof(fileName), L"sdmc:/uji/SlidePad/EvaluateTester/%03d.csv", i );
        p->ExecuteWriteEvaluateData2SD( fileName );
        p->ExecuteFinalize();
    }
    
    // IbZ[W
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf("\f");
        DebugWindow->Printf(" - AGING MODE -\n");
        DebugWindow->Printf("1. %dms * %dtimes * %dLoops Sampling.\n", config.GetAlternative().SamplingLapTime, 
                                                                       config.GetAlternative().SamplingRound, 
                                                                       config.Get().EvaTesterLoopCount);
        DebugWindow->Printf("2. Logs is Written to SD Card.\n");
        
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("\n");
        DebugWindow->Printf("Finish! Return to Menu when Push (A) button.\n");
        Eva_UpdateDebugWindow();
        Eva_WaitInputA();
        Eva_DestroyDebugWindow();
    }
}

void OpenAnalogStickEvaMenu( void )
{
    ClassMenu *m = new ClassMenu( "AnalogStick Eva Menu" );

    m->Add( " TestAndSetCAL", Eva_NewTestAnalogStick );
    m->Add( " Sample&Calib(NotSetCAL)", Eva_SmplAndCalibAnalogStick );
    m->Add( " MaxOutputWidth", Eva_CheckMOWAnalogStick );
    m->Add( " AutoRestoration", Eva_CheckARAnalogStick );
    m->Add( " (old)TestAndSetCAL", Eva_OldTestAnalogStick );
    m->Add( " (old)SimpleCheck", Eva_OldCheckAnalogStick );
    m->Add( " EvaluateTester", Eva_EvaluateTester );
    
    m->Open();

    delete m;
}

void SPMenuForService( void )
{
    ClassMenu *m = new ClassMenu( "Slidepad Menu" );

    m->Add( " Check Sampling", Eva_SmplAndCalibAnalogStick );
    m->Add( " Check MaxOutputWidth", Eva_CheckMOWAnalogStick );
    m->Add( " Check AutoRestoration", Eva_CheckARAnalogStick );
    
    m->Open();

    delete m;
}


}   // namespace
}
