/*--------------------------------------------------------------------------*
 Project:
 File: CalAnalogStick.h


*--------------------------------------------------------------------------*/
#ifndef CALANALOGSTICK_H_INCLUDED
#define CALANALOGSTICK_H_INCLUDED

#include <nn.h>
#include <nn/math.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hid/CTR/hid_AnalogStickCalibrator.h>
#include <nn/drivers/cal/CTR/cal_Api.h>

#include <string>

#include "sys.h"
#include "sys_GraphicsDrawing.h"
#include "../seq/Config.h"
#include "../seq/TestResult.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "LytAnalogStick.h"

using namespace std;
using namespace uji::sys;
using namespace nn::math;

namespace uji {
namespace eva {

// XChpbh̓͏
typedef struct
{
    s16 raw_x;       // l
    s16 raw_y;       // l
    s16 conv_lcd_x;  // lʕ\pɕϊl
    s16 conv_lcd_y;  // lʕ\pɕϊl
    s16 conv_sdk_x;  // lSDKpɕϊl
    s16 conv_sdk_y;  // lSDKpɕϊl
}
AnalogStickDataInformation;


//===========================================================================
//===========================================================================
//   XChpbh̃Lu[VNX
//===========================================================================
//===========================================================================
class CalAnalogStick
{
    enum enumLcd
    {
        MAIN_LCD = 0,
        SUB_LCD  = 1,

        LCD_NUM  = 2
    };

    enum enumDirection
    {
        CENTER0 = 0,
        UPPER   = 1,
        CENTER1 = 2,
        RIGHT   = 3,
        CENTER2 = 4,
        UNDER   = 5,
        CENTER3 = 6,
        LEFT    = 7,
        CENTER4 = 8,

        DIRECTION_NUM = 9
    };

public:
    static CalAnalogStick* GetInstance()
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new CalAnalogStick;
        }
        return m_pInstance;
    }

    bool ExecuteInitialize( void );
    bool ExecuteFinalize( void );
    void ExecuteOnYourMark( void );
    void ExecuteSampling( void );
    void ExecuteCalibrate( void );
    void ExecuteCheckMaxOutputWidth( void );
    void ExecuteCheckAutoRestoration( void );
    bool ExecuteWriteData2SD( void );
    void ExecuteSetCalAnalogStick( void );
    

    void ExecuteCalAnalogStick( void );
    void SetParameterFromCAL( void );
    s16  ReadConvSdkRawX_AR( int i );
    s16  ReadConvSdkRawY_AR( int i );
    
    // ̕]p
    void ExecuteEvaluateTester( void );
    bool ExecuteWriteEvaluateData2SD( const wchar_t* path );

    bool ExecuteSetLapAuto()
    {
        SAMPLING_LAP_TIME = 995;
        return true;
    }
    
    bool ExecuteSetLapManual()
    {
        SAMPLING_LAP_TIME = 3000;
        return true;
    }

private:
    CalAnalogStick()
     :
        gfx( GraphicsDrawing::GetInstance() ),
        m_ModeWindow( 140/(FONT_SIZE/2), 27/FONT_SIZE, FONT_SIZE ),
        m_InformationWindow( 140/(FONT_SIZE/2), 195/FONT_SIZE, FONT_SIZE )
    {
        if (m_pInstance != NULL)
        {
            NW_FATAL_ERROR("CalAnalogStick instance already exists.");
        }
        m_pInstance = this;

    }

private:
    // Xbhp
    void ThreadConvRawData( void );
    void StartThread( void );
    void StopThread( void );

    // ϊp
    void ConvRawDataToLCD( s16& rawx, s16& rawy, s16& convx, s16& convy );
    void ConvRawXToLCD( s16& rawx, s16& convx );
    void ConvRawYToLCD( s16& rawy, s16& convy );
    void ConvRawDataToSDK( s16& rawx, s16& rawy, s16& convx, s16& convy );
    void ConvSDKToLCD( s16& sdkx, s16& sdky, s16& lcdx, s16& lcdy );
    void ConvSDK_X_ToLCD( s16& sdkx, s16& lcdx );
    void ConvSDK_Y_ToLCD( s16& sdky, s16& lcdy );

    // ʕ\p
    void CreateWindows( void );
    void UpdateWindows( void );
    void DestroyWindows( void );
    void PrepareGraphicsDrawing( u8 displayId );
    void UpdateGraphicsDrawing( u8 displayId );
    void UpdateGraphicsDrawing_AR( u8 displayId );
    void UpdateGraphicsDrawing_Information( void );
    void SwapBuffersAndWaitVsync( u8 displayId );
    void SetDefaultBackGroundColor( void );
    void SetBlackBackGroundColor( void );
    void UpdateDisplay_EVA_INFORMATION( void );
    void InitializeBuffer( void );
    void AddDataBuffer( s32 i );
    void FinalizeBuffer( void );
    void LocusDisplay( bool visible );

    // TvÕKChh~p
    bool IsWithinAcceptable( void );

    // Z^[A\p
    void IsStable( void );
    bool IsValidParameter( void );
    bool ChangeTestMode( f32 progress, AnalogStickTestMode& mode );

    // Lu[Vp
    void PresetCalAnalogStick( void );
    s32  SetCalAnalogStick( void );

    // SDւ̃Oo͗p
    bool CreateDirectorySdmc( const wchar_t* path );
    bool WriteData2SD( const wchar_t* path, string line );

    // li[郊Oobt@p
    s16 Next(s32 a)
    {
        return (a + 1) % RAW_DATA_BUFFER_SIZE;
    }

    /* ----------------------------------------------------------------------
     *   oϐ
     * ------------------------------------------------------------------- */
    // VOgIuWFNgւ̃|C^
    static CalAnalogStick* m_pInstance;

    // eCX^X
    LytAnalogStick*                                 m_pLyt;
    nn::hid::AnalogStickCalibrator*                 m_pAsCal;
    nn::hid::CTR::AnalogStickCalData                m_asCalData;
    nn::drivers::cal::CTR::AnalogStickCalDataCore   m_CalDataCore;
    nn::drivers::cal::CTR::AnalogStickCalAppendCore m_CalAppendCore;

    // OtBbNX
    uji::sys::GraphicsDrawing *gfx;

    // 摜\p
    sys::JpegDrawer* m_JpegDrawer;

    // [h
    AnalogStickTestMode m_TestMode;

    // Xbh
    nn::os::Thread m_ThreadConvRawData;

    // tO
    bool m_IsConvRawDataFlag;      // lϊXbhp
    bool m_WasSampledFlag;         // Lu[V
    bool m_LocusVisible;           // OՂ\邩
    bool m_IsOver60Volts;          // o͕60%
    bool m_IsInRange;              // _Y6.5%ȓ
    bool m_IsRetried;              // Z^[A\ł̃gCtO
    s16  m_IsMaxOutputWidthValid;  // őŏl͉\
    s16  m_IsValidParameter;       // L͈͓̒lł邩
    s16  m_IsStable;               // l肵Ă邩

    // EBhEp
    sys::WindowManager  m_WindowManager;
    sys::TextWindow     m_ModeWindow;
    sys::TextWindow     m_InformationWindow;

    // Oobt@p
    AnalogStickDataInformation* m_pAnalogStickDataBuffer;
    s32                         m_Front;
    s32                         m_Rear;

    // ^CAEgp
    nn::os::Tick m_Start;
    nn::os::Tick m_Current;
    s64          m_Time;

    // lpXe[^X
    nn::hid::AnalogStickStatus m_AsStatusRaw;

    // l
    s16 m_RawX;
    s16 m_RawY;

    // lʕ\pɕϊl
    s16 m_ConvLcdRawX;
    s16 m_ConvLcdRawY;

    // lSDKpɕϊl
    s16 m_ConvSdkRawX;
    s16 m_ConvSdkRawY;

    // XChpbh̎
    s16 m_Type;

    // lőŏ
    s16 m_RawMaxX;
    s16 m_RawMinX;
    s16 m_RawMaxY;
    s16 m_RawMinY;

    // _␳l
    s16 m_CenterX;
    s16 m_CenterY;

    // x␳W
    f32 m_ScaleX;
    f32 m_ScaleY;


    // Z^[A\p
    enumDirection m_DirectionId;
    s16 m_RetryFrequency[DIRECTION_NUM];  // gC

    // ʊi[p
    s16  m_CheckMax_ConvSdkRawX[2];
    s16  m_CheckMax_ConvSdkRawY[2];
    s16  m_RawX_AR[5];
    s16  m_RawY_AR[5];
    s16  m_ConvSdkRawX_AR[5];
    s16  m_ConvSdkRawY_AR[5];
    
    // 팟ؗpobt@
    s16  m_BufferForEvaluation[2][2000];
    s16  m_BufNum;
    
public:
    uji::seq::TestResult  m_TestResult;

private:
    /* ----------------------------------------------------------------------
     *   ÓIo
     * -------------------------------------------------------------------- */

    // ֐
    static void WrappingThreadConvRawData(void* param);

    // 萔
    static const int FONT_SIZE            = 12;
    static const s16 PSEUDO_DISPLAY_SIZE  = 240;               // t^TCY
    static const s16 RAWMAX               = 4096;
    static const f32 SCALE_FOR_DISPLAY    = PSEUDO_DISPLAY_SIZE / RAWMAX;
    static const f32 DELTA                = 0.065f;
    static const f32 CALMAX               = RAWMAX * (0.8f - DELTA);  // 80%}6.5% -> Œł73.5%
    static const f32 CALMIN               = RAWMAX * (0.2f + DELTA);  // 20%}6.5% -> ōł26.5%
    static const f32 DEFAULT_CENTER       = RAWMAX >> 1;
    static const f32 DELTA_MAX            = RAWMAX * (0.5f + DELTA);
    static const f32 DELTA_MIN            = RAWMAX * (0.5f - DELTA);
    static const f32 VOLTAGE_MIN          = RAWMAX * 0.60f;
    static const f32 RANGE                = RAWMAX * 0.60f;
    static const s16 LIMIT_MAX            = nn::hid::LIMIT_OF_STICK_CLAMP_MAX;        // 145
    static const s16 MIN_CROSS            = nn::hid::MIN_OF_STICK_CLAMP_MODE_CROSS;   // 41
    static const s16 MIN_CIRCLE           = nn::hid::MIN_OF_STICK_CLAMP_MODE_CIRCLE;  // 46
    static const s16 INLINE_THRESHOLD     = 50; // Z^[A\̏㉺E̓臒l
    static const s16 OUTLINE_THRESHOLD    = 80; // Z^[A\̏㉺E̓臒l

    // XChpbh̓͂SȂꍇl
    // Z^[A\ȊOɂ^CAEgݒ肵Ă
    // static const s16 __TIMEOUT = 10000;  // TIMELIMIT_TEST_START ɒu܂B


    // uji::seq::Config
    s16 UNUSABLE_ZONE_MAX;      // sсiSDKlj
    s64 SAMPLING_LAP_TIME;      // bv^C
    u16 SAMPLING_ROUND;         // TvO [v
    u16 SAMPLING_TOLERANCE;     // ͋e͈
    s32 RAW_DATA_BUFFER_SIZE;   // XChpbh̋O՗pobt@TCY
    s16 TEST_MARGIN_MOW_TEST;   // őŏlmFł̌p}[W
    s16 COUNT_AR_TEST;          // LlƂăJEg
    s32 TIMELIMIT_TEST_START;   // TvOJn̓͑҂̐
    s16 TIMELIMIT_AR_TEST;      // Z^[Ał̐
    s16 MAX_RETRY_FREQUENCY;    // ő僊gC񐔁igpĂȂj
    bool WRITE_DATA_TO_SD;      // SD J[hɃf[^o͂邩
};
//===========================================================================
//===========================================================================


}
}

#endif  // CALANALOGSTICK_H_INCLUDED

