
#include "CalAnalogStick.h"
#include "../seq/TestSequencer.h" 

#define  CALANALOGSTICK_DEBUGGER        0 // fobOɂ 1 
#define  CALANALOGSTICK_WINDOW_VISIBLE  1 // 0 ̏ꍇAm_DrawFramework->DrawText
                                          // 1 ̏ꍇAm_InformationWindow.Printf
#define  CALANAKIGSTICK_LOCUS_LINE1DOT0 0 // 0 ̏ꍇAOՂ̓_\
                                          // 1 ̏ꍇAOՂ̐\

using namespace uji;
using namespace uji::sys;
using namespace nn::math;


namespace uji {
namespace eva {

CalAnalogStick* CalAnalogStick::m_pInstance = 0;

//class CalAnalogStick;

#define EVALUATE_TESTER_MODE 0 // ]ɂ1

//===========================================================================
//===========================================================================
//                            NN_LOG o
//===========================================================================
//===========================================================================
static const bool outputEnable_NN_LOG = false;
static void IsEnable_NN_LOG( const char* format, ... )
{
    if(outputEnable_NN_LOG)
    {
        va_list list;
        va_start(list, format);
        
        NN_LOG(format, list);
        
        va_end(list);
    }
}

//===========================================================================
//===========================================================================
//                            ʕ`Xbh
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: Xbh̃bp[ƃ{fB
---------------------------------------------------------------------------*/
/*
  Desc: XChpbh̐lʕ\pɕϊ
*/
void CalAnalogStick::WrappingThreadConvRawData(void* param)
{
    CalAnalogStick* pCas = reinterpret_cast< CalAnalogStick* >( param );
    pCas->ThreadConvRawData();
}
void CalAnalogStick::ThreadConvRawData()
{
    IsEnable_NN_LOG("@ Create Thread: ThreadConvRawData \n");
    
    while(m_IsConvRawDataFlag)
    {
        // lĎ
        m_pAsCal->ReadRaw(&m_AsStatusRaw);
        m_RawX = m_AsStatusRaw.x;
        m_RawY = m_AsStatusRaw.y;
        
#if EVALUATE_TESTER_MODE==1
        m_BufferForEvaluation[0][m_BufNum] = m_RawX;
        m_BufferForEvaluation[1][m_BufNum] = m_RawY;
        m_BufNum++;
#endif
        
        // ʕ\pɕϊ
        ConvRawDataToLCD( m_RawX, m_RawY, m_ConvLcdRawX, m_ConvLcdRawY );
        
        if( m_WasSampledFlag )
        {
            // ʊJҗpSDKŎgplɕϊ
            ConvRawDataToSDK(m_RawX, m_RawY, m_ConvSdkRawX, m_ConvSdkRawY);
            if(m_ConvSdkRawY > m_CheckMax_ConvSdkRawY[0])   m_CheckMax_ConvSdkRawY[0] = m_ConvSdkRawY;
            if(m_ConvSdkRawX > m_CheckMax_ConvSdkRawX[0])   m_CheckMax_ConvSdkRawX[0] = m_ConvSdkRawX;
            if(m_ConvSdkRawY < m_CheckMax_ConvSdkRawY[1])   m_CheckMax_ConvSdkRawY[1] = m_ConvSdkRawY;
            if(m_ConvSdkRawX < m_CheckMax_ConvSdkRawX[1])   m_CheckMax_ConvSdkRawX[1] = m_ConvSdkRawX;
            
            s16 s = LIMIT_MAX - TEST_MARGIN_MOW_TEST;
            if(m_CheckMax_ConvSdkRawY[0] >      s)  m_IsMaxOutputWidthValid  |= 0x01;
            if(m_CheckMax_ConvSdkRawX[0] >      s)  m_IsMaxOutputWidthValid  |= 0x02;
            if(m_CheckMax_ConvSdkRawY[1] < -1 * s)  m_IsMaxOutputWidthValid  |= 0x04;
            if(m_CheckMax_ConvSdkRawX[1] < -1 * s)  m_IsMaxOutputWidthValid  |= 0x08;
        }
        else
        {
            // TvO͍XV
            if(m_RawX > m_RawMaxX)   m_RawMaxX = m_RawX;
            if(m_RawX < m_RawMinX)   m_RawMinX = m_RawX;
            if(m_RawY > m_RawMaxY)   m_RawMaxY = m_RawY;
            if(m_RawY < m_RawMinY)   m_RawMinY = m_RawY;
            
            m_CenterX = (m_RawMaxX + m_RawMinX) >> 1;
            m_CenterY = (m_RawMaxY + m_RawMinY) >> 1;
            m_ScaleX  = RANGE / (m_RawMaxX - m_RawMinX);
            m_ScaleY  = RANGE / (m_RawMaxY - m_RawMinY);
        }
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(5));
    }
    
    IsEnable_NN_LOG("@ Exit Thread: ThreadConvRawData \n");
}

/*---------------------------------------------------------------------------
  Desc: eXbh̊Jn
---------------------------------------------------------------------------*/
void CalAnalogStick::StartThread()
{
    m_ThreadConvRawData.StartUsingAutoStack( WrappingThreadConvRawData, this, 4096, 2 );
}

/*---------------------------------------------------------------------------
  Desc: eXbh̒~
---------------------------------------------------------------------------*/
void CalAnalogStick::StopThread()
{
    m_IsConvRawDataFlag = false;
    m_ThreadConvRawData.Join();             // XbhI҂
    m_ThreadConvRawData.Finalize();         // Xbhj
}


//===========================================================================
//===========================================================================
//                            ϊp֐
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: lʕ\pɕϊ
---------------------------------------------------------------------------*/
void CalAnalogStick::ConvRawDataToLCD( s16& rawx, s16& rawy, s16& convx, s16& convy )
{
    convx = 400 - ( PSEUDO_DISPLAY_SIZE - static_cast<s16>(rawx * PSEUDO_DISPLAY_SIZE / RAWMAX ));
    convy =         PSEUDO_DISPLAY_SIZE - static_cast<s16>(rawy * PSEUDO_DISPLAY_SIZE / RAWMAX );
}
void CalAnalogStick::ConvRawXToLCD( s16& rawx, s16& convx )
{
    convx = 400 - ( PSEUDO_DISPLAY_SIZE - static_cast<s16>(rawx * PSEUDO_DISPLAY_SIZE / RAWMAX ));
}
void CalAnalogStick::ConvRawYToLCD( s16& rawy, s16& convy )
{
    convy =         PSEUDO_DISPLAY_SIZE - static_cast<s16>(rawy * PSEUDO_DISPLAY_SIZE / RAWMAX );
}

/*---------------------------------------------------------------------------
  Desc: lSDKŎgplɕϊiLuLj
---------------------------------------------------------------------------*/
void CalAnalogStick::ConvRawDataToSDK( s16& rawx, s16& rawy, s16& convx, s16& convy )
{
    convx = static_cast<s16>(m_ScaleX * (rawx - m_CenterX) / 8);
    convy = static_cast<s16>(m_ScaleY * (rawy - m_CenterY) / 8);
}

/*---------------------------------------------------------------------------
  Desc: SDKŎgplʕ\pɕϊiLuLj
---------------------------------------------------------------------------*/
void CalAnalogStick::ConvSDKToLCD( s16& sdkx, s16& sdky, s16& lcdx, s16& lcdy )
{
    s16 rawx = m_CenterX + (8 * sdkx / m_ScaleX);
    s16 rawy = m_CenterY + (8 * sdky / m_ScaleY);
    ConvRawDataToLCD( rawx, rawy, lcdx, lcdy );
}
void CalAnalogStick::ConvSDK_X_ToLCD( s16& sdkx, s16& lcdx )
{
    s16 rawx = m_CenterX + (8 * sdkx / m_ScaleX);
    ConvRawXToLCD( rawx, lcdx );
}
void CalAnalogStick::ConvSDK_Y_ToLCD( s16& sdky, s16& lcdy )
{
    s16 rawy = m_CenterY + (8 * sdky / m_ScaleY);
    ConvRawYToLCD( rawy, lcdy );
}


//===========================================================================
//===========================================================================
//                            ʕ\XVp
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: wiftHg
---------------------------------------------------------------------------*/
void CalAnalogStick::SetDefaultBackGroundColor( void )
{
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
}

/*---------------------------------------------------------------------------
  Desc: wi
---------------------------------------------------------------------------*/
void CalAnalogStick::SetBlackBackGroundColor( void )
{
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
}

/*---------------------------------------------------------------------------
  Desc: ʂXVȂ Evaluation Menu ł̉EBhE\XVp
---------------------------------------------------------------------------*/
void CalAnalogStick::UpdateDisplay_EVA_INFORMATION( void )
{
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    sys::Menu::m_WindowManager.Update();
    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();        
    sys::Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*---------------------------------------------------------------------------
  Desc: obt@̏
---------------------------------------------------------------------------*/
void CalAnalogStick::InitializeBuffer( void )
{
    m_pAnalogStickDataBuffer = new AnalogStickDataInformation[RAW_DATA_BUFFER_SIZE];
    
    for(int i=RAW_DATA_BUFFER_SIZE-1; i>=0; --i)
    {
        AddDataBuffer(i);
    }
}

/*---------------------------------------------------------------------------
  Desc: obt@𖄂߂
---------------------------------------------------------------------------*/
void CalAnalogStick::AddDataBuffer( s32 i )
{
    m_pAnalogStickDataBuffer[i].raw_x = m_RawX;
    m_pAnalogStickDataBuffer[i].raw_y = m_RawY;
    m_pAnalogStickDataBuffer[i].conv_lcd_x = m_ConvLcdRawX;
    m_pAnalogStickDataBuffer[i].conv_lcd_y = m_ConvLcdRawY;
    m_pAnalogStickDataBuffer[i].conv_sdk_x = m_ConvSdkRawX;
    m_pAnalogStickDataBuffer[i].conv_sdk_y = m_ConvSdkRawY;
}

/*---------------------------------------------------------------------------
  Desc: obt@̏I
---------------------------------------------------------------------------*/
void CalAnalogStick::FinalizeBuffer( void )
{
    delete[] m_pAnalogStickDataBuffer;
}

/*---------------------------------------------------------------------------
  Desc: XChpbh̋OՂ\
---------------------------------------------------------------------------*/
void CalAnalogStick::LocusDisplay( bool visible )
{
    if( visible == false ) return;
    
    AddDataBuffer(m_Rear);
    
#if CALANAKIGSTICK_LOCUS_LINE1DOT0==1
    // OՂ̐\
    gfx->m_DrawFramework->SetColor( 0.0f, 1.0f, 0.0f, 1.0f );
    if(m_Front < m_Rear)
    {
        for(int i=m_Rear; i>1; --i)
        {
            gfx->m_DrawFramework->
                 DrawLine((f32)m_pAnalogStickDataBuffer[i].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_y, 
                          (f32)m_pAnalogStickDataBuffer[i-1].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[i-1].conv_lcd_y);
        }
    }
    else
    {
        for(int i=m_Rear; i>0; --i)
        {
            gfx->m_DrawFramework->
                 DrawLine((f32)m_pAnalogStickDataBuffer[i].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_y, 
                          (f32)m_pAnalogStickDataBuffer[i-1].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[i-1].conv_lcd_y);
        }
        {
            gfx->m_DrawFramework->
                 DrawLine((f32)m_pAnalogStickDataBuffer[0].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[0].conv_lcd_y, 
                          (f32)m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_lcd_y);
        }
        for(int i=RAW_DATA_BUFFER_SIZE-1; i>m_Front; --i)
        {
            gfx->m_DrawFramework->
                 DrawLine((f32)m_pAnalogStickDataBuffer[i].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_y, 
                          (f32)m_pAnalogStickDataBuffer[i-1].conv_lcd_x, 
                          (f32)m_pAnalogStickDataBuffer[i-1].conv_lcd_y);
        }
    }
#else
    // OՂ̓_\
    gfx->m_DrawFramework->SetColor( 0.0f, 1.0f, 0.0f, 1.0f );
    if(m_Front < m_Rear)
    {
        for(int i=m_Rear; i>1; --i)
        {
            gfx->m_DrawFramework->FillRectangle(
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_x-0.5f, 
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_y-0.5f, 
                          1.0f, 
                          1.0f);
        }
    }
    else
    {
        for(int i=m_Rear; i>0; --i)
        {
            gfx->m_DrawFramework->FillRectangle(
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_x-0.5f, 
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_y-0.5f, 
                          1.0f, 
                          1.0f);
        }
        {
            gfx->m_DrawFramework->FillRectangle(
                          (f32)m_pAnalogStickDataBuffer[0].conv_lcd_x-0.5f, 
                          (f32)m_pAnalogStickDataBuffer[0].conv_lcd_y-0.5f, 
                          1.0f, 
                          1.0f);
        }
        for(int i=RAW_DATA_BUFFER_SIZE-1; i>m_Front; --i)
        {
            gfx->m_DrawFramework->FillRectangle(
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_x-0.5f, 
                          (f32)m_pAnalogStickDataBuffer[i].conv_lcd_y-0.5f, 
                          1.0f, 
                          1.0f);
        }
    }
#endif
    
    m_Front = (m_Front == Next(m_Rear+1)) ? Next(m_Front) : m_Front;
    m_Rear  = Next(m_Rear);
}

/*---------------------------------------------------------------------------
  Desc: EBhE̐
---------------------------------------------------------------------------*/
void CalAnalogStick::CreateWindows( void )
{
    // eLXgEChE
    (void)m_WindowManager.CreateWindow(&m_ModeWindow, NN_GX_DISPLAY0, 0, 0);
    m_ModeWindow.SetTitle("Mode");
    m_ModeWindow.SetTextColor(ATTR_COLOR_WHITE);
    (void)m_WindowManager.CreateWindow(&m_InformationWindow, NN_GX_DISPLAY0, 0, 30);
    m_InformationWindow.SetTitle("Information");
    m_InformationWindow.SetTextColor(ATTR_COLOR_WHITE);
    
    // ANeBuw
    m_ModeWindow.SetActiveFlag(false);
    m_InformationWindow.SetActiveFlag(false);
    
    // EChE}l[W̃L[𖳌
    m_WindowManager.SetManagerPadControlFlag(false);
}

/*---------------------------------------------------------------------------
  Desc: EBhE̓e
---------------------------------------------------------------------------*/
void CalAnalogStick::UpdateWindows( void )
{
    char charTestMode[50] = "";
         if(m_TestMode == MODE_INITIALIZE)                 sprintf(charTestMode, "INITIALIZE");
    else if(m_TestMode == MODE_ON_YOUR_MARK)               sprintf(charTestMode, "ON YOUR MARK");
    else if(m_TestMode == MODE_SAMPLING)                   sprintf(charTestMode, "SAMPLING");
    else if(m_TestMode == MODE_CALIBRATION)                sprintf(charTestMode, "CALIBRATION");
    else if(m_TestMode == MODE_CHECK_MAX_OUTPUT_WIDTH)     sprintf(charTestMode, "MAX OUTPUT WIDTH");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT0) sprintf(charTestMode, "AUTO RESTORATION CT0");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_UP)  sprintf(charTestMode, "AUTO RESTORATION UP");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT1) sprintf(charTestMode, "AUTO RESTORATION CT1");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_RT)  sprintf(charTestMode, "AUTO RESTORATION RT");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT2) sprintf(charTestMode, "AUTO RESTORATION CT2");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_UN)  sprintf(charTestMode, "AUTO RESTORATION UN");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT3) sprintf(charTestMode, "AUTO RESTORATION CT3");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_LT)  sprintf(charTestMode, "AUTO RESTORATION LT");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT4) sprintf(charTestMode, "AUTO RESTORATION CT4");
    else if(m_TestMode == MODE_SET_CAL)                    sprintf(charTestMode, "SET CAL");
    else if(m_TestMode == MODE_FINALIZE)                   sprintf(charTestMode, "FINALIZE");
    m_ModeWindow.Gotoxy(0,0);
    m_ModeWindow.Printf(" %s \n", charTestMode);
    
    m_InformationWindow.Gotoxy(0,0);
#if CALANALOGSTICK_DEBUGGER==1
    // fobOp
    m_InformationWindow.Printf(" time : %06.lf(sec)\n", m_Time * 0.001f );
#endif
    m_InformationWindow.Printf(" raw  : (%5d, %5d)\n", m_RawX, m_RawY);
    m_InformationWindow.Printf(" sdk  : (%5d, %5d)\n", m_ConvSdkRawX, m_ConvSdkRawY);
    
    m_InformationWindow.Printf(" \n");
    m_InformationWindow.Printf(" x max:%5d, min:%4d\n", m_RawMaxX, m_RawMinX);
    m_InformationWindow.Printf(" y max:%5d, min:%4d\n", m_RawMaxY, m_RawMinY);
    
    if(m_TestMode > MODE_CALIBRATION)
    {
    m_InformationWindow.Printf(" center:(%5d,%5d)\n", m_CenterX, m_CenterY);
    m_InformationWindow.Printf(" scale_x: %9.7f\n", m_ScaleX);
    m_InformationWindow.Printf(" scale_y: %9.7f\n", m_ScaleY);
    }
    
    if(m_TestMode == MODE_CHECK_MAX_OUTPUT_WIDTH)
    {
    m_InformationWindow.Printf(" \n");
    m_InformationWindow.Printf(" %4d/%4d/%4d/%4d\n", m_CheckMax_ConvSdkRawY[0], m_CheckMax_ConvSdkRawX[0], 
                                                     m_CheckMax_ConvSdkRawY[1], m_CheckMax_ConvSdkRawX[1]);
    }
    
    if(m_TestMode >= MODE_CHECK_AUTO_RESTORATION_CT0)
    {
    m_InformationWindow.Printf(" \n");
    m_InformationWindow.Printf(" progress: %3.0f / 100\n", m_pLyt->m_Progress);
    m_InformationWindow.Printf(" time:      %2.f /  %2.f\n", (f32)(m_Time/1000), (f32)(TIMELIMIT_AR_TEST/1000));
    m_InformationWindow.Printf(" retry:     %2d /  %2d\n", m_RetryFrequency[m_DirectionId], MAX_RETRY_FREQUENCY);
    }
    m_WindowManager.Update();
}

/*---------------------------------------------------------------------------
  Desc: EBhE̔j
---------------------------------------------------------------------------*/
void CalAnalogStick::DestroyWindows( void )
{
    m_WindowManager.DestroyWindow(&m_ModeWindow);
    m_WindowManager.DestroyWindow(&m_InformationWindow);
}

/*---------------------------------------------------------------------------
  Desc: GraphicsDrawing̑O
---------------------------------------------------------------------------*/
void CalAnalogStick::PrepareGraphicsDrawing( u8 displayId )
{
    switch( displayId )
    {
    case MAIN_LCD:
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        break;
    case SUB_LCD:
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        break;
    }
}

/*---------------------------------------------------------------------------
  Desc: GraphicsDrawing̓e
---------------------------------------------------------------------------*/
void CalAnalogStick::UpdateGraphicsDrawing( u8 displayId )
{
    using namespace nn::math;
    
    switch( displayId )
    {
    case MAIN_LCD:
        m_WindowManager.DrawDisplay0();
        gfx->BeginDrawingShape();
        
        // XChpbh̋OՂ`
        gfx->m_DrawFramework->SetColor( 0.0f, 1.0f, 1.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle(m_ConvLcdRawX-2.0f, m_ConvLcdRawY-2.0f, 4.0f, 4.0f);
        LocusDisplay( m_LocusVisible );
        break;
        
    case SUB_LCD:
        m_JpegDrawer->DrawPicture(NN_GX_DISPLAY1);
        gfx->BeginDrawingShape();
        break;
    }
}

/*---------------------------------------------------------------------------
  Desc: GraphicsDrawing̓eiZ^[A\j
---------------------------------------------------------------------------*/
void CalAnalogStick::UpdateGraphicsDrawing_AR( u8 displayId )
{
    f32 deg1 = 0.0f;
    f32 deg2 = 0.0f;
    const f32 RADIUS = static_cast<f32>(UNUSABLE_ZONE_MAX);
    s16 x1  = 0,  y1  = 0;    // n_
    s16 x2  = 0,  y2  = 0;    // I_
    s16 cx1 = 0,  cy1 = 0;    // n_iSDK->LCDj
    s16 cx2 = 0,  cy2 = 0;    // I_iSDK->LCDj
    
    s16  xr[6],  yr[6];
    s16 cxr[6], cyr[6];
    xr[0] = yr[0] = -1 * OUTLINE_THRESHOLD;
    xr[1] = yr[1] = -1 * INLINE_THRESHOLD;
    xr[2] = yr[2] = -1 * UNUSABLE_ZONE_MAX;
    xr[3] = yr[3] = UNUSABLE_ZONE_MAX;
    xr[4] = yr[4] = INLINE_THRESHOLD;
    xr[5] = yr[5] = OUTLINE_THRESHOLD;
    ConvSDKToLCD(xr[0], yr[0], cxr[0], cyr[0]);
    ConvSDKToLCD(xr[1], yr[1], cxr[1], cyr[1]);
    ConvSDKToLCD(xr[2], yr[2], cxr[2], cyr[2]);
    ConvSDKToLCD(xr[3], yr[3], cxr[3], cyr[3]);
    ConvSDKToLCD(xr[4], yr[4], cxr[4], cyr[4]);
    ConvSDKToLCD(xr[5], yr[5], cxr[5], cyr[5]);
    
    switch( displayId )
    {
    case MAIN_LCD:
        m_WindowManager.DrawDisplay0();
        gfx->BeginDrawingShape();
        //gfx->SetColor( nw::ut::Color8::YELLOW );
        gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 0.0f, 1.0f );
        
        switch( m_DirectionId )
        {
        case CENTER0:
        case CENTER1:
        case CENTER2:
        case CENTER3:
        case CENTER4:
            // ~
            /*
            for( deg1 = 0.0f; deg1 < 360.0f; deg1 = deg2 )
            {
                deg2 = deg1 + 5.0f;
                x1 = RADIUS * CosDeg(deg1);
                y1 = RADIUS * SinDeg(deg1);
                x2 = RADIUS * CosDeg(deg2);
                y2 = RADIUS * SinDeg(deg2);
                ConvSDKToLCD( x1, y1, cx1, cy1);
                ConvSDKToLCD( x2, y2, cx2, cy2);
                gfx->m_DrawFramework->DrawLine(cx1, cy1, cx2, cy2);
            }
            */
            // `
            gfx->m_DrawFramework->SetColor( 0.0f, 0.2f, 0.8f, 0.2f );
            gfx->m_DrawFramework->
                FillRectangle(cxr[2], cyr[3], FAbs(cxr[3]-cxr[2]), FAbs(cyr[2]-cyr[3]));
            gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 0.0f, 1.0f );
            break;
        case UPPER:
            gfx->m_DrawFramework->
                FillRectangle(cxr[2], cyr[5], FAbs(cxr[3]-cxr[2]), FAbs(cyr[4]-cyr[5]));
            break;
        case RIGHT:
            gfx->m_DrawFramework->
                FillRectangle(cxr[4], cyr[3], FAbs(cxr[5]-cxr[4]), FAbs(cyr[2]-cyr[3]));
            break;
        case UNDER:
            gfx->m_DrawFramework->
                FillRectangle(cxr[2], cyr[1], FAbs(cxr[3]-cxr[2]), FAbs(cyr[0]-cyr[1]));
            break;
        case LEFT:
            gfx->m_DrawFramework->
                FillRectangle(cxr[0], cyr[3], FAbs(cxr[1]-cxr[0]), FAbs(cyr[2]-cyr[3]));
            break;
        }
        
        // XChpbh̋OՂ`
        gfx->m_DrawFramework->SetColor( 0.0f, 1.0f, 1.0f, 1.0f );
        gfx->m_DrawFramework->FillRectangle(m_ConvLcdRawX-2.0f, m_ConvLcdRawY-2.0f, 4.0f, 4.0f);
        LocusDisplay( m_LocusVisible );
        break;
        
    case SUB_LCD:
        m_JpegDrawer->DrawPicture(NN_GX_DISPLAY1);
        gfx->BeginDrawingShape();
        break;
    }
}

void CalAnalogStick::UpdateGraphicsDrawing_Information( void )
{
    char charTestMode[50] = "";
         if(m_TestMode == MODE_INITIALIZE)                 sprintf(charTestMode, "INITIALIZE");
    else if(m_TestMode == MODE_ON_YOUR_MARK)               sprintf(charTestMode, "ON YOUR MARK");
    else if(m_TestMode == MODE_SAMPLING)                   sprintf(charTestMode, "SAMPLING");
    else if(m_TestMode == MODE_CALIBRATION)                sprintf(charTestMode, "CALIBRATION");
    else if(m_TestMode == MODE_CHECK_MAX_OUTPUT_WIDTH)     sprintf(charTestMode, "MAX OUTPUT WIDTH");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT0) sprintf(charTestMode, "AUTO RESTORATION CT0");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_UP)  sprintf(charTestMode, "AUTO RESTORATION UP");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT1) sprintf(charTestMode, "AUTO RESTORATION CT1");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_RT)  sprintf(charTestMode, "AUTO RESTORATION RT");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT2) sprintf(charTestMode, "AUTO RESTORATION CT2");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_UN)  sprintf(charTestMode, "AUTO RESTORATION UN");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT3) sprintf(charTestMode, "AUTO RESTORATION CT3");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_LT)  sprintf(charTestMode, "AUTO RESTORATION LT");
    else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT4) sprintf(charTestMode, "AUTO RESTORATION CT4");
    else if(m_TestMode == MODE_SET_CAL)                    sprintf(charTestMode, "SET CAL");
    else if(m_TestMode == MODE_FINALIZE)                   sprintf(charTestMode, "FINALIZE");
    
    gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->SetFontSize( 8.0f );
    
    gfx->m_DrawFramework->DrawText(0,  0, "[Mode]");
    gfx->m_DrawFramework->DrawText(0, 10, "%s", charTestMode);
    gfx->m_DrawFramework->DrawText(0, 20, "");
    gfx->m_DrawFramework->DrawText(0, 30, "[Information]");
    gfx->m_DrawFramework->DrawText(0, 40, "raw:(%5d,%5d)", m_RawX, m_RawY);
    gfx->m_DrawFramework->DrawText(0, 50, "sdk:(%5d,%5d)", m_ConvSdkRawX, m_ConvSdkRawY);
    gfx->m_DrawFramework->DrawText(0, 60, "");
    gfx->m_DrawFramework->DrawText(0, 70, "x max:%5d", m_RawMaxX);
    gfx->m_DrawFramework->DrawText(0, 80, "  min:%5d", m_RawMinX);
    gfx->m_DrawFramework->DrawText(0, 90, "y max:%5d", m_RawMaxY);
    gfx->m_DrawFramework->DrawText(0,100, "  min:%5d", m_RawMinY);
    
    if(m_TestMode > MODE_CALIBRATION)
    {
    gfx->m_DrawFramework->DrawText(0,110, "");
    gfx->m_DrawFramework->DrawText(0,120, "center:(%5d,%5d)", m_CenterX, m_CenterY);
    gfx->m_DrawFramework->DrawText(0,130, "scale_x:%10.7f", m_ScaleX);
    gfx->m_DrawFramework->DrawText(0,140, "scale_y:%10.7f", m_ScaleY);
    }
    
    if(m_TestMode == MODE_CHECK_MAX_OUTPUT_WIDTH)
    {
    gfx->m_DrawFramework->DrawText(0,150, "");
    gfx->m_DrawFramework->DrawText(0,160, "%4d/%4d/%4d/%4d", m_CheckMax_ConvSdkRawY[0], m_CheckMax_ConvSdkRawX[0], 
                                                              m_CheckMax_ConvSdkRawY[1], m_CheckMax_ConvSdkRawX[1]);
    }
    
    if(m_TestMode >= MODE_CHECK_AUTO_RESTORATION_CT0)
    {
    gfx->m_DrawFramework->DrawText(0,150, "");
    gfx->m_DrawFramework->DrawText(0,160, "progress:%3.0f/100", m_pLyt->m_Progress);
    gfx->m_DrawFramework->DrawText(0,170, "time:     %2.f/ %2.f", (f32)(m_Time/1000), (f32)(TIMELIMIT_AR_TEST/1000));
    gfx->m_DrawFramework->DrawText(0,180, "retry:    %2d/ %2d", m_RetryFrequency[m_DirectionId], MAX_RETRY_FREQUENCY);
    }
    
#if CALANALOGSTICK_DEBUGGER==1
    // fobOp
    gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->SetFontSize( 8.0f );
    gfx->m_DrawFramework->DrawText(200,230, "(DEBUG: %06.lfsec)", m_Time * 0.001f );
#endif
    
}

/*---------------------------------------------------------------------------
  Desc: `̍XV
---------------------------------------------------------------------------*/
void CalAnalogStick::SwapBuffersAndWaitVsync( u8 displayId )
{
    using namespace nn::math;
    
    switch( displayId )
    {
    case MAIN_LCD:
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY0);
        break;
        
    case SUB_LCD:
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY1);
        break;
    }
}

//===========================================================================
//===========================================================================
//                    TvÕKChh~p
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: KChɏ]ăXChpbh͂Ă邩
        
        m_pLyt->m_zDegree       : KCh̊px : 
        (f32)SAMPLING_TOLERANCE : el       : 
        Ƃāu|ƁvƁu{Ɓv̂ꂼŏ𖞂ǂH
        
---------------------------------------------------------------------------*/
bool CalAnalogStick::IsWithinAcceptable( void )
{
        u16 fooST = SAMPLING_TOLERANCE%180;
        
        s16 fooX = m_RawX - 2048;
        s16 fooY = m_RawY - 2048;
        
        f32 fooA = m_pLyt->m_zDegree - (f32)fooST + 360; // A  -90 Jn̂
        f32 fooB = m_pLyt->m_zDegree + (f32)fooST;
        
        f32 fooC = FMod( fooA, 360 );
        f32 fooD = FMod( fooB, 360 );
        
        // X,Y ̒l 1548 ` 2548 (2048}500) ͈͓̔̏ꍇ OK Ƃ
        if( (fooX*fooX) + (fooY*fooY) <= (500*500) )
        {
            return true;
        }
        else if( fooST==0 )
        {
            return true;
        }
        else if( 0 < fooST && fooST <= 90  )
        {
                 if( fooC == 270 || fooD ==  90 ){ if( fooY < 0 )                  { return false; }}
            else if( fooC ==   0 || fooD == 180 ){ if( fooX < 0 )                  { return false; }}
            else if( fooC ==  90 || fooD == 270 ){ if( fooY > 0 )                  { return false; }}
            else if( fooC == 180 || fooD ==   0 ){ if( fooX > 0 )                  { return false; }}
            else if(   0 <  fooC && fooC <  180 ){ if( fooY > fooX / TanDeg(fooC) ){ return false; }}
            else if( 180 <  fooC && fooC <  360 ){ if( fooY < fooX / TanDeg(fooC) ){ return false; }}
            else if(   0 <  fooD && fooD <  180 ){ if( fooY < fooX / TanDeg(fooD) ){ return false; }}
            else if( 180 <  fooD && fooD <  360 ){ if( fooY > fooX / TanDeg(fooD) ){ return false; }}
            
            return true;
        }
        else if( 90 < fooST && fooST < 180 )
        {
                 if(                fooC ==   0 ){ if( fooX >= 0 )                  { return true; }}
            else if(                fooC ==  90 ){ if( fooY <= 0 )                  { return true; }}
            else if(                fooC == 180 ){ if( fooX <= 0 )                  { return true; }}
            else if(                fooC == 270 ){ if( fooY >= 0 )                  { return true; }}
            else if(   0 <  fooC && fooC <  180 ){ if( fooY <= fooX / TanDeg(fooC) ){ return true; }}
            else if( 180 <  fooC && fooC <  360 ){ if( fooY >= fooX / TanDeg(fooC) ){ return true; }}
            
                 if(                fooD ==   0 ){ if( fooX <= 0 )                  { return true; }}
            else if(                fooD ==  90 ){ if( fooY >= 0 )                  { return true; }}
            else if(                fooD == 180 ){ if( fooX >= 0 )                  { return true; }}
            else if(                fooD == 270 ){ if( fooY <= 0 )                  { return true; }}
            else if(   0 <  fooD && fooD <  180 ){ if( fooY >= fooX / TanDeg(fooD) ){ return true; }}
            else if( 180 <  fooD && fooD <  360 ){ if( fooY <= fooX / TanDeg(fooD) ){ return true; }}
            
            return false;
        }
        
        return false;
}

//===========================================================================
//===========================================================================
//                        Z^[Ap
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: XChpbh̒l肵Ă邩
---------------------------------------------------------------------------*/
void CalAnalogStick::IsStable( void )
{
    s16 deltaConvSdkRawX = 0;
    s16 deltaConvSdkRawY = 0;
    
    if( m_Rear > 1 )
    {
        deltaConvSdkRawX = m_pAnalogStickDataBuffer[m_Rear-1].conv_sdk_x -
                           m_pAnalogStickDataBuffer[m_Rear-2].conv_sdk_x;
        deltaConvSdkRawY = m_pAnalogStickDataBuffer[m_Rear-1].conv_sdk_y -
                           m_pAnalogStickDataBuffer[m_Rear-2].conv_sdk_y;
                           
#if 0
        IsEnable_NN_LOG("[%3d,%3d]%3d(%4d,%4d)\n",
        m_Rear, m_Front, m_IsStable, 
        m_pAnalogStickDataBuffer[m_Rear-1].conv_sdk_x, 
        m_pAnalogStickDataBuffer[m_Rear-1].conv_sdk_x);
#endif
    }
    else if( m_Rear == 1 )
    {
        deltaConvSdkRawX = m_pAnalogStickDataBuffer[0].conv_sdk_x -
                           m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_sdk_x;
        deltaConvSdkRawY = m_pAnalogStickDataBuffer[0].conv_sdk_y -
                           m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_sdk_y;
                           
#if 0
        IsEnable_NN_LOG("[%3d,%3d]%3d(%4d,%4d)\n",
        m_Rear, m_Front, m_IsStable, 
        m_pAnalogStickDataBuffer[0].conv_sdk_x, 
        m_pAnalogStickDataBuffer[0].conv_sdk_x);
#endif
    }
    else if( m_Rear == 0 )
    {
        deltaConvSdkRawX = m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_sdk_x -
                           m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-2].conv_sdk_x;
        deltaConvSdkRawY = m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_sdk_y -
                           m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-2].conv_sdk_y;
                           
#if 0
        IsEnable_NN_LOG("[%3d,%3d]%3d(%4d,%4d)\n",
        m_Rear, m_Front, m_IsStable, 
        m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_sdk_x, 
        m_pAnalogStickDataBuffer[RAW_DATA_BUFFER_SIZE-1].conv_sdk_x);
#endif
    }
    
    if( FAbs(deltaConvSdkRawX)<=2 && FAbs(deltaConvSdkRawY)<=2 ) m_IsStable += 1;
    else                                                         m_IsStable  = 0;
    
}

/*---------------------------------------------------------------------------
  Desc: Lȃp[^ł邩
---------------------------------------------------------------------------*/
bool CalAnalogStick::IsValidParameter( void )
{
    switch( m_DirectionId )
    {
    case CENTER0:
    case CENTER1:
    case CENTER2:
    case CENTER3:
    case CENTER4:
        // ~
        //if((m_ConvSdkRawX * m_ConvSdkRawX) + (m_ConvSdkRawY * m_ConvSdkRawY)
        //    <= (UNUSABLE_ZONE_MAX * UNUSABLE_ZONE_MAX)) 
        
        // `
        if(FAbs(m_ConvSdkRawX)<=FAbs(UNUSABLE_ZONE_MAX) && 
           FAbs(m_ConvSdkRawY)<=FAbs(UNUSABLE_ZONE_MAX))
        {
            // 5JEg肷܂ő҂
            IsStable();
            if( m_IsStable > 5 )
            {
                m_IsValidParameter = m_IsStable - 5;
            }
            else if( m_IsStable == 0 )
            {
                m_IsValidParameter = 0;
            }
        }
        else
        {
            m_IsValidParameter = 0;
        }
        break;
    case UPPER:
        if((INLINE_THRESHOLD <= m_ConvSdkRawY && m_ConvSdkRawY <= OUTLINE_THRESHOLD) &&
           (-1 * UNUSABLE_ZONE_MAX <= m_ConvSdkRawX && m_ConvSdkRawX <= UNUSABLE_ZONE_MAX))
                                                         m_IsValidParameter += 1;
        else                                             m_IsValidParameter  = 0;
        break;
    case RIGHT:
        if((INLINE_THRESHOLD <= m_ConvSdkRawX && m_ConvSdkRawX <= OUTLINE_THRESHOLD) &&
           (-1 * UNUSABLE_ZONE_MAX <= m_ConvSdkRawY && m_ConvSdkRawY <= UNUSABLE_ZONE_MAX))
                                                         m_IsValidParameter += 1;
        else                                             m_IsValidParameter  = 0;
        break;
    case UNDER:
        if((-1 * OUTLINE_THRESHOLD <= m_ConvSdkRawY && m_ConvSdkRawY <= -1 * INLINE_THRESHOLD) &&
           (-1 * UNUSABLE_ZONE_MAX <= m_ConvSdkRawX && m_ConvSdkRawX <= UNUSABLE_ZONE_MAX))
                                                         m_IsValidParameter += 1;
        else                                             m_IsValidParameter  = 0;
        break;
    case LEFT:
        if((-1 * OUTLINE_THRESHOLD <= m_ConvSdkRawX && m_ConvSdkRawX <= -1 * INLINE_THRESHOLD) &&
           (-1 * UNUSABLE_ZONE_MAX <= m_ConvSdkRawY && m_ConvSdkRawY <= UNUSABLE_ZONE_MAX))
                                                         m_IsValidParameter += 1;
        else                                             m_IsValidParameter  = 0;
        break;
    }
    
    if( m_IsValidParameter >= COUNT_AR_TEST ) return true;
    else                                      return false;
}

/*---------------------------------------------------------------------------
  Desc: Z^[A\ł̃[hڍs
---------------------------------------------------------------------------*/
bool CalAnalogStick::ChangeTestMode( f32 progress, AnalogStickTestMode& mode )
{
    if( progress > 0  && m_IsRetried == false )
    {
        m_IsRetried = true;
    }
    
    if( progress == 0 && m_IsRetried == true  )
    {
        // Õ[hɖ߂ɁA[h̃gC񐔂CNg
        ++m_RetryFrequency[m_DirectionId];
        
        // Õ[hɖ߂
             if(mode == MODE_CHECK_AUTO_RESTORATION_CT1) mode = MODE_CHECK_AUTO_RESTORATION_UP;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT2) mode = MODE_CHECK_AUTO_RESTORATION_RT;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT3) mode = MODE_CHECK_AUTO_RESTORATION_UN;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT4) mode = MODE_CHECK_AUTO_RESTORATION_LT;
    }
    
    if( progress == 100 )
    {
        // SDJ[hɃf[^oׂ͂ɋL^
        int i=0;
             if(mode == MODE_CHECK_AUTO_RESTORATION_CT0)  i = 0;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT1)  i = 1;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT2)  i = 2;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT3)  i = 3;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT4)  i = 4;
        {
            m_RawX_AR[i] = m_RawX;
            m_RawY_AR[i] = m_RawY;
            ConvRawDataToSDK(m_RawX_AR[i], m_RawY_AR[i], m_ConvSdkRawX_AR[i], m_ConvSdkRawY_AR[i]);
        }
        
        // S`FbNI
        if(mode == MODE_CHECK_AUTO_RESTORATION_CT4) return true;
            
        // [hڍsɑO[h̃gC񐔂Zbg
        m_RetryFrequency[m_DirectionId] = 0;
        
        // [hֈڍs
             if(mode == MODE_CHECK_AUTO_RESTORATION_CT0) mode = MODE_CHECK_AUTO_RESTORATION_UP;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_UP)  mode = MODE_CHECK_AUTO_RESTORATION_CT1;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT1) mode = MODE_CHECK_AUTO_RESTORATION_RT;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_RT)  mode = MODE_CHECK_AUTO_RESTORATION_CT2;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT2) mode = MODE_CHECK_AUTO_RESTORATION_UN;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_UN)  mode = MODE_CHECK_AUTO_RESTORATION_CT3;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_CT3) mode = MODE_CHECK_AUTO_RESTORATION_LT;
        else if(mode == MODE_CHECK_AUTO_RESTORATION_LT)  mode = MODE_CHECK_AUTO_RESTORATION_CT4;
    }
    
    if( ( m_IsValidParameter == 0 && m_IsRetried == true  ) || ( progress == 100 ) )
    {
        // tBMPt@C\ؑ
        switch( mode )
        {
        case MODE_CHECK_AUTO_RESTORATION_CT0:
        case MODE_CHECK_AUTO_RESTORATION_CT1:
        case MODE_CHECK_AUTO_RESTORATION_CT2:
        case MODE_CHECK_AUTO_RESTORATION_CT3:
        case MODE_CHECK_AUTO_RESTORATION_CT4:
            m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_center.jpg");
            break;
        case MODE_CHECK_AUTO_RESTORATION_UP:
            m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_upper.jpg");
            break;
        case MODE_CHECK_AUTO_RESTORATION_RT:
            m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_right.jpg");
            break;
        case MODE_CHECK_AUTO_RESTORATION_UN:
            m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_under.jpg");
            break;
        case MODE_CHECK_AUTO_RESTORATION_LT:
            m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_left.jpg");
            break;
        }
        
        // 
        {
            InitializeBuffer();
            m_IsStable         = 0;
            m_IsValidParameter = 0;
            m_IsRetried = false;
            m_Start = nn::os::Tick::GetSystemCurrent();
        }
    }
    
    return false;
}

//===========================================================================
//===========================================================================
//                        NAND(CAL)ւ̏݊֐
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: b`kւ̏ݏ
---------------------------------------------------------------------------*/
void CalAnalogStick::PresetCalAnalogStick( void )
{
    m_CalDataCore.center_x      = m_CenterX;
    m_CalDataCore.center_y      = m_CenterY;
#if NN_VERSION_REVISION==22048
//SDK 0.11 PEE
    m_CalDataCore.in            = 0;
    m_CalDataCore.out           = 0;
#else
//SDK 0.12 PEEȍ~
    for( int i=0; i<1; i++ ) m_CalDataCore.reserve[i]=0;
#endif
    
    m_CalAppendCore.scale_x     = m_ScaleX;
    m_CalAppendCore.scale_y     = m_ScaleY;
    m_CalAppendCore.max_x       = m_RawMaxX;
    m_CalAppendCore.min_x       = m_RawMinX;
    m_CalAppendCore.max_y       = m_RawMaxY;
    m_CalAppendCore.min_y       = m_RawMinY;
    m_CalAppendCore.type        = m_Type;
    for( int i=0; i<3; i++ ) m_CalAppendCore.reserve[i]=0;
}

/*---------------------------------------------------------------------------
  Desc: b`kւ̏
---------------------------------------------------------------------------*/
s32 CalAnalogStick::SetCalAnalogStick( void )
{
    using namespace nn::drivers::cal::CTR;
    
    enum ERROR_SEQ {
        PASS        =  0,
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };
    
    Calibration cal;
    AnalogStickCalDataCore   calDataCore;
    AnalogStickCalAppendCore calAppendCore;
    
    // CAL ̏
    cal.Initialize();
    
    // l̎擾
    if( !cal.Get(&calDataCore,  CAL_DATA_ANALOG_STICK))         { return ERROR_GET; }
    if( !cal.Get(&calAppendCore,CAL_DATA_ANALOG_STICK_APPEND))  { return ERROR_GET; }
    
    calDataCore.center_x    = m_CalDataCore.center_x;
    calDataCore.center_y    = m_CalDataCore.center_y;
#if NN_VERSION_REVISION==22048
//SDK 0.11 PEE
    calDataCore.in          = 0;
    calDataCore.out         = 0;
#else
//SDK 0.12 PEEȍ~
    for( int i=0; i<1; i++ ) calDataCore.reserve[i]=0;
#endif
    
    calAppendCore.scale_x   = m_CalAppendCore.scale_x;
    calAppendCore.scale_y   = m_CalAppendCore.scale_y;
    calAppendCore.max_x     = m_CalAppendCore.max_x;
    calAppendCore.min_x     = m_CalAppendCore.min_x;
    calAppendCore.max_y     = m_CalAppendCore.max_y;
    calAppendCore.min_y     = m_CalAppendCore.min_y;
    calAppendCore.type      = m_CalAppendCore.type;
    for( int i=0; i<3; i++ ) calAppendCore.reserve[i]=0;
    
    // l̐ݒ
    if( !cal.Set(&calDataCore,  CAL_DATA_ANALOG_STICK))         { return ERROR_SET; }
    if( !cal.Set(&calAppendCore,CAL_DATA_ANALOG_STICK_APPEND))  { return ERROR_SET; }
    
    // t@Cɕۑ
    if( !cal.Flush() )  { return ERROR_FLUSH; }
    
    return PASS;
}

//===========================================================================
//===========================================================================
//                            SDւ̃Oo
//===========================================================================
//===========================================================================

    // o̓f[^̕\
    const char CALANALOGSTICK_TITLE[512] = 
#if EVALUATE_TESTER_MODE==1
    "m_RawX,"       // x  l
    "m_RawY,"       // y  l
    "\n";
#else
    "MacAddress,"   // MACAhX
    "Xraw(MAX),"    // l +x ől
    "Xraw(min),"    // l -x ől
    "Yraw(MAX),"    // l +y ől
    "Yraw(min),"    // l -y ől
    "Xcenter,"      // ␳̒_ x W
    "Ycenter,"      // ␳̒_ y W
    "Xscale,"       // ␳ x XP[
    "Yscale,"       // ␳ y XP[
    "Xcheck(MAX),"  // SDKiƓljł +x ől
    "Xcheck(min),"  // SDKiƓljł -x ől
    "Ycheck(MAX),"  // SDKiƓljł +y ől
    "Ycheck(min),"  // SDKiƓljł -y ől
    "Xraw(U->C),"   // ̃Z^[Al x W
    "Yraw(U->C),"   // ̃Z^[Al y W
    "Xraw(R->C),"   // ẼZ^[Al x W
    "Yraw(R->C),"   // ẼZ^[Al y W
    "Xraw(D->C),"   // ̃Z^[Al x W
    "Yraw(D->C),"   // ̃Z^[Al y W
    "Xraw(L->C),"   // ̃Z^[Al x W
    "Yraw(L->C),"   // ̃Z^[Al y W
    "X(U->C),"      // ̃Z^[A SDKiƓljł x W
    "Y(U->C),"      // ̃Z^[A SDKiƓljł y W
    "X(R->C),"      // ẼZ^[A SDKiƓljł x W
    "Y(R->C),"      // ẼZ^[A SDKiƓljł y W
    "X(D->C),"      // ̃Z^[A SDKiƓljł x W
    "Y(D->C),"      // ̃Z^[A SDKiƓljł y W
    "X(L->C),"      // ̃Z^[A SDKiƓljł x W
    "Y(L->C),"      // ̃Z^[A SDKiƓljł y W
    "Result,"       // 
    "\n";
#endif

/*---------------------------------------------------------------------------
  Desc: fBNgJȂꍇ͐VK쐬

  Args: path        Ώۃt@C̃tpX

  Rtns: Ȃ
---------------------------------------------------------------------------*/
bool CalAnalogStick::CreateDirectorySdmc(const wchar_t* path)
{
    nn::fs::Directory dir;
    nn::Result nnResult = dir.TryInitialize( path );
    
    // fBNgȂꍇ͐VK쐬
    if(nnResult.IsFailure())
    {
        IsEnable_NN_LOG("@ Can't Initialize! So Create Directory... \n");
        
        nnResult = nn::fs::TryCreateDirectory( path );
        
        if(nnResult.IsFailure())
        {
            IsEnable_NN_LOG("* Warning: No Create Directory!\n");
            return false;
        }
    }
    else
    {
        dir.Finalize();
    }
    return true;
}

/*---------------------------------------------------------------------------
  Desc: Ώۃt@CɃf[^݂܂

  Args: path        Ώۃt@C̃tpX
        strBuf      ރf[^

  Rtns: Ȃ
---------------------------------------------------------------------------*/
bool CalAnalogStick::WriteData2SD(const wchar_t* path, string strBuf)
{
    // t@C݂߂̃IuWFNg쐬
    nn::fs::FileStream fos;
    nn::Result nnResult = fos.TryInitialize(path, nn::fs::OPEN_MODE_READ   | 
                                                  nn::fs::OPEN_MODE_WRITE  | 
                                                  nn::fs::OPEN_MODE_CREATE );
    if(nnResult.IsSuccess())
    {
        s64 size = fos.GetSize();
        IsEnable_NN_LOG("FILE_SIZE= %lld\n", size);
        
        if(size == 0)
        {
            // ̂
            fos.Write(CALANALOGSTICK_TITLE, strlen(CALANALOGSTICK_TITLE));
        }
        else
        {
            // ڈȍ~
            fos.Seek( -1, nn::fs::POSITION_BASE_END );
        }
        fos.Write(strBuf.c_str(), strlen(strBuf.c_str()));
        fos.Write("@", 1);
        
        // t@C
        fos.Finalize();
        
        return true;
    }
    else
    {
        // t@C
        fos.Finalize();
        
        return false;
    }
    
}


//===========================================================================
//===========================================================================
//                            C֐
//===========================================================================
//===========================================================================
/*
    MODE_INITIALIZE                =  0,    // 
    MODE_ON_YOUR_MARK              =  1,    // JnO
    MODE_SAMPLING                  =  2,    // ␳p̃f[^W
    MODE_CALIBRATION               =  3,    // ␳iEsj
    MODE_CHECK_MAX_OUTPUT_WIDTH    =  4,    // ől͉ۊmF
    MODE_CHECK_AUTO_RESTORATION_CT0 = 5,    // A\ij
    MODE_CHECK_AUTO_RESTORATION_CT1 = 6,    // A\iとALj
    MODE_CHECK_AUTO_RESTORATION_CT2 = 7,    // A\iEALj
    MODE_CHECK_AUTO_RESTORATION_CT3 = 8,    // A\iALj
    MODE_CHECK_AUTO_RESTORATION_CT4 = 9,    // A\iALj
    MODE_CHECK_AUTO_RESTORATION_UP = 10,    // A\ij
    MODE_CHECK_AUTO_RESTORATION_RT = 11,    // A\iEj
    MODE_CHECK_AUTO_RESTORATION_UN = 12,    // A\ij
    MODE_CHECK_AUTO_RESTORATION_LT = 13,    // A\ij
    MODE_WRITE_DATA_TO_SD          = 14,    // SDJ[hɌf[^o
    MODE_SET_CAL                   = 15,    // NAND(CAL)ɏ
    MODE_FINALIZE                  = 16,    // I
*/

/*---------------------------------------------------------------------------
  Desc: ֐
---------------------------------------------------------------------------*/
bool CalAnalogStick::ExecuteInitialize( void )
{
    m_TestMode = MODE_INITIALIZE;
    IsEnable_NN_LOG("\n[ MODE_INITIALIZE ]\n");
    
    m_pLyt = new LytAnalogStick;
    m_pAsCal = new nn::hid::AnalogStickCalibrator();
    m_JpegDrawer = new sys::JpegDrawer;
    
    uji::seq::Config config;
    
    // ϐ̏
    {
        UNUSABLE_ZONE_MAX    = config.Get().UnusableZone;
        SAMPLING_LAP_TIME    = config.GetAlternative().SamplingLapTime;
        SAMPLING_ROUND       = config.GetAlternative().SamplingRound;
        SAMPLING_TOLERANCE   = config.Get().SamplingTolerance;
        RAW_DATA_BUFFER_SIZE = config.Get().RawDataBufferSize;
        TEST_MARGIN_MOW_TEST = config.Get().TestMarginMaxOutputWidth;
        COUNT_AR_TEST        = config.Get().CountAutoRestoration;
        TIMELIMIT_TEST_START = config.Get().TimelimitTestStart * 1000;
        TIMELIMIT_AR_TEST    = config.Get().TimelimitAutoRestoration * 1000;
        MAX_RETRY_FREQUENCY  = config.Get().MaxRetryFrequency;
        WRITE_DATA_TO_SD     = config.Get().WriteData2SdSlidePad;
        
        m_TestMode = MODE_ON_YOUR_MARK;
        m_IsConvRawDataFlag = true;
        m_WasSampledFlag    = false;
        m_LocusVisible      = false;
        m_IsOver60Volts     = false;
        m_IsInRange         = false;
        m_IsRetried         = false;
        m_IsMaxOutputWidthValid = 0;
        m_IsValidParameter      = 0;
        m_IsStable              = 0;
        
        m_Front = 0;
        m_Rear  = 0;
        
        m_RawX = 2048;
        m_RawY = 2048;
        ConvRawDataToLCD(m_RawX, m_RawY, m_ConvLcdRawX, m_ConvLcdRawY);
        m_ConvSdkRawX = 0;
        m_ConvSdkRawY = 0;
        
        m_Type = 0;
        
        m_RawMaxX = static_cast<s16>(DEFAULT_CENTER);
        m_RawMinX = static_cast<s16>(DEFAULT_CENTER);
        m_RawMaxY = static_cast<s16>(DEFAULT_CENTER);
        m_RawMinY = static_cast<s16>(DEFAULT_CENTER);
        
        m_CenterX = RAWMAX >> 1;
        m_CenterY = RAWMAX >> 1;
        m_ScaleX = 1.f;
        m_ScaleY = 1.f;
        
        m_DirectionId = CENTER0;
        for(int i=0; i<DIRECTION_NUM; ++i)
        {
            m_RetryFrequency[i] = 0;
        }
        
        m_Start   = nn::os::Tick(0);
        m_Current = nn::os::Tick(0);
        m_Time    = (m_Current-m_Start).ToTimeSpan().GetMilliSeconds();
        
        for(int i=0; i<2; ++i)
        {
            m_CheckMax_ConvSdkRawX[i] = 0;
            m_CheckMax_ConvSdkRawY[i] = 0;
        }
        for(int i=0; i<5; ++i)
        {
            m_RawX_AR[i] = 0;
            m_RawY_AR[i] = 0;
            m_ConvSdkRawX_AR[i] = 0;
            m_ConvSdkRawY_AR[i] = 0;
        }
        
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro  = 0;
        sprintf(m_TestResult.m_String, "");
        
#if EVALUATE_TESTER_MODE==1
        for( int i=0; i<2; i++){
            for( int j=0; j<2000; j++){
                m_BufferForEvaluation[i][j]=0;
            }
        }
        m_BufNum = 0;
#endif
    }
    
    SetBlackBackGroundColor();
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_upper.jpg");
#if CALANALOGSTICK_WINDOW_VISIBLE==1
    CreateWindows();
#endif
    StartThread();
    m_pAsCal->StartCalibration();   // Lu[VJn
    InitializeBuffer();
    
    // CAEgNX̃CX^X쐬
    m_pLyt->Initialize();
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc: I֐
  ̊֐͊e֐̃G[łsׁAm_TestResult ͕ύXȂ
---------------------------------------------------------------------------*/
bool CalAnalogStick::ExecuteFinalize( void )
{
    m_TestMode = MODE_FINALIZE;
    IsEnable_NN_LOG("\n[ MODE_FINALIZE ]\n");
    
    m_pLyt->Finalize();
    
    FinalizeBuffer();
    StopThread();
#if CALANALOGSTICK_WINDOW_VISIBLE==1
    DestroyWindows();
#endif
    m_JpegDrawer->ClosePicture();
    SetDefaultBackGroundColor();
    
    delete m_JpegDrawer;
    delete m_pAsCal;
    delete m_pLyt;
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc: TvOJnȌʒuֈړ
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteOnYourMark( void )
{
    m_TestMode = MODE_ON_YOUR_MARK;
    IsEnable_NN_LOG("\n[ MODE_ON_YOUR_MARK ]\n");
    
    enum enumMicroErrorId
    {
        TIMEOUT_ON_YOUR_MARK = 0,
        MICRO_ERROR_NUM      = 1
    };
    
    uji::sys::Pad pad;
    m_LocusVisible = false;
    InitializeBuffer();
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_upper.jpg");
    m_Start = nn::os::Tick::GetSystemCurrent();
    
    do
    {
        pad.UpdatePad();
#if CALANALOGSTICK_WINDOW_VISIBLE==1
        UpdateWindows();
#endif
        
        PrepareGraphicsDrawing(0);          // tO
        m_pLyt->UpdateLayout(m_TestMode);   // tCAEg
        UpdateGraphicsDrawing(0);           // tOtBbNX
#if CALANALOGSTICK_WINDOW_VISIBLE==0
        UpdateGraphicsDrawing_Information();
#endif
        SwapBuffersAndWaitVsync(0);         // tXV
        PrepareGraphicsDrawing(1);          // tO
        UpdateGraphicsDrawing(1);           // tOtBbNX
        SwapBuffersAndWaitVsync(1);         // tXV
        
        // 
        // *1 ^CAEg
        m_Current = nn::os::Tick::GetSystemCurrent();
        m_Time    = (m_Current-m_Start).ToTimeSpan().GetMilliSeconds();
        if( m_Time > TIMELIMIT_TEST_START )
        {
            sprintf(m_TestResult.m_String, "Time out(%dms).", TIMELIMIT_TEST_START);
            m_TestResult.m_Result = false;
            m_TestResult.m_Micro  = TIMEOUT_ON_YOUR_MARK;
            ExecuteWriteData2SD();
            ExecuteFinalize();
            return;
        }
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(m_RawY < CALMAX);
    
    m_TestResult.m_Result = true;
}

/*---------------------------------------------------------------------------
  Desc: Lu[VpɐlTvO
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteSampling( void )
{
    m_TestMode = MODE_SAMPLING;
    IsEnable_NN_LOG("\n[ MODE_SAMPLING ]\n");
    
    // LINE [hȊOł̓TvOȂ
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        sprintf(m_TestResult.m_String, "It is not executed in the QC mode.");
        m_TestResult.m_Result = true;
        return;     // I
    }
    
    uji::sys::Pad pad;
    bool breakFlag = false;
    m_LocusVisible = true;
    InitializeBuffer();
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_x3.jpg");
    
    m_Start = nn::os::Tick::GetSystemCurrent();
    
    do
    {
        m_Current = nn::os::Tick::GetSystemCurrent();
        m_Time    = (m_Current-m_Start).ToTimeSpan().GetMilliSeconds();
        if( 360 * SAMPLING_ROUND * SAMPLING_LAP_TIME >= 360 * m_Time )
        {
            m_pLyt->m_zDegree = (f32)( 360 * m_Time / SAMPLING_LAP_TIME );
        }
        else
        {
            m_pLyt->m_zDegree = 360 * SAMPLING_ROUND;
            breakFlag = true;
        }
        
        pad.UpdatePad();
#if CALANALOGSTICK_WINDOW_VISIBLE==1
        UpdateWindows();
#endif
        
        PrepareGraphicsDrawing(0);          // tO
        m_pLyt->UpdateLayout(m_TestMode);   // tCAEg
        UpdateGraphicsDrawing(0);           // tOtBbNX
#if CALANALOGSTICK_WINDOW_VISIBLE==0
        UpdateGraphicsDrawing_Information();
#endif
        SwapBuffersAndWaitVsync(0);         // tXV
        PrepareGraphicsDrawing(1);          // tO
        UpdateGraphicsDrawing(1);           // tOtBbNX
        SwapBuffersAndWaitVsync(1);         // tXV
        
        // KChɑ΂ċe͈͂𒴂lTvOꂽꍇ NG Ƃ
        if( false == IsWithinAcceptable() )
        {
            sprintf(m_TestResult.m_String, "Exceeded the allowed values.");
            m_TestResult.m_Result = false;
            ExecuteWriteData2SD();
            ExecuteFinalize();
            return;
        }
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while( breakFlag==false );
    
    m_TestResult.m_Result = true;
}

/*---------------------------------------------------------------------------
  Desc: Lu[V֐
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteCalibrate( void )
{
    m_TestMode = MODE_CALIBRATION;
    IsEnable_NN_LOG("\n[ MODE_CALIBRATION ]\n");
    
    // LINE [hȊOł͔肵Ȃ
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        sprintf(m_TestResult.m_String, "It is not executed in the QC mode.");
        m_TestResult.m_Result = true;
        return;     // I
    }
    
    enum enumMicroErrorId
    {
        LOWER_OUTPUT_VOLTAGE = 0,
        CENTER_OUTSIDE_SPEC  = 1,
        FAIL_STOPCALIBRATION = 2,
        
        MICRO_ERROR_NUM      = 3
    };
    
    m_LocusVisible = false;
    InitializeBuffer();
    
    // 
    // *2 o͕60%𒴂Ă邱
    m_IsOver60Volts = (((m_RawMaxX - m_RawMinX > VOLTAGE_MIN) && 
                        (m_RawMaxY - m_RawMinY > VOLTAGE_MIN)) ? true : false);
    if( m_IsOver60Volts==false )
    {
        IsEnable_NN_LOG("* Warning: The output voltage is lower than specs. \n");
        sprintf(m_TestResult.m_String, 
            "X(%5d-%5d) Y(%5d-%5d)", m_RawMaxX, m_RawMinX, m_RawMaxY, m_RawMinY);
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro  = LOWER_OUTPUT_VOLTAGE;
        ExecuteWriteData2SD();
        ExecuteFinalize();
        return;
    }
    
    // 
    // *3 m_CenterX,m_CenterY ̒l RAWMAX * (50%}6.5%) ͈͓̔ł邱
    m_IsInRange = ((m_CenterX > DELTA_MIN && m_CenterX < DELTA_MAX &&
                    m_CenterY > DELTA_MIN && m_CenterY < DELTA_MAX) ? true : false);
    if( m_IsInRange==false )
    {
        IsEnable_NN_LOG("* Warning: The center is outside of product spec. \n");
        sprintf(m_TestResult.m_String, "center=(%d %d)", m_CenterX, m_CenterY);
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro  = CENTER_OUTSIDE_SPEC ;
        ExecuteWriteData2SD();
        ExecuteFinalize();
        return;
    }
    
    // 
    // *4 Lu[ViTvOjI
    nn::Result nnResult = m_pAsCal->StopCalibration(true);
    if(nnResult.IsFailure())
    {
        IsEnable_NN_LOG("* Warning: It failed to 'StopCalibration()'. \n");
        sprintf(m_TestResult.m_String, "It failed to 'StopCalibration()'.");
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro  = FAIL_STOPCALIBRATION ;
        ExecuteWriteData2SD();
        ExecuteFinalize();
        return;
    }
    
    // Lu[Vl擾
    m_pAsCal->GetCalibrateParam(&m_asCalData);
    
    // XbhŃTvOlSDK֐Ŏ擾lr
    IsEnable_NN_LOG("\n");
    IsEnable_NN_LOG(" m_ScaleX  : %9.7f | %9.7f : m_asCalData.scale_x\n",  m_ScaleX,  m_asCalData.scale_x);
    IsEnable_NN_LOG(" m_ScaleY  : %9.7f | %9.7f : m_asCalData.scale_y\n",  m_ScaleY,  m_asCalData.scale_y);
    IsEnable_NN_LOG(" m_CenterX : %7d   | %7d   : m_asCalData.center_x\n", m_CenterX, m_asCalData.center_x);
    IsEnable_NN_LOG(" m_CenterY : %7d   | %7d   : m_asCalData.center_y\n", m_CenterY, m_asCalData.center_y);
    IsEnable_NN_LOG(" m_RawMaxX : %7d   | %7d   : m_asCalData.max_x\n",    m_RawMaxX, m_asCalData.max_x);
    IsEnable_NN_LOG(" m_RawMinX : %7d   | %7d   : m_asCalData.min_x\n",    m_RawMinX, m_asCalData.min_x);
    IsEnable_NN_LOG(" m_RawMaxY : %7d   | %7d   : m_asCalData.max_y\n",    m_RawMaxY, m_asCalData.max_y);
    IsEnable_NN_LOG(" m_RawMinY : %7d   | %7d   : m_asCalData.min_y\n",    m_RawMinY, m_asCalData.min_y);
    IsEnable_NN_LOG(" m_Type    : %7d   | %7d   : m_asCalData.type\n",     m_Type,    m_asCalData.type);
    IsEnable_NN_LOG("\n");
    
    
    // SDK֐Ŏ擾lɍXVi͂j
    m_ScaleX  = m_asCalData.scale_x;
    m_ScaleY  = m_asCalData.scale_y;
    m_CenterX = m_asCalData.center_x;
    m_CenterY = m_asCalData.center_y;
    m_RawMaxX = m_asCalData.max_x;
    m_RawMinX = m_asCalData.min_x;
    m_RawMaxY = m_asCalData.max_y;
    m_RawMinY = m_asCalData.min_y;
    m_Type    = m_asCalData.type;
    
    // TvO˃Lu[V{ꍇ true 
    m_WasSampledFlag = true;
    
    m_TestResult.m_Result = true;
}

/*---------------------------------------------------------------------------
  Desc: őŏl͉̓ۊmF
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteCheckMaxOutputWidth( void )
{
    m_TestMode = MODE_CHECK_MAX_OUTPUT_WIDTH;
    IsEnable_NN_LOG("\n[ MODE_CHECK_MAX_OUTPUT_WIDTH ]\n");
    
    uji::seq::Config config;
    
    /*
        LINE [hȊÕ[hAvZX`FbŇł́ATvO
        Lu[V͎{ȂB
        ׁ̈ATvOtO true ɂACAL ݒlǂݍށB
    */
    if( config.Get().TestMode != uji::seq::pl::LINE || m_WasSampledFlag ==false )
    {
        // CAL ݒlǂݍ
        SetParameterFromCAL();
        // TvOtO true ɂ
        m_WasSampledFlag = true;
    }
    
    enum enumMicroErrorId
    {
        FAIL_GET_MOW         = 0,
        
        MICRO_ERROR_NUM      = 1
    };
    
    uji::sys::Pad pad;
    bool breakFlag = false;
    
    m_LocusVisible = true;
    InitializeBuffer();
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_x1.jpg");
    m_Start = nn::os::Tick::GetSystemCurrent();
    
    do
    {
        m_Current = nn::os::Tick::GetSystemCurrent();
        m_Time    = (m_Current-m_Start).ToTimeSpan().GetMilliSeconds();
        if( 360 * SAMPLING_LAP_TIME >= 360 * m_Time )
        {
            m_pLyt->m_zDegree = (f32)(360 * m_Time / SAMPLING_LAP_TIME);
        }
        else
        {
            m_pLyt->m_zDegree = 360;
            breakFlag = true;
        }
        
        pad.UpdatePad();
#if CALANALOGSTICK_WINDOW_VISIBLE==1
        UpdateWindows();
#endif
        
        PrepareGraphicsDrawing(0);          // tO
        m_pLyt->UpdateLayout(m_TestMode);   // tCAEg
        UpdateGraphicsDrawing(0);           // tOtBbNX
#if CALANALOGSTICK_WINDOW_VISIBLE==0
        UpdateGraphicsDrawing_Information();
#endif
        SwapBuffersAndWaitVsync(0);         // tXV
        PrepareGraphicsDrawing(1);          // tO
        UpdateGraphicsDrawing(1);           // tOtBbNX
        SwapBuffersAndWaitVsync(1);         // tXV
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while( breakFlag==false );
    
    // 
    // *5 SDKł̍őŏlinn::hid::LIMIT_OF_STICK_CLAMP_MAXj͂ł邱
    if( m_IsMaxOutputWidthValid < 0xF )
    {
        sprintf(m_TestResult.m_String, " %4d/%4d/%4d/%4d", 
            m_CheckMax_ConvSdkRawY[0], m_CheckMax_ConvSdkRawX[0], 
            m_CheckMax_ConvSdkRawY[1], m_CheckMax_ConvSdkRawX[1]);
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro  = FAIL_GET_MOW ;
        ExecuteWriteData2SD();
        ExecuteFinalize();
    }
    else
    {
        m_TestResult.m_Result = true;
    }
}

/*---------------------------------------------------------------------------
  Desc: Z^[A\
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteCheckAutoRestoration( void )
{
    m_TestMode = MODE_CHECK_AUTO_RESTORATION_CT0;
    IsEnable_NN_LOG("\n[ MODE_CHECK_AUTO_RESTORATION ]\n");
    
    /*
        LINE [hȊÕ[hAvZX`FbŇł́ATvO
        Lu[V͎{ȂB
        ׁ̈ATvOtO true ɂACAL ݒlǂݍށB
    */
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE || m_WasSampledFlag ==false )
    {
        // TvOtO true ɂ
        m_WasSampledFlag = true;
        // CAL ݒlǂݍ
        SetParameterFromCAL();
    }
    
    enum enumMicroErrorId
    {
        EXCEED_RETRY_LIMIT   = 0,
        TIMEOUT_AR_TEST      = 1,
        
        MICRO_ERROR_NUM      = 2
    };
    
    uji::sys::Pad pad;
    bool breakFlag = false;
    m_WasSampledFlag = true;
    m_LocusVisible = true;
    InitializeBuffer();
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_center.jpg");
    m_Start = nn::os::Tick::GetSystemCurrent();
    
    do
    {
        pad.UpdatePad();
#if CALANALOGSTICK_WINDOW_VISIBLE==1
        UpdateWindows();
#endif
        
        switch( m_TestMode )
        {
        case MODE_CHECK_AUTO_RESTORATION_CT0:    m_DirectionId = CENTER0;    break;
        case MODE_CHECK_AUTO_RESTORATION_UP:     m_DirectionId = UPPER;      break;
        case MODE_CHECK_AUTO_RESTORATION_CT1:    m_DirectionId = CENTER1;    break;
        case MODE_CHECK_AUTO_RESTORATION_RT:     m_DirectionId = RIGHT;      break;
        case MODE_CHECK_AUTO_RESTORATION_CT2:    m_DirectionId = CENTER2;    break;
        case MODE_CHECK_AUTO_RESTORATION_UN:     m_DirectionId = UNDER;      break;
        case MODE_CHECK_AUTO_RESTORATION_CT3:    m_DirectionId = CENTER3;    break;
        case MODE_CHECK_AUTO_RESTORATION_LT:     m_DirectionId = LEFT;       break;
        case MODE_CHECK_AUTO_RESTORATION_CT4:    m_DirectionId = CENTER4;    break;
        }
        
        IsValidParameter();
        m_pLyt->m_Progress = 100 * m_IsValidParameter / COUNT_AR_TEST;
        
        PrepareGraphicsDrawing(0);          // tO
        m_pLyt->UpdateLayout(m_TestMode);   // tCAEg
        UpdateGraphicsDrawing_AR(0);        // tOtBbNX
#if CALANALOGSTICK_WINDOW_VISIBLE==0
        UpdateGraphicsDrawing_Information();
#endif
        SwapBuffersAndWaitVsync(0);         // tXV
        PrepareGraphicsDrawing(1);          // tO
        UpdateGraphicsDrawing_AR(1);        // tOtBbNX
        SwapBuffersAndWaitVsync(1);         // tXV
        
        // Z^[A\肨у[hڍs
        breakFlag = ChangeTestMode(m_pLyt->m_Progress, m_TestMode);
        
        // 
        // *6 gCSڂNG
        if( m_RetryFrequency[m_DirectionId] > MAX_RETRY_FREQUENCY )
        {
            sprintf(m_TestResult.m_String, "It exceeded Retry Limit.(%d)", m_DirectionId);
            m_TestResult.m_Micro  = EXCEED_RETRY_LIMIT ;
            m_TestResult.m_Result = false;
            ExecuteWriteData2SD();
            ExecuteFinalize();
            return;
        }
        
        // 
        // *7 ^CAEgG[
        m_Current = nn::os::Tick::GetSystemCurrent();
        m_Time    = (m_Current-m_Start).ToTimeSpan().GetMilliSeconds();
        if( m_Time > TIMELIMIT_AR_TEST )
        {
            // SDJ[hɃf[^oׂ͂ɋL^
            int i=0;
                 if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT0)  i = 0;
            else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT1)  i = 1;
            else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT2)  i = 2;
            else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT3)  i = 3;
            else if(m_TestMode == MODE_CHECK_AUTO_RESTORATION_CT4)  i = 4;
            {
                m_RawX_AR[i] = m_RawX;
                m_RawY_AR[i] = m_RawY;
                ConvRawDataToSDK(m_RawX_AR[i], m_RawY_AR[i], m_ConvSdkRawX_AR[i], m_ConvSdkRawY_AR[i]);
            }
            
            sprintf(m_TestResult.m_String, "Time out(%dms).(%4d %4d)", 
                TIMELIMIT_AR_TEST, m_ConvSdkRawX_AR[i], m_ConvSdkRawY_AR[i]);
            m_TestResult.m_Result = false;
            m_TestResult.m_Micro  = TIMEOUT_AR_TEST ;
            ExecuteWriteData2SD();
            ExecuteFinalize();
            return;
        }
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while( breakFlag == false );
    
    m_TestResult.m_Result = true;
}

/*---------------------------------------------------------------------------
  Desc: SDJ[hɊef[^Oo͂i]pj
  ̊֐͊e֐̃G[łsׁAm_TestResult ͕ύXȂ
---------------------------------------------------------------------------*/
bool CalAnalogStick::ExecuteWriteData2SD( void )
{
    m_TestMode = MODE_WRITE_DATA_TO_SD;
    IsEnable_NN_LOG("\n[ MODE_WRITE_DATA_TO_SD ]\n");
    
    // tO false ̎ SD J[hɃf[^o͂Ȃ
    uji::seq::Config config;
    if( WRITE_DATA_TO_SD == false )
    {
        return true;        // I
    }
    
    // p[^o͐
    const wchar_t* SLIDEPAD_SD_DIR   = L"sdmc:/uji/SlidePad";
    const wchar_t* SLIDEPAD_SD_PATH  = L"sdmc:/uji/SlidePad/SlidePad.csv";
    
    string line;
    string strMsgRawX_AR;
    string strMsgConvSdkRawX_AR;
    char strMsgMac[32]      = "";
    char strMsgRaw[32]      = "";
    char strMsgCenter[16]   = "";
    char strMsgScale[32]    = "";
    char strMsgCheckMax[32] = "";
    char strMsgResult[8]    = "";
    char strMsgString[64]   = "";
    char strBreak[2]        = "\n";
    char strBuf[64]         = "";
    
    // MacAhX
    bit8 mac[6]={0,0,0,0,0,0};
    uji::sys::GetMacAddress(mac);
    sprintf(strMsgMac,    "%02X::%02X::%02X::%02X::%02X::%02X,", 
        mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
        
    // l
    sprintf(strMsgRaw,    "%d,%d,%d,%d,", 
        m_RawMaxX, m_RawMinX, m_RawMaxY, m_RawMinY);
        
    // ␳̒_Wilj
    sprintf(strMsgCenter, "%d,%d,", m_CenterX, m_CenterY);
    
    // XP[l
    sprintf(strMsgScale,  "%9.7f,%9.7f,", m_ScaleX, m_ScaleY);
    
    // őŏlmFsdkl
    sprintf(strMsgCheckMax,  "%d,%d,%d,%d,", 
        m_CheckMax_ConvSdkRawX[0], m_CheckMax_ConvSdkRawX[1], 
        m_CheckMax_ConvSdkRawY[0], m_CheckMax_ConvSdkRawY[1]);
        
    // Z^[A̐l
    for(int i=1; i<5; ++i)
    {
        sprintf(strBuf, "%d,%d,", m_RawX_AR[i], m_RawY_AR[i]);
        strMsgRawX_AR += static_cast<string>(strBuf);
    }
    
    // Z^[Asdkl
    for(int i=1; i<5; ++i)
    {
        sprintf(strBuf, "%d,%d,", m_ConvSdkRawX_AR[i], m_ConvSdkRawY_AR[i]);
        strMsgConvSdkRawX_AR += static_cast<string>(strBuf);
    }
    
    // 
    if( m_TestResult.m_Result==true ) sprintf(strMsgResult, "PASS");
    else                              sprintf(strMsgResult, "FAIL");
    
    // G[bZ[W
    if( strcmp(m_TestResult.m_String, "") != 0 )
    {
        sprintf(strMsgString, " [ %s ]", m_TestResult.m_String);
    }

    line = static_cast<string>(strMsgMac) 
         + static_cast<string>(strMsgRaw) 
         + static_cast<string>(strMsgCenter) 
         + static_cast<string>(strMsgScale) 
         + static_cast<string>(strMsgCheckMax) 
         + strMsgRawX_AR 
         + strMsgConvSdkRawX_AR 
         + static_cast<string>(strMsgResult) 
         + static_cast<string>(strMsgString) 
         + static_cast<string>(strBreak);
         
    // SDJ[ho
    if( nn::fs::IsSdmcInserted() )
    {
        // }Eg
        if ( nn::fs::MountSdmc().IsSuccess() )
        {
            // SD ɏo
            if( CreateDirectorySdmc( L"sdmc:/uji" )    == false ) return false;
            if( CreateDirectorySdmc( SLIDEPAD_SD_DIR ) == false ) return false;
            if( WriteData2SD( SLIDEPAD_SD_PATH, line ) == false ) return false;
        }
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Unmount("sdmc:"));
    }
    
    // IsEnable_NN_LOG
    IsEnable_NN_LOG("\n");
    IsEnable_NN_LOG("- SlidePad Test Data Log -\n");
    IsEnable_NN_LOG(" MacAddress: %s\n",  strMsgMac);
    IsEnable_NN_LOG(" max_x     : %4d\n", m_RawMaxX);
    IsEnable_NN_LOG(" min_x     : %4d\n", m_RawMinX);
    IsEnable_NN_LOG(" max_y     : %4d\n", m_RawMaxY);
    IsEnable_NN_LOG(" min_y     : %4d\n", m_RawMinY);
    IsEnable_NN_LOG(" center_x  : %4d\n", m_CenterX);
    IsEnable_NN_LOG(" center_y  : %4d\n", m_CenterY);
    IsEnable_NN_LOG(" scale_x   : %9.7f\n", m_ScaleX);
    IsEnable_NN_LOG(" scale_y   : %9.7f\n", m_ScaleY);
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc: XChpbhb`k
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteSetCalAnalogStick( void )
{
    m_TestMode = MODE_SET_CAL;
    IsEnable_NN_LOG("\n[ MODE_SET_CAL ]\n");
    
    // LINE [hȊOł͂b`kɏ܂Ȃ
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        sprintf(m_TestResult.m_String, "It is not executed in the QC mode.");
        m_TestResult.m_Result = true;
        return;     // I
    }
    
    enum enumMicroErrorId
    {
        FAIL_GET_CAL         = 0,
        FAIL_SET_CAL         = 1,
        FAIL_FLUSH_CAL       = 2,
        
        MICRO_ERROR_NUM      = 3
    };
    
    PresetCalAnalogStick();
    
    if( SetCalAnalogStick()<0 )
    {
        m_TestResult.m_Result = false;
        
        switch( SetCalAnalogStick() )
        {
        case -1: 
            sprintf(m_TestResult.m_String, "It failed to get CAL.");
            m_TestResult.m_Micro  = FAIL_GET_CAL ;
            break;
        case -2: 
            sprintf(m_TestResult.m_String, "It failed to set CAL.");
            m_TestResult.m_Micro  = FAIL_SET_CAL ;
            break;
        case -3: 
            sprintf(m_TestResult.m_String, "It failed to flush CAL.");
            m_TestResult.m_Micro  = FAIL_FLUSH_CAL ;
            break;
        }
    }
    else
    {
        m_TestResult.m_Result = true;
    }
}

/*---------------------------------------------------------------------------
  Desc: ]pj[ŌĂԊ֐
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteCalAnalogStick( void )
{
    uji::seq::Config config;
    
    ExecuteInitialize();
    ExecuteOnYourMark();
    if( m_TestResult.m_Result==true ) ExecuteSampling();
    if( m_TestResult.m_Result==true ) ExecuteCalibrate();
    if( m_TestResult.m_Result==true ) ExecuteCheckMaxOutputWidth();
    if( m_TestResult.m_Result==true ) ExecuteCheckAutoRestoration();
    if( m_TestResult.m_Result==true && config.Get().WriteData2SdSlidePad == true )
    {
        ExecuteWriteData2SD();
    }
    if( m_TestResult.m_Result==true && config.Get().EvaSetCalAnalogStick == true )
    {
        ExecuteSetCalAnalogStick();
    }
    if( m_TestResult.m_Result==true ) ExecuteFinalize();
}

void CalAnalogStick::SetParameterFromCAL( void )
{
    using namespace nn::drivers::cal::CTR;
    
    Calibration              cal;
    AnalogStickCalDataCore   calDataCore;
    AnalogStickCalAppendCore calAppendCore;
    
    cal.Initialize();
    cal.Get(&calDataCore,   CAL_DATA_ANALOG_STICK);
    cal.Get(&calAppendCore, CAL_DATA_ANALOG_STICK_APPEND);
    
    // Lu[Vl擾
    m_ScaleX  = calAppendCore.scale_x;
    m_ScaleY  = calAppendCore.scale_y;
    m_CenterX = calDataCore.center_x;
    m_CenterY = calDataCore.center_y;
    m_RawMaxX = calAppendCore.max_x;
    m_RawMinX = calAppendCore.min_x;
    m_RawMaxY = calAppendCore.max_y;
    m_RawMinY = calAppendCore.min_y;
    m_Type    = calAppendCore.type;
}

s16 CalAnalogStick::ReadConvSdkRawX_AR( int i )
{
    return m_ConvSdkRawX_AR[i];
}

s16 CalAnalogStick::ReadConvSdkRawY_AR( int i )
{
    return m_ConvSdkRawY_AR[i];
}

/*---------------------------------------------------------------------------
  Desc: ̃f[^p
---------------------------------------------------------------------------*/
void CalAnalogStick::ExecuteEvaluateTester( void )
{
    m_TestMode = MODE_SAMPLING;
    IsEnable_NN_LOG("\n[ MODE_SAMPLING ]\n");
    
    uji::sys::Pad pad;
    bool breakFlag = false;
    m_LocusVisible = true;
    InitializeBuffer();
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/slidepad_x3.jpg");
    
    m_Start = nn::os::Tick::GetSystemCurrent();
    
    do
    {
        m_Current = nn::os::Tick::GetSystemCurrent();
        m_Time    = (m_Current-m_Start).ToTimeSpan().GetMilliSeconds();
        if( 360 * SAMPLING_ROUND * SAMPLING_LAP_TIME >= 360 * m_Time )
        {
            m_pLyt->m_zDegree = (f32)( 360 * m_Time / SAMPLING_LAP_TIME );
        }
        else
        {
            m_pLyt->m_zDegree = 360 * SAMPLING_ROUND;
            breakFlag = true;
        }
        
        pad.UpdatePad();
#if CALANALOGSTICK_WINDOW_VISIBLE==1
        UpdateWindows();
#endif
        
        PrepareGraphicsDrawing(0);          // tO
        m_pLyt->UpdateLayout(m_TestMode);   // tCAEg
        UpdateGraphicsDrawing(0);           // tOtBbNX
#if CALANALOGSTICK_WINDOW_VISIBLE==0
        UpdateGraphicsDrawing_Information();
#endif
        SwapBuffersAndWaitVsync(0);         // tXV
        PrepareGraphicsDrawing(1);          // tO
        UpdateGraphicsDrawing(1);           // tOtBbNX
        SwapBuffersAndWaitVsync(1);         // tXV
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while( breakFlag==false );
    
    m_TestResult.m_Result = true;
}

bool CalAnalogStick::ExecuteWriteEvaluateData2SD( const wchar_t* path )
{
#if EVALUATE_TESTER_MODE==1
    string line = "";
    
    for( int i=0; i<m_BufNum; i++ )
    {
        char strBuf[64] = "";
        sprintf( strBuf, "%d, %d,\n", 
            m_BufferForEvaluation[0][i], m_BufferForEvaluation[1][i] );
        line += strBuf;
    }
    
    // SDJ[ho
    if( nn::fs::IsSdmcInserted() )
    {
        if ( nn::fs::MountSdmc().IsSuccess() )
        {
            if( CreateDirectorySdmc( L"sdmc:/uji" )                         == false ) return false;
            if( CreateDirectorySdmc( L"sdmc:/uji/SlidePad" )                == false ) return false;
            if( CreateDirectorySdmc( L"sdmc:/uji/SlidePad/EvaluateTester" ) == false ) return false;
            if( WriteData2SD( path, line )                                  == false ) return false;
        }
        nn::fs::Unmount("sdmc:");
    }
    else
    {
        return false;
    }
#else
    IsEnable_NN_LOG("%s", path);
#endif
    return true;
}

} // namespace eva
} // namespace uji
