/*--------------------------------------------------------------------------*
 Project:
 File: ApplicationImporter.cpp


*--------------------------------------------------------------------------*/
#include "ApplicationImporter.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/Config.h"
#include "../seq/TestListManager.h"
#include <nn/os.h>
#include <nn/srv.h>
#include <nn/fs.h>
#include <nn/ns/CTR/ns_ApiShell.h>
#include <nn/ns/CTR/ns_Shell.h>
#include <nn/applet.h>
#include <nn/applet/CTR/applet_APIPrivate.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {

char s_ImporteePrgName[16] = "";
char s_ImporteePrgVer [ 8] = "";
const u16 COMMON_DRAW_LINE =  7; // ʂŕ\s


/*
    Desc: TestListp CX^X\bh֐|C^oRs邽
    AvP[V{̂ɃC|[gA{܂
*/
bool ApplicationImporter::ImportAndRunApplication( uji::seq::TestResult &result )
{
    uji::eva::ApplicationImporter *ai = new uji::eva::ApplicationImporter;
    ai->ImportAndRun();

    /*ȍ~ɓB邱Ƃ͖(AȂ)*/
    result.m_Result = false;
    return false;
}
    
/*
    Desc: AvP[V֑Jڂ܂
*/
void ApplicationImporter::ImportAndRun()
{
#define APPLICATION_FILE_PATH(name) (L"rom:/cia/"name)
    
    nn::am::TitleId titleId;
    
#ifndef EVA_APP_JUMP
    const int FONT_SIZE = 12;
    const int DEBUG_WND_WIDTH  = 210/(FONT_SIZE/2);
    const int DEBUG_WND_HEIGHT = FONT_SIZE*10/FONT_SIZE;

#ifdef EVA_APP_I
    sprintf( s_ImporteePrgName, "%s", IMPORTEE_PRG_NAME );  // ݑΏۂ̌ď
    sprintf( s_ImporteePrgVer,  "%s", IMPORTEE_PRG_VER  );  // ݑΏۂ̃o[W
#endif
    
    // fobOEChE
    m_DebugWnd = new sys::TextWindow(DEBUG_WND_WIDTH, DEBUG_WND_HEIGHT, FONT_SIZE);
    m_DebugWnd->SetTitle("LOG");
    m_DebugWnd->SetBackColor(nw::ut::Color8(0, 0, 200, 255));
    m_WndManager.CreateWindow(m_DebugWnd, NN_GX_DISPLAY1, 0, 0);
    // ANeBuw
    m_DebugWnd->SetActiveFlag(false);

    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 0.01f, 0.01f, 0.2f, 1.0f);
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1, 0.01f, 0.01f, 0.2f, 1.0f);

    // N
    DrawTitle(gfx);

    // A{^͑҂
    do
    {
        sys::Pad().UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20)); 
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_A));

    // 
    DrawPreparation(gfx);
    
    // STARTȌ
    WriteStartLog();
    
    // CIA ̃vO ID 擾
    nn::am::ProgramInfo programInfo;
    const wchar_t* filePath = sys::GetBondingOption() == 1 ? APPLICATION_FILE_PATH(L"Application.cia")
                                                           : APPLICATION_FILE_PATH(L"Application.master-ols.cia");
    NN_UTIL_PANIC_IF_FAILED(
        nn::am::GetProgramInfoFromCia(&programInfo, filePath));
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "File: %ls\n", filePath);

    // ɑ݂̂C|[gƃG[ԂĂ̂ŁA炩ߏĂ
    DeleteProgramAndTicket(programInfo);

    // NANDAṽC|[giʂ̍XV܂ށj
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "Now Importing..\n");
    ImportFile(nn::fs::MEDIA_TYPE_NAND, filePath);

    // OKȌ
    WriteOkLog();

    m_WndManager.DestroyWindow(m_DebugWnd);
    delete m_DebugWnd;
    
    // 擾^CgID
    titleId = programInfo.id;
#else
    // AvWvIDߑł
    titleId = IMPORTEE_APPLICATION_ID;
#endif
    NN_LOG("Jumping to imported program(programId: %016llx) ...\n", titleId);
    NN_UTIL_PANIC_IF_FAILED(
        nn::applet::PrepareToJumpToOtherApplication( titleId, nn::fs::MEDIA_TYPE_NAND ));
    NN_UTIL_PANIC_IF_FAILED(
        nn::applet::JumpToOtherApplication());
}

/*
    Desc: t@CC|[gXbh̎

    Args: importeeFile  - C|[gt@C̏
          pQueue        - pubLOL[ւ̃|C^

    Rtns: Ȃ
*/
void ApplicationImporter::ImportThread(ImporteeFileInfo* importeeFile, nn::os::BlockingQueue* pQueue)
{
    nn::Result result;
    nn::fs::FileOutputStream* stream;
    result = nn::am::BeginImportProgram(&stream, importeeFile->mediaType);
    NN_UTIL_PANIC_IF_FAILED(result);

    {
        size_t readBufSize = sizeof(bit8) * 256 * 1024;
        bit8* readBuf = reinterpret_cast<bit8*>(sys::Alloc(readBufSize, 32));

        ImportProgress progress;
        progress.readTotal = 0;
        progress.read = -1;

        NN_LOG("importing: %ls...", importeeFile->filename);
        nn::fs::FileInputStream in(importeeFile->filename);

        // t@CTCY擾
        progress.fileSize = in.GetSize();

        // 擾t@CTCY𑗐M
        pQueue->Enqueue(reinterpret_cast<uptr>(&progress));

        while(s32 read = in.Read(readBuf, readBufSize))
        {
            stream->Write(readBuf, progress.read = read);
            progress.readTotal += read;
            pQueue->Enqueue(reinterpret_cast<uptr>(&progress)); // C|[g󋵂𑗐M
        }

        sys::Free(readBuf);
    }

    result = nn::am::EndImportProgram(stream);
    NN_UTIL_PANIC_IF_FAILED(result);
    NN_LOG(" done.\n");
}

/*
    Desc: C|[gXbh̃bv֐
*/
void ApplicationImporter::s_ImportThread(void* param)
{
    ImportThreadArgs* pImportThreadArgs = reinterpret_cast<ImportThreadArgs*>(param);
    ApplicationImporter* pApplicationImporter = pImportThreadArgs->ai;
    pApplicationImporter->ImportThread(&(pImportThreadArgs->importFile), pImportThreadArgs->queue);
}

/*
    Desc: wt@C̃C|[g
*/
void ApplicationImporter::ImportFile(nn::fs::MediaType mediaType, const wchar_t* filename)
{
    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();

    s32 percent;

    nn::os::BlockingQueue queue;
    ImportProgress buffer[10];  // ImportThread͋ɂȂ܂ő҂̂ŗvf[1]łOK
    nn::os::Thread importThread;

    // ubLOL[̏
    queue.Initialize(reinterpret_cast<uptr*>(buffer), sizeof(buffer)/sizeof(ImportProgress));

    // C|[gXbh
    const size_t STACK_SIZE = 4096;
    ImportThreadArgs threadArgs;
    threadArgs.ai = this;
    threadArgs.queue = &queue;
    threadArgs.importFile.mediaType = mediaType;
    threadArgs.importFile.filename = filename;
    importThread.StartUsingAutoStack(s_ImportThread, &threadArgs, STACK_SIZE);

    // TCY̎擾҂
    ImportProgress progress = *reinterpret_cast<ImportProgress*>(queue.Dequeue());

    // vOXo[
    f32 posY = 20 + (14 * COMMON_DRAW_LINE) + 24;
    ProgressBarApplicationImporter* pbai = new ProgressBarApplicationImporter(20, posY, 360, 16, 0, progress.fileSize);

    while(progress.readTotal != progress.fileSize)
    {
        progress = *reinterpret_cast<ImportProgress*>(queue.Dequeue());
        percent = static_cast<s32>((static_cast<double>(progress.readTotal) /
                                    static_cast<double>(progress.fileSize)) * 100.0);

        // ݒ̉
        pbai->SetStep(progress.readTotal);
        DrawImporting(gfx, percent, progress.readTotal, progress.fileSize, pbai);
    }

    delete pbai;

    // XbȟEj
    importThread.Join();
    importThread.Finalize();
    // ubLOL[̔j
    queue.Finalize();
}

/*
    Desc: AvP[Vƃ`Pbg̍폜
*/
void ApplicationImporter::DeleteProgramAndTicket( nn::am::ProgramInfo programInfo )
{
    using namespace nn::am;
    const sys::ATTR_TEXT_COLOR WHITE   = sys::ATTR_COLOR_WHITE;
    const sys::ATTR_TEXT_COLOR MAGENTA = sys::ATTR_COLOR_MAGENTA;
    
    sys::ATTR_TEXT_COLOR color = WHITE;
    char msg[50]="Delete Old Application\n";
    DEBUG_WND_LOG( color, msg );
    
    // AvP[V̍폜
    nn::Result nnr = nn::am::DeleteProgram(nn::fs::MEDIA_TYPE_NAND, programInfo.id);
    if( nnr.IsSuccess() )                               { color = WHITE;    sprintf( msg, "[Pass] Delete Success\n" );          }
    else{    if( nnr == ResultNotFound() )              { color = WHITE;    sprintf( msg, "[Pass] NotFound\n" );                }
        else if( nnr == ResultInvalidEnumValue() )      { color = MAGENTA;  sprintf( msg, "[Failure] InvalidEnumValue\n" );     }
        else if( nnr == ResultInternalDataCorrupted() ) { color = MAGENTA;  sprintf( msg, "[Failure] InternalDataCorrupted\n" );}
        else                                            { color = MAGENTA;  sprintf( msg, "[Failure] UnknownResult\n" );        }
    }
    DEBUG_WND_LOG( color, msg );
    
    // ^CgႤP[XɑΉ邽߂ɁA`PbgĂB
    nn::am::DeleteTicket(programInfo.id);
}

/*
    Desc: fobOo
*/
void ApplicationImporter::DEBUG_WND_LOG(sys::ATTR_TEXT_COLOR color, const char* format, ...)
{
    sys::ATTR_TEXT_COLOR prev_color = m_DebugWnd->GetTextColor();

    m_DebugWnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    m_DebugWnd->VPrintf(format, vlist);
    va_end(vlist);

    m_DebugWnd->SetTextColor(prev_color);

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: ʕ\Ɋւ
*/
void ApplicationImporter::DrawInfo(sys::GraphicsDrawing *gfx, f32 FontHeight, u32 color, f32 x, f32 y)
{
    gfx->SetFixedWidthFont(FontHeight);     // tHgTCY
    gfx->m_TextWriter.SetTextColor(color);  // F
    gfx->m_TextWriter.SetCursor(x, y);      // ʒu
}

/*
    Desc: ʂ̋ʕ\
*/
void ApplicationImporter::DrawCommon(sys::GraphicsDrawing *gfx)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    {
        gfx->m_DrawFramework->Clear();
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        DrawInfo(gfx, 14, nw::ut::Color8::WHITE, 20, 20);
        gfx->BeginDrawingString();
            // ȉ̕\s COMMON_DRAW_LINE Ƃ
            // ---  --------------------------------------------------------------------------
            (void)gfx->m_TextWriter.Printf("APPLICATION IMPORTER (Ver.%s)\n", VERSION_STRING);
            (void)gfx->m_TextWriter.Printf("\n");
            (void)gfx->m_TextWriter.Printf("\n");
            (void)gfx->m_TextWriter.Printf("Identification Information:\n");
            (void)gfx->m_TextWriter.Printf("[ %s (Ver.%s) ]\n", s_ImporteePrgName, s_ImporteePrgVer);
            (void)gfx->m_TextWriter.Printf("\n");
            (void)gfx->m_TextWriter.Printf("\n");
            // --- ܂ --------------------------------------------------------------------------
        gfx->EndDrawingString();
    }
    gfx->m_DrawFramework->SwapBuffers();
}

/*
    Desc: ^Cg
*/
void ApplicationImporter::DrawTitle(sys::GraphicsDrawing *gfx)
{
    // ʕ\
    DrawCommon(gfx);
    
    // 
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    {
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        DrawInfo(gfx, 14, nw::ut::Color8::YELLOW, 20, 20+14*COMMON_DRAW_LINE);
        gfx->BeginDrawingString();
            (void)gfx->m_TextWriter.Printf("Push A button to Start.\n");
            (void)gfx->m_TextWriter.Printf("Import Application And Write 'App_I' Log.\n");
            (void)gfx->m_DrawFramework->SwapBuffers();
        gfx->EndDrawingString();
    }
    gfx->m_DrawFramework->SwapBuffers();
    
    // 
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    {
        gfx->m_DrawFramework->Clear();
    }
    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: 
*/
void ApplicationImporter::DrawPreparation(sys::GraphicsDrawing *gfx)
{
    // ʕ\
    DrawCommon(gfx);
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    {
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        DrawInfo(gfx, 14, nw::ut::Color8::WHITE, 20, 20+14*COMMON_DRAW_LINE);
        gfx->BeginDrawingString();
            (void)gfx->m_TextWriter.Printf("In Preparation.\n");
            (void)gfx->m_DrawFramework->SwapBuffers();
        gfx->EndDrawingString();
    }
    gfx->m_DrawFramework->SwapBuffers();
}

/*
    Desc: C|[g̉
*/
void ApplicationImporter::DrawImporting(sys::GraphicsDrawing *gfx, 
                                        s32 percent, 
                                        s32 readTotal, 
                                        s64 fileSize, 
                                        ProgressBarApplicationImporter *pbai)
{
    // ʕ\
    DrawCommon(gfx);
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    {
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        DrawInfo(gfx, 14, nw::ut::Color8::WHITE, 20, 20+14*COMMON_DRAW_LINE);
        gfx->BeginDrawingString();
            (void)gfx->m_TextWriter.Printf("Importing %d(%%) %d/%lld(byte)\n", percent, readTotal, fileSize);
            (void)gfx->m_TextWriter.Printf("\n\n\n");   // ̃Xy[XɃvOXo[\
            (void)gfx->m_TextWriter.Printf("Please Wait.");
        gfx->EndDrawingString();
        
        // vOXo[̍XV
        pbai->Draw(gfx);
    
    }
    gfx->m_DrawFramework->SwapBuffers();
    
    //gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: STARTO
*/
void ApplicationImporter::WriteStartLog(void)
{
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "Write Production Log [START]\n");
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    pdl->Add_1Line(0, "App_I", "START", VERSION_STRING, "", "", "", "");
    delete pdl;
}

/*
    Desc: OKO
*/
void ApplicationImporter::WriteOkLog(void)
{
    uji::seq::Config          *cfg = new uji::seq::Config;
    uji::seq::TestListManager *tlm = new uji::seq::TestListManager;
    char pdlMsg[80] = "";
    
    // RtBOΉ̃eXgXgK肷
    tlm->SetCurrentTestList( cfg->GetAlternative().TestList );
    sprintf( pdlMsg, "Seq:%04d$Cfg:%04d", tlm->GetCheckCode(), cfg->GetCheckCode() );
    
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "Write Production Log [OK]\n");
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    pdl->Add_1Line(0, "App_I", "OK", VERSION_STRING, "", "", "", pdlMsg);
    delete pdl;
}


} // namespace
}
