/*--------------------------------------------------------------------------*
 Project:
 File: AgingSequencer.h


*--------------------------------------------------------------------------*/
#ifndef __AGING_SEQUENCER_H__
#define __AGING_SEQUENCER_H__

#include <nn/types.h>
#include <nw/ut.h>    
#include "sys.h"
#include "../seq/Config.h"
#include "../seq/TestResult.h"
    
namespace uji {
namespace eva {
    
/*
    Desc: G[WÕV[PẌׂ̃NX
*/
class AgingSequencer
{
public:
    AgingSequencer() 
    {
        m_Config = new seq::Config;
        m_AgingTime = static_cast<s32>(m_Config->Get().AgingTime);
        //m_Config->Load();        
    }
    virtual ~AgingSequencer()
    {
        delete m_Config;
    }

    //TestListp
    static bool RunAging( uji::seq::TestResult &result );
    
    void Test();
    
private:
    // m点v̓_p^[
    enum INFO_LED_PATTERN{
        INFO_LED_PATTERN_RED,
        INFO_LED_PATTERN_BLUE,         
        INFO_LED_PATTERN_OFF        
    };
    
    seq::Config *m_Config;
    s32 m_AgingTime;
    
    void PutMessage(sys::GraphicsDrawing *gfx, char* message);    
    void SetInfoLedPattern(int pattern);
    void ClearAlarm();
    void WriteRunLog( int pastmin );
    void AnalyzeLog();
    
    static const int LCD_BL_TURNON_MSEC     = 3000;
    static const int LCD_BL_TURNOFF_MSEC    = 6000;    
};


} // namespace
}


#endif
