/*--------------------------------------------------------------------------*
 Project:
 File: AgingSequencer.cpp


*--------------------------------------------------------------------------*/
#include "AgingSequencer.h"
#include "../sys/sys_SoundPlayer.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/config.h"
#include "../mcu/McuInitializer.h"
#include "../mcu/TestPowerOff.h"
#include "../sound/NWSound.h"
#include "../gpu_Eva.h"

#include <nn/os.h>
#include <nn/srv.h>
#include <nn/fs.h>
#include <nn/gx/CTR/gx_LcdPowerManager.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {

/*
    Desc: TestListp CX^X\bh֐|C^oRŎs邽ߗp
    G[WOeXg{܂
*/
bool AgingSequencer::RunAging( uji::seq::TestResult &result )
{
    uji::eva::AgingSequencer* as = new uji::eva::AgingSequencer;
    as->Test();

    /*ȍ~ɓB邱Ƃ͖(AȂ)*/
    result.m_Result = false;
    return result.m_Result;
}
    
/*
    Desc: G[WOeXg{܂
*/
void AgingSequencer::Test()
{
    nn::os::Tick::Tick  startTick;
    seq::TestResult result_gpu, result_sound;
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    bool isLcdTurnOn = false;
    bool isExit = false;
    int loop = 1;
    int pastmin;

    startTick = nn::os::Tick::GetSystemCurrent();

#ifdef SC_CHECK_BATTERY_AGING
    //obe[`FbN[h̎́AG[WOԂIɕύX
    if (sys::GetPlatformType() == sys::PLATFORM_CTR || sys::GetPlatformType() == sys::PLATFORM_FTR)
        m_AgingTime = 240;
    else if (sys::GetPlatformType() == sys::PLATFORM_SPR)
        m_AgingTime = 285;
    AnalyzeLog();
#endif
    
    //X[vvɑ΂ԓLɂ܂
    sys::SleepHandler::EnableSleep();

    // m点v_
    SetInfoLedPattern(INFO_LED_PATTERN_BLUE);

    // Z[uA[JCuJ[hobNAbvłȂꍇNANDAvƔf
	if (strcmp("data:", UJI_SAVEARCHIVE) != 0)
	{
        sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
        jpegDrawer->OpenPicture(L"rom:/aging/EjectCard.jpg");
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        // J[ho܂ő҂܂
        while (nn::fs::IsCardInserted())
        {
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        }
        
        jpegDrawer->ClosePicture();
        delete jpegDrawer;
    }

    // 炵܂
    uji::eva::agingsnd::StartAgingSound(result_sound);

    // {̂Ԃŉo悤ɂ܂
    // uji::eva::SoundInitializer().InitSDK() ɌĂłKv܂B
    nn::snd::SetHeadphoneOutOnShellClose(false);
    
    do {        
        // GPUeXgs
        gpu::TestGpu(result_gpu, startTick);

        // X[vʒmmFۂLCDEobNCgēxON
        if (sys::SleepHandler::IsSleepRequested() && !isLcdTurnOn)
        {
            nn::gx::CTR::LcdPowerManager::TurnOnAll();
            sys::WaitMilliSeconds(LCD_BL_TURNON_MSEC);
            isLcdTurnOn = true;
        }

        // oߎԂ̎Zo
        pastmin = (int)(nn::os::Tick::GetSystemCurrent() - startTick).ToTimeSpan().GetMinutes();

        if ((!m_Config->Get().AgingEndless && m_AgingTime <= pastmin) || !result_gpu.m_Result)
        {
            // ~܂
            uji::eva::agingsnd::StopAgingSound(result_sound);

            // m点v
            PutMessage(gfx, "Info LED Off.");
            SetInfoLedPattern(result_gpu.m_Result ? INFO_LED_PATTERN_OFF : INFO_LED_PATTERN_RED);

            // Ȍ
            PutMessage(gfx, "Production Log.");
            char logMesg[seq::pl::LOG_MSG_LEN];
            std::sprintf(logMesg, "%d(Cfg:%d) min", pastmin, m_AgingTime);            
            uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
            pdl->Initialize();
#ifdef SC_CHECK_BATTERY_AGING
            pdl->Add_1Line(m_Config->Get().TestMode, "Aging", result_gpu.m_Result ? "TMP_OK" : "NG", VERSION_STRING, "", "", "", logMesg);
            delete pdl;
            // Vbg_E
            eva::mcu::PowerOff();
#else
            pdl->Add_1Line(m_Config->Get().TestMode, "Aging", result_gpu.m_Result ? "OK" : "NG", VERSION_STRING, "", "", "", logMesg);
            delete pdl;
#endif
            
            if (sys::SleepHandler::IsSleepRequested())
            {
                // LCDEobNCgOFF
                PutMessage(gfx, "LCD,BL Off.");
                nn::gx::CTR::LcdPowerManager::TurnOffAll();
                sys::WaitMilliSeconds(LCD_BL_TURNOFF_MSEC);

                // X[v[hɓ
                PutMessage(gfx, "Go Sleep.");
                sys::SleepHandler::SleepSystem();

                // ĊJ̏
                PutMessage(gfx, "Return from Sleep.");
                nn::gx::StartLcdDisplay();
            }
            
            // ʉʂ̕\
            const nw::ut::FloatColor COLOR_PASS = nw::ut::FloatColor(0.1f, 1.0f, 0.1f, 1.0f);
            const nw::ut::FloatColor COLOR_FAIL = nw::ut::FloatColor(1.0f, 0.1f, 0.1f, 1.0f);
            nw::ut::FloatColor back = result_gpu.m_Result ? COLOR_PASS : COLOR_FAIL;
            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
            if (result_gpu.m_Result)
                jpegDrawer->OpenPicture(L"rom:/aging/Pass.jpg");
            else
                jpegDrawer->OpenPicture(L"rom:/aging/Fail.jpg");

            // Display_0
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->Clear();

            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->SwapBuffers();

            // Display_1
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1, back.r, back.g, back.b, back.a);
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();

            gfx->m_DrawFramework->SetColor(0.1f, 0.1f, 1.0f);
            gfx->m_DrawFramework->SetFontSize(8.0f);
            gfx->m_DrawFramework->DrawText(0,  0, "Result : %s\n", result_gpu.m_Result ? "PASS":"FAIL");
            gfx->m_DrawFramework->DrawText(0, 10, "Time   : %d(min) Loop: %d\n", pastmin, loop);
            gfx->m_DrawFramework->DrawText(0, 20, "Micro  : %03d\n", result_gpu.m_Micro);
            gfx->m_DrawFramework->DrawText(0, 30, "Message: %s\n", result_gpu.m_String);
            gfx->m_DrawFramework->SwapBuffers();

            gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);           

            isExit = true;
        }
        else
        {
#ifdef SC_CHECK_BATTERY_AGING
            WriteRunLog(pastmin);
#endif
        }
        
        if (!isExit) loop++;        
    }
    while (!isExit);

#if 0
    // ʉ
    sys::SoundPlayer sp;
    if (result_gpu.m_Result)
        sp.UjiSoundPlayer( "rom:/aging/ok.wav", 1500 );
    else
        sp.UjiSoundPlayer( "rom:/aging/ng.wav", 1500 );
#endif
    // X[v𖳌
    sys::SleepHandler::Finalize();

    while(1)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    // ɂ͗܂

#if 0
    jpegDrawer->ClosePicture();
    delete jpegDrawer;
#endif
}

/*
    Desc: bZ[W̕\
*/
void AgingSequencer::PutMessage(sys::GraphicsDrawing *gfx, char* message)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();

    gfx->m_DrawFramework->SetColor(1.0f, 1.0f, 1.0f);
    gfx->m_DrawFramework->SetFontSize(8.0f);
    gfx->m_DrawFramework->DrawText(0,  0, "%s\n", message);
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: m点v̐
*/
void AgingSequencer::SetInfoLedPattern(int pattern)
{
    nn::mcu::CTR::InfoLedPattern infoLedPattern =
    {
            0,           // 1t[̒(PMCU`bN/2ms)
            0,           // ݂̐Ft[wFɓB܂ł̎
                         // ʏframeTimeƓlw肵Ă
            255,         // ŏIt[JԂ(255Ȃ疳ɌJԂ)
            0,           // \
            0,           // R1,R2..R32, G1,G2..G32, B1,B2..B32
    };

    eva::mcu::McuInitializer().HwCheckInit();
    // MCU vZXɃNGXg𑗂邽߂̃NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        eva::mcu::McuInitializer().GetHSession()    // mꂽZbṼnh
    );                                              // RXgN^Ɏw

    switch (pattern)
    {
    // ԓ_
    case INFO_LED_PATTERN_RED:
        for(int i = 0; i < 32; i++)
        {
           infoLedPattern.frameColors[i] = 255;
        }
        for(int i = 32; i < 96; i++)
        {
            infoLedPattern.frameColors[i] = 0;
        }
        break;
    // _
    case INFO_LED_PATTERN_BLUE:
        for(int i = 0; i < 64; i++)
        {
            infoLedPattern.frameColors[i] = 0;
        }
        for(int i = 64; i < 96; i++)
        {
            infoLedPattern.frameColors[i] = 255;
        }
        break;
    // 
    case INFO_LED_PATTERN_OFF:
        for(int i = 0; i < 96; i++)
        {
            infoLedPattern.frameColors[i] = 0;
        }
        break;
    default:
        return;
    }

    mcu.SetInfoLEDPattern(infoLedPattern);

    // pmcun̏I
    eva::mcu::McuInitializer().HwCheckEnd();
}

    
/*
  Desc: OɌoߎԂSTATE"RUNNING"ŏ݂܂
*/
void AgingSequencer::WriteRunLog( int pastmin )
{
    char logMesg[seq::pl::LOG_MSG_LEN];
    
    std::sprintf(logMesg, "%d(Cfg:%d) min", pastmin, m_AgingTime);
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    pdl->Overwrite_1Line(m_Config->Get().TestMode, "Aging", "RUNNING", UJI_APPVER, "", "", "", logMesg);
    delete pdl;
}

/*
  Desc: Os̃obe[`FbNpG[WOOcĂΌʂ\A΃G[WOJn܂
*/
void AgingSequencer::AnalyzeLog()
{
    nw::ut::FloatColor back;
    
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    
    do
    {
        // ŐṼG[WOO擾
        int index = pdl->Get_LatestLogEntryIndex("Aging");        
        if ( index < 0 ) break;
        uji::seq::LogEntry le;
        le = pdl->Get_LogEntry(index);

        {
            sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;

            // OKOcĂꍇ
            if ( 0 == strncmp(le.state, "TMP_OK",6) )
            {
                pdl->Add_1Line(le.testmode, "Aging", "OK", le.version, "", "", "", le.message);        
                back = nw::ut::FloatColor(0.1f, 1.0f, 0.1f, 1.0f);
                jpegDrawer->OpenPicture(L"rom:/aging/Pass.jpg");
            }
            else if ( (0 == strncmp(le.state, "NG",2) ) ||
                      (0 == strncmp(le.state, "RUNNING",7)) )
            {
                pdl->Add_1Line(le.testmode, "Aging", "CHECKED", le.version, "", "", "", le.message);    
                back= nw::ut::FloatColor(1.0f, 0.1f, 0.1f, 1.0f);
                jpegDrawer->OpenPicture(L"rom:/aging/Fail.jpg");
            }
            else
            {
                delete jpegDrawer;        
                break;
            }
            
            do {            
                // Display_0
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();

                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->SwapBuffers();

                // Display_1
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1, back.r, back.g, back.b, back.a);
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
                gfx->m_DrawFramework->Clear();

                gfx->m_DrawFramework->SetColor(0.1f, 0.1f, 1.0f);
                gfx->m_DrawFramework->SetFontSize(8.0f);
                gfx->m_DrawFramework->DrawText(0, 00, "Last State: %s\n", le.state);
                gfx->m_DrawFramework->DrawText(0, 10, "%s\n", le.message);
                gfx->m_DrawFramework->SwapBuffers();

                gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);           

            } while (1);

            //̎dlł͐䂪AȂ߁ARgAEg
            //delete jpegDrawer;
        }
                
    } while(0);

    pdl->Add_1Line(m_Config->Get().TestMode, "Aging", "START", UJI_APPVER, "", "", "", "");
        
    delete pdl;
}

    
} // namespace
}
