/*--------------------------------------------------------------------------*
 Project:
 File: AgingImporter.h


*--------------------------------------------------------------------------*/
#ifndef __AGING_IMPORTER_H__
#define __AGING_IMPORTER_H__

#include <nn/types.h>
#include <nn/am.h>    
#include <nw/ut.h>    
#include "sys.h"
#include "../seq/TestResult.h"

namespace uji {
namespace eva {


//============================================================================
//  vOXo[
//============================================================================
class ProgressBar 
{
public:
    // RXgN^
    // o[㉺2ŕ`悷sAheight 2̔{Őݒ肵ĉB
    ProgressBar(f32 x, f32 y, f32 width, f32 height, s32 lower, s32 upper)
    : m_X(x), m_Y(y), m_Width(width), m_Height(height),
    m_AddStep(1), m_CurrentStep(0), m_Lower(lower) ,m_Upper(upper)
    {
        m_DrawingRate = static_cast<f32>(width) / static_cast<f32>(upper - lower);
    
        m_ColorBar1     = nw::ut::FloatColor(0.1f, 0.85f, 0.1f, 1.0f);
        m_ColorBar2     = nw::ut::FloatColor(0.1f, 0.70f, 0.1f, 1.0f);        
        m_ColorFrame    = nw::ut::FloatColor(0.9f, 0.9f, 0.9f, 1.0f);
        m_ColorBack     = nw::ut::FloatColor(0.3f, 0.3f, 0.3f, 1.0f);
    }
    
    // fXgN^
    virtual ~ProgressBar() {}

    // J[ݒ
    void SetColor(
        nw::ut::FloatColor color_bar1, 
        nw::ut::FloatColor color_bar2, 
        nw::ut::FloatColor color_frame, 
        nw::ut::FloatColor color_back)
    {
        m_ColorBar1     = color_bar1;
        m_ColorBar2     = color_bar2;        
        m_ColorFrame    = color_frame;
        m_ColorBack     = color_back;
    }
        
    // wXebvɃWv
    void SetStep(s32 nStep)
    {
        m_CurrentStep = nStep;
    }
        
    // `
    void Draw(sys::GraphicsDrawing *gfx)
    {
        // Og    
	    gfx->m_DrawFramework->SetColor(m_ColorFrame.r, m_ColorFrame.g, m_ColorFrame.b, m_ColorFrame.a);
        gfx->m_DrawFramework->FillRectangle(m_X-1.0f, m_Y-1.0f, m_Width+2.0f, m_Height+2.0f);        
	    // wi
	    gfx->m_DrawFramework->SetColor(m_ColorBack.r, m_ColorBack.g, m_ColorBack.b, m_ColorBack.a);
        gfx->m_DrawFramework->FillRectangle(m_X, m_Y, m_Width, m_Height);
        // iso[
        f32 screenStep = m_DrawingRate * m_CurrentStep;
	    gfx->m_DrawFramework->SetColor(m_ColorBar1.r, m_ColorBar1.g, m_ColorBar1.b, m_ColorBar1.a);
        gfx->m_DrawFramework->FillRectangle(m_X, m_Y, screenStep, m_Height/2);
	    gfx->m_DrawFramework->SetColor(m_ColorBar2.r, m_ColorBar2.g, m_ColorBar2.b, m_ColorBar2.a);
        gfx->m_DrawFramework->FillRectangle(m_X, m_Y+m_Height/2, screenStep, m_Height/2);        
    }

private:    
    s32 m_X;                // \ʒuXW
    s32 m_Y;                // \ʒuYW
    s32 m_Width;            // vOXo[̕ij
    s32 m_Height;           // vOXo[̍
    
    s32 m_AddStep;          // Update̍ۂɑXebv
    s32 m_CurrentStep;      // ݂̃Xebv    
    s32 m_Lower;            // Xebv    
    s32 m_Upper;            // Xebv
    
    f32 m_DrawingRate;
    
    nw::ut::FloatColor m_ColorBar1;
    nw::ut::FloatColor m_ColorBar2;    
    nw::ut::FloatColor m_ColorFrame;
    nw::ut::FloatColor m_ColorBack;
};


//============================================================================
//  C|[g
//============================================================================
class AgingImporter;

// C|[gt@C
typedef struct {
    nn::fs::MediaType   mediaType;  // C|[g̃foCX    
    const wchar_t*      filename;   // C|[gt@C
} ImporteeFileInfo; 

// C|[gXbḧ
typedef struct {
    AgingImporter*          ai;
    nn::os::BlockingQueue*  queue;
    
    ImporteeFileInfo        importFile;
} ImportThreadArgs;

// ubLOL[őMC|[gis
typedef struct {
    s64 fileSize;   // t@CTCY
    s32 read;       // [hTCY
    s32 readTotal;  // [hTCY̍v    
} ImportProgress;

/*
    G[WOiNANDAvjC|[gĎsׂ̃NX
*/
class AgingImporter
{
public:
    AgingImporter() {}
    virtual ~AgingImporter() {}

    //AgingOO`FbN
    static bool LogCheckPrevAging( uji::seq::TestResult &result );
    
    //TestListp G[WOvÕC|[gWv
    static bool ImportAndRunAging( uji::seq::TestResult &result );

    // G[WOvÕC|[gWv
    void ImportAndRun();
    // G[WOvONAND폜
    nn::Result DeleteProgram()
    {
        return nn::am::DeleteProgram(nn::fs::MEDIA_TYPE_NAND, IMPORTEE_AGING_ID);        
    }
    // G[WOvONANDC|[g擾
    nn::Result GetProgramInfo(nn::am::ProgramInfo* pOutInfo)
    {
        const nn::ProgramId id[] = {IMPORTEE_AGING_ID};

        return nn::am::GetProgramInfos(pOutInfo, nn::fs::MEDIA_TYPE_NAND, id, 1);     
    }
            
private:
    // C|[gXbh
    void ImportThread(ImporteeFileInfo* importeeFile, nn::os::BlockingQueue* pQueue);
    static void s_ImportThread(void* param);
    
    // wt@C̃C|[g
    void ImportFile(nn::fs::MediaType mediaType, const wchar_t* filename);
    
    /*
        \֘A
    */
    // EChE}l[W
    sys::WindowManager m_WndManager;
    // EChE
    sys::TextWindow* m_DebugWnd;
    // fobOEChEɕo
    void DEBUG_WND_LOG(sys::ATTR_TEXT_COLOR color, const char* format, ...);
    // ^Cg
    void DrawTitle(sys::GraphicsDrawing *gfx);
    // 
    void DrawPreparation(sys::GraphicsDrawing *gfx);
    
public:         
    static const nn::ProgramId IMPORTEE_AGING_ID = 0x000400000F980000L;  // G[WO     
};


} // namespace
}


#endif
