/*--------------------------------------------------------------------------*
 Project:
 File: AgingImporter.cpp


*--------------------------------------------------------------------------*/
#include "AgingImporter.h"
#include "AgingCheckLogList.h"
#include "../seq/TesterLog/ProductionLog.h"
#include <nn/os.h>
#include <nn/srv.h>
#include <nn/fs.h>
#include <nn/ns/CTR/ns_ApiShell.h>
#include <nn/ns/CTR/ns_Shell.h>
#include <nn/applet.h>
#include <nn/applet/CTR/applet_APIPrivate.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {


// LɂƃC|[gXbhƖ{Xbhœi݁XV݁XV..j
// ĉʂXV܂B{Xbh𖈃t[XVꍇ͒`𖳌ɁB
#define BLOCK_MAIN_THREAD


/*
   Desc: AgingHO܂ł̃O`FbN
 */
bool AgingImporter::LogCheckPrevAging( uji::seq::TestResult &result )
{
    std::string *checkLogList;
    int checkListLength = 0;
    
    result.m_Result = true;

    //AFTR̂݃`FbN
    if ( uji::sys::GetPlatformType() != uji::sys::PLATFORM_FTR )
    {
        return result.m_Result;
    }
    else
    {
        checkLogList = LogListPrevAgingFtr;
        checkListLength =  sizeof(LogListPrevAgingFtr) / sizeof(LogListPrevAgingFtr[0]);
    }

    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;
    pl->Initialize();
    
    // 핶񂪁Aproduct.logɑ݂Ă邩ǂ肷
    std::string missingProcess = "";
    for(int i =0; i < checkListLength; i++)
    {
        if ( pl->LogTable_LatestLogEntryIsOK(checkLogList[i].c_str(), uji::seq::pl::LINE) == false)
        {
            // O݂Ȃ̕m_Resultɉ
            missingProcess = missingProcess + checkLogList[i] + " ";
            result.m_Result = false;
        }
    }
    // ǂ̌̃OȂ m_ResultɓĂ
    if ( false == result.m_Result ) { sprintf(result.m_String, "==Process Missed!==\n%s", missingProcess.c_str()); }
    
    pl->Finalize();
    delete pl;
    
    return result.m_Result;
}


/*
    Desc: t@CC|[gXbh̎

    Args: importeeFile  - C|[gt@C̏
          pQueue        - pubLOL[ւ̃|C^

    Rtns: Ȃ
*/
void AgingImporter::ImportThread(ImporteeFileInfo* importeeFile, nn::os::BlockingQueue* pQueue)
{
    nn::Result result;
    nn::fs::FileOutputStream* stream;
    result = nn::am::BeginImportProgram(&stream, importeeFile->mediaType);
    NN_UTIL_PANIC_IF_FAILED(result);

    {
        size_t readBufSize = sizeof(bit8) * 256 * 1024;
        bit8* readBuf = reinterpret_cast<bit8*>(sys::Alloc(readBufSize, 32));

        ImportProgress progress;
        progress.readTotal = 0;
        progress.read = -1;

        NN_LOG("importing: %ls...", importeeFile->filename);
        nn::fs::FileInputStream in(importeeFile->filename);

        // t@CTCY擾
        progress.fileSize = in.GetSize();

        // 擾t@CTCY𑗐M
        pQueue->Enqueue(reinterpret_cast<uptr>(&progress));

        while(s32 read = in.Read(readBuf, readBufSize))
        {
            stream->Write(readBuf, progress.read = read);
            progress.readTotal += read;
#if 1
            // C|[g󋵂𑗐M
            pQueue->Enqueue(reinterpret_cast<uptr>(&progress));
#else       // for Debug
            if (!pQueue->TryEnqueue(reinterpret_cast<uptr>(&progress)))
            {
                // Ŏ~܂lȂ{X̏AL[̗vfǂ
                NN_TPANIC_("Failed: TryEnqueue.\n");
            }
#endif
        }

        sys::Free(readBuf);
    }

    result = nn::am::EndImportProgram(stream);
    NN_UTIL_PANIC_IF_FAILED(result);
    NN_LOG(" done.\n");
}

/*
    Desc: C|[gXbh̃bv֐
*/
void AgingImporter::s_ImportThread(void* param)
{
    ImportThreadArgs* pImportThreadArgs = reinterpret_cast<ImportThreadArgs*>(param);
    AgingImporter* pAgingImporter = pImportThreadArgs->ai;
    pAgingImporter->ImportThread(&(pImportThreadArgs->importFile), pImportThreadArgs->queue);
}

/*
    Desc: wt@C̃C|[g
*/
void AgingImporter::ImportFile(nn::fs::MediaType mediaType, const wchar_t* filename)
{
    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();

    s32 percent;

    nn::os::BlockingQueue queue;
    ImportProgress buffer[10];  // ImportThread͋ɂȂ܂ő҂̂ŗvf[1]łOK
    nn::os::Thread importThread;

    // ubLOL[̏
    queue.Initialize(reinterpret_cast<uptr*>(buffer), sizeof(buffer)/sizeof(ImportProgress));

    // C|[gXbh
    const size_t STACK_SIZE = 4096;
    ImportThreadArgs threadArgs;
    threadArgs.ai = this;
    threadArgs.queue = &queue;
    threadArgs.importFile.mediaType = mediaType;
    threadArgs.importFile.filename = filename;
    importThread.StartUsingAutoStack(s_ImportThread, &threadArgs, STACK_SIZE);

    // TCY̎擾҂
    ImportProgress progress = *reinterpret_cast<ImportProgress*>(queue.Dequeue());

    // vOXo[
    ProgressBar* pb = new ProgressBar(20, 68, 360, 16, 0, progress.fileSize);

    while(progress.readTotal != progress.fileSize)
    {
#ifdef BLOCK_MAIN_THREAD
        progress = *reinterpret_cast<ImportProgress*>(queue.Dequeue());
#else
        ImportProgress *tmp;
        if (queue.TryDequeue(reinterpret_cast<uptr*>(&tmp)))
        {
            progress = *tmp;
        }
#endif
        percent = static_cast<s32>((static_cast<double>(progress.readTotal) /
                                    static_cast<double>(progress.fileSize)) * 100.0);

        // vOXo[XV
        pb->SetStep(progress.readTotal);

        /*
            `揈
        */
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);

        gfx->SetFixedWidthFont(14);
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
        gfx->m_TextWriter.SetCursor(20, 20);
        gfx->BeginDrawingString();
            (void)gfx->m_TextWriter.Printf("AGING PROGRAM IMPORTER Ver.%s\n", VERSION_STRING);
            (void)gfx->m_TextWriter.Printf("\n");
            (void)gfx->m_TextWriter.Printf("Importing %d(%%) %d/%lld(byte)\n", percent, progress.readTotal, progress.fileSize);
            (void)gfx->m_TextWriter.Printf("\n\n\n");
            (void)gfx->m_TextWriter.Printf("- Please Wait -");
        gfx->EndDrawingString();
        pb->Draw(gfx);

        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }

    delete pb;

    // XbȟEj
    importThread.Join();
    importThread.Finalize();
    // ubLOL[̔j
    queue.Finalize();
}


/*
    Desc: TestListp CX^X\bh֐|C^oRs邽
    G[WOeXg{̂ɃC|[gA{܂
*/
bool AgingImporter::ImportAndRunAging( uji::seq::TestResult &result )
{
    uji::eva::AgingImporter *ai = new uji::eva::AgingImporter;
    ai->ImportAndRun();

    /*ȍ~ɓB邱Ƃ͖(AȂ)*/
    result.m_Result = false;
    return false;
}
    
/*
    Desc: G[WOvO֑Jڂ܂
*/
void AgingImporter::ImportAndRun()
{
#define AGING_FILE_PATH(name) (L"rom:/cia/"name)
    const int FONT_SIZE = 12;
    const int DEBUG_WND_WIDTH  = 210/(FONT_SIZE/2);
    const int DEBUG_WND_HEIGHT = FONT_SIZE*10/FONT_SIZE;

    // fobOEChE
    m_DebugWnd = new sys::TextWindow(DEBUG_WND_WIDTH, DEBUG_WND_HEIGHT, FONT_SIZE);
    m_DebugWnd->SetTitle("LOG");
    m_DebugWnd->SetBackColor(nw::ut::Color8(0, 0, 200, 255));
    m_WndManager.CreateWindow(m_DebugWnd, NN_GX_DISPLAY1, 0, 0);
    // ANeBuw
    m_DebugWnd->SetActiveFlag(false);

    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 0.01f, 0.01f, 0.2f, 1.0f);
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1, 0.01f, 0.01f, 0.2f, 1.0f);

    // N
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    {
        gfx->m_DrawFramework->Clear();
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        DrawTitle(gfx);
    }
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    {
        gfx->m_DrawFramework->Clear();
    }
    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);        

    do
    {
        sys::Pad().UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20)); 
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_A));

    // 
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    {
        gfx->m_DrawFramework->Clear();
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        DrawPreparation(gfx);
    }
    gfx->m_DrawFramework->SwapBuffers();

    // Ȍ
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "Write Production Log [START]\n");
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    pdl->Add_1Line(0, "Aging", "START", VERSION_STRING, "", "", "", "");
    delete pdl;

    const wchar_t* filePath = sys::GetBondingOption() == 1 ? AGING_FILE_PATH(L"Aging.cia")
                                                           : AGING_FILE_PATH(L"Aging.master-ols.cia");
    // CIA ̃vO ID 擾
    nn::am::ProgramInfo programInfo;
    NN_UTIL_PANIC_IF_FAILED(
        nn::am::GetProgramInfoFromCia(&programInfo, filePath));
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "File: %ls\n", filePath);

    // ɑ݂̂C|[gƃG[ԂĂ̂ŁA炩ߏĂ
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "Delete Old Aging Program\n");
    nn::Result result = nn::am::DeleteProgram(nn::fs::MEDIA_TYPE_NAND, programInfo.id);
    if (result.IsFailure())
    {
        if (result == nn::am::ResultInvalidEnumValue())
        {
            DEBUG_WND_LOG(sys::ATTR_COLOR_MAGENTA, "[Failure] InvalidEnumValue\n");
        }
        else if (result == nn::am::ResultNotFound())
        {
            DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "[Pass] NotFound\n");
        }
        else if (result == nn::am::ResultInternalDataCorrupted())
        {
            DEBUG_WND_LOG(sys::ATTR_COLOR_MAGENTA, "[Failure] InternalDataCorrupted\n");
        }
        else 
        {
            DEBUG_WND_LOG(sys::ATTR_COLOR_MAGENTA, "[Failure] UnknownResult\n");
        }
    }
    else
    {
        DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "[Pass] Delete Success\n");
    }
    // ^CgႤP[XɑΉ邽߂ɁA`PbgĂB
    nn::am::DeleteTicket(programInfo.id);    

    // NANDAṽC|[g
    DEBUG_WND_LOG(sys::ATTR_COLOR_WHITE, "Now Importing..\n");
    ImportFile(nn::fs::MEDIA_TYPE_NAND, filePath);

    m_WndManager.DestroyWindow(m_DebugWnd);
    delete m_DebugWnd;

    // G[WOvOֈڍs
    NN_LOG("Jumping to imported program(programId: %016llx) ...\n", programInfo.id);
    NN_UTIL_PANIC_IF_FAILED(
        nn::applet::PrepareToJumpToOtherApplication( programInfo.id, nn::fs::MEDIA_TYPE_NAND ));
    NN_UTIL_PANIC_IF_FAILED(
        nn::applet::JumpToOtherApplication());
}

/*
    Desc: fobOo
*/
void AgingImporter::DEBUG_WND_LOG(sys::ATTR_TEXT_COLOR color, const char* format, ...)
{
    sys::ATTR_TEXT_COLOR prev_color = m_DebugWnd->GetTextColor();

    m_DebugWnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    m_DebugWnd->VPrintf(format, vlist);
    va_end(vlist);

    m_DebugWnd->SetTextColor(prev_color);

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: ^Cg
*/
void AgingImporter::DrawTitle(sys::GraphicsDrawing *gfx)
{
    gfx->SetFixedWidthFont(14);
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
    gfx->m_TextWriter.SetCursor(20, 20);
    gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf("AGING PROGRAM IMPORTER Ver.%s\n", VERSION_STRING);
        (void)gfx->m_TextWriter.Printf("\n");
        (void)gfx->m_TextWriter.Printf("Write [START] Log & Import Aging Program.\n");
        (void)gfx->m_TextWriter.Printf("\n");
        (void)gfx->m_TextWriter.SetTextColor(nw::ut::Color8::YELLOW);
        (void)gfx->m_TextWriter.Printf("- PUSH A BUTTON TO START -\n");
        (void)gfx->m_DrawFramework->SwapBuffers();
    gfx->EndDrawingString();
}

/*
    Desc: 
*/
void AgingImporter::DrawPreparation(sys::GraphicsDrawing *gfx)
{
    gfx->SetFixedWidthFont(14);
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
    gfx->m_TextWriter.SetCursor(20, 20);
    gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf("AGING PROGRAM IMPORTER Ver.%s\n", VERSION_STRING);
        (void)gfx->m_TextWriter.Printf("\n");
        (void)gfx->m_TextWriter.Printf("Write [START] Log & Import Aging Program.\n");
        (void)gfx->m_TextWriter.Printf("\n");
        (void)gfx->m_TextWriter.Printf("- In Preparation -\n");    
    gfx->EndDrawingString();    
}


} // namespace
}
