/*--------------------------------------------------------------------------*
 Project:
 File: WriteAccDataToSD.cpp

*--------------------------------------------------------------------------*/
#include <nn.h>
#include "ShowAccTestPassage.h"
#include "../../sys/sys_GetPlatform.h"
#include "TestAccTool.h"
#include "../sys/sys_GetSerialNumber.h"
#include "WriteAccDataToSD.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {
namespace acc {

void WriteAccDataToSD(ShowPassage* pse, u32* another_ng_code, string line)

{
    const wstring SD_PATH_DP0_4 = L"sdmc:/uji/Acc/AccLog.csv"; // xOo͐
    u32 sd_ng_code = RESULT_OK;         // SDɊւG[ꍇɃG[R[hi[ׂ̕ϐ
    nn::Result nnr;
    // SDJ[h}Eg
    NN_LOG("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        NN_LOG("failed.\n");
        if( pse->ng_code == RESULT_OK ) pse->ng_code     = SD_MOUNT + pse->test_process * 100;
        else                            *another_ng_code = SD_MOUNT + pse->test_process * 100;
    }
    else
    {
        // /ujifBNg`FbNiΐVK쐬j
        sd_ng_code = CreateDirectorySdmc(L"sdmc:/uji");

        if( sd_ng_code != RESULT_OK )
        {
            if( pse->ng_code == RESULT_OK ) pse->ng_code     = sd_ng_code + pse->test_process * 100;
            else                            *another_ng_code = sd_ng_code + pse->test_process * 100;
        }
        else
        {
            // /uji/AccfBNg`FbNiΐVK쐬j
            sd_ng_code = CreateDirectorySdmc(L"sdmc:/uji/Acc");

            if( sd_ng_code != RESULT_OK )
            {
                // 1ڂ̃fBNg쐬NGƌ邽߂NGR[h+1Ă܂B
                if( pse->ng_code == RESULT_OK ) pse->ng_code     = sd_ng_code + pse->test_process * 100;
                else                            *another_ng_code = sd_ng_code + pse->test_process * 100;
            }
            else
            {
                // SDJ[hɏo
                sd_ng_code = WriteData2SD( SD_PATH_DP0_4, line, pse->pCnfMem );
                if( sd_ng_code != RESULT_OK )
                {
                    if( pse->ng_code == RESULT_OK ) pse->ng_code     = sd_ng_code + pse->test_process * 100;
                    else                            *another_ng_code = sd_ng_code + pse->test_process * 100;
                }
            }
        }

        // SDJ[h̃A}Eg
        NN_LOG("sdmc archive unmount ");
        nnr = nn::fs::Unmount("sdmc:");
        if ( nnr.IsFailure())
        {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);
            if( pse->ng_code == RESULT_OK ) pse->ng_code     = SD_UNMOUNT + pse->test_process * 100;
            else                            *another_ng_code = SD_UNMOUNT + pse->test_process * 100;
        }
        NN_LOG("succeeded.\n");
    }


    return;
}


/*---------------------------------------------------------------------------
  Desc: SDJ[hɎwtH_݂邩mF܂B(tH_ꍇ̓tH_쐬܂B)

  Args: path        ΏۃtH_̃tpX

  Rtns: OK/NG
---------------------------------------------------------------------------*/
s32 CheckDirectorySdmc(const wchar_t* path)
{
    nn::fs::Directory dir;
    nn::Result result = dir.TryInitialize( path );

    // fBNgȂꍇ̓G[
    if(result.IsFailure())
    {
        NN_LOG("* Warning: No Create Directory! \n");
        return CHECK_DIRECTORY;
    }
    return RESULT_OK;
}


/*---------------------------------------------------------------------------
  Desc: SDJ[hɎwtH_݂邩mF܂B(tH_ꍇ̓tH_쐬܂B)

  Args: path        ΏۃtH_̃tpX

  Rtns: OK/NG
---------------------------------------------------------------------------*/
s32 CreateDirectorySdmc(const wchar_t* path)
{
    nn::fs::Directory dir;
    nn::Result result = dir.TryInitialize( path );

    // fBNgȂꍇ͐VK쐬
    if(result.IsFailure())
    {
        NN_LOG("Can't Initialize! So Create Directory... \n");

        result = nn::fs::TryCreateDirectory( path );

        dir.Finalize();

        if(result.IsFailure())
        {
            NN_LOG("* Warning: No Create Directory! \n");
            return CREATE_DIRECTORY;
        }
    }
    return RESULT_OK;
}


/*---------------------------------------------------------------------------
  Desc: SDJ[hɃf[^݂܂

  Args: path        Ώۃt@C̃tpX
        strBuf      ރf[^

  Rtns: Ȃ
---------------------------------------------------------------------------*/
u32 WriteData2SD(const wstring& path, string strBuf, uji::seq::Config::Member* p_ConfigMem)
{

#ifdef SHORT_VERSION
//


    const char ACC_ITEM[900] = "Ver,"               // o[W
                            "TestMode,"         // LINE,QCȂǂ̃eXg[h
                            "CONFIG_CRC,"       // RtBOCRC
                            "MacAddress,"       // l`bAhX
                            "SerialNo,"         // VAio[
                            "Result,"           // G[R[h
                            "Info,"             // ڍ׏
                            "CAL_0G-X,"         // xZT CALlƂď܂Ăl
                            "CAL_0G-Y,"         //
                            "CAL_0G-Z,"         //
                            "CAL_Sens-X,"       //
                            "CAL_Sens-Y,"       //
                            "CAL_Sens-Z,"       //
                            "DIF_0G-X,"         // xZT CALlƂď܂Ălƍ̌ʂ瓾CALl̍
                            "DIF_0G-Y,"         //
                            "DIF_0G-Z,"         //
                            "DIF_Sens-X(%),"    //
                            "DIF_Sens-Y(%),"    //
                            "DIF_Sens-Z(%),"    //
                            "0G-X,"             // xZTŌvlɁAvZŋ߂Lul
                            "0G-Y,"             //
                            "0G-Z,"             //
                            "Sens-X,"           //
                            "Sens-Y,"           //
                            "Sens-Z,"           //
                            "Sta-X_0,"          // 100TvÔ̍ől|ŏl
                            "Sta-Y_0,"          //
                            "Sta-Z_0,"          //
                            "Sta-X_1,"          //
                            "Sta-Y_1,"          //
                            "Sta-Z_1,"          //
                            "Sta-X_2,"          //
                            "Sta-Y_2,"          //
                            "Sta-Z_2,"          //
                            "Ave-X_0,"          // AccSamplingNum̃Tv̕ϒl
                            "Ave-Y_0,"          //
                            "Ave-Z_0,"          //
                            "Ave-X_1,"          //
                            "Ave-Y_1,"          //
                            "Ave-Z_1,"          //
                            "Ave-X_2,"          //
                            "Ave-Y_2,"          //
                            "Ave-Z_2,"          //
                            "Max-X_0,"          //  AccSamplingNum̃Tv̍ől
                            "Max-Y_0,"          //
                            "Max-Z_0,"          //
                            "Max-X_1,"          //
                            "Max-Y_1,"          //
                            "Max-Z_1,"          //
                            "Max-X_2,"          //
                            "Max-Y_2,"          //
                            "Max-Z_2,"          //
                            "Min-X_0,"          // AccSamplingNum̃Tv̍ŏl
                            "Min-Y_0,"          //
                            "Min-Z_0,"          //
                            "Min-X_1,"          //
                            "Min-Y_1,"          //
                            "Min-Z_1,"          //
                            "Min-X_2,"          //
                            "Min-Y_2,"          //
                            "Min-Z_2,"          //
                            "DIF_X0,"           //
                            "DIF_Y0,"           //
                            "DIF_Z0,"           //
                            "FullMax_X0,"       //
                            "FullMax_Y0,"       //
                            "FullMax_Z0,"       //
                            "FullMin_X0,"       //
                            "FullMin_Y0,"       //
                            "FullMin_Z0,"       //
                            "\n";
#else
// 
    const char ACC_ITEM[900] = "Ver,"               // o[W
                            "TestMode,"         // LINE,QCȂǂ̃eXg[h
                            "CONFIG_CRC,"       // RtBOCRC
                            "MacAddress,"       // l`bAhX
                            "SerialNo,"         // VAio[
                            "Result,"           // G[R[h
                            "Info,"             // ڍ׏
                            "CAL_0G-X,"         // xZT CALlƂď܂Ăl
                            "CAL_0G-Y,"         //
                            "CAL_0G-Z,"         //
                            "CAL_Sens-X,"       //
                            "CAL_Sens-Y,"       //
                            "CAL_Sens-Z,"       //
                            "DIF_0G-X,"         // xZT CALlƂď܂Ălƍ̌ʂ瓾CALl̍
                            "DIF_0G-Y,"         //
                            "DIF_0G-Z,"         //
                            "DIF_Sens-X(%),"    //
                            "DIF_Sens-Y(%),"    //
                            "DIF_Sens-Z(%),"    //
                            "0G-X,"             // xZTŌvlɁAvZŋ߂Lul
                            "0G-Y,"             //
                            "0G-Z,"             //
                            "Sens-X,"           //
                            "Sens-Y,"           //
                            "Sens-Z,"           //
                            "Sta-X_0,"          // 100TvÔ̍ől|ŏl
                            "Sta-Y_0,"          //
                            "Sta-Z_0,"          //
                            "Sta-X_1,"          //
                            "Sta-Y_1,"          //
                            "Sta-Z_1,"          //
                            "Sta-X_2,"          //
                            "Sta-Y_2,"          //
                            "Sta-Z_2,"          //
                            "Rep-X(1-3),"       // Y(p13̂Ƃ)AZ(p04̂Ƃ)̍ČmF(TvOf[^AccSamplingNum̕ϒl̍)
                            "Rep-Y(1-3),"       //
                            "Rep-Z(1-3),"       //
                            "Rep-X(0-4),"       //
                            "Rep-Y(0-4),"       //
                            "Rep-Z(0-4),"       //
                            "Ave-X_0,"          // AccSamplingNum̃Tv̕ϒl
                            "Ave-Y_0,"          //
                            "Ave-Z_0,"          //
                            "Ave-X_1,"          //
                            "Ave-Y_1,"          //
                            "Ave-Z_1,"          //
                            "Ave-X_2,"          //
                            "Ave-Y_2,"          //
                            "Ave-Z_2,"          //
                            "Ave-X_3,"          //
                            "Ave-Y_3,"          //
                            "Ave-Z_3,"          //
                            "Ave-X_4,"          //
                            "Ave-Y_4,"          //
                            "Ave-Z_4,"          //
                            "Max-X_0,"          //  AccSamplingNum̃Tv̍ől
                            "Max-Y_0,"          //
                            "Max-Z_0,"          //
                            "Max-X_1,"          //
                            "Max-Y_1,"          //
                            "Max-Z_1,"          //
                            "Max-X_2,"          //
                            "Max-Y_2,"          //
                            "Max-Z_2,"          //
                            "Max-X_3,"          //
                            "Max-Y_3,"          //
                            "Max-Z_3,"          //
                            "Max-X_4,"          //
                            "Max-Y_4,"          //
                            "Max-Z_4,"          //
                            "Min-X_0,"          // AccSamplingNum̃Tv̍ŏl
                            "Min-Y_0,"          //
                            "Min-Z_0,"          //
                            "Min-X_1,"          //
                            "Min-Y_1,"          //
                            "Min-Z_1,"          //
                            "Min-X_2,"          //
                            "Min-Y_2,"          //
                            "Min-Z_2,"          //
                            "Min-X_3,"          //
                            "Min-Y_3,"          //
                            "Min-Z_3,"          //
                            "Min-X_4,"          //
                            "Min-Y_4,"          //
                            "Min-Z_4,"          //
                            "DIF_X0,"           //
                            "DIF_Y0,"           //
                            "DIF_Z0,"           //
                            "FullMax_X0,"       //
                            "FullMax_Y0,"       //
                            "FullMax_Z0,"       //
                            "FullMin_X0,"       //
                            "FullMin_Y0,"       //
                            "FullMin_Z0,"       //
                            "\n";

#endif

    char str_max[900];
    char str_min[900];
    string tmp_str;

    if(  (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
        ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (p_ConfigMem->ScreenCheckFlag == 0)) ||
        ((uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType()) && (p_ConfigMem->ScreenCheckFlag == 0)) )
    {
        //QC[h
        if(p_ConfigMem->TestMode == 1)
        {
            sprintf(str_max, "\n QC Max,,,,,,, ,,,,,, %u,%u,%u,8%%,8%%,8%%, ,,,,,, %u,%u,%u,%u,%u,%u,%u,%u,%u, %u,%u,-%u,%u,-%u,%u,-%u,%u,%u, ,,,,,,,,, ,,,,,,,,, %u,%u,%u, ,,,-%f,-%f,-%f,\n",
                        p_ConfigMem->QC_0G_X_Offset, p_ConfigMem->QC_0G_Y_Offset, p_ConfigMem->QC_0G_Z_Offset,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_Z_1G_Max,
                        p_ConfigMem->QC_ALL_0G_Max, - p_ConfigMem->QC_Y_1G_Min, p_ConfigMem->QC_ALL_0G_Max,
                        p_ConfigMem->QC_X_1G_Max, p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_ALL_0G_Max,
                        p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff,
                         (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );

            sprintf(str_min, " QC Min,,,,,,, ,,,,,, ,,,,,, ,,,,,, 0,0,0,0,0,0,0,0,0, -%u,-%u,-%u,-%u,-%u,-%u,-%u,-%u,-%u, ,,,,,,,,, ,,,,,,,,, 0,0,0, %f,%f,%f,,,\n",
                        p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_Z_1G_Min,
                        p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_Y_1G_Max, p_ConfigMem->QC_ALL_0G_Min,
                        p_ConfigMem->QC_X_1G_Min, p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_ALL_0G_Min,
                        (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );
        }
        else
        {
            sprintf(str_max, "\n LINE Max,,,,,,, ,,,,,, ,,,,,, ,,,,,, %u,%u,%u,%u,%u,%u,%u,%u,%u, %u,%u,-%u,%u,-%u,%u,-%u,%u,%u, ,,,,,,,,, ,,,,,,,,, %u,%u,%u, ,,,-%f,-%f,-%f,\n",
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->Z_1G_Max,
                        p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->Y_1G_Min, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G,
                        p_ConfigMem->X_1G_Max, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G,
                        p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff,
                         (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );

            sprintf(str_min, " LINE Min,,,,,,, ,,,,,, ,,,,,, ,,,,,, 0,0,0,0,0,0,0,0,0, -%u,-%u,-%u,-%u,-%u,-%u,-%u,-%u,-%u, ,,,,,,,,, ,,,,,,,,, 0,0,0, %f,%f,%f,,,\n",
                        p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->Z_1G_Min,
                        p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->Y_1G_Max, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G,
                        p_ConfigMem->X_1G_Min, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G,
                        (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );
        }
    }
    else
    {
        //QC[h
        if(p_ConfigMem->TestMode == 1)
        {
            sprintf(str_max, "\n QC Max,,,,,,, ,,,,,, %u,%u,%u,8%%,8%%,8%%, ,,,,,, %u,%u,%u,%u,%u,%u,%u,%u,%u, %u,%u,-%u,%u,%u,%u,-%u,%u,%u, ,,,,,,,,, ,,,,,,,,, %u,%u,%u, ,,,-%f,-%f,-%f,\n",
                        p_ConfigMem->QC_0G_X_Offset, p_ConfigMem->QC_0G_Y_Offset, p_ConfigMem->QC_0G_Z_Offset,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_Z_1G_Max,
                        p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_Y_1G_Max, p_ConfigMem->QC_ALL_0G_Max,
                        p_ConfigMem->QC_X_1G_Max, p_ConfigMem->QC_ALL_0G_Max, p_ConfigMem->QC_ALL_0G_Max,
                        p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff,
                         (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );

            sprintf(str_min, " QC Min,,,,,,, ,,,,,, ,,,,,, ,,,,,, 0,0,0,0,0,0,0,0,0, -%u,-%u,-%u,-%u,%u,-%u,-%u,-%u,-%u, ,,,,,,,,, ,,,,,,,,, 0,0,0, %f,%f,%f,,,\n",
                        p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_Z_1G_Min,
                        p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_Y_1G_Min, p_ConfigMem->QC_ALL_0G_Min,
                        p_ConfigMem->QC_X_1G_Min, p_ConfigMem->QC_ALL_0G_Min, p_ConfigMem->QC_ALL_0G_Min,
                        (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );
        }
        else
        {
            sprintf(str_max, "\n LINE Max,,,,,,, ,,,,,, ,,,,,, ,,,,,, %u,%u,%u,%u,%u,%u,%u,%u,%u, %u,%u,-%u,%u,%u,%u,-%u,%u,%u, ,,,,,,,,, ,,,,,,,,, %u,%u,%u, ,,,-%f,-%f,-%f,\n",
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange, p_ConfigMem->AccStabilityRange,
                        p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->Z_1G_Max,
                        p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->Y_1G_Max, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G,
                        p_ConfigMem->X_1G_Max, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Max + p_ConfigMem->AgainAddition0G,
                        p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff, p_ConfigMem->DiffRange0G + p_ConfigMem->AgainAdditionDiff,
                         (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );

            sprintf(str_min, " LINE Min,,,,,,, ,,,,,, ,,,,,, ,,,,,, 0,0,0,0,0,0,0,0,0, -%u,-%u,-%u,-%u,%u,-%u,-%u,-%u,-%u, ,,,,,,,,, ,,,,,,,,, 0,0,0, %f,%f,%f,,,\n",
                        p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->Z_1G_Min,
                        p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->Y_1G_Min, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G,
                        p_ConfigMem->X_1G_Min, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G, p_ConfigMem->ALL_0G_Min + p_ConfigMem->AgainAddition0G,
                        (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000, (float)(p_ConfigMem->FullScaleRange)/1000
                        );
        }

    }


    tmp_str = static_cast<string>(str_max) + static_cast<string>(str_min);

    // t@Cׂ݂̈̃IuWFNg쐬
    nn::fs::FileStream fos;
    nn::Result result = fos.TryInitialize(path.c_str(), nn::fs::OPEN_MODE_READ   |
                                                        nn::fs::OPEN_MODE_WRITE  |
                                                        nn::fs::OPEN_MODE_CREATE );
    if(result.IsSuccess())
    {
        s64 size = fos.GetSize();
        NN_LOG("FILE_SIZE= %lld\n", size);

        if(size == 0)
        {
            // ̂ݏLACC_ITEMt@Cɏ
            fos.Write(ACC_ITEM, strlen(ACC_ITEM));
            fos.Seek( -1, nn::fs::POSITION_BASE_END );
            fos.Write(tmp_str.c_str(), strlen(tmp_str.c_str()));
        }
        else
        {
            // ڈȍ~̓t@C̏I[Ɉړ
            fos.Seek( -1, nn::fs::POSITION_BASE_END );
        }
        fos.Write(strBuf.c_str(), strlen(strBuf.c_str()));
        fos.Write("@", 1);
    }
    else return SD_WRITE;

    // t@C
    fos.Finalize();

    return RESULT_OK;
}






void MakeCSVData( Config::Member* accMember,
                             s32 diffStabilityMaxMin[AXIS_NUM][TEST_PROCESS_MAX],
                             s32 sample_min[AXIS_NUM][TEST_PROCESS_MAX], s32 sample_max[AXIS_NUM][TEST_PROCESS_MAX], s32 sample_average[AXIS_NUM][TEST_PROCESS_MAX],
                             s32 dif0g_x0_yz, s32 dif0g_y0_zx, s32 dif0g_z0_xy, AccelerometerScale full_scale,
                             char* result_str, AccelerometerCalibrateParamFloat read_cal, AccelerometerCalibrateParamFloat set_cal,  AccelerometerCalibrateParamFloat diff_line_qc, string* line, StrLogForSD* p_AccResultLine )
{
    bit8 mac[nn::uds::MAC_ADDRESS_SIZE];    // MACAhXi[
    char strBreak[2]        = "\n";


// SDJ[hɎcO̓e
    //  o[W(ږFVer)͉ō쐬

    // LINE,QCȂǂ̃eXg[h  (ږFTestMode)
    sprintf(p_AccResultLine->strTestMode, ",%s,", TestMode[accMember->TestMode]);

    // RtBOCRC擾A쐬  (ږFCONFIG_CRC)
    uji::seq::Config *c = new uji::seq::Config;
    sprintf(p_AccResultLine->str_config_crc, "%d,", c->GetCheckCode());
    delete c;

    //l`bAhX擾itcrgpjAMacAddress  (ږFMacAddress)쐬
    sys::GetMacAddress(mac);
    sprintf(p_AccResultLine->str_mac, "[%02X::%02X::%02X::%02X::%02X::%02X],", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

    // VAio[(ږFSerialNo)͏ŊɎ擾
    // G[R[h(ږFResult)͏(result_str)ŊɎ擾
    // ڍ׏(ږFInfo)͏(ng_info_str)ŊɎ擾

    // xZT CALlƂď܂Ăl(LINEŏޒlȂ̂ŒʏLINEł͒lĂȂ)A ̒lƍ̌ʂ瓾CALl̍
    // (ږFCAL_0G-*,,CAL_Sens-*,DIF_0G-*,DIF_Sens-*(%),0G-*,Sens-*)
    sprintf( p_AccResultLine->strAccRaw, ",%d,%d,%d,%f,%f,%f,%d,%d,%d,%f,%f,%f,%d,%d,%d,%f,%f,%f,",
        read_cal.x.offset, read_cal.y.offset, read_cal.z.offset, 1000/read_cal.x.scale, 1000/read_cal.y.scale, 1000/read_cal.z.scale,
        diff_line_qc.x.offset,     diff_line_qc.y.offset,     diff_line_qc.z.offset,     diff_line_qc.x.scale,               diff_line_qc.y.scale,               diff_line_qc.z.scale,
        set_cal.x.offset,  set_cal.y.offset,  set_cal.z.offset,  1000/set_cal.x.scale,  1000/set_cal.y.scale,  1000/set_cal.z.scale );

    // p0,1,2ꂼ̂Ƃ̃Tvől|ŏl(ږFSta-*_0,Sta-*_1,Sta-*_2)
    sprintf( p_AccResultLine->strStability,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
        diffStabilityMaxMin[AXIS_X][0], diffStabilityMaxMin[AXIS_Y][0], diffStabilityMaxMin[AXIS_Z][0],
        diffStabilityMaxMin[AXIS_X][1], diffStabilityMaxMin[AXIS_Y][1], diffStabilityMaxMin[AXIS_Z][1],
        diffStabilityMaxMin[AXIS_X][2], diffStabilityMaxMin[AXIS_Y][2], diffStabilityMaxMin[AXIS_Z][2] );

    // Y(p13̂Ƃ)AZ(p04̂Ƃ)̍ČmF Vł͌sȂ
    sprintf( p_AccResultLine->strCmpX13_Z04,    "" );

    // AccSamplingNum̃Tv̕ϒl(ږFAve-:*_0`2)
    sprintf( p_AccResultLine->strAverage,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
    sample_average[AXIS_X][0], sample_average[AXIS_Y][0], sample_average[AXIS_Z][0],
    sample_average[AXIS_X][1], sample_average[AXIS_Y][1], sample_average[AXIS_Z][1],
    sample_average[AXIS_X][2], sample_average[AXIS_Y][2], sample_average[AXIS_Z][2] );

    // AccSamplingNum̃Tv̍ől(ږFMax-:*_0`2)
    sprintf( p_AccResultLine->strSmpMax,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
    sample_max[AXIS_X][0], sample_max[AXIS_Y][0], sample_max[AXIS_Z][0],
    sample_max[AXIS_X][1], sample_max[AXIS_Y][1], sample_max[AXIS_Z][1],
    sample_max[AXIS_X][2], sample_max[AXIS_Y][2], sample_max[AXIS_Z][2] );

    // AccSamplingNum̃Tv̍ŏl(ږFMin-:*_0`2)
    sprintf( p_AccResultLine->strSmpMin,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
    sample_min[AXIS_X][0], sample_min[AXIS_Y][0], sample_min[AXIS_Z][0],
    sample_min[AXIS_X][1], sample_min[AXIS_Y][1], sample_min[AXIS_Z][1],
    sample_min[AXIS_X][2], sample_min[AXIS_Y][2], sample_min[AXIS_Z][2] );

    // 0G̒l߂ۂɎg2pf[^(:X0̂ƂYAZXl)̍(ږFDIF_*0)
    sprintf( p_AccResultLine->strDiffXYZ, "%d,%d,%d,", dif0g_x0_yz, dif0g_y0_zx, dif0g_z0_xy );

    // full scale1.8Gȏ゠邱Ƃ̊mF̃f[^
    sprintf( p_AccResultLine->strFullScale, "%f,%f,%f,%f,%f,%f,", full_scale.x.max, full_scale.y.max, full_scale.z.max, full_scale.x.min, full_scale.y.min, full_scale.z.min );

    memset(p_AccResultLine->strTestLver, 0x00, sizeof(p_AccResultLine->strTestLver));

    if     (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) sprintf(p_AccResultLine->strTestLver, "S%s", VERSION_STRING); // SPFLp
    else if(uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) sprintf(p_AccResultLine->strTestLver, "F%s", VERSION_STRING); // FTRp
    else                                                           sprintf(p_AccResultLine->strTestLver, "C%s", VERSION_STRING); // ̑

    *line = static_cast<string>(p_AccResultLine->strTestLver)       // o[W(ږFVer)
        + static_cast<string>(p_AccResultLine->strTestMode)     // LINE,QCȂǂ̃eXg[h  (ږFTestMode)
        + static_cast<string>(p_AccResultLine->str_config_crc)  // RtBOCRC擾A쐬  (ږFCONFIG_CRC)
        + static_cast<string>(p_AccResultLine->str_mac)         // MacAddress  (ږFMacAddress)
        + static_cast<string>(p_AccResultLine->m_serialNo)      // VAio[(ږFSerialNo)
        + static_cast<string>(result_str)       // G[R[h(ږFResult)
        + static_cast<string>(p_AccResultLine->strAccRaw)       // xZT CALlƂď܂Ăl(LINEŏޒlȂ̂ŒʏLINEł͒lĂȂ)A
                                                //   ̒lƍ̌ʂ瓾CALl̍(ږFCAL_0G-*,,CAL_Sens-*,DIF_0G-*,DIF_Sens-*(%),0G-*,Sens-*)
        + static_cast<string>(p_AccResultLine->strStability)        // p0,1,2ꂼ̂Ƃ̃Tvől|ŏl(ږFSta-*_0,Sta-*_1,Sta-*_2)
        + static_cast<string>(p_AccResultLine->strCmpX13_Z04)   // Y(p13̂Ƃ)AZ(p04̂Ƃ)̍ČmF(TvOf[^AccSamplingNum̕ϒl̍)(ږFRep-*(1-3),Rep-*(0-4))
        + static_cast<string>(p_AccResultLine->strAverage)      // AccSamplingNum̃Tv̕ϒl(ږFAve-*_0`4)
        + static_cast<string>(p_AccResultLine->strSmpMax)       // AccSamplingNum̃Tv̍ől(ږFMax-*_0`4)
        + static_cast<string>(p_AccResultLine->strSmpMin)       // AccSamplingNum̃Tv̍ŏl(ږFMin-*_0`4)
        + static_cast<string>(p_AccResultLine->strDiffXYZ)      // X,Y,Z0G2v̍
        + static_cast<string>(p_AccResultLine->strFullScale)        // FullScale`FbN̒l
        + static_cast<string>(strBreak);        // "\n"

    return;
}


}
}
}
