
/*--------------------------------------------------------------------------*
 Project:
 File: WaitButtonR.cpp

*--------------------------------------------------------------------------*/
#include "WaitButtonR.h"
#include "TestAccTool.h"


namespace uji {
namespace eva {
namespace acc {


static void WaitButton(uji::sys::Pad::Button button);


//============================================================================
//
//    ݉\SDJ[h}Ă̂mFAR{^̂҂֐
//
//============================================================================
bool WaitButtonR(seq::TestResult &result)
{
    // RtBOp
    Config::Member accMember;
    Config accConfig;
    accMember = accConfig.Get();

    // LINE[hSDɃOޏꍇA܂QC[hSDɃOޏꍇSDJ[h̊mFs
    if(    ((accMember.TestMode == 0) && (accMember.LINE_Write_SD_Flag == 1))
        || ((accMember.TestMode == 1) && (accMember.QC_Write_SD_Flag == 1))   )
    {
        //rcJ[h̑}mF
        if( !nn::fs::IsSdmcInserted() )
        {
            strcpy( result.m_String, "NO SD CARD" );
            result.m_Micro = 1;
            result.m_Result = false;
            return result.m_Result;
        }

        //CgveNgmF
        if( !nn::fs::IsSdmcWritable() )
        {
            strcpy( result.m_String, "WRITE PROTECTED" );
            result.m_Micro = 2;
            result.m_Result = false;
            return result.m_Result;
        }
    }

    // OPENԂɂȂ܂ő҂֐
    uji::eva::mcu::WaitOpenState();

    // {̂Ԃŉo悤ɂ鏈
    AccSoundReInitialize();

    // JPG摜XV
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    if(uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        jpegDrawer->OpenPicture(L"rom:/jpeg/CloseAndPushR_FTR.jpg");
    }
    else if((accMember.TestMode == 0) && (accMember.LINE_Write_SD_Flag == 0))
    {
        jpegDrawer->OpenPicture(L"rom:/jpeg/CloseAndPushRforCIS.jpg");
    }
    else if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) )
    {
        jpegDrawer->OpenPicture(L"rom:/jpeg/CloseAndPushR_SPR.jpg");
    }
    else
    {
        jpegDrawer->OpenPicture(L"rom:/jpeg/CloseAndPushR.jpg");
    }

    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    glFlush();

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SwapBuffers();

    // R{^̂҂
    WaitButton(sys::Pad::BUTTON_R);

    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(300));

    // soundI
    AccSoundFinalize();

    jpegDrawer->ClosePicture();
    delete jpegDrawer;

    result.m_Result = 1;

    return result.m_Result;
}


//============================================================================
//    Ŏw肵{^̂҂֐
//============================================================================
static void WaitButton(uji::sys::Pad::Button  button)
{
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    while(  !( (sys::Pad().IsButtonPress(button)) )  )
    {
        // L[͂̊mF
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus);
    }

    return;
}


}
}
}
