/*--------------------------------------------------------------------------*
 Project:
 File: TestAcc.cpp

*--------------------------------------------------------------------------*/

#include <nn.h>
#include <stdlib.h>
#include <vector>
#include <nn/cfg/CTR/detail/cfg_SecureInfo.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/fnd.h>
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/gx.h>
#include <nn/gx/CTR/gx_LcdPowerManager.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_HidBase.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hid/CTR/hid_AccelerometerCalibrator.h>
#include <nw/types.h>
#include <nn/uds.h>

#include "sys_App.h"
#include "sys_Pad.h"
#include "TestAcc.h"
#include "TestAccErrorCode.h"
#include "TestAccTool.h"
#include "../gyro/gyro_AgingTester.h"
#include "../gyro/gyro_EvaMenu.h"
#include "../gyro/gyro_ShockTester.h"
#include "../gyro/gyro_UdsClient.h"
#include "../mcu/McuInitializer.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/TesterLog/ProductionLogDummy.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestListManager.h"
#include "../seq/TestResult.h"
#include "../seq/TestSequencer.h"
#include "../sys/sys_SoundPlayer.h"
#include "../sys/sys_GetMacAddress.h"
#include "../sys/sys_GetSerialNumber.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

// 2ځA2ڂ̌ȗꍇ͂̒`s
#define SHORT_VERSION

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
using namespace uji::eva::mcu;
using namespace uji::eva::acc;

namespace uji {
namespace eva {
namespace acc {


//============================================================================
//    R{^̂҂֐
//============================================================================
bool WaitButtonR(seq::TestResult &result)
{

    // RtBOp
    Config::Member accMember;
    Config accConfig;
    accMember = accConfig.Get();

    uji::eva::acc::DemoAcc *p = new uji::eva::acc::DemoAcc;

	// LINE[hSDɃOޏꍇA܂QC[hSDɃOޏꍇSDJ[h̊mFs
	if( ((accMember.TestMode == 0) && (accMember.LINE_Write_SD_Flag == 1)) || ((accMember.TestMode == 1) && (accMember.QC_Write_SD_Flag == 1)) )
	{
	    //rcJ[h̑}mF
	    if( !nn::fs::IsSdmcInserted() )
	    {
	        strcpy( result.m_String, "NO SD CARD" );
	        result.m_Micro = 1;
	        result.m_Result = false;
	        return result.m_Result;
	    }
	
	    //CgveNgmF
	    if( !nn::fs::IsSdmcWritable() )
	    {
	        strcpy( result.m_String, "WRITE PROTECTED" );
	        result.m_Micro = 2;
	        result.m_Result = false;
	        return result.m_Result;
	    }
	}

    p->accWaitButtonR();

    delete p;

    result.m_Result = 1;

    return result.m_Result;
    
}


//============================================================================
// R{^̂҂֐(ʕ\)
//============================================================================
void DemoAcc::accWaitButtonR()
{

    // RtBOp
    Config::Member accMember;
    Config accConfig;
    accMember = accConfig.Get();

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();

    // {̂Ԃŉo悤ɂ
    nn::snd::SetHeadphoneOutOnShellClose(false);

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    gfx->m_DrawFramework->Clear();

    //  EChE
    m_WindowManager.UpdatePad(pad);  // pbh
    m_WindowManager.Update();        // XV
    m_WindowManager.DrawDisplay0();

    //  `
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

    // `̑O
//    gfx->BeginDrawingString();
    gfx->SetFixedWidthFont(16);
    gfx->m_TextWriter.SetCursor(10, 20);

    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;

    // 摜XV
    if((accMember.TestMode == 0) && (accMember.LINE_Write_SD_Flag == 0)) jpegDrawer->OpenPicture(L"rom:/jpeg/CloseAndPushRforCIS.jpg");
    else    jpegDrawer->OpenPicture(L"rom:/jpeg/CloseAndPushR.jpg");
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    glFlush();
    gfx->m_DrawFramework->SwapBuffers();

    while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) )  )
    {
        // L[͂̊mF
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus);
    }

    jpegDrawer->ClosePicture();
    delete jpegDrawer;

}


//============================================================================
//    Gyro̐~Ԍ
//============================================================================
bool GyroAgingTest(seq::TestResult &result)
{

    GyroAgingTester g;
    g.Test(result);

    return result.m_Result;

}


//============================================================================
//                         xZT
//============================================================================
bool AccelerometerTest(seq::TestResult &result)
{

    uji::eva::acc::DemoAcc *p = new uji::eva::acc::DemoAcc;

    result = p->Run();

    delete p;
    return result.m_Result;

}


/*---------------------------------------------------------------------------
 Desc:  xZTs(Z-1GY1GX-1GY1GZ-1G̏Ɍ)
        IAA{^ōČAB{^Ńj[ʂɕA
---------------------------------------------------------------------------*/
seq::TestResult DemoAcc::Run()
{
    // ʊi[p
    seq::TestResult acc_result;

    // p
    uji::sys::SoundPlayer *q = new uji::sys::SoundPlayer;


    q->UjiSoundPlayer( "rom:/SoundPlayer/fanfare_16bit_fs32kHz_1ch.wav", 1 );

    // Ԍvp
    nn::os::Tick start_tick;
    s64 test_time = 0;

    // Ԍvp(xg[^)
    nn::os::Tick test_start_tick;
    s64 all_time = 0;

    // Ԍvp(莞)
    nn::os::Tick stability_tick;
    s64 stability_time = 0;

    // Ԍvp(莞)
    nn::os::Tick gravity_tick;
    s64 gravity_time = 0;

    // f[^p̃JE^[
    s32 data_counter = 0;
    
    // gC
    s32 retry_counter = 0;
    s32 retry_error_counter = 0;
    
	test_start_tick = nn::os::Tick::GetSystemCurrent();
    
    // xZTl
    s32 gx = 0;
    s32 gy = 0;
    s32 gz = 0;

    // TvOxZTl̒ł̍őƍŏ
    s32 gx_max = -2048;
    s32 gx_min = 2048;
    s32 gy_max = -2048;
    s32 gy_min = 2048;
    s32 gz_max = -2048;
    s32 gz_min = 2048;

    // Ԉ莞̃JEgi[ϐ
    u32 stability_count_gx = 0;
    u32 stability_count_gy = 0;
    u32 stability_count_gz = 0;
    
	// TvO̒l񐔈ȏ肵Ăꍇ1ɂȂtO
    u32 stability_ok_flag = 0;

    // e̔肪NG̏ꍇ̓tOPɂȂ
    u32 ng_flag_x = 0;
    u32 ng_flag_y = 0;
    u32 ng_flag_z = 0;

    // CTR VAio[i[p
    char m_serialNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN +1];//VANO

    // NGĂȂꍇ0ANGꍇ0ȊO
    u32 ng_code = RESULT_OK;
    u32 tmp_ng_code = 0;
    u32 another_ng_code = RESULT_OK;
    u32 sd_ng_code = RESULT_OK;

    // ǂ̒iK܂Ői񂾂ϐ Z莞:1 Y莞:2 X莞:3 
    u32 test_process = 1;

    // xZT
    nn::hid::AccelerometerReader accReader;
    nn::hid::AccelerometerStatus accStatus;
    nn::hid::AccelerometerStatus accStatusRaw;

    // ʊi[p(ɓꂽl͍̂Ƃ딻ɎgĂ܂B)
    TestResult test_result;

    // RtBOp
    Config::Member accMember;
    Config accConfig;
    accMember = accConfig.Get();

    // ʕ\ڗp\
    ShowPassage pse;

	// TvOli[ϐ		AccStabilityNum:100		AccSamplingNum:30
    s32 sampling_buf_x[6][accMember.AccStabilityNum];
    s32 sampling_buf_y[6][accMember.AccStabilityNum];
    s32 sampling_buf_z[6][accMember.AccStabilityNum];

	// 肷邱ƂmFۂ̃TvO:AccStabilityNum > 肵ƂmFłA̒ōŐVAccSamplingNum̃f[^CALlƂĎg
    // AccSamplingNum񐔕̕ϒl(5OKȂ̂łƂ65ɕύX)
    s32 smpl_average_x[5] = { -10000, -10000, -10000, -10000, -10000 };
    s32 smpl_average_y[5] = { -10000, -10000, -10000, -10000, -10000 };
    s32 smpl_average_z[5] = { -10000, -10000, -10000, -10000, -10000 };

	// AccStabilityNum񐔕̍ŏl
	s32 smpl_Min_x[5] = { -10000, -10000, -10000, -10000, -10000 };
	s32 smpl_Min_y[5] = { -10000, -10000, -10000, -10000, -10000 };
	s32 smpl_Min_z[5] = { -10000, -10000, -10000, -10000, -10000 };

	// AccStabilityNum񐔕̍ől
	s32 smpl_Max_x[5] = { -10000, -10000, -10000, -10000, -10000 };
	s32 smpl_Max_y[5] = { -10000, -10000, -10000, -10000, -10000 };
	s32 smpl_Max_z[5] = { -10000, -10000, -10000, -10000, -10000 };

	// AccSamplingNum񐔕̍ől
	s32 sample_max_x[5] = { -10000, -10000, -10000, -10000, -10000 };
	s32 sample_max_y[5] = { -10000, -10000, -10000, -10000, -10000 };
	s32 sample_max_z[5] = { -10000, -10000, -10000, -10000, -10000 };

	// AccSamplingNum񐔕̍ŏl
    s32 sample_min_x[5] = { 100000, 100000, 100000, 100000, 100000 };
    s32 sample_min_y[5] = { 100000, 100000, 100000, 100000, 100000 };
    s32 sample_min_z[5] = { 100000, 100000, 100000, 100000, 100000 };

    char ng_code_str[20] = "NG";
    
    // SetAccCalCore֐G[߂li[
    char err_info[81] = "";
    
    // ʕ\p
    char str_ng_Average[256]    = "";

    // callƂď܂Ă0_̒lƁA񌟍ۂ0_̒l̍
    // callƂď܂Ă1G̒lƁA񌟍ۂ1G̒l̍(%\)̕i[
    char str_dif[512];

    // [vpϐ
    int i,k,j;

	// 2񑪂0Gl̍傫قȂꍇ1ɂȂtO
	s32 diff_x0_yz_flag = 0;
	s32 diff_y0_zx_flag = 0;
	s32 diff_z0_xy_flag = 0;
	
	// 2Ŏ0G̒l̍傫NGꍇ1ɂȂtO
	s32 diff0g_ng_counter = 0;
	s32 diff0g_ng_flag = 0;			// diff0g_ng_counter1ɂȂƂ1ɂȂtO(Aʔ莞ɃtO0ɖ߂ǍAtO͓x1ɂȂȂ)
	s32 diff0g_limit = 0;
	
	// 0G̐l臒l𒴂NGꍇ1ɂȂtO
	s32 limit_ng_counter = 0;
	s32 limit_ng_flag = 0;			// 1ɂȂƂ1ɂȂtO(Aʔ莞ɃtO0ɖ߂ǍAtO͓x1ɂȂȂ)
	s32 pre_limit_ng_counter = 0;
	s32 upper_limit_0g = 0;			// 0Gl臒l
	s32 lower_limit_0g = 0;			// 0Gl臒l

    // J[\ʒup
    uji::sys::Point cursorPos;

    // {^p
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    // xl֐(ReadRaw)g߂ɕKv
    nn::hid::AccelerometerCalibrator testAcc;

    // ConvertToAccelerationpϐ
    nn::hid::AccelerationFloat acceleration;

#define ERR_NUM 9000
//#define ERR_STR_LEN 28
#define ERR_STR_LEN 20
    static char strAllDifStability[ERR_NUM*(ERR_STR_LEN+1)] = "";
    static char strDifStability[ERR_NUM+1][28];
    u16 raw_counter = 0;

    memset( strAllDifStability, 0x00, sizeof(strAllDifStability) );
    memset( strDifStability,    0x00, sizeof(strDifStability)    );

//#define GETTINT_NG_LOG
    
    // ʕ\p
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // WĂĂʕ\܂܂ɂ֐
    nn::gx::CTR::LcdPowerManager::TurnOnAll();

    McuInitializer().HwCheckInit();

    //  xZT̒Ǐ]̐ݒ
    accReader.SetSensitivity(accMember.Play, accMember.Sensitivity);  // Ǐ]̐ݒ

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // SerialNumber̎擾
    uji::sys::GetSerialNumber( m_serialNo );

    // WaitSamplingp
    nn::hid::Accelerometer& accelerometer = nn::hid::GetAccelerometer( );

    // ԌvJn
    start_tick = nn::os::Tick::GetSystemCurrent();
	
    // m点v_
    uji::eva::mcu::NotifyLedBlueOn(test_result);

	// xCALlވׂ̕ϐ
	nn::hid::AccelerometerCalibrateParam acc_cal_param;

	// callƂď܂ĂlǂݏoɊi[邽߂̕ϐ
	s32 cal_x0 = -10000;
	s32 cal_y0 = -10000;
	s32 cal_z0 = -10000;
	s32 cal_x1 = 0;
	s32 cal_y1 = 0;
	s32 cal_z1 = 0;

	// Lcal_**̒l𕂓_^ϐɕϊۂɎgϐ
	float f_cal_x1 = 0;
	float f_cal_y1 = 0;
	float f_cal_z1 = 0;
	
	s32 x_ng_flag = 0;
	s32 y_ng_flag = 0;
	s32 z_ng_flag = 0;
	
	s32 old_x, old_y, old_z;

	// LINE[h̏ꍇ  Lu[Vl
	if( accMember.TestMode != 0 )
	{
		// i[ĂLu[Vlǂݏo
		GetAccCalCore(&acc_cal_param);
		cal_x0 = acc_cal_param.x.offset;
		cal_x1 = acc_cal_param.x.scale;
		cal_y0 = acc_cal_param.y.offset;
		cal_y1 = acc_cal_param.y.scale;
		cal_z0 = acc_cal_param.z.offset;
		cal_z1 = acc_cal_param.z.scale;
	
		// 1ĜƂ̒l𕂓_^ϐɑ
		f_cal_x1 = cal_x1;
		f_cal_y1 = cal_y1;
		f_cal_z1 = cal_z1;
	}

    stability_tick = nn::os::Tick::GetSystemCurrent();
	gravity_tick = nn::os::Tick::GetSystemCurrent();

    do
    {
		// 1xNGɂȂꍇ
		if( diff0g_ng_counter > 0 )
		{
			diff0g_limit = accMember.DiffRange0G + accMember.AgainAdditionDiff;
		}
		else
		{
			diff0g_limit = accMember.DiffRange0G;
		}

		// Ԉ莞̃JEgi[ϐZbg
        stability_count_gx = 0;
        stability_count_gy = 0;
        stability_count_gz = 0;
		
		// f[^JE^[L^
		// gC(retry_counter)+1  (肵AAXYZꂩ̃ZT[̐l臒lɎ܂ĂȂꍇɃgC񐔂+1B)
		if((retry_counter+retry_error_counter)<ERR_NUM) retry_counter++;
		gravity_time = GetMilliSecond(gravity_tick);
#ifdef GETTINT_NG_LOG
		sprintf( strDifStability[retry_counter+retry_error_counter], "L:%d-%d-%d t:%lld %d:%d:%d,", test_process, retry_counter, retry_error_counter, gravity_time, gx, gy, gz );
		strcat(strAllDifStability, strDifStability[retry_counter+retry_error_counter]);
		NN_LOG("%s\n", strDifStability[retry_counter+retry_error_counter]);
#endif
		// f[^p̃JE^[Zbg
		data_counter = 0;
		gravity_tick   = nn::os::Tick::GetSystemCurrent();
		stability_tick = nn::os::Tick::GetSystemCurrent();

        // 萫̊mF[v
        do
        {
            test_time = GetMilliSecond(start_tick);

            // Jn莞Ԃo߂Ăꍇ
            if ( (test_time/1000) >= accMember.TimeOut )
            {
                test_process = TIME_OUT;

                if( ng_code == RESULT_OK )
                {
                    ng_code = test_process * 100 + TIME_OUT;
                }
                else if( another_ng_code == RESULT_OK )
                {
                    another_ng_code = test_process * 100 + TIME_OUT;
                }

                NN_LOG("TIME_OUT [%d - %d]\n", test_process, ng_code);
                break;
            }

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // ̉xli[܂wait
            accelerometer.WaitSampling();

            // xZT[l̎擾
            testAcc.ReadRaw(&accStatusRaw);
            sampling_buf_x[test_process-1][data_counter] = gx = accStatusRaw.x;
            sampling_buf_y[test_process-1][data_counter] = gy = accStatusRaw.y;
            sampling_buf_z[test_process-1][data_counter] = gz = accStatusRaw.z;
            
			sprintf( strDifStability[raw_counter], " %d %d %d,", gx, gy, gz );
			strcat( strAllDifStability, strDifStability[raw_counter] );
            
            raw_counter++;

            // ------------------ẍmF--------------------
            // ܂ł̃TvO̒ł̍őlEŏlXV
            if(gx_max < gx) gx_max = gx;
            if(gx_min > gx) gx_min = gx;

            // őlƍŏl̍l𒴂Ăꍇ(肵ĂȂꍇ)
            if( (gx_max - gx_min) > accMember.AccStabilityRange )
            {
				old_x = gx_max - gx_min;
				
                gx_max = gx;
                gx_min = gx;
                stability_count_gx = 0;
                data_counter = -1;

				x_ng_flag = 1;

                if( stability_ok_flag == 1 )
                {
                    ng_code = another_ng_code;
                }
                else
                {
                    ng_code = test_process * 100 + UNSTABLE_X;
                }
            }
            else
            {
                stability_count_gx++;
            }

            // ------------------ÿmF--------------------
            // ܂ł̃TvO̒ł̍őlEŏlXV
            if(gy_max < gy) gy_max = gy;
            if(gy_min > gy) gy_min = gy;

            // őlƍŏl̍l𒴂Ăꍇ(肵ĂȂꍇ)
            if( (gy_max - gy_min) > accMember.AccStabilityRange )
            {
				old_y = gy_max - gy_min;

                gy_max = gy;
                gy_min = gy;
                stability_count_gy = 0;
                data_counter = -1;

				y_ng_flag = 1;


                if( stability_ok_flag == 1 )
                {
                    ng_code = another_ng_code;
                }
                else
                {
                    if(ng_code == UNSTABLE_X) ng_code = test_process * 100 + UNSTABLE_XY;
                    else                      ng_code = test_process * 100 + UNSTABLE_Y;
                }
            }
            else
            {
                stability_count_gy++;
            }

            // ------------------z̈mF--------------------
            // ܂ł̃TvO̒ł̍őlEŏlXV
            if(gz_max < gz) gz_max = gz;
            if(gz_min > gz) gz_min = gz;

            // őlƍŏl̍l𒴂Ăꍇ(肵ĂȂꍇ)
            if( (gz_max - gz_min) > accMember.AccStabilityRange )
            {
                old_z = gz_max - gz_min;

                gz_max = gz;
                gz_min = gz;
                stability_count_gz = 0;
                data_counter = -1;

				z_ng_flag = 1;


                if( stability_ok_flag == 1 )
                {
                    ng_code = another_ng_code;
                }
                else
                {
                    if(ng_code == UNSTABLE_XY)      ng_code = test_process * 100 + UNSTABLE_XYZ;
                    else if(ng_code == UNSTABLE_X)  ng_code = test_process * 100 + UNSTABLE_ZX;
                    else if(ng_code == UNSTABLE_Y)  ng_code = test_process * 100 + UNSTABLE_YZ;
                    else                            ng_code = test_process * 100 + UNSTABLE_Z;
                }
            }
            else
            {
                stability_count_gz++;
            }


			if( x_ng_flag == 1 || y_ng_flag == 1 || z_ng_flag == 1 )
			{
				stability_time = GetMilliSecond(stability_tick);
				if((retry_counter+retry_error_counter)<ERR_NUM)
				{
					retry_error_counter++;

#ifdef GETTINT_NG_LOG
					sprintf( strDifStability[retry_counter+retry_error_counter], "c:%d-%d-%d  t:%lld  x:%d y:%d z:%d ,", test_process, retry_counter, retry_error_counter, stability_time, old_x, old_y, old_z );
					strcat(strAllDifStability, strDifStability[retry_counter+retry_error_counter]);
					NN_LOG("%s\n", strDifStability[retry_counter+retry_error_counter]);
#endif
				}
				gravity_tick   = nn::os::Tick::GetSystemCurrent();
				stability_tick = nn::os::Tick::GetSystemCurrent();

				x_ng_flag = 0;
				y_ng_flag = 0;
				z_ng_flag = 0;
				
				old_x = 0;
				old_y = 0;
				old_z = 0;
			}


            gfx->m_DrawFramework->Clear();

            /*
                EChE
            */
            m_WindowManager.UpdatePad(pad);  // pbh
            m_WindowManager.Update();        // XV
            m_WindowManager.DrawDisplay0();

            /*
                `
            */
            gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

            // `̑O
//            gfx->BeginDrawingString();
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
            gfx->m_TextWriter.SetCursor(40, 20);

            // ʕ\p̒l
            pse.test_process = test_process;
            pse.stability_count_gx = stability_count_gx;
            pse.stability_count_gy = stability_count_gy;
            pse.stability_count_gz = stability_count_gz;
            pse.accMember = accMember;
            pse.gx = gx;
            pse.gy = gy;
            pse.gz = gz;
            pse.ng_code = ng_code;
            pse.test_time = test_time;
            pse.ng_flag_x = ng_flag_x;
            pse.ng_flag_y = ng_flag_y;
            pse.ng_flag_z = ng_flag_z;
            pse.gfx = gfx;

            // ʕ\p֐
            ShowAccTestPassage(pse, limit_ng_counter, diff0g_limit);

            glFlush();
            gfx->m_DrawFramework->SwapBuffers();

            // TvO
            data_counter++;

            // 萔̃Tv̒l肵Ăꍇbreak
            if( data_counter >= accMember.AccStabilityNum )
            {
                ng_code = RESULT_OK;
                stability_ok_flag = 1;
                break;
            }

        // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
        } while( !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );


		//-------------------------------------------肵ꍇ͂牺-------------------------------------------------

        if( ( test_process >= 1 ) && ( test_process <= 5 ) )
        {
            smpl_Min_x[test_process-1] = gx_min;
            smpl_Min_y[test_process-1] = gy_min;
            smpl_Min_z[test_process-1] = gz_min;

            smpl_Max_x[test_process-1] = gx_max;
            smpl_Max_y[test_process-1] = gy_max;
            smpl_Max_z[test_process-1] = gz_max;
        }

        // ------------------x͈͓Ɏ܂Ă邩̊mF------------------

        // ^CAEgɂȂĂȂꍇ
        if( test_process != TIME_OUT )
        {

            // SAMPLING_NUM̊ԁAf[^OK͈͂ɂ邱ƂmF   NGR[hNG邽тɏ㏑܂B
            for(i=0;i<accMember.AccSamplingNum;i++)
            {

                // L[͂̊mF
                padReader.ReadLatest(&padStatus);
                pad.UpdatePad(padStatus);

                // xZT̊mF
                gx = sampling_buf_x[test_process-1][accMember.AccStabilityNum-1 - i];
                gy = sampling_buf_y[test_process-1][accMember.AccStabilityNum-1 - i];
                gz = sampling_buf_z[test_process-1][accMember.AccStabilityNum-1 - i];

                // QC̏ꍇ
                if( (accMember.TestMode == 1) || (accMember.TestMode == 9) )
                {
                    // z`FbN
                    if( ( test_process == 1 ) || ( test_process == 5 ) )
                    {
                        ng_flag_x = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gx );
                        ng_flag_y = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gy );
                        ng_flag_z = AccelerometerTest( - accMember.QC_Z_1G_Max, -   accMember.QC_Z_1G_Min, gz );
                    }
                    // y`FbN
                    else if( ( test_process == 2 ) || ( test_process == 4 ) )
                    {
// SPFLp
						if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType() )
						{
	                        ng_flag_x = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gx );
	                        ng_flag_y = AccelerometerTest( - accMember.QC_Y_1G_Min, - accMember.QC_Y_1G_Max, gy );
	                        ng_flag_z = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gz );
						}
// CTRp
						else
						{
	                        ng_flag_x = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gx );
	                        ng_flag_y = AccelerometerTest( accMember.QC_Y_1G_Max,       accMember.QC_Y_1G_Min, gy );
	                        ng_flag_z = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gz );
						}
                    }
                    // x`FbN
                    else if( test_process == 3 )
                    {
                        ng_flag_x = AccelerometerTest( - accMember.QC_X_1G_Max, -   accMember.QC_X_1G_Min, gx );
                        ng_flag_y = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gy );
                        ng_flag_z = AccelerometerTest( accMember.QC_ALL_0G_Max, - accMember.QC_ALL_0G_Min, gz );
                    }
                }
                else
                {
					// 0GA1G̐lNGɂȂĂȂꍇ
					if( limit_ng_counter == 0 )
					{
						upper_limit_0g = accMember.ALL_0G_Max;
						lower_limit_0g = accMember.ALL_0G_Min;
					}
					// 0G̒l臒l1xNGɂȂꍇ(0G臒l75136ɍL܂)
					else
					{
						upper_limit_0g = accMember.ALL_0G_Max + accMember.AgainAddition0G;
						lower_limit_0g = accMember.ALL_0G_Min + accMember.AgainAddition0G;
					}

                    // z`FbN
                    if( ( test_process == 1 ) || ( test_process == 5 ) )
                    {
                        ng_flag_x = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gx );
                        ng_flag_y = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gy );
                        ng_flag_z = AccelerometerTest( - accMember.Z_1G_Max, -   accMember.Z_1G_Min, gz );
                    }
                    // y`FbN
                    else if( ( test_process == 2 ) || ( test_process == 4 ) )
                    {
//SPFLp
						if(uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
						{
	                        ng_flag_x = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gx );
	                        ng_flag_y = AccelerometerTest( - accMember.Y_1G_Min, -   accMember.Y_1G_Max, gy );
	                        ng_flag_z = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gz );
						}
// CTRp
						else
						{
	                        ng_flag_x = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gx );
	                        ng_flag_y = AccelerometerTest( accMember.Y_1G_Max, accMember.Y_1G_Min, gy );
	                        ng_flag_z = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gz );
						}

                    }
                    // x`FbN
                    else if( test_process == 3 )
                    {
                        ng_flag_x = AccelerometerTest( - accMember.X_1G_Max, - accMember.X_1G_Min, gx );
                        ng_flag_y = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gy );
                        ng_flag_z = AccelerometerTest( upper_limit_0g, - lower_limit_0g, gz );
                    }
                }

                // NGĂ鎲ɃG[R[h쐬
                ng_code = MakeErrorNumberXYZ( ng_flag_x, ng_flag_y, ng_flag_z, test_process * 100 + AXIS_ERROR );

                if( ng_code != 0 )
                {
					i = 99999;
					pre_limit_ng_counter = 1;
				}

                gfx->m_DrawFramework->Clear();

                /*
                    EChE
                */
                m_WindowManager.UpdatePad(pad);  // pbh
                m_WindowManager.Update();        // XV
                m_WindowManager.DrawDisplay0();

                /*
                    `
                */
                gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

                // `̑O
//                gfx->BeginDrawingString();

                gfx->SetFixedWidthFont(9);
                gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);

                gfx->SetFixedWidthFont(16);
                gfx->m_TextWriter.SetCursor(40, 20);

                // ʕ\p̒l
                pse.test_process = test_process;
                pse.stability_count_gx = stability_count_gx;
                pse.stability_count_gy = stability_count_gy;
                pse.stability_count_gz = stability_count_gz;
                pse.accMember = accMember;
                pse.gx = gx;
                pse.gy = gy;
                pse.gz = gz;
                pse.ng_code = ng_code;
                pse.test_time = test_time;
                pse.ng_flag_x = ng_flag_x;
                pse.ng_flag_y = ng_flag_y;
                pse.ng_flag_z = ng_flag_z;
                pse.gfx = gfx;

                ShowAccTestPassage(pse, limit_ng_counter, diff0g_limit);

            }
            // 1łNG_ ܂ TvׂOKɂȂƂ ܂ ^CAEg Ń[v𔲂

        }       //if( test_process != TIME_OUT )
        else
        {
            NN_LOG("TIME OUT [%d - %d]\n",test_process, ng_code);
        }

		// TvOf[^̒l𑫂킹vi[ϐ
		s64 sample_sum_x = 0;
		s64 sample_sum_y = 0;
		s64 sample_sum_z = 0;
		
		// AccStabilityNum(100)̓AŐVAccSamplingNum(30)ɑ΂őlsample_maxEŏlsample_minсAϒl擾
		for(k=0;k<accMember.AccSamplingNum;k++)
		{
			// TvOf[^̒l𑫂킹
		    sample_sum_x += sampling_buf_x[test_process-1][accMember.AccStabilityNum-1 - k];
		    sample_sum_y += sampling_buf_y[test_process-1][accMember.AccStabilityNum-1 - k];
		    sample_sum_z += sampling_buf_z[test_process-1][accMember.AccStabilityNum-1 - k];

			// TvOf[^̍őlo
		    if(sampling_buf_x[test_process-1][accMember.AccStabilityNum-1 - k] > sample_max_x[test_process-1]) sample_max_x[test_process-1] = sampling_buf_x[test_process-1][accMember.AccStabilityNum-1 - k];
		    if(sampling_buf_y[test_process-1][accMember.AccStabilityNum-1 - k] > sample_max_y[test_process-1]) sample_max_y[test_process-1] = sampling_buf_y[test_process-1][accMember.AccStabilityNum-1 - k];
		    if(sampling_buf_z[test_process-1][accMember.AccStabilityNum-1 - k] > sample_max_z[test_process-1]) sample_max_z[test_process-1] = sampling_buf_z[test_process-1][accMember.AccStabilityNum-1 - k];

			// TvOf[^̍ŏlo
		    if(sampling_buf_x[test_process-1][accMember.AccStabilityNum-1 - k] < sample_min_x[test_process-1]) sample_min_x[test_process-1] = sampling_buf_x[test_process-1][accMember.AccStabilityNum-1 - k];
		    if(sampling_buf_y[test_process-1][accMember.AccStabilityNum-1 - k] < sample_min_y[test_process-1]) sample_min_y[test_process-1] = sampling_buf_y[test_process-1][accMember.AccStabilityNum-1 - k];
		    if(sampling_buf_z[test_process-1][accMember.AccStabilityNum-1 - k] < sample_min_z[test_process-1]) sample_min_z[test_process-1] = sampling_buf_z[test_process-1][accMember.AccStabilityNum-1 - k];

		}

		// TvOf[^畽ϒl擾
		smpl_average_x[test_process-1] = sample_sum_x / accMember.AccSamplingNum;
		smpl_average_y[test_process-1] = sample_sum_y / accMember.AccSamplingNum;
		smpl_average_z[test_process-1] = sample_sum_z / accMember.AccSamplingNum;

		NN_LOG("ave[%d - %d] x:%d  y:%d  z:%d \n", test_process, ng_code, smpl_average_x[test_process-1], smpl_average_y[test_process-1], smpl_average_z[test_process-1]);

		stability_count_gx = 0;
		stability_count_gy = 0;
		stability_count_gz = 0;

        // OK̏ꍇ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        if ( ng_code == RESULT_OK )
        {

			pre_limit_ng_counter = 0;

            stability_ok_flag = 0;

            uji::eva::mcu::SetMasterLedMax(test_result);
            
            // ZOKm点v_
            if( test_process == 5 -1 )  uji::eva::mcu::NotifyLedBlueOn(test_result);

            // YOKm点vΓ_
            else if( ( test_process == 2 -1 ) || ( test_process == 4 -1 ) ) uji::eva::mcu::NotifyLedGreenOn(test_result);

            // XOKm点vԓ_
            else if( test_process == 3 -1 ) uji::eva::mcu::NotifyLedRedOn(test_result);

            // ׂĂ̎̌IĂȂꍇ
            // o
            if( test_process < 5 )
            {
                // TEh
                ng_code = q->UjiSoundPlayer( "rom:/SoundPlayer/fanfare_16bit_fs32kHz_1ch.wav", 1500 );

                if ( ng_code == uji::sys::SoundPlayer::SOUND_TRY_INIT_NG ) ng_code = SOUND_NG1 + test_process * 100;
                else if ( ng_code == uji::sys::SoundPlayer::SOUND_ALLOC_NG ) ng_code = SOUND_NG2 + test_process * 100;
            }

            test_process++;

            // ԌvJn
             start_tick = nn::os::Tick::GetSystemCurrent();

        }//------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        // ^CAEgȊONGɂȂĂꍇ
        else if ( test_process != TIME_OUT )
        {
            if( test_process <= 5 )
            {
                if( ng_code != RESULT_OK ) another_ng_code = ng_code;
                ng_code = RESULT_OK;
            }
        }

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // OK̏ꍇA܂TIME OUT̏ꍇ------------------------------------------------------------------------------------------------------------
#ifdef SHORT_VERSION
        if( test_process > 3 ) test_process = test_process + 2;		//p4,5(ڂY,Z)Ȃꍇ
#endif
        if( test_process > 5 )
        {
            NN_LOG("5[%d - %d] x:%d  y:%d  z:%d \n", test_process, ng_code, gx, gy, gz);

            char result_str[256];			// ʕ(͂̕rcJ[h(ږFResult)ɋL^̂ƓłB)
            char ng_info_str[128] = "";		// ʏڍ׏񕶎(͂̕rcJ[h(ږFInfo)ɋL^̂ƓłB)

            // Lup̒l
            s32 x0 = 0, x1 = 0;
            s32 y0 = 0, y1 = 0;
            s32 z0 = 0, z1 = 0;

			// 1G̒l(1G̐l0G̐l(2̒l𕽋ω))x1,y1,z1𕂓_^ϐɕϊۂɎgϐ
			float f_x1, f_y1, f_z1;
			
			// callƂď܂Ă0_̒lƁA񌟍ۂ0_̒l̍
            s32 diff_x0 = -10000;
            s32 diff_y0 = -10000;
            s32 diff_z0 = -10000;
            
            // callƂď܂Ă1G̒lƁA񌟍ۂ1G̒l̍(%\)
            float diff_x1 = -10000;
            float diff_y1 = -10000;
            float diff_z1 = -10000;

            // 2񑪂0Gl̍(Fx,y1Gl莞zl̍)
            s32 diff_x0_yz = -10000;
            s32 diff_y0_zx = -10000;
            s32 diff_z0_xy = -10000;
            
            // 0G܂1G̐l臒l𒴂Ăꍇ
            if( pre_limit_ng_counter != 0 )
            {
            	// ꎞIng_codeRESULT_OKɂ(L1̕Ōɖ߂)
            	tmp_ng_code = ng_code;
            	ng_code = RESULT_OK;
				
				limit_ng_counter++;
				
				// 臒lNG1ڂ̏ꍇ
				if( limit_ng_counter == 1 ) limit_ng_flag = 1;
            }
            
            if( ng_code == RESULT_OK )
            {
//--------------------------------------------------0_̒l2pꂼ̂Ƃő傫قȂȂƂ̊mF---------------------------------------------------------------
	            // y1ǦvɏIĂꍇ(x0G̃Lul߂ԂɂȂĂꍇ)
	            if( smpl_average_x[1] != -10000 )
	            {
		            diff_x0_yz = abs(smpl_average_x[0] - smpl_average_x[1]);

					if( diff_x0_yz > diff0g_limit ) diff_x0_yz_flag = 1;
				}

	            // x1ǦvɏIĂꍇ(y0GAz0G̃Lul߂ԂɂȂĂꍇ)
	            if( smpl_average_x[2] != -10000 )
				{
					diff_y0_zx = abs(smpl_average_y[0] - smpl_average_y[2]);
		            diff_z0_xy = abs(smpl_average_z[1] - smpl_average_z[2]);

					if( diff_y0_zx > diff0g_limit ) diff_y0_zx_flag = 1;
					if( diff_z0_xy > diff0g_limit ) diff_z0_xy_flag = 1;
				}
				
	            ng_code = MakeErrorNumberXYZ(diff_x0_yz_flag, diff_y0_zx_flag, diff_z0_xy_flag, DIFF_0G);
//--------------------------------------------------0_̒l2pꂼ̂ƂŒl傫قȂȂƂ̊mF  I-----------------------------------------------------
	            

//--------------------------------------------------callƂďޒl(0G̒lƊx␳p̒l)߂---------------------------------------------------------------
	            // 0GxZTl2𑫂2Ŋĕω
	            if( smpl_average_x[1] == -10000 ) x0 = -10000;
	            else                              x0 = (smpl_average_x[0] + smpl_average_x[1]) / 2;
	            if( smpl_average_y[2] == -10000 ) y0 = -10000;
	            else                              y0 = (smpl_average_y[0] + smpl_average_y[2]) / 2;
	            if( smpl_average_z[2] == -10000 ) z0 = -10000;
	            else                              z0 = (smpl_average_z[1] + smpl_average_z[2]) / 2;
	
	            // 1GxZTlقǋ߂0G̐l(ωꂽ)1Gcall߂
	            if( (smpl_average_x[2] == -10000) || (x0 == -10000) ) x1 = 0;
	            else                                                  x1 = (smpl_average_x[2] - x0);
	            if( (smpl_average_y[1] == -10000) || (y0 == -10000) ) y1 = 0;
	            else                                                  y1 = (smpl_average_y[1] - y0);
	            if( (smpl_average_z[0] == -10000) || (z0 == -10000) ) z1 = 0;
	            else                                                  z1 = (smpl_average_z[0] - z0);
//--------------------------------------------------callƂďޒl(0G̒lƊx␳p̒l)߂  I---------------------------------------------------------------
	
	            NN_LOG("x0:%d, y0:%d, z0:%d, x1:%d, y1:%d, z1:%d  \n", x0, y0, z0, x1, y1, z1);
	            NN_LOG("x0:%d, x1:%d, x2:%d  \n",  smpl_average_x[0],  smpl_average_x[1], smpl_average_x[2] );
	            NN_LOG("y0:%d, y1:%d, y2:%d  \n",  smpl_average_y[0],  smpl_average_y[1], smpl_average_y[2] );
	            NN_LOG("z0:%d, z1:%d, z2:%d  \n",  smpl_average_z[0],  smpl_average_z[1], smpl_average_z[2] );
	        }

			if(pre_limit_ng_counter != 0)
			{
				// ng_codeɖ߂        1
				if( ng_code == RESULT_OK ) ng_code = tmp_ng_code;
				
				tmp_ng_code = 0;

				pre_limit_ng_counter = 0;
			}

            // 1Gcall(CTR{̂ɕۑĂlł͂ȂǍœl)𕂓_^ϐɑ
            f_x1 = x1;
            f_y1 = y1;
            f_z1 = z1;

            // Y1G(p13)̏o͒ľ덷
            s32 cmp1_3_x = -10000;
            s32 cmp1_3_y = -10000;
            s32 cmp1_3_z = -10000;
			
			 // Z1G(p04)̏o͒ľ덷
            s32 cmp0_4_x = -10000;
            s32 cmp0_4_y = -10000;
            s32 cmp0_4_z = -10000;

#ifndef SHORT_VERSION
// 5pŒlꍇ(ȗo[Wł͂Ȃꍇ)

            // OK̏ꍇ͒ǉ Y,Z1ڂ2ڂŒl傫قȂȂƂ̊mF
            if( ng_code == RESULT_OK )
            {
                // Y1G(p13)̏o͒ľ덷Kl傫ꍇ(NG)1ɂȂtO
                bool cmp1_3_x_flag = 0;
                bool cmp1_3_y_flag = 0;
                bool cmp1_3_z_flag = 0;

                // Z1G(p04)̏o͒ľ덷Kl傫ꍇ(NG)1ɂȂtO
                bool cmp0_4_x_flag = 0;
                bool cmp0_4_y_flag = 0;
                bool cmp0_4_z_flag = 0;

                // Y̊mF(TvOf[^AccSamplingNum̕ϒl̍)
                cmp1_3_x = smpl_average_x[1] - smpl_average_x[3];
                cmp1_3_y = smpl_average_y[1] - smpl_average_y[3];
                cmp1_3_z = smpl_average_z[1] - smpl_average_z[3];

                if( abs(cmp1_3_x) > accMember.Reappearance ) cmp1_3_x_flag = 1;
                if( abs(cmp1_3_y) > accMember.Reappearance ) cmp1_3_y_flag = 1;
                if( abs(cmp1_3_z) > accMember.Reappearance ) cmp1_3_z_flag = 1;

                // NGĂ鎲ɃG[R[h쐬
                another_ng_code = MakeErrorNumberXYZ( cmp1_3_x_flag, cmp1_3_y_flag, cmp1_3_z_flag, test_process * 100 + CMP_Y_1_3_ERROR );

                // Z̊mF(TvOf[^AccSamplingNum̕ϒl̍)
                cmp0_4_x = smpl_average_x[0] - smpl_average_x[4];
                cmp0_4_y = smpl_average_y[0] - smpl_average_y[4];
                cmp0_4_z = smpl_average_z[0] - smpl_average_z[4];

                if( abs(cmp0_4_x) > accMember.Reappearance ) cmp0_4_x_flag = 1;
                if( abs(cmp0_4_y) > accMember.Reappearance ) cmp0_4_y_flag = 1;
                if( abs(cmp0_4_z) > accMember.Reappearance ) cmp0_4_z_flag = 1;

                NN_LOG( "\n Y x1:%d  y:%d  z:%d \n", smpl_average_x[1], smpl_average_y[1], smpl_average_z[1] );
                NN_LOG( "\n Y x3:%d  y:%d  z:%d \n", smpl_average_x[3], smpl_average_y[3], smpl_average_z[3] );
                NN_LOG( "\n Y cmp1_3_x:%d  y:%d  z:%d test_process:%d\n", cmp1_3_x, cmp1_3_y, cmp1_3_z, test_process );
                NN_LOG( "\n Y cmp1_3_x_flag:%d  y:%d  z:%d \n", cmp1_3_x_flag, cmp1_3_y_flag, cmp1_3_z_flag );

                NN_LOG( "\n Z x0:%d  y:%d  z:%d \n", smpl_average_x[0], smpl_average_y[0], smpl_average_z[0] );
                NN_LOG( "\n Z x4:%d  y:%d  z:%d \n", smpl_average_x[4], smpl_average_y[4], smpl_average_z[4] );
                NN_LOG( "\n Z cmp0_4_x:%d  y:%d  z:%d test_process:%d \n", cmp0_4_x, cmp0_4_y, cmp0_4_z, test_process );
                NN_LOG( "\n Z cmp0_4_x_flag:%d  y:%d  z:%d \n", cmp0_4_x_flag, cmp0_4_y_flag, cmp0_4_z_flag );

                // NGĂ鎲ɃG[R[h쐬
                ng_code = MakeErrorNumberXYZ( cmp0_4_x_flag, cmp0_4_y_flag, cmp0_4_z_flag, test_process * 100 + CMP_Z_0_4_ERROR );

                // ZNGȂꍇYł̃G[R[hng_codeɊi[
                if( ng_code == 0 )
                {
                    ng_code = another_ng_code;
                    another_ng_code = 0;
                }

                NN_LOG( "\n MakeErrorNumberXYZ:%d :%d :%d \n", test_process, ng_code, another_ng_code );

            }
#endif


//----------------------------tXP[`FbN----------------------------
			float full_scale_max_x = -10000;
			float full_scale_min_x = -10000;
			float full_scale_max_y = -10000;
			float full_scale_min_y = -10000;
			float full_scale_max_z = -10000;
			float full_scale_min_z = -10000;
			
            // ܂łŃG[ĂȂꍇ
            if( ng_code == RESULT_OK )
            {
				// X
				// tXP[+1.8Gȏł邱Ƃ̊mF
				full_scale_max_x = float(2048-x0)/f_x1;
				
				// tXP[-1.8Gȉł邱Ƃ̊mF
				full_scale_min_x = float(-2047-x0)/f_x1;

				// Y
				// tXP[+1.8Gȏł邱Ƃ̊mF
				full_scale_max_y = float(2048-y0)/f_y1;
				
				// tXP[-1.8Gȉł邱Ƃ̊mF
				full_scale_min_y = float(-2047-y0)/f_y1;
	
				// Z
				// tXP[+1.8Gȏł邱Ƃ̊mF
				full_scale_max_z = float(2048-z0)/f_z1;
				
				// tXP[-1.8Gȉł邱Ƃ̊mF
				full_scale_min_z = float(-2047-z0)/f_z1;
			
				s32 full_scale_x_flag = 0;
				s32 full_scale_y_flag = 0;
				s32 full_scale_z_flag = 0;

				if( abs(full_scale_max_x) * 1000 < accMember.FullScaleRange ) full_scale_x_flag = 1;
				if( abs(full_scale_max_y) * 1000 < accMember.FullScaleRange ) full_scale_y_flag = 1;
				if( abs(full_scale_max_z) * 1000 < accMember.FullScaleRange ) full_scale_z_flag = 1;
				if( abs(full_scale_min_x) * 1000 < accMember.FullScaleRange ) full_scale_x_flag = 1;
				if( abs(full_scale_min_y) * 1000 < accMember.FullScaleRange ) full_scale_y_flag = 1;
				if( abs(full_scale_min_z) * 1000 < accMember.FullScaleRange ) full_scale_z_flag = 1;

	            // Full Scale NGĂꍇ̓G[R[h쐬
	            if( full_scale_max_x || full_scale_max_y || full_scale_max_z ) ng_code = MakeErrorNumberXYZ( full_scale_x_flag, full_scale_y_flag, full_scale_z_flag, FULL_SCALE );
			}
//----------------------------tXP[`FbN I----------------------------

            // Y,Z̍Č܂߁AׂĂ̌OK̏ꍇ
            if( ng_code == RESULT_OK )
            {
                // LINE[h̏ꍇ  Lu[Vl
                if( accMember.TestMode == 0 )
                {
                    // SetAccCalCore֐G[߂l
                    s32 set_cal_err = 0;
                    
                    // vZďolCALlɑ
                    acc_cal_param.x.offset = x0;
                    acc_cal_param.x.scale  = -x1;
                    acc_cal_param.y.offset = y0;
					if(uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
						acc_cal_param.y.scale  = -y1;	// SPFLp
					else
						acc_cal_param.y.scale  = y1;	// CTRp
                    acc_cal_param.z.offset = z0;
                    acc_cal_param.z.scale  = -z1;

                    // vZďolCALlɐݒ肷
                    set_cal_err = SetAccCalCore(acc_cal_param);
                    if(set_cal_err != 0)
                    {
                        sprintf(err_info, "SetAccCalCore:%d", set_cal_err);
                        ng_code = SET_CAL_STATUS + test_process * 100;
                    }
                }
                // LINE[hȊȌꍇ Lu[VlǂݏoāǍ̃Lu[Vl(̒l͏܂Ȃ)Ɣr
                else
                {

//--------------------------------------------------------------------QCLINÊmF------------------------------------------------------------------------
					// callƂď܂Ă0_̒lƁA񌟍ۂ0_̒l̍
					diff_x0 = x0 - cal_x0;
					diff_y0 = y0 - cal_y0;
					diff_z0 = z0 - cal_z0;
					
					// callƂď܂Ă1G̒lƁA񌟍ۂ1G̒l̍(%\)
					diff_x1 = ( ( abs(f_x1) - abs(f_cal_x1) ) / abs(f_cal_x1) ) * 100;
					diff_y1 = ( ( abs(f_y1) - abs(f_cal_y1) ) / abs(f_cal_y1) ) * 100;
					diff_z1 = ( ( abs(f_z1) - abs(f_cal_z1) ) / abs(f_cal_z1) ) * 100;

					bool flag_offset_0 = 0;		// 0GY邩ǂ̔tO
					u32  ng_code_0 = RESULT_OK;	// 0GYꍇ̃G[R[hi[ϐ(YȂꍇ0)
                    
                    // 0G茋ʗpɃtOZbg
                    ng_flag_x = 0;
                    ng_flag_y = 0;
                    ng_flag_z = 0;

                    // 0GĂ邩ǂ̔
                    if( abs(diff_x0) > accMember.QC_0G_X_Offset ) ng_flag_x = 1;
                    if( abs(diff_y0) > accMember.QC_0G_Y_Offset ) ng_flag_y = 1;
                    if( abs(diff_z0) > accMember.QC_0G_Z_Offset ) ng_flag_z = 1;

                    if( (ng_flag_x == 1) || (ng_flag_y == 1) || (ng_flag_z == 1) ) flag_offset_0 = 1;

					// NGĂ鎲ɃG[R[h쐬(1)
                    ng_code_0 = MakeErrorNumberXYZ( ng_flag_x, ng_flag_y, ng_flag_z, test_process * 100 + QC_OFFSET_0 );

                    // 1G茋ʗpɃtOZbg
                    ng_flag_x = 0;
                    ng_flag_y = 0;
                    ng_flag_z = 0;

					// 1GĂ邩ǂ̔
                    if( abs(diff_x1 * 100) > accMember.QC_1G_X_Offset ) ng_flag_x = 1;
                    if( abs(diff_y1 * 100) > accMember.QC_1G_Y_Offset ) ng_flag_y = 1;
                    if( abs(diff_z1 * 100) > accMember.QC_1G_Z_Offset ) ng_flag_z = 1;

					// NGĂ鎲ɃG[R[h쐬
                    // 0GNG̏ꍇ
                    if( flag_offset_0 == 1 )
                    {
                    	// 0GE1GNGł
                    	if( ng_flag_x || ng_flag_y || ng_flag_z ) ng_code = ng_code_0 + QC_OFFSET_01 - QC_OFFSET_0;
                    	// 1GOK,0GNG̏ꍇ(̎_ng_codeRESULT_OK(0)Ă̂ŁA1̃G[R[h꒼)
                    	else ng_code = ng_code_0;
                    }
                    // 0GOK̏ꍇ
                    else ng_code = MakeErrorNumberXYZ( ng_flag_x, ng_flag_y, ng_flag_z, test_process * 100 + QC_OFFSET_1 );

//--------------------------------------------------------------------QCLINÊmF  I------------------------------------------------------------------------
                }

            }

            // ܂łɃG[ĂȂꍇ
            if( ng_code == RESULT_OK )
			{
				// ČOKɂȂꍇInfoɏc
				if( ( diff0g_ng_counter > 0 ) || ( limit_ng_counter > 0 ) )
				{
					sprintf(ng_info_str, "OK[d:%d][l:%d] 0G}%d[%d]", diff0g_ng_counter, limit_ng_counter, upper_limit_0g, diff0g_limit);
				}
				
                NN_LOG("OK\n");
				
				sprintf(result_str, ",OK,%s", ng_info_str);
            }
            // ܂łɃG[ꍇ
            else
            {

				if( diff_x0_yz_flag || diff_y0_zx_flag || diff_z0_xy_flag )
				{
					diff0g_ng_counter++;
					if( diff0g_ng_counter == 1 ) 
					{
						diff0g_ng_flag = 1;
					}
				}

				if( ( limit_ng_flag == 1 ) || ( diff0g_ng_flag == 1 ) )
					sprintf(ng_info_str, "AGAIN[d:%d][l:%d] 0G}%d[%d]", diff0g_ng_counter, limit_ng_counter, upper_limit_0g, diff0g_limit);
				else if( ( diff0g_ng_counter > 0 ) || ( limit_ng_counter > 0 ) )
					sprintf(ng_info_str, "NG[d:%d][l:%d] 0G}%d[%d]", diff0g_ng_counter, limit_ng_counter, upper_limit_0g, diff0g_limit);

                // ^CAEgG[ɂȂꍇ́A^CAEgÕG[R[hng_codeɊi[
                if( (ng_code%100 == TIME_OUT) && (another_ng_code != 0) )
                {
                    ng_code = another_ng_code;
                    another_ng_code = TIME_OUT + test_process * 100;
                }
                sprintf(result_str, ",%02d-%03d-%03d,%s"  , (s32)39, (s32)ng_code%1000, (s32)another_ng_code%1000, ng_info_str);
                sprintf(ng_code_str, "%02d-%03d-%03d"  , (s32)39, (s32)ng_code%1000, (s32)another_ng_code%1000);

                NN_LOG("NG %s \n", result_str);
            }

            // p[^o͐
            const wstring SD_PATH_DP0_4 = L"sdmc:/uji/Acc/AccLog.csv";
            string line;
            char strTestMode[20] = "";				// LINE,QCȂǂ̃eXg[h  (ږFTestMode)
            char str_config_crc[10] = "";			// RtBOCRC擾A쐬  (ږFCONFIG_CRC)
            char str_mac[32];						// MACAhX
            char strAccRaw[256]      = "";			// xZT CALlƂď܂Ăl(LINEŏޒlȂ̂ŒʏLINEł͒lĂȂ)A 
            										//     ̒lƍ̌ʂ瓾CALl̍ (ږFCAL_0G-*,,CAL_Sens-*,DIF_0G-*,DIF_Sens-*(%),0G-*,Sens-*))
            char strStability[256]  = "";			// p0,1,2ꂼ̂Ƃ̃Tvől|ŏl(ږFSta-*_0,Sta-*_1,Sta-*_2)
            char strCmpX13_Z04[256]      = "";		// Y(p13̂Ƃ)̍ČmF(TvOf[^AccSamplingNum̕ϒl̍)(ږFRep-*(1-3),Rep-*(0-4))
            char strAverage[256]    = "";			// AccSamplingNum̃Tv̕ϒl(ږFAve-:*_0`4)
            char strSmpMax[256]    = "";			
            char strSmpMin[256]    = "";			
            char strDiffXYZ[256]    = "";			
            char strFullScale[256]    = "";			
            char strAccTestTime_mS[32]        = "";
            char strBreak[2]        = "\n";			
            bit8 mac[nn::uds::MAC_ADDRESS_SIZE];	
            nn::Result nnr;							

            //  (ږF)
            // 
            //  o[W(ږFVer)͉ō쐬
            
            // LINE,QCȂǂ̃eXg[h  (ږFTestMode)
            sprintf(strTestMode, ",%s,", TestMode[accMember.TestMode]);

			// RtBOCRC擾A쐬  (ږFCONFIG_CRC)
			uji::seq::Config *c = new uji::seq::Config;
			sprintf(str_config_crc, "%d,", c->GetCheckCode());
			delete c;

            //l`bAhX擾itcrgpjAMacAddress  (ږFMacAddress)쐬
            sys::GetMacAddress(mac);
            sprintf(str_mac, "[%02X::%02X::%02X::%02X::%02X::%02X],", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
            
            // VAio[(ږFSerialNo)͏ŊɎ擾
            // G[R[h(ږFResult)͏(result_str)ŊɎ擾
            // ڍ׏(ږFInfo)͏(ng_info_str)ŊɎ擾

            // xZT CALlƂď܂Ăl(LINEŏޒlȂ̂ŒʏLINEł͒lĂȂ)A ̒lƍ̌ʂ瓾CALl̍
            // (ږFCAL_0G-*,,CAL_Sens-*,DIF_0G-*,DIF_Sens-*(%),0G-*,Sens-*)
            sprintf( strAccRaw, ",%d,%d,%d,%f,%f,%f,%d,%d,%d,%f,%f,%f,%d,%d,%d,%f,%f,%f,",
                cal_x0, cal_y0, cal_z0, abs(1000/f_cal_x1), abs(1000/f_cal_y1), abs(1000/f_cal_z1),
                diff_x0, diff_y0, diff_z0, diff_x1, diff_y1, diff_z1,
                x0, y0, z0, abs(1000/f_x1), abs(1000/f_y1), abs(1000/f_z1) );

            // p0,1,2ꂼ̂Ƃ̃Tvől|ŏl(ږFSta-*_0,Sta-*_1,Sta-*_2)
            sprintf( strStability,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,",
                smpl_Max_x[0]-smpl_Min_x[0], smpl_Max_y[0]-smpl_Min_y[0], smpl_Max_z[0]-smpl_Min_z[0],
                smpl_Max_x[1]-smpl_Min_x[1], smpl_Max_y[1]-smpl_Min_y[1], smpl_Max_z[1]-smpl_Min_z[1],
                smpl_Max_x[2]-smpl_Min_x[2], smpl_Max_y[2]-smpl_Min_y[2], smpl_Max_z[2]-smpl_Min_z[2] );

            // Y(p13̂Ƃ)AZ(p04̂Ƃ)̍ČmF(TvOf[^AccSamplingNum̕ϒl̍)(ږFRep-*(1-3),Rep-*(0-4))
            sprintf( strCmpX13_Z04,    "%d,%d,%d,%d,%d,%d,", cmp1_3_x, cmp1_3_y, cmp1_3_z, cmp0_4_x, cmp0_4_y, cmp0_4_z );

            // AccSamplingNum̃Tv̕ϒl(ږFAve-:*_0`4)
            sprintf( strAverage,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,",
            smpl_average_x[0], smpl_average_y[0], smpl_average_z[0],
            smpl_average_x[1], smpl_average_y[1], smpl_average_z[1],
            smpl_average_x[2], smpl_average_y[2], smpl_average_z[2],
            smpl_average_x[3], smpl_average_y[3], smpl_average_z[3],
            smpl_average_x[4], smpl_average_y[4], smpl_average_z[4] );

            // AccSamplingNum̃Tv̍ől(ږFMax-:*_0`4)
            sprintf( strSmpMax,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,",
            sample_max_x[0], sample_max_y[0], sample_max_z[0],
            sample_max_x[1], sample_max_y[1], sample_max_z[1],
            sample_max_x[2], sample_max_y[2], sample_max_z[2],
            sample_max_x[3], sample_max_y[3], sample_max_z[3],
            sample_max_x[4], sample_max_y[4], sample_max_z[4] );

            // AccSamplingNum̃Tv̍ŏl(ږFMin-:*_0`4)
            sprintf( strSmpMin,  "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,",
            sample_min_x[0], sample_min_y[0], sample_min_z[0],
            sample_min_x[1], sample_min_y[1], sample_min_z[1],
            sample_min_x[2], sample_min_y[2], sample_min_z[2],
            sample_min_x[3], sample_min_y[3], sample_min_z[3],
            sample_min_x[4], sample_min_y[4], sample_min_z[4] );

            // 0G̒l߂ۂɎg2pf[^(:X0̂ƂYAZXl)̍(ږFDIF_*0)
            sprintf( strDiffXYZ, "%d,%d,%d,", diff_x0_yz, diff_y0_zx, diff_z0_xy );

            // full scale1.8Gȏ゠邱Ƃ̊mF̃f[^
            sprintf( strFullScale, "%f,%f,%f,%f,%f,%f,", full_scale_max_x, full_scale_max_y, full_scale_max_z, full_scale_min_x, full_scale_min_y, full_scale_min_z );

            all_time = GetMilliSecond(test_start_tick);
            
            sprintf( strAccTestTime_mS, "%d,", all_time );
            

//SPFLp
			if(uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
			{
				char strSPFLver[15] = "";
				sprintf(strSPFLver, "SPFL%s", VERSION_STRING);
			
				line = static_cast<string>(strSPFLver)		// o[W(ږFVer)
					+ static_cast<string>(strTestMode)		// LINE,QCȂǂ̃eXg[h  (ږFTestMode)
					+ static_cast<string>(str_config_crc)	// RtBOCRC擾A쐬  (ږFCONFIG_CRC)
					+ static_cast<string>(str_mac)			// MacAddress  (ږFMacAddress)
					+ static_cast<string>(m_serialNo)		// VAio[(ږFSerialNo)
					+ static_cast<string>(result_str)		// G[R[h(ږFResult)
					+ static_cast<string>(strAccRaw)		// xZT CALlƂď܂Ăl(LINEŏޒlȂ̂ŒʏLINEł͒lĂȂ)A 
															// ̒lƍ̌ʂ瓾CALl̍(ږFCAL_0G-*,,CAL_Sens-*,DIF_0G-*,DIF_Sens-*(%),0G-*,Sens-*)
					+ static_cast<string>(strStability)		// p0,1,2ꂼ̂Ƃ̃Tvől|ŏl(ږFSta-*_0,Sta-*_1,Sta-*_2)
					+ static_cast<string>(strCmpX13_Z04)	// Y(p13̂Ƃ)AZ(p04̂Ƃ)̍ČmF(TvOf[^AccSamplingNum̕ϒl̍)(ږFRep-*(1-3),Rep-*(0-4))
					+ static_cast<string>(strAverage)		// AccSamplingNum̃Tv̕ϒl(ږFAve-*_0`4)
					+ static_cast<string>(strSmpMax)		// AccSamplingNum̃Tv̍ől(ږFMax-*_0`4)
					+ static_cast<string>(strSmpMin)		// AccSamplingNum̃Tv̍ŏl(ږFMin-*_0`4)
					+ static_cast<string>(strDiffXYZ)		// X,Y,Z0G2v̍
					+ static_cast<string>(strFullScale)		// FullScale`FbN̒l
					+ static_cast<string>(strAccTestTime_mS)// x
					+ static_cast<string>(strAllDifStability)
					+ static_cast<string>(strBreak);		// "\n"
			}
			else
			{	
				line = static_cast<string>(VERSION_STRING)
					+ static_cast<string>(strTestMode)
					+ static_cast<string>(str_config_crc)
					+ static_cast<string>(str_mac)
					+ static_cast<string>(m_serialNo)
					+ static_cast<string>(result_str)
					+ static_cast<string>(strAccRaw)
					+ static_cast<string>(strStability)
					+ static_cast<string>(strCmpX13_Z04)
					+ static_cast<string>(strAverage)
					+ static_cast<string>(strSmpMax)
					+ static_cast<string>(strSmpMin)
					+ static_cast<string>(strDiffXYZ)
					+ static_cast<string>(strFullScale)
					+ static_cast<string>(strAccTestTime_mS)// x
					+ static_cast<string>(strAllDifStability)
					+ static_cast<string>(strBreak);
			}

#ifdef SHORT_VERSION
            // ʉʕ\p
            sprintf( str_ng_Average,  "\n0:(%d  %d  %d) 1:(%d  %d  %d) \n2:(%d  %d  %d)  D0XYZ:%d,%d,%d\n X:%d,Y:%d,Z:%d\n X:%d,Y:%d,Z:%d\n",
            smpl_average_x[0], smpl_average_y[0], smpl_average_z[0],
            smpl_average_x[1], smpl_average_y[1], smpl_average_z[1],
            smpl_average_x[2], smpl_average_y[2], smpl_average_z[2],
            diff_x0_yz, diff_y0_zx, diff_z0_xy,
            int(full_scale_max_x * 1000), int(full_scale_max_y * 1000), int(full_scale_max_z * 1000), int(full_scale_min_x * 1000), int(full_scale_min_y * 1000), int(full_scale_min_z * 1000) );
#else
            // ʉʕ\p
            sprintf( str_ng_Average,  "\n0:(%d  %d  %d) 1:(%d  %d  %d) \n2:(%d  %d  %d) 3:(%d  %d  %d)\n4:(%d  %d  %d)  D0XYZ:%d,%d,%d\n X:%d,Y:%d,Z:%d\n X:%d,Y:%d,Z:%d\n",
            smpl_average_x[0], smpl_average_y[0], smpl_average_z[0],
            smpl_average_x[1], smpl_average_y[1], smpl_average_z[1],
            smpl_average_x[2], smpl_average_y[2], smpl_average_z[2],
            smpl_average_x[3], smpl_average_y[3], smpl_average_z[3],
            smpl_average_x[4], smpl_average_y[4], smpl_average_z[4],
            diff_x0_yz, diff_y0_zx, diff_z0_xy,
            int(full_scale_max_x * 1000), int(full_scale_max_y * 1000), int(full_scale_max_z * 1000), int(full_scale_min_x * 1000), int(full_scale_min_y * 1000), int(full_scale_min_z * 1000) );
#endif

			// callƂď܂Ă0_̒lƁA񌟍ۂ0_̒l̍AcallƂď܂Ă1G̒lƁA񌟍ۂ1G̒l̍(%\)
            sprintf( str_dif, "D0G:(%d  %d  %d) D1G:(%f  %f  %f)",  diff_x0, diff_y0, diff_z0, diff_x1, diff_y1, diff_z1 );

            // LINE[h,QC[hSD݃tO1̏ꍇSDJ[hɌf[^
            if( ((accMember.TestMode == 0) && (accMember.LINE_Write_SD_Flag == 1)) || ((accMember.TestMode == 1) && (accMember.QC_Write_SD_Flag == 1)) )
            {
                tmp_ng_code = ng_code;

//--------------------------------------------------------SDJ[hɃOc-------------------------------------------------------------
                // SDJ[h}Eg
                NN_LOG("sdmc archive mount ");
                nnr = nn::fs::MountSdmc();
                if (nnr.IsFailure())
                {
                    nn::dbg::PrintResult(nnr);
                    NN_LOG("failed.\n");
                    if( ng_code == RESULT_OK ) ng_code = SD_MOUNT + test_process * 100;
                    else               another_ng_code = SD_MOUNT + test_process * 100;
                }
                else
                {
                    // /ujifBNg`FbNiNGj <-WC̐Î~ȂȂꍇujitH_悤ɕύXKvoĂ\
                    sd_ng_code = CheckDirectorySdmc(L"sdmc:/uji");

                    if( sd_ng_code != RESULT_OK )
                    {
                        if( ng_code == RESULT_OK ) ng_code = sd_ng_code + test_process * 100;
                        else               another_ng_code = sd_ng_code + test_process * 100;
                    }
                    else
                    {
                        // /uji/AccfBNg`FbNiΐVK쐬j
                        sd_ng_code = CreateDirectorySdmc(L"sdmc:/uji/Acc");

                        if( sd_ng_code != RESULT_OK )
                        {
                            // 1ڂ̃fBNg쐬NGƌ邽߂NGR[h+1Ă܂B
                            if( ng_code == RESULT_OK ) ng_code = sd_ng_code + test_process * 100;
                            else               another_ng_code = sd_ng_code + test_process * 100;
                        }
                        else
                        {
                            // SDJ[hɏo
                            sd_ng_code = WriteData2SD( SD_PATH_DP0_4, line );
                            if( sd_ng_code != RESULT_OK )
                            {
                                if( ng_code == RESULT_OK ) ng_code = sd_ng_code + test_process * 100;
                                else               another_ng_code = sd_ng_code + test_process * 100;
                            }
                        }
                    }

                    // SDJ[h̃A}Eg
                    NN_LOG("sdmc archive unmount ");
                    nnr = nn::fs::Unmount("sdmc:");
                    if ( nnr.IsFailure())
                    {
                        NN_LOG("failed.\n");
                        nn::dbg::PrintResult(nnr);
                        if( ng_code == RESULT_OK ) ng_code = SD_UNMOUNT + test_process * 100;
                        else               another_ng_code = SD_UNMOUNT + test_process * 100;
                    }
                    NN_LOG("succeeded.\n");
                }
                
                
                // SDJ[ĥ݂݂ŃG[ꍇ
                if( ( tmp_ng_code == 0 ) && ( ng_code != 0 ) )
                {
                	sprintf(ng_code_str, "%02d-%03d-%03d", (s32)39, (s32)ng_code%1000, (s32)another_ng_code%1000);
				}
//--------------------------------------------------------SDJ[hɃOc I--------------------------------------------------------


                // m点v F_
                uji::eva::mcu::NotifyLedWhiteOn();

	            // 2񑪂0Gl̍臒lȏł΍Čs(A1ڂ̂݁B2ڂ0Gl臒lȏłNGƂ)
	            // ܂́Al臒l𒴂ꍇA臒lɂ߂čČs(臒lɂ߂ĂꍇNGƂ)
				if( (limit_ng_flag == 1) || (diff0g_ng_flag == 1) )
				{
		            strcpy(strAllDifStability, "");
					raw_counter = 0;

		            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
	            
					// 摜XV(Č𑣂)
					jpegDrawer->OpenPicture(L"rom:/jpeg/AccAgain.jpg");
	                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
	                glFlush();
	                gfx->m_DrawFramework->SwapBuffers();
	
	                // R{^܂Ń[v
	                do
	                {
						// L[͂̊mF
						padReader.ReadLatest(&padStatus);
						pad.UpdatePad(padStatus);
					}while( !(sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) );
					
					// tO
					diff_x0_yz_flag = 0;
					diff_y0_zx_flag = 0;
					diff_z0_xy_flag = 0;
					
					limit_ng_flag = 0;
					diff0g_ng_flag = 0;
	
					test_process = 1;
					
	                // ʂ
	                jpegDrawer->ClosePicture();
	                delete jpegDrawer;
				}
				
				else
				{

#ifndef ACC_DEBUG_MODE
	
	                // }Ԏ擾
	                bool bInserted;
	                sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
	
	                jpegDrawer->OpenPicture(L"rom:/jpeg/removeSD.jpg");
		            jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
		            glFlush();
		            gfx->m_DrawFramework->SwapBuffers();
		
		            // SDJ[h܂Ń[v
		            do
		            {
		                bInserted = nn::fs::IsSdmcInserted();
		            }while(bInserted == 1);
	
	
	                // SDJ[h𔲂ʂ
	                jpegDrawer->ClosePicture();
	                delete jpegDrawer;
#endif
				}

                // m点v(LED)
                uji::eva::mcu::NotifyLedWhiteOff();

            }
            else 
			{
				
	            // 2񑪂0Gl̍臒lȏł΍Čs(A1ڂ̂݁B2ڂ0Gl臒lȏłNGƂ)
	            // ܂́Al臒l𒴂ꍇA臒lɂ߂čČs(臒lɂ߂ĂꍇNGƂ)
				if( (limit_ng_flag == 1) || (diff0g_ng_flag == 1) )
				{
		            
		            strcpy(strAllDifStability, "");
					raw_counter = 0;
		            
		            sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
	            
					// 摜XV(Č𑣂)
					jpegDrawer->OpenPicture(L"rom:/jpeg/AccAgain.jpg");
	                jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
	                glFlush();
	                gfx->m_DrawFramework->SwapBuffers();
	
	                // R{^܂Ń[v
	                do
	                {
						// L[͂̊mF
						padReader.ReadLatest(&padStatus);
						pad.UpdatePad(padStatus);
					}while( !(sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) );
					
					// tO
					diff_x0_yz_flag = 0;
					diff_y0_zx_flag = 0;
					diff_z0_xy_flag = 0;
					
					limit_ng_flag = 0;
					diff0g_ng_flag = 0;
	
					test_process = 1;
					
	                // ʂ
	                jpegDrawer->ClosePicture();
	                delete jpegDrawer;
				}
				
			}

            NN_LOG("%s\n", line.c_str());

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // xZT̊mF
            accReader.ReadLatest(&accStatus);
            accReader.ConvertToAcceleration(&acceleration, 1, &accStatus);

            gfx->m_DrawFramework->Clear();

            // EChE
            m_WindowManager.UpdatePad(pad);  // pbh
            m_WindowManager.Update();        // XV
            m_WindowManager.DrawDisplay0();

            // `
            gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);


            for(j=0;j<5;j++)
            {
                smpl_average_x[j] = -10000;
                smpl_average_y[j] = -10000;
                smpl_average_z[j] = -10000;
            }

            for(j=0;j<3;j++)
            {
                smpl_Max_x[j] = -10000;
                smpl_Max_y[j] = -10000;
                smpl_Max_z[j] = -10000;
                smpl_Min_x[j] = -10000;
                smpl_Min_y[j] = -10000;
                smpl_Min_z[j] = -10000;
            }


            gfx->m_DrawFramework->SwapBuffers();

            // ʂW̐Fɖ߂
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 0.36f, 0.42f, 0.5f, 0.0f );
            start_tick = nn::os::Tick::GetSystemCurrent();

        }   //  if( test_process > 5 )--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

        NN_LOG("\n test_process: %d \n", test_process);

    } while ( test_process < 6 );




    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_NONE);

NN_LOG("\n 1 \n");

    acc_result.m_Micro = ng_code % 1000;
    if(ng_code == 0)
    {
        s32 flag_log_err = 0;
        uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
        pl->Initialize();

NN_LOG("\n 2 \n");

        // O  TestMode, testerName, state, version, date, time, testerId, message,
        flag_log_err = pl->Add_1Line(accMember.TestMode, "Acc", "OK",  VERSION_STRING, "","","", "");

        if(flag_log_err < 0)
        {
            ng_code = WRITE_LOG + test_process * 100;
            sprintf(err_info, "Add_1Line:%d", flag_log_err);
        }
        else
        {
            pl->Finalize();
            delete pl;
            acc_result.m_Result = 1;    // OK̏ꍇ
        }
    }

NN_LOG("\n 3 \n");

    if(ng_code != 0)
    {
        uji::eva::mcu::SetMasterLedMax(test_result);
        // m点vԓ_
        uji::eva::mcu::NotifyLedRedBlinker();

NN_LOG("\n 4 \n");

        uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
NN_LOG("\n 4-0 \n");
        pl->Initialize();
NN_LOG("\n 4-1 \n");
        pl->Add_1Line(accMember.TestMode, "Acc", ng_code_str,  VERSION_STRING,  "", "", "", "");
NN_LOG("\n 4-2 \n");
        pl->Finalize();
NN_LOG("\n 4-3 \n");
        delete pl;

        acc_result.m_Result = 0;                // NG̏ꍇ
    }
    else
    {
        // m点v_
        uji::eva::mcu::NotifyLedBlueBlinker();
    }


NN_LOG("\n 5 \n");


    if(accMember.TestMode == 1)
    {
        sprintf( acc_result.m_String, "%d-%d  (%s) %s%s%s", (s32)(ng_code%1000), (s32)(another_ng_code%1000), TestMode[pse.accMember.TestMode], err_info, str_ng_Average, str_dif );
    }
    else sprintf( acc_result.m_String, "%d-%d  (%s) \n%s%s", (s32)(ng_code%1000), (s32)(another_ng_code%1000), TestMode[pse.accMember.TestMode], err_info, str_ng_Average );

NN_LOG("\n 6 \n");

    NN_LOG("end... 1:%d  2:%d \n", acc_result.m_Micro, acc_result.m_Result );

NN_LOG("\n 7 \n");


    delete q;


NN_LOG("\n endend\n");
//while(1){};

    return acc_result;
}

//#endif



}   // usingnamespace acc
}   // usingnamespace eva
}   // usingnamespace uji




