/*--------------------------------------------------------------------------*
 Project:
 File: TestAccTool.h


*--------------------------------------------------------------------------*/
#ifndef TEST_ACC_TOOL_H_INCLUDED
#define TEST_ACC_TOOL_H_INCLUDED


#include "../seq/TestListManager.h"
#include "ShowAccTestPassage.h"


#define SHORT_VERSION       // 2ځA2ڂ̌ȗꍇ͂̒`s
//#define STATIC_ACC_GYRO   // 1pŌꍇ͂̒`s
//#define ALL_PASS          // fobOp pύXŌʂOKɂȂ(LulɂNG̒l͂܂܂ɂȂ܂B)

#define TEST_PROCESS_MAX 5
#define AXIS_NUM         3

using namespace uji::seq;
extern char str_ver[10];


namespace uji {
namespace eva {
namespace acc {

extern bool accSoundStartFlag;

#define ACC_FLAG_OFF 0
#define ACC_FLAG_ON  1


    enum AXIS_XYZ {
        AXIS_X = 0,
        AXIS_Y = 1,
        AXIS_Z = 2
    };

    enum LIMIT_MAX_MIN {
        LIMIT_MAX = 0,
        LIMIT_MIN = 1
    };

    enum ERROR_ACC_CAL {
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };

typedef struct
{
    float scale;  // ItZbg1g̏o͔͈
    s16   offset;  // 0g̃ItZbg
} AccelerometerCalibrateAxisParamFloat;

typedef struct {
    AccelerometerCalibrateAxisParamFloat x;
    AccelerometerCalibrateAxisParamFloat y;
    AccelerometerCalibrateAxisParamFloat z;
} AccelerometerCalibrateParamFloat;


typedef struct
{
    float max;  // ől
    float min;  // ŏl
} MaxMinFloat;


typedef struct {
    MaxMinFloat x;
    MaxMinFloat y;
    MaxMinFloat z;
}AccelerometerScale;


typedef struct
{
    char strTestMode[64];           // LINE,QCȂǂ̃eXg[h  (ږFTestMode)
    char  m_serialNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN +1];   // VAio[i[
    char str_config_crc[64];        // RtBOCRC擾A쐬  (ږFCONFIG_CRC)
    char str_mac[32];               // MACAhX
    char strAccRaw[256];            // xZT CALlƂď܂Ăl(LINEŏޒlȂ̂ŒʏLINEł͒lĂȂ)A
                                    // ̒lƍ̌ʂ瓾CALl̍ (ږFCAL_0G-*,,CAL_Sens-*,DIF_0G-*,DIF_Sens-*(%),0G*))
    char strStability[256];         // p0,1,2ꂼ̂Ƃ̃Tvől|ŏl(ږFSta-*_0,Sta-*_1,Sta-*_2)
    char strCmpX13_Z04[256];        // Y(p13̂Ƃ)̍ČmF(TvOf[^AccSamplingNum̕ϒl̍)(ږFRep-*(1-3),Rep-*(0-4))
    char strAverage[256];           // AccSamplingNum̃Tv̕ϒl(ږFAve-:*_0`4)
    char strSmpMax[256];
    char strSmpMin[256];
    char strDiffXYZ[256];
    char strFullScale[256];
    char strTestLver[15];
}StrLogForSD;


// [hʂɕ\ۂɎg
const char TestMode[10][15]={
    "LINE",
    "QC",
    "REPAIR",
    "SC",
    "SUBSIDIARY",
    "SUBMIT",
    "RESERVED1",
    "RESERVED2",
    "RESERVED3",
    "DEBUG",
};

    extern s64 GetMilliSecond( nn::os::Tick start_time );
    extern s32 SetAccCalCore(nn::hid::AccelerometerCalibrateParam acc_cal_param);
    extern s32 GetAccCalCore(nn::hid::AccelerometerCalibrateParam *acc_cal_param);
    extern u32 MakeAccErrorNumber( bool ng_flag_x, bool ng_flag_y, bool ng_flag_z, u32 base_code );
    extern void ChooseAccLimit(ShowPassage* p_pse, s32 diff0g_ng_counter, s32 limit_ng_counter);
    extern void TurnOnOKLed(ShowPassage* p_pse);
    extern void TurnOnNGLedAndWriteNGLog(Config::Member* accMember, char* ng_code_str);
    extern void MakeResultStr(char* str, s32 switch_num, s32 sample_average[AXIS_NUM][TEST_PROCESS_MAX],
                              s32 diff_x0_yz, s32 diff_y0_zx, s32 diff_z0_xy, AccelerometerScale full_scale);
    extern void CheckDifferenceOfLineAndQC( AccelerometerCalibrateParamFloat diff_line_qc, ShowPassage* p_pse );
    s32 AccSoundInitialize(void);
    void AccSoundFinalize(void);
    s32 AccSoundReInitialize(void);


}
}
}

#endif
