/*--------------------------------------------------------------------------*
 Project:
 File: TestAccTool.cpp

*--------------------------------------------------------------------------*/
#include <nn.h>
#include "TestAccTool.h"
#include "TestAccErrorCode.h"
#include "ShowAccTestPassage.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {
namespace acc {


/*!--------------------------------------------------------------------------*
  @brief        Ԍv֐
        vJn_
  ߂l    start_timeo߂(mS)
 *---------------------------------------------------------------------------*/
s64 GetMilliSecond( nn::os::Tick start_time )
{

    nn::os::Tick currentTick = nn::os::Tick::GetSystemCurrent();

    float millisecond = (float)((currentTick - start_time).ToTimeSpan().GetMicroSeconds() / 1000.0);

    return millisecond;

}


/*---------------------------------------------------------------------------
    Desc: CallNANDɕۑ܂
    Arg : x,y,zscaleoffset
---------------------------------------------------------------------------*/
s32 SetAccCalCore(nn::hid::AccelerometerCalibrateParam acc_cal_param)
{
    using namespace nn::drivers::cal::CTR;

    Calibration calibration;
    AccelCalDataCore accCalDataCore;

    // Cal ̏
    // Lȃf[^x[XΓǂݍ
    // Lȃf[^x[XȂ΃ftHglŖ߂f[^x[X쐬
    calibration.Initialize();

    // l̎擾
    if (!calibration.Get(&accCalDataCore, CAL_DATA_ACCEL)) { return ERROR_GET; }

    // l̐ݒ
    accCalDataCore.x.offset  = acc_cal_param.x.offset;
    accCalDataCore.x.scale   = acc_cal_param.x.scale;
    accCalDataCore.y.offset  = acc_cal_param.y.offset;
    accCalDataCore.y.scale   = acc_cal_param.y.scale;
    accCalDataCore.z.offset  = acc_cal_param.z.offset;
    accCalDataCore.z.scale   = acc_cal_param.z.scale;

    if (!calibration.Set(&accCalDataCore, CAL_DATA_ACCEL)) { return ERROR_SET; }

    // t@Cɕۑ
    if (!calibration.Flush()) { return ERROR_FLUSH; }

    return 0;
}

/*---------------------------------------------------------------------------
    Desc: CallNANDǂݏo܂
    Arg : x,y,zscaleoffset
---------------------------------------------------------------------------*/
s32 GetAccCalCore(nn::hid::AccelerometerCalibrateParam *acc_cal_param)
{
    using namespace nn::drivers::cal::CTR;

    Calibration calibration;
    AccelCalDataCore accCalDataCore;

    // Cal ̏
    // Lȃf[^x[XΓǂݍ
    // Lȃf[^x[XȂ΃ftHglŖ߂f[^x[X쐬
    calibration.Initialize();

    // l̎擾
    if (!calibration.Get(&accCalDataCore, CAL_DATA_ACCEL)) { return ERROR_GET; }

    // l̐ݒ
     acc_cal_param->x.offset = accCalDataCore.x.offset;
     acc_cal_param->x.scale  = accCalDataCore.x.scale;
     acc_cal_param->y.offset = accCalDataCore.y.offset;
     acc_cal_param->y.scale  = accCalDataCore.y.scale;
     acc_cal_param->z.offset = accCalDataCore.z.offset;
     acc_cal_param->z.scale  = accCalDataCore.z.scale;

    return 0;
}




/*============================================================================
        xyz̃G[󋵂ɉăG[ԍo͂֐

    ng_flag_x: xɊւ锻茋ʂ\tO(0:OK 1:NG)
        ng_flag_y: yɊւ锻茋ʂ\tO(0:OK 1:NG)
        ng_flag_z: zɊւ锻茋ʂ\tO(0:OK 1:NG)
        base_code: NGR[h̃x[XɂȂ鐔
 ߂l G[R[h(G[ĂȂꍇ0ɂȂ)
        base_code{ǂ̎NGԍ(1`7) x:1 y:2 3:z 4:xy 5:xz 6:yx 7:xyz

  ============================================================================*/
u32 MakeAccErrorNumber( bool ng_flag_x, bool ng_flag_y, bool ng_flag_z, u32 base_code )
{
    #define X_BIT 0
    #define Y_BIT 1
    #define Z_BIT 2

    u32 ng_code;

    ng_code = (ng_flag_x << X_BIT) + (ng_flag_y << Y_BIT) + (ng_flag_z << Z_BIT);

    if(ng_code != RESULT_OK)  ng_code = base_code + ng_code;

    return ng_code;
}


void TurnOnOKLed(ShowPassage* p_pse)
{
    TestResult test_result;

    uji::eva::mcu::SetMasterLedMax(test_result);

    // ZOKm点v_
    if( p_pse->test_process == 5 -1 )  uji::eva::mcu::NotifyLedBlueOnNoWait();

    // YOKm点vΓ_
    else if( ( p_pse->test_process == 2 -1 ) || ( p_pse->test_process == 4 -1 ) ) uji::eva::mcu::NotifyLedGreenOnNoWait();

    // XOKm点vԓ_
    else if( p_pse->test_process == 3 -1 ) uji::eva::mcu::NotifyLedRedOnNoWait();

    return;
}


void TurnOnNGLedAndWriteNGLog(Config::Member* accMember, char* ng_code_str)
{
    // m点v(LED)
    uji::eva::mcu::NotifyLedWhiteOff();

    // m点vԓ_
    uji::eva::mcu::NotifyLedRedBlinkerNoWait();

    // O
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();
    pl->Add_1Line(accMember->TestMode, "Acc", ng_code_str,  VERSION_STRING,  "", "", "", "");
    pl->Finalize();
    delete pl;

    return;
}


void MakeResultStr(char* str, s32 switch_num, s32 sample_average[AXIS_NUM][TEST_PROCESS_MAX],
                   s32 diff_x0_yz, s32 diff_y0_zx, s32 diff_z0_xy, AccelerometerScale full_scale)
{
    char str_average[512];
    char str_etc[256];

    if(switch_num == 0)
    {
            // ʉʕ\p
            sprintf( str_average,  "\n0:%d %d %d 1:%d %d %d \n2:%d %d %d ",
            sample_average[AXIS_X][0], sample_average[AXIS_Y][0], sample_average[AXIS_Z][0],
            sample_average[AXIS_X][1], sample_average[AXIS_Y][1], sample_average[AXIS_Z][1],
            sample_average[AXIS_X][2], sample_average[AXIS_Y][2], sample_average[AXIS_Z][2] );
    }
    else
    {
            sprintf( str_average,  "\n0:%d %d %d 1:%d %d %d \n2:%d %d %d 3:%d %d %d\n4:%d %d %d ",
            sample_average[AXIS_X][0], sample_average[AXIS_Y][0], sample_average[AXIS_Z][0],
            sample_average[AXIS_X][1], sample_average[AXIS_Y][1], sample_average[AXIS_Z][1],
            sample_average[AXIS_X][2], sample_average[AXIS_Y][2], sample_average[AXIS_Z][2],
            sample_average[AXIS_X][3], sample_average[AXIS_Y][3], sample_average[AXIS_Z][3],
            sample_average[AXIS_X][4], sample_average[AXIS_Y][4], sample_average[AXIS_Z][4] );
    }

    sprintf(str_etc, "D_0G_X:%d,Y:%d,Z:%d\nS_MAX_X: %d,Y: %d,Z: %d\nS_MIN_X:%d,Y:%d,Z:%d\n",
            diff_x0_yz, diff_y0_zx, diff_z0_xy,
            int(full_scale.x.max * 1000), int(full_scale.y.max * 1000), int(full_scale.z.max * 1000),
            int(full_scale.x.min * 1000), int(full_scale.y.min * 1000), int(full_scale.z.min * 1000));

    strcat(str_average, str_etc);
    strcpy(str, str_average);

    return;
}



void ChooseAccLimit(ShowPassage* p_pse, s32 diff0g_ng_counter, s32 limit_ng_counter)
{
    if(p_pse->pCnfMem->AgainTest_Flag == 0)
    {
        p_pse->diff0g_limit = p_pse->pCnfMem->DiffRange0G + p_pse->pCnfMem->AgainAdditionDiff;

        // QC̏ꍇ
        if( (p_pse->pCnfMem->TestMode == 1) || (p_pse->pCnfMem->TestMode == 9) )
        {
            p_pse->upper_limit_0g = p_pse->pCnfMem->QC_ALL_0G_Max;
            p_pse->lower_limit_0g = p_pse->pCnfMem->QC_ALL_0G_Min;
        }
        else
        {
            p_pse->upper_limit_0g = p_pse->pCnfMem->ALL_0G_Max + p_pse->pCnfMem->AgainAddition0G;
            p_pse->lower_limit_0g = p_pse->pCnfMem->ALL_0G_Min + p_pse->pCnfMem->AgainAddition0G;
        }
    }
    else
    {
        // 0G̍Č(2񑪂0Gl̍ȓɎ܂ǂ̔)1xNGɂȂꍇ
        if( diff0g_ng_counter > 0 )
        {
            p_pse->diff0g_limit = p_pse->pCnfMem->DiffRange0G + p_pse->pCnfMem->AgainAdditionDiff;
        }
        else
        {
            p_pse->diff0g_limit = p_pse->pCnfMem->DiffRange0G;
        }

        // QC̏ꍇ
        if( (p_pse->pCnfMem->TestMode == 1) || (p_pse->pCnfMem->TestMode == 9) )
        {
            // 0G̐l`FbN臒l1xNGɂȂꍇ(NG 2ڈȍ~)0G臒l75145ɍL܂
            if( limit_ng_counter != 0 )
            {
                p_pse->upper_limit_0g = p_pse->pCnfMem->QC_ALL_0G_Max;
                p_pse->lower_limit_0g = p_pse->pCnfMem->QC_ALL_0G_Min;
            }
            // 1ڂLINEƓ臒l75
            else
            {
                p_pse->upper_limit_0g = p_pse->pCnfMem->ALL_0G_Max;
                p_pse->lower_limit_0g = p_pse->pCnfMem->ALL_0G_Min;
            }
        }
        // LINȄꍇ
        else
        {
            // 0G̐l`FbN臒l1xNGɂȂꍇ(0G臒l75136ɍL܂)
            if( limit_ng_counter != 0 )
            {
                p_pse->upper_limit_0g = p_pse->pCnfMem->ALL_0G_Max + p_pse->pCnfMem->AgainAddition0G;
                p_pse->lower_limit_0g = p_pse->pCnfMem->ALL_0G_Min + p_pse->pCnfMem->AgainAddition0G;
            }
            else
            {
                p_pse->upper_limit_0g = p_pse->pCnfMem->ALL_0G_Max;
                p_pse->lower_limit_0g = p_pse->pCnfMem->ALL_0G_Min;
            }
        }
    }
}


void CheckDifferenceOfLineAndQC( AccelerometerCalibrateParamFloat diff_line_qc, ShowPassage* p_pse )
{
    bool flag_offset_0 = 0;     // 0GY邩ǂ̔tO
    u32  ng_code_0 = RESULT_OK; // 0GYꍇ̃G[R[hi[ϐ(YȂꍇ0)

    bool ng_flag_x = 0;
    bool ng_flag_y = 0;
    bool ng_flag_z = 0;

    // 0GĂ邩ǂ̔
    if( abs(diff_line_qc.x.offset) > p_pse->pCnfMem->QC_0G_X_Offset ) ng_flag_x = 1;
    if( abs(diff_line_qc.y.offset) > p_pse->pCnfMem->QC_0G_Y_Offset ) ng_flag_y = 1;
    if( abs(diff_line_qc.z.offset) > p_pse->pCnfMem->QC_0G_Z_Offset ) ng_flag_z = 1;

    if( (ng_flag_x == 1) || (ng_flag_y == 1) || (ng_flag_z == 1) ) flag_offset_0 = 1;

    // NGĂ鎲ɃG[R[h쐬(1)
    ng_code_0 = MakeAccErrorNumber( ng_flag_x, ng_flag_y, ng_flag_z, p_pse->test_process * 100 + QC_OFFSET_0 );

    // 1G茋ʗpɃtOZbg
    ng_flag_x = 0;
    ng_flag_y = 0;
    ng_flag_z = 0;

    // 1GĂ邩ǂ̔
    if( abs(diff_line_qc.x.scale * 100) > p_pse->pCnfMem->QC_1G_X_Offset ) ng_flag_x = 1;
    if( abs(diff_line_qc.y.scale * 100) > p_pse->pCnfMem->QC_1G_Y_Offset ) ng_flag_y = 1;
    if( abs(diff_line_qc.z.scale * 100) > p_pse->pCnfMem->QC_1G_Z_Offset ) ng_flag_z = 1;

    // NGĂ鎲ɃG[R[h쐬
    // 0GNG̏ꍇ
    if( flag_offset_0 == 1 )
    {
        // 0GE1GNGł
        if( ng_flag_x || ng_flag_y || ng_flag_z ) p_pse->ng_code = ng_code_0 + QC_OFFSET_01 - QC_OFFSET_0;
        // 1GOK,0GNG̏ꍇ(̎_p_pse->ng_codeRESULT_OK(0)Ă̂ŁA1̃G[R[h꒼)
        else p_pse->ng_code = ng_code_0;
    }
    // 0GOK̏ꍇ
    else p_pse->ng_code = MakeAccErrorNumber( ng_flag_x, ng_flag_y, ng_flag_z, p_pse->test_process * 100 + QC_OFFSET_1 );

    return;
}


/*------------------------------------------------------------------------------
    xpsoundJn
    ܂t@[ɂĂ͊WJĂԂ
    SetHeadphoneOutOnShellClose֐Ă΂ȂƐݒ肪LɂȂȂꍇB
    ̏ꍇ͊WĴ҂֐(uji::eva::mcu::WaitOpenState)
    AccSoundInitializȇOɌĂԂƁB
------------------------------------------------------------------------------*/
s32 AccSoundInitialize(void)
{
    nn::Result result;

    if(accSoundStartFlag==ACC_FLAG_OFF)
    {
        // {̂Ԃŉo悤ɂ鏈
        uji::eva::SoundInitializer().InitSDK();
        result = nn::snd::SetHeadphoneOutOnShellClose(false);
        accSoundStartFlag = ACC_FLAG_ON;
    }

    return result.IsSuccess();
}


/*------------------------------------------------------------------------------
    xpsoundI
------------------------------------------------------------------------------*/
void AccSoundFinalize(void)
{
    if(accSoundStartFlag==ACC_FLAG_ON)
    {
        uji::eva::SoundInitializer().FinalizeSDK();
        accSoundStartFlag = ACC_FLAG_OFF;
    }

    return;
}


/*------------------------------------------------------------------------------
    xpsound(KJnsꍇɎg֐)
------------------------------------------------------------------------------*/
s32 AccSoundReInitialize(void)
{
    nn::Result result;

    // ɏsĂꍇ͏Is
    if(accSoundStartFlag==ACC_FLAG_ON)
    {
        uji::eva::SoundInitializer().FinalizeSDK();
        accSoundStartFlag = ACC_FLAG_OFF;
    }

    // {̂Ԃŉo悤ɂ鏈
    uji::eva::SoundInitializer().InitSDK();
    result = nn::snd::SetHeadphoneOutOnShellClose(false);
    accSoundStartFlag = ACC_FLAG_ON;

    return result.IsSuccess();
}


}
}
}

