/*--------------------------------------------------------------------------*
 Project:
 File: TestAcc.cpp

*--------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/cfg/CTR/detail/cfg_SecureInfo.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/fnd.h>
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/gx.h>
#include <nn/gx/CTR/gx_LcdPowerManager.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_AccelerometerCalibrator.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hid/CTR/hid_HidBase.h>
#include <nn/uds.h>
#include <nw/types.h>
#include <stdlib.h>
#include <vector>

#include "sys_App.h"
#include "sys_Pad.h"
#include "../mcu/McuInitializer.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/TesterLog/ProductionLogDummy.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestListManager.h"
#include "../seq/TestResult.h"
#include "../seq/TestSequencer.h"
#include "../sys/sys_SoundPlayer.h"
#include "../sys/sys_GetMacAddress.h"
#include "../sys/sys_GetSerialNumber.h"

#include "TestAcc.h"
#include "TestAccErrorCode.h"
#include "TestAccTool.h"
#include "CheckStability.h"
#include "CheckLimit0_1G.h"
#include "WriteAccDataToSD.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
using namespace uji::eva::mcu;
using namespace uji::eva::acc;


namespace uji {
namespace eva {
namespace acc {

    bool accSoundStartFlag = ACC_FLAG_OFF;


//============================================================================
//    Gyro̐~Ԍ
//============================================================================
bool GyroAgingTest(seq::TestResult &result)
{
    GyroAgingTester g;

    g.Test(result);

    return result.m_Result;

}


//============================================================================
//                         xZT
//============================================================================
bool AccelerometerTest(seq::TestResult &result)
{
    uji::eva::acc::DemoAcc *p = new uji::eva::acc::DemoAcc;

    result = p->Run();

    delete p;

    return result.m_Result;
}


/*---------------------------------------------------------------------------
 Desc:  xZTs(Z-1GY1GX-1GY1GZ-1G̏Ɍ)
        IAA{^ōČAB{^Ńj[ʂɕA
---------------------------------------------------------------------------*/
seq::TestResult DemoAcc::Run()
{
    // mFTv:AccStabilityNum > mFA̒ōŐVAccSamplingNum̃f[^CALlƂĎg

    s32 diffStabilityMaxMin[AXIS_NUM][TEST_PROCESS_MAX] = { { -10000, -10000, -10000, -10000, -10000 },
                                                            { -10000, -10000, -10000, -10000, -10000 },
                                                            { -10000, -10000, -10000, -10000, -10000 } };

    // AccSamplingNum(30)񐔕̕ϒl
    s32 sample30_average[AXIS_NUM][TEST_PROCESS_MAX] = { { -10000, -10000, -10000, -10000, -10000 },
                                                         { -10000, -10000, -10000, -10000, -10000 },
                                                         { -10000, -10000, -10000, -10000, -10000 } };

    // AccSamplingNum(30)񐔕̍ől
    s32 sample30_max[AXIS_NUM][TEST_PROCESS_MAX] = {     { -10000, -10000, -10000, -10000, -10000 },
                                                         { -10000, -10000, -10000, -10000, -10000 },
                                                         { -10000, -10000, -10000, -10000, -10000 } };

    // AccSamplingNum(30)񐔕̍ŏl
    s32 sample30_min[AXIS_NUM][TEST_PROCESS_MAX] = {     { 10000, 10000, 10000, 10000, 10000 },
                                                         { 10000, 10000, 10000, 10000, 10000 },
                                                         { 10000, 10000, 10000, 10000, 10000 }  };

    s64 sample30_sum[AXIS_NUM] = {0,0,0};       // TvOf[^̒l𑫂킹vi[
    bool stability_ok_flag = 0;                 // TvO̒l񐔈ȏ肵Ăꍇ1ɂȂtO

    s32 diff0g_ng_counter = 0;                  // 2񑪂0Gl̍傫قȂG[񐔂\ϐ
    bool diff0g_ng_flag = 0;                    // diff0g_ng_counter1ɂȂƂ1ɂȂtO
    s32 limit_ng_counter = 0;                   // 臒lNG񐔂ϐ
    bool limit_ng_flag = 0;                     // limit_ng_counter1ɂȂƂ1ɂȂtO
    bool pre_limit_ng_flag = 0;                 // 臒lNGꍇ1ɂȂtO

    nn::hid::AccelerationFloat acceleration;               // ConvertToAccelerationp
    nn::hid::AccelerometerCalibrateParam acc_cal_param;    // ꎞIcalli[
    AccelerometerCalibrateParamFloat read_cal = {0,-10000,0,-10000,0,-10000};  // ǂݏocall
    AccelerometerCalibrateParamFloat set_cal  = {0,0,0,0,0,0};                 // callƂďޒl
    AccelerometerCalibrateParamFloat diff_line_qc = {-10000,-10000,-10000,-10000,-10000,-10000};     // call̍
    AccelerometerScale full_scale = { -10000, -10000, -10000, -10000, -10000, -10000 };       // full scaleli[p

    s32 diff_x0_yz = -10000;                    // 2񑪂0Gl̍(y,z1Gl莞xl̍)
    s32 diff_y0_zx = -10000;                    // 2񑪂0Gl̍(z,x1Gl莞yl̍)
    s32 diff_z0_xy = -10000;                    // 2񑪂0Gl̍(x,y1Gl莞zl̍)
    bool diff_x0_yz_flag = 0;                   // 2񑪂X0Gl̍傫قȂꍇ1ɂȂtO
    bool diff_y0_zx_flag = 0;                   // 2񑪂Y0Gl̍傫قȂꍇ1ɂȂtO
    bool diff_z0_xy_flag = 0;                   // 2񑪂Z0Gl̍傫قȂꍇ1ɂȂtO
    bool readCalCheckNgFlag = CHECK_READ_CAL_OK; // ǂݏoLl臒lɓĂȂꍇ1ɂȂtO
    s32 result_sound = 0;                       // UjiSoundPlayer֐߂l
    s32 sound_counter = 0;                      // UjiSoundPlayerNGۂ̃gC񐔂JEgϐ

    u32 another_ng_code = RESULT_OK;            // 2ڂNGR[hi[ϐ
                                                //(1NGĂ̂܂܌𑱍sčēxNGꍇɎg)
    u32 tmp_ng_code = 0;                        // ng_codeanother_ng_codëڂւɎgNGR[hi[p
    seq::TestResult acc_result;                 // ʊi[p
    nn::os::Tick start_tick;                    // Ԍvp
    nn::hid::CTR::PadReader padReader;          // {^p(AGAIN̂ƂɕKv)
    nn::hid::CTR::PadStatus padStatus;          // {^p
    uji::sys::Pad pad;                          // {^p
    nn::hid::AccelerometerReader accReader;     // xZTp
    nn::hid::AccelerometerStatus accStatus;     // xZTp
    TestResult test_result;                     // ϐĂяo̍ۂɈTestResult^̕ϐKvɂȂۂɎgϐ
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();    // ʕ\p
    uji::sys::SoundPlayer *q = new uji::sys::SoundPlayer;               // p

    char ng_code_str[20] = "NG";                // NGR[hi[p
    char err_info[81] = "";                     // SetAccCalCore֐G[߂li[
    char str_ng_Average[512]    = "";           // ʕ\p
    char result_str[512];                       // ʕ(rcJ[h(ږFResult)Ɠ)
    char ng_info_str[128] = "";                 // ʏ񕶎(rcJ[h(ږFInfo)ɋL^̂Ɠ)
    string line;                                // SDJ[hɏރf[^p
    StrLogForSD AccResultForSD;                 // SDJ[hɏރf[^p\

    Config::Member accMember;                   // RtBOp
    Config accConfig;                           // RtBOp
    accMember = accConfig.Get();

    s32 stability_buf[AXIS_NUM][TEST_PROCESS_MAX][accMember.AccStabilityNum];  // 萫mFTvO̒li[
    ShowPassage pse = { RESULT_OK, 1, &accMember, gfx };           // ʕ\ڗp\

//----------------------------------------------------------------------------
    // xɁuAGAINvʂ\ĎČsǂ؂ւtOCTRȊO0(AGAIN)ɂ
    if( uji::sys::PLATFORM_CTR != uji::sys::GetPlatformType() )
    {
        accMember.AgainTest_Flag = 0;
    }

#ifdef STATIC_ACC_GYRO
    accMember.AgainTest_Flag = 0;
#endif

    // WĂĂʕ\܂܂ɂ֐
    nn::gx::CTR::LcdPowerManager::TurnOnAll();

    //  xZT̒Ǐ]̐ݒ
    accReader.SetSensitivity(accMember.Play, accMember.Sensitivity);  // Ǐ]̐ݒ

    // SerialNumber̎擾
    uji::sys::GetSerialNumber( AccResultForSD.m_serialNo );

    // ԌvJn
    start_tick = nn::os::Tick::GetSystemCurrent();

    // LED̋PxMAXɐݒ
    uji::eva::mcu::SetMasterLedMax(test_result);

    // m点v_
    uji::eva::mcu::NotifyLedBlueOnNoWait();

    // LINE[hł͂Ȃꍇ
    if( accMember.TestMode != 0 )
    {
        // NANDɋL^ĂLu[Vlǂݏo
        GetAccCalCore(&acc_cal_param);
        read_cal.x.offset = acc_cal_param.x.offset;
        read_cal.x.scale  = acc_cal_param.x.scale;
        read_cal.y.offset = acc_cal_param.y.offset;
        read_cal.y.scale  = acc_cal_param.y.scale;
        read_cal.z.offset = acc_cal_param.z.offset;
        read_cal.z.scale  = acc_cal_param.z.scale;

        // ǂݏocall臒lȌꍇ
        if(
            acc_cal_param.x.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
            acc_cal_param.x.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||
            acc_cal_param.y.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
            acc_cal_param.y.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||
            acc_cal_param.z.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
            acc_cal_param.z.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||

            acc_cal_param.x.scale  <   (s16)accMember.X_1G_Max ||
            acc_cal_param.x.scale  >   (s16)accMember.X_1G_Min ||
            acc_cal_param.y.scale  <   (s16)accMember.Y_1G_Min ||
            acc_cal_param.y.scale  >   (s16)accMember.Y_1G_Max ||
            acc_cal_param.z.scale  <   (s16)accMember.Z_1G_Max ||
            acc_cal_param.z.scale  >   (s16)accMember.Z_1G_Min
        )
        {
            pse.test_process = TIME_OUT;
            pse.ng_code =READ_CAL_VALUE_ERROR + 600;
            readCalCheckNgFlag = CHECK_READ_CAL_NG;
        }
    }

//---------mF臒lmF 3p܂5psׂ̃[vJnn_--------
    do
    {

        // 臒l̐ݒ
        ChooseAccLimit(&pse, diff0g_ng_counter, limit_ng_counter);

        // mF(肷邩^CAEg܂ł̊֐̒ŗ܂)
        if(readCalCheckNgFlag == CHECK_READ_CAL_OK)
        {
            CheckStability( start_tick, &pse, &another_ng_code, stability_buf[AXIS_X][pse.test_process-1],
                            stability_buf[AXIS_Y][pse.test_process-1], stability_buf[AXIS_Z][pse.test_process-1],
                            diffStabilityMaxMin, &stability_ok_flag );
        }

        //---------------mF̌ʂOKꍇ̏---------------------
        if( (pse.test_process != TIME_OUT) && (pse.ng_code == 0) )
        {
            // ϐ̏
            for(int j=pse.test_process-1;j<TEST_PROCESS_MAX;j++)
            {
                // ̏sȂ21G̒lꍇ̂ŕK{
                sample30_max[AXIS_X][j] = -10000;
                sample30_max[AXIS_Y][j] = -10000;
                sample30_max[AXIS_Z][j] = -10000;

                sample30_min[AXIS_X][j] = 10000;
                sample30_min[AXIS_Y][j] = 10000;
                sample30_min[AXIS_Z][j] = 10000;
            }

            // eTvOf[^̒l𑫂킹vƕϒlvZ
            for(int j=0;j<AXIS_NUM;j++)
            {
                // TvOf[^̒l𑫂킹vi[ϐ
                sample30_sum[j]= 0;

                // AccStabilityNum(100)̓AŐVAccSamplingNum(30)ɑ΂
                // őlsample30_maxEŏlsample30_minсAϒl擾
                for(int k=0;k<accMember.AccSamplingNum;k++)
                {
                    // TvOf[^̒l𑫂킹
                    sample30_sum[j] += stability_buf[j][pse.test_process-1][accMember.AccStabilityNum-1 - k];

                    // TvOf[^̍őlo
                    if(stability_buf[j][pse.test_process-1][accMember.AccStabilityNum-1 - k]
                        > sample30_max[j][pse.test_process-1])
                            sample30_max[j][pse.test_process-1]
                             = stability_buf[j][pse.test_process-1][accMember.AccStabilityNum-1 - k];

                    // TvOf[^̍ŏlo
                    if(stability_buf[j][pse.test_process-1][accMember.AccStabilityNum-1 - k]
                        < sample30_min[j][pse.test_process-1])
                            sample30_min[j][pse.test_process-1]
                             = stability_buf[j][pse.test_process-1][accMember.AccStabilityNum-1 - k];
                }

                // TvOf[^畽ϒl擾
                sample30_average[j][pse.test_process-1] = sample30_sum[j] / accMember.AccSamplingNum;
            }

            // xZT̊mF
            pse.acc_raw_x = sample30_average[AXIS_X][pse.test_process-1];
            pse.acc_raw_y = sample30_average[AXIS_Y][pse.test_process-1];
            pse.acc_raw_z = sample30_average[AXIS_Z][pse.test_process-1];

            // 0G,1G̎̉xZT̐l̃TvOϒl͈͓Ɏ܂Ă邱ƂmF
            pse.ng_code = CheckLimit0_1G( &pse );

            if( pse.ng_code != 0 )
            {
                pre_limit_ng_flag = 1;
            }
        }

        // mFE臒l藼OK̏ꍇ
        if ( pse.ng_code == RESULT_OK )
        {
            pre_limit_ng_flag = 0;
            stability_ok_flag = 0;

            // e臒lOKAɍ킹LED_
            TurnOnOKLed(&pse);

            // t@t@[o
            q->UjiSoundPlayer2013( "rom:/SoundPlayer/fanfare_16bit_fs32kHz_1ch.wav", 1500, 8.0 );

            pse.test_process++;

            // ԌvJn
            start_tick = nn::os::Tick::GetSystemCurrent();
        }//------------------------------------------------------------------------------------------------------------
        // ^CAEgȊONGɂȂĂꍇ
        else if ( pse.test_process != TIME_OUT )
        {
            if( pse.test_process <= 5 )
            {
                // ̌^CAEgɂȂꍇ͂another_ng_codeɓꂽG[R[hng_codeɊi[
                if( pse.ng_code != RESULT_OK ) another_ng_code = pse.ng_code;
                pse.ng_code = RESULT_OK;
            }
        }

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // OK̏ꍇA܂TIME OUT̏ꍇ-----------------------------------------------------------------------
#ifdef SHORT_VERSION
        //p4,5(ڂY,Z)Ȃꍇ
        if( pse.test_process > 3 ) pse.test_process = pse.test_process + 2;
#endif
#ifdef STATIC_ACC_GYRO
        //p2,3,4,5(ڂY,Z)Ȃꍇ
        if( pse.test_process > 1 ) pse.test_process = pse.test_process + 4;
#endif

        if( pse.test_process > TEST_PROCESS_MAX )
        {

            // 0G܂1G̐l臒l𒴂Ăꍇ
            if( pre_limit_ng_flag != 0 )
            {
                // ꎞIpse.ng_codeRESULT_OKɂ(L1̕Ōɖ߂)
                tmp_ng_code = pse.ng_code;
                pse.ng_code = RESULT_OK;

                // 臒lNG񐔂+1
                limit_ng_counter++;

                // 臒lNG1ڂ̏ꍇ
                if( limit_ng_counter == 1 ) limit_ng_flag = 1;
            }

            if( pse.ng_code == RESULT_OK )
            {
#ifdef STATIC_ACC_GYRO
                // xŔ팟̎pύXȂꍇ
                set_cal.x.offset = sample30_average[AXIS_X][0];
                set_cal.y.offset = sample30_average[AXIS_Y][0];
                set_cal.z.offset = sample30_average[AXIS_Z][0] + accMember.Gravity_1G;
                set_cal.x.scale = - accMember.Gravity_1G;
                set_cal.y.scale =   accMember.Gravity_1G;
                set_cal.z.scale = - accMember.Gravity_1G;
#else
                // xŔ팟̎pύXꍇ
//-----------------0_̒l2pꂼ̂Ƃő傫قȂȂƂ̊mF------------------------------
                // y1ǦvɏIĂꍇ(x0Gcall߂ԂɂȂĂꍇ)
                if( sample30_average[AXIS_X][1] != -10000 )
                {
                    diff_x0_yz = abs(sample30_average[AXIS_X][0] - sample30_average[AXIS_X][1]);

                    if( diff_x0_yz > pse.diff0g_limit ) diff_x0_yz_flag = 1;
                }

                // x1ǦvɏIĂꍇ(y0GAz0Gcall߂ԂɂȂĂꍇ)
                if( sample30_average[AXIS_X][2] != -10000 )
                {
                    diff_y0_zx = abs(sample30_average[AXIS_Y][0] - sample30_average[AXIS_Y][2]);
                    diff_z0_xy = abs(sample30_average[AXIS_Z][1] - sample30_average[AXIS_Z][2]);

                    if( diff_y0_zx > pse.diff0g_limit ) diff_y0_zx_flag = 1;
                    if( diff_z0_xy > pse.diff0g_limit ) diff_z0_xy_flag = 1;
                }

                // NG󋵂ɍ킹ăG[R[h쐬
                pse.ng_code = MakeAccErrorNumber(diff_x0_yz_flag, diff_y0_zx_flag, diff_z0_xy_flag, pse.test_process * 100 + DIFF_0G);
//--------------0_̒l2pꂼ̂ƂŒl傫قȂȂƂ̊mF  I-----------------

//--------------callƂďޒl(0G̒lƊx␳p̒l)߂----------------------------
                // 0GxZTl2𑫂2Ŋĕω
                if( sample30_average[AXIS_X][1] == -10000 ) set_cal.x.offset = -10000;
                else set_cal.x.offset = (sample30_average[AXIS_X][0] + sample30_average[AXIS_X][1]) / 2;
                if( sample30_average[AXIS_Y][2] == -10000 ) set_cal.y.offset = -10000;
                else set_cal.y.offset = (sample30_average[AXIS_Y][0] + sample30_average[AXIS_Y][2]) / 2;
                if( sample30_average[AXIS_Z][2] == -10000 ) set_cal.z.offset = -10000;
                else set_cal.z.offset = (sample30_average[AXIS_Z][1] + sample30_average[AXIS_Z][2]) / 2;

                // 1GxZTlقǋ߂0G̐l(ωꂽ)1Gcall߂
                if( (sample30_average[AXIS_X][2] == -10000) || (set_cal.x.offset == -10000) ) set_cal.x.scale = 0;
                else set_cal.x.scale = (sample30_average[AXIS_X][2] - set_cal.x.offset);
                if( (sample30_average[AXIS_Y][1] == -10000) || (set_cal.y.offset == -10000) ) set_cal.y.scale = 0;
                else set_cal.y.scale = (sample30_average[AXIS_Y][1] - set_cal.y.offset);
                if( (sample30_average[AXIS_Z][0] == -10000) || (set_cal.z.offset == -10000) ) set_cal.z.scale = 0;
                else set_cal.z.scale = (sample30_average[AXIS_Z][0] - set_cal.z.offset);
//--------------callƂďޒl(0G̒lƊx␳p̒l)߂  I---------------------------
#endif
            }

            if(pre_limit_ng_flag != 0)
            {
                // pse.ng_codeɖ߂        1
                if( tmp_ng_code != RESULT_OK ) pse.ng_code = tmp_ng_code;

                tmp_ng_code = 0;

                pre_limit_ng_flag = 0;
            }

#ifdef STATIC_ACC_GYRO
// 1p݂̂̌̓tXP[`FbNȗ
#else

//----------------------------tXP[`FbN----------------------------
            // ܂łŃG[ĂȂꍇ
            if( pse.ng_code == RESULT_OK )
            {
                // X
                // tXP[+1.8Gȏł邱Ƃ̊mF
                full_scale.x.max = float(2048-set_cal.x.offset)/abs(set_cal.x.scale);

                // tXP[-1.8Gȉł邱Ƃ̊mF
                full_scale.x.min = float(-2047-set_cal.x.offset)/abs(set_cal.x.scale);

                // Y
                // tXP[+1.8Gȏł邱Ƃ̊mF
                full_scale.y.max = float(2048-set_cal.y.offset)/abs(set_cal.y.scale);

                // tXP[-1.8Gȉł邱Ƃ̊mF
                full_scale.y.min = float(-2047-set_cal.y.offset)/abs(set_cal.y.scale);

                // Z
                // tXP[+1.8Gȏł邱Ƃ̊mF
                full_scale.z.max = float(2048-set_cal.z.offset)/abs(set_cal.z.scale);

                // tXP[-1.8Gȉł邱Ƃ̊mF
                full_scale.z.min = float(-2047-set_cal.z.offset)/abs(set_cal.z.scale);

                bool full_scale_x_flag = 0;
                bool full_scale_y_flag = 0;
                bool full_scale_z_flag = 0;

                if( abs(full_scale.x.max) * 1000 < accMember.FullScaleRange ) full_scale_x_flag = 1;
                if( abs(full_scale.y.max) * 1000 < accMember.FullScaleRange ) full_scale_y_flag = 1;
                if( abs(full_scale.z.max) * 1000 < accMember.FullScaleRange ) full_scale_z_flag = 1;
                if( abs(full_scale.x.min) * 1000 < accMember.FullScaleRange ) full_scale_x_flag = 1;
                if( abs(full_scale.y.min) * 1000 < accMember.FullScaleRange ) full_scale_y_flag = 1;
                if( abs(full_scale.z.min) * 1000 < accMember.FullScaleRange ) full_scale_z_flag = 1;

                // Full Scale NGĂꍇ̓G[R[h쐬
                if( full_scale_x_flag || full_scale_y_flag || full_scale_z_flag )
                {
                    pse.ng_code = MakeAccErrorNumber( full_scale_x_flag, full_scale_y_flag, full_scale_z_flag, pse.test_process * 100 + FULL_SCALE );
                }
            }
//----------------------------tXP[`FbN I----------------------------
#endif

            if( pse.ng_code == RESULT_OK )
            {
                // LINE[h̏ꍇ  Lu[Vl
                if( accMember.TestMode == 0 )
                {
                    // SetAccCalCore֐G[߂l
                    s32 set_cal_err = 0;

                    // vZďolCALlɑ
                    acc_cal_param.x.offset =   set_cal.x.offset;
                    acc_cal_param.x.scale  = - set_cal.x.scale;
                    acc_cal_param.y.offset =   set_cal.y.offset;
                    acc_cal_param.z.offset =   set_cal.z.offset;
                    acc_cal_param.z.scale  = - set_cal.z.scale;

                    // łFTR̉dSPRƓɂȂ܂B
                    if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                       ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (pse.pCnfMem->ScreenCheckFlag == 0) ) )
                        acc_cal_param.y.scale  = - set_cal.y.scale;
                    else
                        acc_cal_param.y.scale  =   set_cal.y.scale;

                    // ݒpcall臒lȌꍇ
                    if(
                        acc_cal_param.x.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
                        acc_cal_param.x.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||
                        acc_cal_param.y.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
                        acc_cal_param.y.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||
                        acc_cal_param.z.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
                        acc_cal_param.z.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||

                        acc_cal_param.x.scale  <  (s16)accMember.X_1G_Max ||
                        acc_cal_param.x.scale  >  (s16)accMember.X_1G_Min ||
                        acc_cal_param.y.scale  <  (s16)accMember.Y_1G_Min ||
                        acc_cal_param.y.scale  >  (s16)accMember.Y_1G_Max ||
                        acc_cal_param.z.scale  <  (s16)accMember.Z_1G_Max ||
                        acc_cal_param.z.scale  >  (s16)accMember.Z_1G_Min
                    )
                    {
                        pse.ng_code =SET_CAL_VALUE_ERROR + pse.test_process * 100;

                        read_cal.x.offset = acc_cal_param.x.offset;
                        read_cal.x.scale  = acc_cal_param.x.scale;
                        read_cal.y.offset = acc_cal_param.y.offset;
                        read_cal.y.scale  = acc_cal_param.y.scale;
                        read_cal.z.offset = acc_cal_param.z.offset;
                        read_cal.z.scale  = acc_cal_param.z.scale;
                    }
                    // ݒpcallȏꍇ
                    else
                    {
                        // vZďolCALlɐݒ肷
                        set_cal_err = SetAccCalCore(acc_cal_param);
                        if(set_cal_err != 0)
                        {
                            sprintf(err_info, "SetAccCalCore:%d", set_cal_err);
                            pse.ng_code = SET_CAL_STATUS_ERROR + pse.test_process * 100;
                        }
                        else
                        {
                            // ݒ肵Lu[Vlǂݏo
                            GetAccCalCore(&acc_cal_param);
                            read_cal.x.offset = acc_cal_param.x.offset;
                            read_cal.x.scale  = acc_cal_param.x.scale;
                            read_cal.y.offset = acc_cal_param.y.offset;
                            read_cal.y.scale  = acc_cal_param.y.scale;
                            read_cal.z.offset = acc_cal_param.z.offset;
                            read_cal.z.scale  = acc_cal_param.z.scale;

                            // ǂݏocall臒lȌꍇ
                            if(
                                acc_cal_param.x.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
                                acc_cal_param.x.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||
                                acc_cal_param.y.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
                                acc_cal_param.y.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||
                                acc_cal_param.z.offset < - (s16)(accMember.ALL_0G_Min + accMember.AgainAddition0G) ||
                                acc_cal_param.z.offset >   (s16)(accMember.ALL_0G_Max + accMember.AgainAddition0G) ||

                                acc_cal_param.x.scale  <   (s16)accMember.X_1G_Max ||
                                acc_cal_param.x.scale  >   (s16)accMember.X_1G_Min ||
                                acc_cal_param.y.scale  <   (s16)accMember.Y_1G_Min ||
                                acc_cal_param.y.scale  >   (s16)accMember.Y_1G_Max ||
                                acc_cal_param.z.scale  <   (s16)accMember.Z_1G_Max ||
                                acc_cal_param.z.scale  >   (s16)accMember.Z_1G_Min
                            )
                            {
                                pse.ng_code =READ_CAL_VALUE_ERROR + pse.test_process * 100;
                            }
                        }
                    }
                }
                // LINE[hȊȌꍇ Lu[VlǂݏoāǍ̃Lu[VlƔr
                else
                {
//--------------------QCLINÊmF------------------------
                    // callƂď܂Ă0_̒lƁA񌟍ۂ0_̒l̍
                    diff_line_qc.x.offset = set_cal.x.offset - read_cal.x.offset;
                    diff_line_qc.y.offset = set_cal.y.offset - read_cal.y.offset;
                    diff_line_qc.z.offset = set_cal.z.offset - read_cal.z.offset;

                    // callƂď܂Ă1G̒lƁA񌟍ۂ1G̒l̍(%\)
                    diff_line_qc.x.scale
                     = ( ( abs(set_cal.x.scale) - abs(read_cal.x.scale) ) / abs(read_cal.x.scale) ) * 100;
                    diff_line_qc.y.scale
                     = ( ( abs(set_cal.y.scale) - abs(read_cal.y.scale) ) / abs(read_cal.y.scale) ) * 100;
                    diff_line_qc.z.scale
                     = ( ( abs(set_cal.z.scale) - abs(read_cal.z.scale) ) / abs(read_cal.z.scale) ) * 100;

                    // LINEQC0GA1GcallĂ邩ǂ̔
                    CheckDifferenceOfLineAndQC( diff_line_qc, &pse );
//----------------------QCLINÊmF  I--------------------------
                }
            }

            if( pse.ng_code == RESULT_OK )
            {
                if( accMember.AgainTest_Flag == 1 )
                {
                    // ČOKɂȂꍇInfoɏc
                    if( ( diff0g_ng_counter > 0 ) || ( limit_ng_counter > 0 ) )
                    {
                        sprintf(ng_info_str, "OK[d:%d][l:%d] 0G}%d[%d]",
                                diff0g_ng_counter, limit_ng_counter, pse.upper_limit_0g, pse.diff0g_limit);
                    }
                }

                sprintf(result_str, ",OK,%s", ng_info_str);
            }
            // ܂łɃG[ꍇ
            else
            {
                // e2񂸂0G̒l̍(1ł)臒l傫ꍇ
                if( diff_x0_yz_flag || diff_y0_zx_flag || diff_z0_xy_flag )
                {
                    diff0g_ng_counter++;
                    if( diff0g_ng_counter == 1 )
                    {
                        diff0g_ng_flag = 1;
                    }
                }

                // uAGAINvtO(ČtO)ON̂Ƃ
                if( accMember.AgainTest_Flag == 1 )
                {
                    if( ( limit_ng_flag == 1 ) || ( diff0g_ng_flag == 1 ) )
                        sprintf(ng_info_str, "AGAIN[d:%d][l:%d] 0G}%d[%d]",
                          diff0g_ng_counter, limit_ng_counter, pse.upper_limit_0g, pse.diff0g_limit);
                    else if( ( diff0g_ng_counter > 0 ) || ( limit_ng_counter > 0 ) )
                        sprintf(ng_info_str, "NG[d:%d][l:%d] 0G}%d[%d]",
                         diff0g_ng_counter, limit_ng_counter, pse.upper_limit_0g, pse.diff0g_limit );
                }

                // ^CAEgG[ɂȂꍇ́A^CAEgÕG[R[hpse.ng_codeɊi[
                if( (pse.ng_code%100 == TIME_OUT) && (another_ng_code != 0) )
                {
                    pse.ng_code = another_ng_code;
                    another_ng_code = TIME_OUT + pse.test_process * 100;
                }

                sprintf(result_str, ",%02d-%03d-%03d,%s",
                 (s32)39, (s32)pse.ng_code%1000, (s32)another_ng_code%1000, ng_info_str);

                sprintf(ng_code_str, "%02d-%03d-%03d",
                 (s32)39, (s32)pse.ng_code%1000, (s32)another_ng_code%1000);
            }

            // SDJ[hɎccsvt@Cp̃f[^쐬
            MakeCSVData( &accMember, diffStabilityMaxMin, sample30_min, sample30_max, sample30_average,
                             diff_x0_yz, diff_y0_zx, diff_z0_xy, full_scale, result_str,
                             read_cal, set_cal, diff_line_qc, &line, &AccResultForSD );

            // ʉʕ\p
            MakeResultStr(str_ng_Average,  0,  sample30_average,  diff_x0_yz,  diff_y0_zx,  diff_z0_xy,  full_scale);

            // LINE[h,QC[hSD݃tO1̏ꍇSDJ[hɌf[^
            if( ((accMember.TestMode == 0) && (accMember.LINE_Write_SD_Flag == 1))
             || ((accMember.TestMode == 1) && (accMember.QC_Write_SD_Flag == 1)) )
            {
                tmp_ng_code = pse.ng_code;

                // SDJ[hɃOc
                WriteAccDataToSD(&pse, &another_ng_code, line);

                // SDJ[ĥ݂݂ŃG[ꍇ
                if( ( tmp_ng_code == 0 ) && ( pse.ng_code != 0 ) )
                {
                    sprintf(ng_code_str, "%02d-%03d-%03d", (s32)39, (s32)pse.ng_code%1000, (s32)another_ng_code%1000);
                }
                else pse.ng_code = tmp_ng_code;

                // RtBOŐݒ肳AČ@\tOOFFɂȂĂꍇ
                if(accMember.AgainTest_Flag == 0)
                {
                    // LtO0ɂƍČs킸NGƔ肵܂B
                    limit_ng_flag = 0;
                    diff0g_ng_flag = 0;
                }

                // 2񑪂0Gl̍臒lȏł΍Čs(A1ڂ̂݁B)
                // ܂́ATvOϒl臒l𒴂ꍇA臒lɂ߂čČs
                if( (limit_ng_flag == 1) || (diff0g_ng_flag == 1) )
                {
                    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;      // ʕ\p

                    // m点v F_
                    uji::eva::mcu::NotifyLedWhiteOn();

                    // TEho͊֐(FTEht@CA炷ԁȂ傫߂{)
                    q->UjiSoundPlayer2013( "rom:/SoundPlayer/annotation.wav", 900, 8.0 );

                    // 摜XV(Č𑣂)
                    jpegDrawer->OpenPicture(L"rom:/jpeg/AccAgain.jpg");
                    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                    glFlush();
                    gfx->m_DrawFramework->SwapBuffers();

                    // WĴ҂
                    uji::eva::mcu::WaitOpenState();

                    // {̂Ԃŉo悤ɂ鏈
                    AccSoundReInitialize();

                    // R{^܂Ń[v
                    do
                    {
                        // L[͂̊mF
                        padReader.ReadLatest(&padStatus);
                        pad.UpdatePad(padStatus);
                    }while( !(sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) );

                    // ʂ
                    jpegDrawer->ClosePicture();
                    delete jpegDrawer;

                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(300));

                    // m点v(LED)
                    uji::eva::mcu::NotifyLedWhiteOff();

                    // soundI
                    AccSoundFinalize();

                    // tO
                    diff_x0_yz_flag = 0;
                    diff_y0_zx_flag = 0;
                    diff_z0_xy_flag = 0;

                    limit_ng_flag = 0;
                    diff0g_ng_flag = 0;
                    stability_ok_flag = 0;

                    pse.test_process = 1;
                }
                // ϒlNGtOA0GČtOƂ1ɂȂĂȂꍇANGƂď
                else
                {
                    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;

                    // m点v F_
                    uji::eva::mcu::NotifyLedWhiteOn();

                    q->UjiSoundPlayer2013( "rom:/SoundPlayer/annotation.wav", 900, 8.0 );

                    jpegDrawer->OpenPicture(L"rom:/jpeg/removeSD.jpg");
                    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                    glFlush();
                    gfx->m_DrawFramework->SwapBuffers();

                    // }Ԏ擾tO
                    bool bInserted;

                    // SDJ[h܂Ń[v
                    do
                    {
                        bInserted = nn::fs::IsSdmcInserted();
                    }while(bInserted == 1);

                    // SDJ[h𔲂ʂ
                    jpegDrawer->ClosePicture();
                    delete jpegDrawer;

                    // m点v(LED)
                    uji::eva::mcu::NotifyLedWhiteOff();
                }
            }
            // SDJ[hɃf[^܂Ȃꍇ
            else
            {
                if(accMember.AgainTest_Flag == 0)
                {
                    limit_ng_flag = 0;
                    diff0g_ng_flag = 0;
                }

                // 2񑪂0Gl̍臒lȏł΍Čs(A1ڂ̂݁B)
                // ܂́Al臒l𒴂ꍇA臒lɂ߂čČs(臒lɂ߂ĂꍇNGƂ)
                if( (limit_ng_flag == 1) || (diff0g_ng_flag == 1) )
                {
                    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;

                    // m点v F_
                    uji::eva::mcu::NotifyLedWhiteOn();

                    q->UjiSoundPlayer2013( "rom:/SoundPlayer/annotation.wav", 900, 8.0 );

                    // 摜XV(Č𑣂)
                    jpegDrawer->OpenPicture(L"rom:/jpeg/AccAgain.jpg");
                    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
                    glFlush();
                    gfx->m_DrawFramework->SwapBuffers();

                    // OPENԂɂȂ܂ő҂֐
                    uji::eva::mcu::WaitOpenState();

                    // {̂Ԃŉo悤ɂ鏈
                    AccSoundReInitialize();

                    // R{^܂Ń[v
                    do
                    {
                        // L[͂̊mF
                        padReader.ReadLatest(&padStatus);
                        pad.UpdatePad(padStatus);
                    }while( !(sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) );

                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(300));

                    // ʂ
                    jpegDrawer->ClosePicture();
                    delete jpegDrawer;

                    // m点v(LED)
                    uji::eva::mcu::NotifyLedWhiteOff();

                    // soundI
                    AccSoundFinalize();

                    // tO
                    diff_x0_yz_flag = 0;
                    diff_y0_zx_flag = 0;
                    diff_z0_xy_flag = 0;

                    limit_ng_flag = 0;
                    diff0g_ng_flag = 0;
                    stability_ok_flag = 0;

                    pse.test_process = 1;
                }
            }

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // xZT̊mF
            accReader.ReadLatest(&accStatus);
            accReader.ConvertToAcceleration(&acceleration, 1, &accStatus);

            gfx->m_DrawFramework->Clear();

            // EChE
            m_WindowManager.UpdatePad(pad);
            m_WindowManager.Update();
            m_WindowManager.DrawDisplay0();

            // `
            gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);

            gfx->m_DrawFramework->SwapBuffers();

            // ʂW̐Fɖ߂
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 0.36f, 0.42f, 0.5f, 0.0f );
            start_tick = nn::os::Tick::GetSystemCurrent();

        }
    } while ( pse.test_process < TEST_PROCESS_MAX+1 );

    // -----------------------------------IAV[PXɌʂ𑗂铙̏-------------------------------
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_NONE);

    acc_result.m_Micro = pse.ng_code % 1000;

    if(pse.ng_code == 0)
    {
        // m点v_
        uji::eva::mcu::NotifyLedBlueOnNoWait();

        s32 flag_log_err;
        uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
        pl->Initialize();

        // O (TestMode, testerName, state, version, date, time, testerId, message,)
        flag_log_err = pl->Add_1Line(accMember.TestMode, "Acc", "OK",  VERSION_STRING, "","","", "");

        if(flag_log_err < 0)
        {
            pse.ng_code = WRITE_LOG + pse.test_process * 100;
            sprintf(err_info, "WRITE LOG TO NAND ERROR  CODE:%d", flag_log_err);
            acc_result.m_Result = 0;
        }
        else
        {
            acc_result.m_Result = 1;    // OK̏ꍇ
        }
        pl->Finalize();
        delete pl;
    }
    else
    {
        TurnOnNGLedAndWriteNGLog(&accMember, ng_code_str);
        acc_result.m_Result = 0;
    }


    char tmp_str[1024];


    // sNGꍇ
    if(((pse.ng_code/10) % 10) == 1)
    {
        sprintf( tmp_str, "%d-%d (%s) \n UNSTABLE  x:%d y:%d z:%d\n 0:%d %d %d 1:%d %d %d \n 2:%d %d %d",
           (s32)(pse.ng_code%1000), (s32)(another_ng_code%1000), TestMode[pse.pCnfMem->TestMode],
            diffStabilityMaxMin[AXIS_X][pse.ng_code/100 - 1],
            diffStabilityMaxMin[AXIS_Y][pse.ng_code/100 - 1],
            diffStabilityMaxMin[AXIS_Z][pse.ng_code/100 - 1],
            sample30_average[AXIS_X][0], sample30_average[AXIS_Y][0], sample30_average[AXIS_Z][0],
            sample30_average[AXIS_X][1], sample30_average[AXIS_Y][1], sample30_average[AXIS_Z][1],
            sample30_average[AXIS_X][2], sample30_average[AXIS_Y][2], sample30_average[AXIS_Z][2] );
    }
    // sNGȊOAAo׌̏ꍇ
    else if(accMember.TestMode == 1)
    {
        char str_dif[512];

        if(readCalCheckNgFlag == CHECK_READ_CAL_NG)
        {
            sprintf( tmp_str, "%d-%d (%s) READ CAL ERROR \n           x:%d %d y:%d %d z:%d %d ",
               (s32)(pse.ng_code%1000), (s32)(another_ng_code%1000), TestMode[pse.pCnfMem->TestMode],
                acc_cal_param.x.offset, acc_cal_param.x.scale,
                acc_cal_param.y.offset, acc_cal_param.y.scale,
                acc_cal_param.z.offset, acc_cal_param.z.scale);
        }
        else
        {
            // callƂď܂Ă0_̒lƁA񌟍ۂ0_̒l̍A
            // callƂď܂Ă1G̒lƁA񌟍ۂ1G̒l̍(%\)
            sprintf( str_dif, "D0:%d %d %d D1:%f %f %f",
              diff_line_qc.x.offset, diff_line_qc.y.offset, diff_line_qc.z.offset,
              diff_line_qc.x.scale, diff_line_qc.y.scale, diff_line_qc.z.scale );

            sprintf( tmp_str, "%d-%d (%s) %s%s%s",
               (s32)(pse.ng_code%1000), (s32)(another_ng_code%1000), TestMode[pse.pCnfMem->TestMode],
               err_info, str_ng_Average, str_dif );
        }
    }
    else
    {
        sprintf( tmp_str, "%d-%d (%s) \n%s%s",
           (s32)(pse.ng_code%1000), (s32)(another_ng_code%1000), TestMode[pse.pCnfMem->TestMode],
           err_info, str_ng_Average );
    }

    memset(acc_result.m_String, 0x00, MAX_STRING_LEN);
    strncpy(acc_result.m_String, tmp_str, MAX_STRING_LEN-2);


    delete q;

    return acc_result;
}




}   // usingnamespace acc
}   // usingnamespace eva
}   // usingnamespace uji



