/*--------------------------------------------------------------------------*
 Project:
 File: ShowAccTestPassage.cpp

*--------------------------------------------------------------------------*/
#include <nn.h>
#include "ShowAccTestPassage.h"
#include "../../sys/sys_GetPlatform.h"
#include "TestAccTool.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {
namespace acc {

//============================================================================
// xԕ\֐
//============================================================================
void ShowAccTestPassage(ShowPassage pse)
{

    static const char PROGRAM_VERSION_DATE[] = __DATE__ " " __TIME__ ;

    pse.gfx->BeginDrawingString();

    // o[W\

    if((pse.pCnfMem->TestMode == 0) && (pse.pCnfMem->LINE_Write_SD_Flag == 0))
    {
        (void)pse.gfx->m_TextWriter.Printf("%s Ver %s %s\n\n", "CIS ACC Test Program *", VERSION_STRING, PROGRAM_VERSION_DATE);
    }
    else
    {
        if(uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
        {
            //SPFLp
            (void)pse.gfx->m_TextWriter.Printf("%s Ver %s %s\n\n", "S ACC Test Program", VERSION_STRING, PROGRAM_VERSION_DATE);
        }
        else if(uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
        {
            //FTRp
            if(pse.pCnfMem->ScreenCheckFlag == 0)
                (void)pse.gfx->m_TextWriter.Printf("%s Ver %s %s\n\n", "TRIAL ACC Test Program", VERSION_STRING, PROGRAM_VERSION_DATE);
            else
                (void)pse.gfx->m_TextWriter.Printf("%s Ver %s %s\n\n", "PROD ACC Test Program", VERSION_STRING, PROGRAM_VERSION_DATE);
        }
        else
        {
            (void)pse.gfx->m_TextWriter.Printf("%s Ver %s %s\n\n", "C ACC Test Program", VERSION_STRING, PROGRAM_VERSION_DATE);
        }
    }
#ifdef ALL_PASS
            (void)pse.gfx->m_TextWriter.Printf("%s Ver ---\n\n", "ALL PASS");
#endif

    // Z
    if( ( pse.test_process == 1 ) || ( pse.test_process == 5 ) )
    {
        pse.gfx->SetFixedWidthFont(40);
        (void)pse.gfx->m_TextWriter.Printf("Z-%d  [%s]\n", pse.test_process, TestMode[pse.pCnfMem->TestMode]);
        pse.gfx->SetFixedWidthFont(16);
        (void)pse.gfx->m_TextWriter.Printf("STEP:%d  stability x:%d y:%d z:%d \n\n", pse.test_process, pse.stability_count_gx, pse.stability_count_gy, pse.stability_count_gz);

        if( (pse.pCnfMem->TestMode == 1) || (pse.pCnfMem->TestMode == 9) )
        {
            // QC 
            (void)pse.gfx->m_TextWriter.Printf("x%d: %05d < %05d < %05d [%d]\n", pse.test_process , - pse.lower_limit_0g,            pse.acc_raw_x,   pse.upper_limit_0g,           pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("y%d: %05d < %05d < %05d [%d]\n", pse.test_process , - pse.lower_limit_0g,            pse.acc_raw_y,   pse.upper_limit_0g,           pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("z%d: %05d < %05d < %05d [%d]\n", pse.test_process ,
                  - pse.pCnfMem->QC_Z_1G_Min,  pse.acc_raw_z, - pse.pCnfMem->QC_Z_1G_Max, pse.diff0g_limit);
        }
        else
        {
            (void)pse.gfx->m_TextWriter.Printf("x%d: %05d < %05d < %05d [%d]\n", pse.test_process , - pse.lower_limit_0g,        pse.acc_raw_x,   pse.upper_limit_0g,        pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("y%d: %05d < %05d < %05d [%d]\n", pse.test_process , - pse.lower_limit_0g,        pse.acc_raw_y,   pse.upper_limit_0g,        pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("z%d: %05d < %05d < %05d [%d]\n", pse.test_process , - pse.pCnfMem->Z_1G_Min, pse.acc_raw_z, - pse.pCnfMem->Z_1G_Max, pse.diff0g_limit);
        }
    }
    // Y
    else if( ( pse.test_process == 2 ) || ( pse.test_process == 4 ) )
    {
        pse.gfx->SetFixedWidthFont(40);
        (void)pse.gfx->m_TextWriter.Printf("Y-%d  [%s]\n", pse.test_process, TestMode[pse.pCnfMem->TestMode]);
        pse.gfx->SetFixedWidthFont(16);
        (void)pse.gfx->m_TextWriter.Printf("STEP:%d  stability x:%d y:%d z:%d \n\n",  pse.test_process, pse.stability_count_gx, pse.stability_count_gy, pse.stability_count_gz);

        if( (pse.pCnfMem->TestMode == 1) || (pse.pCnfMem->TestMode == 9) )
        {
            // QC[hADEBUG[h̏ꍇ
            (void)pse.gfx->m_TextWriter.Printf("x%d: %05d < %05d < %05d [%d]\n",  pse.test_process, - pse.lower_limit_0g, pse.acc_raw_x, pse.upper_limit_0g, pse.diff0g_limit);

            // łFTR̉dSPRƓɂȂ܂B
            if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (pse.pCnfMem->ScreenCheckFlag == 0)) )
            {
                //SPFLp
                (void)pse.gfx->m_TextWriter.Printf("y%d: -%05d < %05d < -%05d[%d]\n", pse.test_process, pse.pCnfMem->QC_Y_1G_Max,     pse.acc_raw_y, pse.pCnfMem->QC_Y_1G_Min,   pse.diff0g_limit);
            }
            else
            {
                (void)pse.gfx->m_TextWriter.Printf("y%d: %05d < %05d < %05d [%d]\n",  pse.test_process, pse.pCnfMem->QC_Y_1G_Min,     pse.acc_raw_y, pse.pCnfMem->QC_Y_1G_Max,   pse.diff0g_limit);
            }
            (void)pse.gfx->m_TextWriter.Printf("z%d: %05d < %05d < %05d [%d]\n",  pse.test_process, - pse.lower_limit_0g,             pse.acc_raw_z, pse.upper_limit_0g,             pse.diff0g_limit);
        }
        else
        {
            (void)pse.gfx->m_TextWriter.Printf("x%d: %05d < %05d < %05d [%d]\n",  pse.test_process, - pse.lower_limit_0g,             pse.acc_raw_x, pse.upper_limit_0g,             pse.diff0g_limit);

            // łFTR̉dSPRƓɂȂ܂B
            if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (pse.pCnfMem->ScreenCheckFlag == 0)) )
            {
                //SPFLp
                (void)pse.gfx->m_TextWriter.Printf("y%d: -%05d < %05d < -%05d[%d]\n", pse.test_process, pse.pCnfMem->Y_1G_Max,        pse.acc_raw_y, pse.pCnfMem->Y_1G_Min,      pse.diff0g_limit);
            }
            else
            {
                (void)pse.gfx->m_TextWriter.Printf("y%d: %05d < %05d < %05d [%d]\n",  pse.test_process, pse.pCnfMem->Y_1G_Min,        pse.acc_raw_y, pse.pCnfMem->Y_1G_Max,      pse.diff0g_limit);
            }
            (void)pse.gfx->m_TextWriter.Printf("z%d: %05d < %05d < %05d [%d]\n",  pse.test_process, - pse.lower_limit_0g,             pse.acc_raw_z, pse.upper_limit_0g,             pse.diff0g_limit);
        }
    }
    // X
    else if( pse.test_process == 3 )
    {
        pse.gfx->SetFixedWidthFont(40);
        (void)pse.gfx->m_TextWriter.Printf("X-%d  [%s]\n", pse.test_process, TestMode[pse.pCnfMem->TestMode]);
        pse.gfx->SetFixedWidthFont(16);
        (void)pse.gfx->m_TextWriter.Printf("STEP:%d  stability x:%d y:%d z:%d \n\n", pse.test_process, pse.stability_count_gx, pse.stability_count_gy, pse.stability_count_gz);

        if( (pse.pCnfMem->TestMode == 1) || (pse.pCnfMem->TestMode == 9) )
        {
            // QC[hADEBUG[h̏ꍇ
            (void)pse.gfx->m_TextWriter.Printf("x3: %05d < %05d < %05d [%d]\n" , - pse.pCnfMem->QC_X_1G_Min,   pse.acc_raw_x, - pse.pCnfMem->QC_X_1G_Max,   pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("y3: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g,             pse.acc_raw_y,   pse.upper_limit_0g,             pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("z3: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g,             pse.acc_raw_z,   pse.upper_limit_0g,             pse.diff0g_limit);
        }
        else
        {
            (void)pse.gfx->m_TextWriter.Printf("x3: %05d < %05d < %05d [%d]\n" , - pse.pCnfMem->X_1G_Min,    pse.acc_raw_x, - pse.pCnfMem->X_1G_Max, pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("y3: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g,           pse.acc_raw_y,   pse.upper_limit_0g,        pse.diff0g_limit);
            (void)pse.gfx->m_TextWriter.Printf("z3: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g,           pse.acc_raw_z,   pse.upper_limit_0g,        pse.diff0g_limit);
        }
    }
    else
    {
        pse.gfx->SetFixedWidthFont(40);
        (void)pse.gfx->m_TextWriter.Printf("END  [%s]\n", TestMode[pse.pCnfMem->TestMode]);
        pse.gfx->SetFixedWidthFont(16);
        (void)pse.gfx->m_TextWriter.Printf("STEP:%d  stability x:%d y:%d z:%d \n\n", pse.test_process, pse.stability_count_gx, pse.stability_count_gy, pse.stability_count_gz);
        (void)pse.gfx->m_TextWriter.Printf("x: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g, pse.acc_raw_x, pse.upper_limit_0g, pse.diff0g_limit);
        (void)pse.gfx->m_TextWriter.Printf("y: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g, pse.acc_raw_y, pse.upper_limit_0g, pse.diff0g_limit);
        (void)pse.gfx->m_TextWriter.Printf("z: %05d < %05d < %05d [%d]\n" , - pse.lower_limit_0g, pse.acc_raw_z, pse.upper_limit_0g, pse.diff0g_limit);
    }

    (void)pse.gfx->m_TextWriter.Printf("\nNG CODE: %05d   TIME:%05lld < %05ld mS\n", pse.ng_code, pse.test_time, (pse.pCnfMem->TimeOut)*1000 );

    pse.gfx->EndDrawingString();

    return;
}


}
}
}


