
/*--------------------------------------------------------------------------*
 Project:
 File: CheckStability.cpp

*--------------------------------------------------------------------------*/
#include <nn.h>
#include "../seq/TestListManager.h"
#include "TestAccTool.h"
#include "CheckStability.h"
#include "TestAccErrorCode.h"
#include "../sys/sys_Menu.h"


namespace uji {
namespace eva {
namespace acc {


/*------------------------------------------------------------------------------------------------*
    xZT̈萫mF֐
    萔(AccStabilityNum)̃TvOl̍őlƍŏl̍AccStabilityRangeȓɎ܂Ă邱ƂmF

    start_tick       : ěJn
    pse              :
    another_ng_code  : NGR[hi[p
    sampling_buf_x   : X̃TvOf[^i[p
    sampling_buf_y     ỸTvOf[^i[p
    sampling_buf_z   : Z̃TvOf[^i[p
    sampling_max_min : e̍őlŏli[p
    stability_ok_flag: TvO̒l񐔈ȏ肵Ăꍇ1ɂȂtO
*--------------------------------------------------------------------------------------------------*/
s32 CheckStability( nn::os::Tick start_tick, ShowPassage* pse, u32* another_ng_code,
                       s32* sampling_buf_x, s32* sampling_buf_y, s32* sampling_buf_z,
                       s32 diffStabilityMaxMin[AXIS_NUM][TEST_PROCESS_MAX], bool* stability_ok_flag )
{
    s32 data_counter = 0;       // f[^p̃JE^[
    nn::hid::AccelerometerCalibrator testAcc;   // xl֐(ReadRaw)g߂ɕKv
    nn::hid::AccelerometerStatus accStatusRaw;  // xZTpϐ
    static s32 stability_process = 0;   // 萫m肵eXgHԍ(z:0Ay:1Ax:2A2y:3A2z:4)

    s32 gx_max = -2048;         // TvOxxZTl̒̍ő
    s32 gx_min = 2048;          // TvOxyZTl̒̍ŏ
    s32 gy_max = -2048;         // TvOxzZTl̒̍ő
    s32 gy_min = 2048;          // TvOxxZTl̒̍ŏ
    s32 gz_max = -2048;         // TvOxyZTl̒̍ő
    s32 gz_min = 2048;          // TvOxzZTl̒̍ŏ

    nn::hid::Accelerometer& accelerometer = nn::hid::GetAccelerometer( );       // WaitSamplingp

    // Ԉ莞̃JEgi[ϐZbg
    pse->stability_count_gx = 0;
    pse->stability_count_gy = 0;
    pse->stability_count_gz = 0;

    // 萫̊mF[v
    while( 1 )
    {
        pse->test_time = GetMilliSecond(start_tick);

        // ^CAEgG[
        if ( (pse->test_time/1000) >= pse->pCnfMem->TimeOut )
        {
            pse->test_process = TIME_OUT;

            // Jn莞Ԃo߂Ăꍇ̓^CAEgG[ɂȂ
            // ng_codeɃG[R[hĂꍇ1xł肵Ƃ̂ŕsNGł͂ȂB
            if( pse->ng_code == RESULT_OK )          pse->ng_code = pse->test_process * 100 + TIME_OUT;
            else if( *another_ng_code == RESULT_OK ) *another_ng_code = pse->test_process * 100 + TIME_OUT;

            gx_max = pse->acc_raw_x;
            gx_min = pse->acc_raw_x;
            gy_max = pse->acc_raw_y;
            gy_min = pse->acc_raw_y;
            gz_max = pse->acc_raw_z;
            gz_min = pse->acc_raw_z;

            for(data_counter=0;data_counter<100;data_counter++){
                // ̉xli[܂wait
                accelerometer.WaitSampling();

                // xZT[l̎擾
                testAcc.ReadRaw(&accStatusRaw);
                sampling_buf_x[data_counter] = pse->acc_raw_x = accStatusRaw.x;
                sampling_buf_y[data_counter] = pse->acc_raw_y = accStatusRaw.y;
                sampling_buf_z[data_counter] = pse->acc_raw_z = accStatusRaw.z;

                // ܂ł̃TvO̒ł̍őlEŏlXV
                if(gx_max < pse->acc_raw_x) gx_max = pse->acc_raw_x;
                if(gx_min > pse->acc_raw_x) gx_min = pse->acc_raw_x;
                if(gy_max < pse->acc_raw_y) gy_max = pse->acc_raw_y;
                if(gy_min > pse->acc_raw_y) gy_min = pse->acc_raw_y;
                if(gz_max < pse->acc_raw_z) gz_max = pse->acc_raw_z;
                if(gz_min > pse->acc_raw_z) gz_min = pse->acc_raw_z;
            }

            break;
        }

        // ̉xli[܂wait
        accelerometer.WaitSampling();

        // xZT[l̎擾
        testAcc.ReadRaw(&accStatusRaw);
        sampling_buf_x[data_counter] = pse->acc_raw_x = accStatusRaw.x;
        sampling_buf_y[data_counter] = pse->acc_raw_y = accStatusRaw.y;
        sampling_buf_z[data_counter] = pse->acc_raw_z = accStatusRaw.z;

        // ܂ł̃TvO̒ł̍őlEŏlXV
        if(gx_max < pse->acc_raw_x) gx_max = pse->acc_raw_x;
        if(gx_min > pse->acc_raw_x) gx_min = pse->acc_raw_x;
        if(gy_max < pse->acc_raw_y) gy_max = pse->acc_raw_y;
        if(gy_min > pse->acc_raw_y) gy_min = pse->acc_raw_y;
        if(gz_max < pse->acc_raw_z) gz_max = pse->acc_raw_z;
        if(gz_min > pse->acc_raw_z) gz_min = pse->acc_raw_z;

        // ------------------ẍmF--------------------
        // őlƍŏl̍l𒴂Ăꍇ(肵ĂȂꍇ)
        if( (gx_max - gx_min) > pse->pCnfMem->AccStabilityRange )
        {
            pse->stability_count_gx = 0;
        }
        else
        {
            pse->stability_count_gx++;
        }

        // ------------------ÿmF--------------------
        // őlƍŏl̍l𒴂Ăꍇ(肵ĂȂꍇ)
        if( (gy_max - gy_min) > pse->pCnfMem->AccStabilityRange )
        {
            pse->stability_count_gy = 0;
        }
        else
        {
            pse->stability_count_gy++;
        }

        // ------------------z̈mF--------------------
        // őlƍŏl̍l𒴂Ăꍇ(肵ĂȂꍇ)
        if( (gz_max - gz_min) > pse->pCnfMem->AccStabilityRange )
        {
            pse->stability_count_gz = 0;
        }
        else
        {
            pse->stability_count_gz++;
        }

        // sԂ̏ꍇ
        if( (pse->stability_count_gx == 0) || (pse->stability_count_gy == 0) || (pse->stability_count_gz == 0) )
        {
            data_counter = -1;
            // 1xł肵Ƃꍇ͕sNGł͂Ȃ̂ŁAONGR[hanother_ng_codeng_codeɑ
            if( *stability_ok_flag == 1 )
            {
                   pse->ng_code = *another_ng_code;
            }
            else
            {
                pse->ng_code = MakeAccErrorNumber(pse->stability_count_gx == 0, pse->stability_count_gy == 0,
                                    pse->stability_count_gz == 0, pse->test_process * 100 + ACC_UNSTABLE_ERROR);
            }

            // sNG̍őlƍŏl̍ێ
            diffStabilityMaxMin[AXIS_X][pse->test_process -1] = gx_max - gx_min;
            diffStabilityMaxMin[AXIS_Y][pse->test_process -1] = gy_max - gy_min;
            diffStabilityMaxMin[AXIS_Z][pse->test_process -1] = gz_max - gz_min;

            // NGAŌɎ擾llƂׁAőEŏ̗ɍŌɎ擾l
            gx_max = pse->acc_raw_x;
            gx_min = pse->acc_raw_x;
            gy_max = pse->acc_raw_y;
            gy_min = pse->acc_raw_y;
            gz_max = pse->acc_raw_z;
            gz_min = pse->acc_raw_z;
        }

        // ʕ\
        pse->gfx->m_DrawFramework->Clear();
        pse->gfx->SetScreenSize(pse->gfx->DISPLAY0_WIDTH, pse->gfx->DISPLAY0_HEIGHT);
        pse->gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        pse->gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        pse->gfx->m_TextWriter.SetCursor(40, 20);

        // 擾Ă鐶lȂǂ̏ʂɕ\
        ShowAccTestPassage(*pse);
        glFlush();
        pse->gfx->m_DrawFramework->SwapBuffers();

        // TvO񐔁{P
        data_counter++;

        // 萔̃Tv̒l肵Ăꍇbreak
        if( data_counter >= pse->pCnfMem->AccStabilityNum )
        {
            // 莞̍őlƍŏl̍ێ
            diffStabilityMaxMin[AXIS_X][pse->test_process -1] = gx_max - gx_min;
            diffStabilityMaxMin[AXIS_Y][pse->test_process -1] = gy_max - gy_min;
            diffStabilityMaxMin[AXIS_Z][pse->test_process -1] = gz_max - gz_min;

            pse->ng_code = RESULT_OK;
            *stability_ok_flag = 1;
            break;
        }

    };

    return pse->ng_code;
}

}
}
}


