/*--------------------------------------------------------------------------*
 Project:
 File: CheckLimit0_1G.cpp

*--------------------------------------------------------------------------*/
#include <nn.h>
#include <stdlib.h>
#include <vector>
#include "TestAccErrorCode.h"
#include "../../sys/sys_GetPlatform.h"
#include "TestAccTool.h"
#include "CheckLimit0_1G.h"

namespace uji {
namespace eva {
namespace acc {

s32 CheckLimit0_1G(ShowPassage* p_pse)
{
    bool ng_flag_x = 0;          // e̔tO(ʂNG̏ꍇ̓tOPɂȂ)
    bool ng_flag_y = 0;
    bool ng_flag_z = 0;
    u32 ng_code = RESULT_OK;            // NGR[hi[ϐ  NGĂȂꍇ0ANGꍇ0ȊO

    // QC̏ꍇ
    if( (p_pse->pCnfMem->TestMode == 1) || (p_pse->pCnfMem->TestMode == 9) )
    {
        // z`FbN
        if( ( p_pse->test_process == 1 ) || ( p_pse->test_process == 5 ) )
        {
            ng_flag_x = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_x );
            ng_flag_y = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_y );
            ng_flag_z = AccelerometerLimitTest( - p_pse->pCnfMem->QC_Z_1G_Max, - p_pse->pCnfMem->QC_Z_1G_Min,   p_pse->acc_raw_z );
        }
        // y`FbN
        else if( ( p_pse->test_process == 2 ) || ( p_pse->test_process == 4 ) )
        {
        // SPFLp
            // łFTR̉dSPRƓɂȂ܂B
            if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (p_pse->pCnfMem->ScreenCheckFlag == 0)) )
            {
                ng_flag_x = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_x );
                ng_flag_y = AccelerometerLimitTest( - p_pse->pCnfMem->QC_Y_1G_Min, - p_pse->pCnfMem->QC_Y_1G_Max,   p_pse->acc_raw_y );
                ng_flag_z = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_z );
            }
        // CTRp
            else
            {
                ng_flag_x = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_x );
                ng_flag_y = AccelerometerLimitTest( p_pse->pCnfMem->QC_Y_1G_Max,     p_pse->pCnfMem->QC_Y_1G_Min,   p_pse->acc_raw_y );
                ng_flag_z = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_z );
            }
        }
        // x`FbN
        else if( p_pse->test_process == 3 )
        {
            ng_flag_x = AccelerometerLimitTest( - p_pse->pCnfMem->QC_X_1G_Max, - p_pse->pCnfMem->QC_X_1G_Min,   p_pse->acc_raw_x );
            ng_flag_y = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_y );
            ng_flag_z = AccelerometerLimitTest( p_pse->pCnfMem->QC_ALL_0G_Max, - p_pse->pCnfMem->QC_ALL_0G_Min, p_pse->acc_raw_z );
        }
    }
    else
    {
        // z`FbN
        if( ( p_pse->test_process == 1 ) || ( p_pse->test_process == 5 ) )
        {
            ng_flag_x = AccelerometerLimitTest( p_pse->upper_limit_0g, - p_pse->lower_limit_0g, p_pse->acc_raw_x );
            ng_flag_y = AccelerometerLimitTest( p_pse->upper_limit_0g, - p_pse->lower_limit_0g, p_pse->acc_raw_y );
            ng_flag_z = AccelerometerLimitTest( - p_pse->pCnfMem->Z_1G_Max, -   p_pse->pCnfMem->Z_1G_Min, p_pse->acc_raw_z );
        }
        // y`FbN
        else if( ( p_pse->test_process == 2 ) || ( p_pse->test_process == 4 ) )
        {
            // łFTR̉dSPRƓɂȂ܂B
            if(  (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (p_pse->pCnfMem->ScreenCheckFlag == 0)) )
            {
                ng_flag_x = AccelerometerLimitTest( p_pse->upper_limit_0g,        - p_pse->lower_limit_0g, p_pse->acc_raw_x );
                ng_flag_y = AccelerometerLimitTest( - p_pse->pCnfMem->Y_1G_Min, - p_pse->pCnfMem->Y_1G_Max, p_pse->acc_raw_y );
                ng_flag_z = AccelerometerLimitTest( p_pse->upper_limit_0g,        - p_pse->lower_limit_0g, p_pse->acc_raw_z );
            }
        // CTR/FTRp
            else
            {
                ng_flag_x = AccelerometerLimitTest( p_pse->upper_limit_0g, - p_pse->lower_limit_0g, p_pse->acc_raw_x );
                ng_flag_y = AccelerometerLimitTest( p_pse->pCnfMem->Y_1G_Max, p_pse->pCnfMem->Y_1G_Min, p_pse->acc_raw_y );
                ng_flag_z = AccelerometerLimitTest( p_pse->upper_limit_0g, - p_pse->lower_limit_0g, p_pse->acc_raw_z );
            }
        }
        // x`FbN
        else if( p_pse->test_process == 3 )
        {
            ng_flag_x = AccelerometerLimitTest( - p_pse->pCnfMem->X_1G_Max, - p_pse->pCnfMem->X_1G_Min, p_pse->acc_raw_x );
            ng_flag_y = AccelerometerLimitTest( p_pse->upper_limit_0g, - p_pse->lower_limit_0g, p_pse->acc_raw_y );
            ng_flag_z = AccelerometerLimitTest( p_pse->upper_limit_0g, - p_pse->lower_limit_0g, p_pse->acc_raw_z );
        }
    }

    // NGĂ鎲ɃG[R[h쐬
    ng_code = MakeAccErrorNumber( ng_flag_x, ng_flag_y, ng_flag_z, p_pse->test_process * 100 + AXIS_ERROR );

    return ng_code;
}


//-----------------------------------------------------------------------------------
// K񐔕̃TvOsAׂ臒lɎ܂ĂOKA܂ĂȂNG
//    臒l
//    臒l
//    vl
// ߂l  OK0 NG1
//-----------------------------------------------------------------------------------
bool AccelerometerLimitTest( s32 upper_limit, s32 lower_limit, s32 sampling_value )
{
    if( ( sampling_value < lower_limit ) || ( upper_limit < sampling_value ) )
    {
        return LIMIT_TEST_NG;
    }

    return LIMIT_TEST_OK;
}


void CheckLTesterPosition(ShowPassage* p_pse)
{
    u32 ng_flag_x = 0;          // e̔tO(ʂNG̏ꍇ̓tOPɂȂ)
    u32 ng_flag_y = 0;
    u32 ng_flag_z = 0;
    u32 ng_code = RESULT_OK;    // NGR[hi[ϐ  NGĂȂꍇ0ANGꍇ0ȊO
    TestResult test_result;     // ϐĂяo̍ۂɈTestResult^̕ϐKvɂȂۂɎgϐ(ɓꂽl͍̂Ƃ딻ɎgĂ܂B)
    s32 x,y,z,max_0g,min_0g;
    uji::seq::Config::Member* p_ConfigMem;
    s32 WiFiLedOnFlag = 0;

    x = p_pse->acc_raw_x;
    y = p_pse->acc_raw_y;
    z = p_pse->acc_raw_z;
    max_0g = p_pse->upper_limit_0g;
    min_0g = p_pse->lower_limit_0g;

    p_ConfigMem = p_pse->pCnfMem;

    // QC̏ꍇ
    if( (p_pse->pCnfMem->TestMode == 1) || (p_pse->pCnfMem->TestMode == 9) )
    {
        // z`FbN
        if( ( p_pse->test_process == 1 ) || ( p_pse->test_process == 5 ) )
        {
            if ( ( abs((int)p_ConfigMem->QC_ALL_0G_Max - x) > 700 ) || ( abs((int)(x - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 ) ||
                 ( abs((int)p_ConfigMem->QC_ALL_0G_Max - y) > 700 ) || ( abs((int)(y - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 ) ||
                 ( abs((int)- p_ConfigMem->QC_Z_1G_Max - z) > 700 ) || ( abs((int)(z - (- p_ConfigMem->QC_Z_1G_Min)))   > 700 )      )
                 WiFiLedOnFlag = 1;
        }
        // y`FbN
        else if( ( p_pse->test_process == 2 ) || ( p_pse->test_process == 4 ) )
        {
        // SPFL/FTRp
            // łFTR̉dSPRƓɂȂ܂B
            if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (p_pse->pCnfMem->ScreenCheckFlag == 0)) )
            {
                if ( ( abs((int)p_ConfigMem->QC_ALL_0G_Max - x) > 700 ) || ( abs((int)(x - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 ) ||
                     ( abs((int)- p_ConfigMem->QC_Y_1G_Min - y) > 700 ) || ( abs((int)(y - (- p_ConfigMem->QC_Y_1G_Max)))   > 700 ) ||
                     ( abs((int)p_ConfigMem->QC_ALL_0G_Max - z) > 700 ) || ( abs((int)(z - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 )      )
                     WiFiLedOnFlag = 1;
            }
        // CTRp
            else
            {
                if ( ( abs((int)p_ConfigMem->QC_ALL_0G_Max - x) > 700 ) || ( abs((int)(x - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 ) ||
                     ( abs((int)p_ConfigMem->QC_Y_1G_Max - y)   > 700 ) || ( abs((int)(y - (  p_ConfigMem->QC_Y_1G_Min)))   > 700 ) ||
                     ( abs((int)p_ConfigMem->QC_ALL_0G_Max - z) > 700 ) || ( abs((int)(z - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 )      )
                     WiFiLedOnFlag = 1;
            }
        }
        // x`FbN
        else if( p_pse->test_process == 3 )
        {
            if ( ( abs((int)- p_ConfigMem->QC_X_1G_Max - x) > 700 ) || ( abs((int)(x - (- p_ConfigMem->QC_X_1G_Min)))   > 700 ) ||
                 ( abs((int)p_ConfigMem->QC_ALL_0G_Max - y) > 700 ) || ( abs((int)(y - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 ) ||
                 ( abs((int)p_ConfigMem->QC_ALL_0G_Max - z) > 700 ) || ( abs((int)(z - (- p_ConfigMem->QC_ALL_0G_Min))) > 700 )      )
                 WiFiLedOnFlag = 1;
        }
    }
    else
    {
        // z`FbN
        if( ( p_pse->test_process == 1 ) || ( p_pse->test_process == 5 ) )
        {
            if ( ( abs((int)max_0g - x)                  > 700 ) || ( abs((int)(x - (- min_0g)))                > 700 ) ||
                 ( abs((int)max_0g - y)                  > 700 ) || ( abs((int)(y - (- min_0g)))                > 700 ) ||
                 ( abs((int)- p_ConfigMem->Z_1G_Max - z) > 700 ) || ( abs((int)(z - (- p_ConfigMem->Z_1G_Min))) > 700 )      )
                 WiFiLedOnFlag = 1;
        }
        // y`FbN
        else if( ( p_pse->test_process == 2 ) || ( p_pse->test_process == 4 ) )
        {
        //SPFL/FTRp
            // łFTR̉dSPRƓɂȂ܂B
            if( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) ||
                ((uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) && (p_pse->pCnfMem->ScreenCheckFlag == 0)) )
            {
                if ( ( abs((int)(max_0g - x))                  > 700 ) || ( abs((int)(x - (- min_0g)))                > 700 ) ||
                     ( abs((int)(- p_ConfigMem->Y_1G_Min - y)) > 700 ) || ( abs((int)(y - (- p_ConfigMem->Y_1G_Max))) > 700 ) ||
                     ( abs((int)(max_0g - z))                  > 700 ) || ( abs((int)(z - (- min_0g)))                > 700 )      )
                     WiFiLedOnFlag = 1;
            }
        // CTRp
            else
            {
                if ( ( abs((int)max_0g - x)                  > 700 ) || ( abs((int)(x - (- min_0g)))                > 700 ) ||
                     ( abs((int)p_ConfigMem->Y_1G_Max - y)   > 700 ) || ( abs((int)(y - (  p_ConfigMem->Y_1G_Min))) > 700 ) ||
                     ( abs((int)max_0g - z)                  > 700 ) || ( abs((int)(z - (- min_0g)))                > 700 )      )
                     WiFiLedOnFlag = 1;
            }
        }
        // x`FbN
        else if( p_pse->test_process == 3 )
        {
            if ( ( abs((int)(- p_ConfigMem->X_1G_Max - x)) > 700 ) || ( abs((int)(x - (- p_ConfigMem->X_1G_Min))) > 700 ) ||
                 ( abs((int)(max_0g - y))                  > 700 ) || ( abs((int)(y - (- min_0g)))                > 700 ) ||
                 ( abs((int)(max_0g - z))                  > 700 ) || ( abs((int)(z - (- min_0g)))                > 700 )      )
                 WiFiLedOnFlag = 1;
        }
    }

    if( WiFiLedOnFlag == 1 )
    {
//      uji::eva::mcu::WiFiLedYellowOnNoWait(test_result);
//      WiFiLedOnFlag = 0;
    }
    else
//      uji::eva::mcu::WiFiLedYellowOff(test_result);

    return;
}

//  NN_LOG("\n\n\n p_pse->test_process 3: %d",  p_pse->test_process);

}
}
}
