/************************************************************************

 ^b`plE]p

 *************************************************************************/
/* dCN[h */
#ifndef TEST_TOUCH_PANEL_H_INCLUDED
#define TEST_TOUCH_PANEL_H_INCLUDED

#include <nn.h>
#include <string.h>
#include <nn/hid/CTR/hid_TouchPanelCalibrator.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include "../seq/config.h"
#include "../seq/TestResult.h"
#include "../seq/TestSample.h"
#include "../sys/sys_TextWindow.h"
#include "../wireless/CommandUtil.h"

namespace uji{
namespace eva{

namespace TouchPanel
{
    extern bool TestTouchPanel( uji::seq::TestResult &result );
    extern bool CheckTPAccuracy( uji::seq::TestResult &result );
    extern bool WriteTouchPanelLog( uji::seq::TestResult &result );
    extern void TestTPSequencer();
    static bool WriteTouchPanelLogCommon( uji::seq::TestResult &result, bool isOKLog );
    
}


//------------------------------------------------------------------------------
// j[\p
//------------------------------------------------------------------------------
void TouchPanelMenu();
void TouchPanelMenuForService();

//------------------------------------------------------------------------------
// ʕ\p(DP1b)
//------------------------------------------------------------------------------
void ShowTestResult( uji::seq::TestResult &result );


struct CoordinateType
{
    int x;
    int y;
};

struct LineCoordinate
{
    CoordinateType start;
    CoordinateType end;
};
//------------------------------------------------------------------------------
// ^b`plSʂ̊NX 
//------------------------------------------------------------------------------
class BaseTouchPanel
{
    // RXgN^protectedɂ鎖
    // NX̃CX^X}
    protected:
    BaseTouchPanel() : m_LineWidth( 1.0f )
    {
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        gfx->m_DrawFramework->SetLineWidth( m_LineWidth );
        gfx->m_DrawFramework->SetPointSize( m_LineWidth );
        
    }  
    virtual ~BaseTouchPanel(){}

    void ClearCampus();
    
    void SetDrawColor( const nw::ut::Color8 &color8 )
    {
        nw::ut::FloatColor fColor = color8;
        this->SetDrawColor( fColor );
    }
    
    void SetDrawColor( const nw::ut::FloatColor &fColor )
    {
        uji::sys::GraphicsDrawing::GetInstance()->m_DrawFramework->SetColor( fColor.r,
                                                                             fColor.g,
                                                                             fColor.b );
    }
    
    void WaitReleasePen();
    
    void DrawCheckPointBlue( const CoordinateType &pos )
    {
        SetDrawColor( nw::ut::Color8::BLUE );
        this->DrawCheckPoint( pos );
    }
    void DrawCheckPoint( const CoordinateType &pos );
    void DrawTouchPoint( const CoordinateType &pos );
    void DrawCircle( const CoordinateType &pos, const int size );

    bool IsJudgeTP( const CoordinateType &touchPos );
    
    void DrawCenterSquare();
    void PaintOutSquareLU();
    void PaintOutSquareRD();
    void LoadCalData();
    
    //--------------------------------------------------------------------------
    // e萔
    static const int INFO_WINDOW_WIDTH  = 240;
    static const int INFO_WINDOW_HEIGHT = 120;
    static const int INFO_WINDOW_POS_X  = 10;
    static const int INFO_WINDOW_POS_Y  = 10;
    static const int FONT_SIZE          = 14;
    static const f32 LINE_WIDTH_MAX     = 5.0f;
    static const f32 LINE_WIDTH_MIN     = 1.0f;
    
    static const int POS_DISP1_CENTER_X = 160;
    static const int POS_DISP1_CENTER_Y = 120;
    static const int POS_DISP1_WIDTH    = 320;
    static const int POS_DISP1_HEIGHT   = 240;
    
    static const int TP_VER_WINDOW_HEIGHT = 60;
    static const int TP_VER_WINDOW_WIDTH  = 320;
    static const int TP_VER_WINDOW_POS_X  = 10;
    static const int TP_VER_WINDOW_POS_Y  = 150;
    
    enum TpMicroCode
    {
        TP_CAL_RETRY_ERROR     = 001,
        TP_CAL_CHECK_ERROR     = 002,
        TP_CHECK_RETRY_ERROR   = 100,
        TP_CAL_TIMEOUT_ERROR   = 200,
        TP_CHECK_TIMEOUT_ERROR = 201,
        TP_CAL_WRITE_ERROR     = 900
    };

    
    //--------------------------------------------------------------------------
    // ϐ
    f32 m_LineWidth;
    
    nn::hid::CTR::TouchPanelStatus m_TPStatus;
    nn::hid::CTR::TouchPanelReader m_TPReader;
    

};

//------------------------------------------------------------------------------
// jAeB`FbNp̃NX
//------------------------------------------------------------------------------
class TPLinear : private BaseTouchPanel
{
    public:
    static void Execute()
    {
        TPLinear tPL;
        tPL.TouchPanelLinear();
    }
    
    static void ExecuteModuleTest()
    {
        uji::seq::TestResult result;
        TPLinear* tPL = new TPLinear;
        tPL->TouchPanelModuleTest( result );
        delete tPL;
        ShowTestResult( result );
    }

    TPLinear(){}
    virtual ~TPLinear(){}
    bool TouchPanelModuleTest( uji::seq::TestResult &result );
    
    private:
    
    void TouchPanelLinear();

    void DrawChartGrid();
    void DrawTestMarker( bool isTouched, CoordinateType pos );
    void DrawTestLine();
    
    //--------------------------------------------------------------------------
    // e萔
    static const int POS_DISP1_CENTER_X = 160;
    static const int POS_DISP1_CENTER_Y = 120;
    static const int POS_DISP1_WIDTH    = 320;
    static const int POS_DISP1_HEIGHT   = 240;
    
    enum ResultMicro
    {
        ERROR_CAL = 1,
        ERROR_LINEARITY        
    };
    
    //--------------------------------------------------------------------------
    // ϐ

    
};

//------------------------------------------------------------------------------
// ^b`pl`FbNp
//------------------------------------------------------------------------------
class TouchPanelCheck : private BaseTouchPanel
{
    public:
    static void Execute()
    {
        uji::seq::TestResult testResult;
        TouchPanelCheck tTP;
        tTP.TestTPCommon( testResult );
        
        ShowTestResult( testResult );
    }
    
    TouchPanelCheck(){}
    virtual ~TouchPanelCheck(){}
    
    bool TestTPCommon( uji::seq::TestResult &testResult );
    
    private:
    

};


//------------------------------------------------------------------------------
// ^b`plLu[Vp
//------------------------------------------------------------------------------
class TouchPanelCal : private BaseTouchPanel
{
    public:
    static void Execute()
    {
        uji::seq::TestResult testResult;
        
        TouchPanelCal tPC;
        tPC.TPCalCommon( testResult, false );
        
        ShowTestResult( testResult );
    }
    
    static void ExecuteJigCal()
    {
        uji::seq::TestResult testResult;
        
        TouchPanelCal tPC;
        tPC.forJigCalibration( testResult );
        
        ShowTestResult( testResult );
    }
    
    TouchPanelCal()
    {

    }
    virtual ~TouchPanelCal(){}
    
    bool TPCalCommon( uji::seq::TestResult &result, bool isModuleTest );
    bool forJigCalibration( uji::seq::TestResult &result );
    
    private:
    bool GetRawDataForCalibration( nn::hid::TouchPanelStatus* pReturnRaw, const CoordinateType &point );
    bool IsJudgeCalibration( const CoordinateType &pos );
    bool IsJudgeRawDataValiety( const nn::hid::TouchPanelStatus* pTPStatus, const u16 &checkNum );
    bool FlushCalData( const nn::hid::TouchPanelStatus &rawLU, const nn::hid::TouchPanelStatus &rawRD );
    
    //--------------------------------------------------------------------------
    // ݂̌
    
    enum CalibState
    {
        STATE_NO_GET_RAW = 0,
        STATE_GET_RAW_LU,
        STATE_GET_RAW_RD,
        STATE_FLUSH_CAL,
        STATE_END
    };
    
    int m_NowCalibState;
    
    //--------------------------------------------------------------------------
    // e萔

    nn::hid::CTR::TouchPanelCalibrator m_TPCal;
};


} // namespace eva
} // namespace uji

#endif /* TEST_TOUCH_PANEL_H_INCLUDED */
