
/*--------------------------------------------------------------------------*
AvP[V{
*--------------------------------------------------------------------------*/


#include <nn.h>
#include <nn/fnd.h>
#include <nn/gx.h>
#include <nn/version.h>
#include <nn/uds.h>
#include <stdlib.h>
#include <nw/types.h>
#include <nn/ndm.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include "sys.h"
#include "sys/sys_GetSerialNumber.h"
#include "sys/sys_PowerButton.h"
#include "seq/TestSequencer.h"
#include "seq/Config.h"
#include "seq/TestListManager.h"
#include "seq/Reception_camera.h"
#include "seq/reception_board_interface.h"
#include "Application.h"
#include "eva/demo/demo_window.h"
#include "eva/camera/EvaCamera.h"
#include "eva/camera/SeqCamera.h"
#include "eva/camera/TestCamAndIF.h"
#include "eva/key/TestKey.h"
#include "eva/analogkey/EvaAnalogStick.h"
#include "eva/TouchPanel/TestTouchPanel.h"
#include "eva/wireless/TestWirelessMenu.h"
#include "eva/wlaudio/TestWlAudioMenu.h"
#include "eva/lcd/TestLcdMenu.h"
#include "eva/mic/mic_Eva.h"
#include "eva/cardspi/EvaCardSpi.h"
#include "eva/accelerator/TestAcc.h"
#include "eva/gyro/gyro_UdsClient.h"
#include "eva/gyro/gyro_UdsMaster.h"
#include "eva/gyro/gyro_EvaMenu.h"
#include "eva/gyro/gyro_ShockTester.h"
#include "eva/gyro/gyro_AgingTester.h"
#include "eva/import/TcpComm.h"
#include "eva/import/TestExecuteImport.h"
#include "eva/mcu/TestMcu.h"
#include "eva/mcu/mcu_Menu.h"
#include "eva/mcuport/McuPort.h"
#include "eva/codec/EvaCodec.h"
#include "eva/nand/EvaNand.h"
#include "eva/sound/EvaSound.h"
#include "eva/ir/TestIr.h"
#include "sec/FileViewer.h"
#include "eva/gpu/gpu_Eva.h"
#include "sec/CalMenu.h"
#include "sec/CfgMenu.h"
#include "sec/Cal2Cfg.h"
#include "eva/sd/TestSd.h"
#include "eva/volume/EvaVolume.h"
#include "eva/aging/AgingImporter.h"
#include "eva/aging/AgingSequencer.h"
#include "eva/Collect/CollectLogData.h"
#include "eva/procchk/ProcessCheck.h"
#include "sys/sys_AppType.h"
#include "eva/ai/ApplicationImporter.h"
#include "eva/procchk/ProcessCheck.h"

#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>

#include "sys_GetPlatform.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
using namespace uji::eva;

static void CameraMenuForService(void);
static void CalibrationMenuForService(void);
static void ShowIdentification(void);
static void TestInCamera(void);
static void TestLcdAndKey(void);
static void TestLcdAndKey_QC(void);
static void TestShock_QC(void);
static void AccTest(void);
static void TestGyroM(void);
static void TestMicTester(void);
static void TestAging(void);
static void TestAgingImport(void);
static void TestTouchPanel(void);
static void TestSlidePad(void);
static void TestPreProcessCheck(void);
static void TestProcessCheck(void);
static void TestUpdate(void);
static void TestImport(void);
static void TestReentry(void);
static void TestBackup(void);
static void TestRestore(void);
static void TestOutCameraWB(void);
static void TestSpAndTp(void);
static void CameraCapture(void);
static void TestComposite(void);
static void RemoveCard(void);
static void TestAppImport(void);

/************************************************************************
֐|C^oRŌĂ΂郁j[
************************************************************************/
static void Debug1Main(void)
{
    uji::eva::DemoWindow *p = new uji::eva::DemoWindow;

    p->Run();

    delete p;
}

static void Debug2Main(void)
{
    uji::sys::Pad pad;
    string platformTypeString = "???\n   Please push the A button.";
    do
    {
        pad.UpdatePad();
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");

        if(pad.IsButtonDown(Pad::BUTTON_A))
        {
            uji::sys::PlatformType type = uji::sys::GetPlatformType();
                 if( type==uji::sys::PLATFORM_CTR    ) platformTypeString="BSK (=CTR)  ";
            else if( type==uji::sys::PLATFORM_SPR    ) platformTypeString="ANK (=SPR)  ";
            else if( type==uji::sys::PLATFORM_KTR    ) platformTypeString="MDK (=KTR)  ";
            else if( type==uji::sys::PLATFORM_FTR    ) platformTypeString="SYK (=FTR)  ";
            else if( type==uji::sys::PLATFORM_UNKNOWN ) platformTypeString="??? (UNKNOWN)";
        }

        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf("   MCU_INFO_REGISTERS_10_%s\n", platformTypeString.c_str());
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.UpdatePad(uji::sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

static void Debug3Main(void)
{
}

static void Debug4Main(void)
{
}

static void Debug5Main(void)
{
    uji::sys::Pad pad;
    u8 out = 0;
    nn::Result nnResult1;
    nn::Result nnResult2;
    do
    {
        pad.UpdatePad();

        if(pad.IsButtonDown(Pad::BUTTON_LEFT))
        {
            nnResult1 = nn::fs::CardSlotPowerOn(&out);
            if(nnResult1 <= nn::fs::ResultNotFound())
            {
                NN_LOG( "NG: CardSlotPowerOn\n" );
            }
        }
        if(pad.IsButtonDown(Pad::BUTTON_RIGHT))
        {
            nnResult1 = nn::fs::CardSlotPowerOff(&out);
            if(nnResult1 <= nn::fs::ResultNotFound())
            {
                NN_LOG( "NG: CardSlotPowerOff\n" );
            }
        }
        {
            nnResult2 = nn::fs::CardSlotGetCardIFPowerStatus(&out);
            if(nnResult2 <= nn::fs::ResultNotFound())
            {
                NN_LOG( "NG: CardSlotGetCardIFPowerStatus\n" );
            }
            else
            {
                NN_LOG( "OK: CardSlotGetCardIFPowerStatus: %x\n", out );
            }
        }

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - CardSlotPower - \n");
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf("   Status: %x\n", out);
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.UpdatePad(uji::sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

static void Debug6Main(void)
{
using namespace uji::eva::procchk;

#define TYPE_QRCODE      2

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("QR Code");

    pc->CreateQRCode();

    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_QRCODE);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_A));

    pc->GraphicsFinalize(TYPE_QRCODE);

    delete pc;
}


/************************************************************************
AvP[VsJn|Cgijlbpj
 ************************************************************************/
void Application::ExecuteForKmc(void)
{

    nn::fs::MountSpecialArchive("cardspi:", nn::fs::CTR::ARCHIVE_TYPE_CARD_SPI);

    nn::ndm::Initialize();
    nn::ndm::SuspendScheduler( false );

    //RtBOƌXg̓ǂݍ
    uji::seq::Config  *c = new uji::seq::Config;
    TestListManager *tlm = new TestListManager;

    uji::sys::Pad pad;

    //Y{^ĂSDJ[h̐ݒ肪ǂ߂ȂĂASȂ
    //(SDJ[hconfig,sequencef[^̍쐬Ɏgpj
    pad.UpdatePad();
    if( !pad.IsButtonPress( Pad::BUTTON_Y ))
    {
        if( !c->Load() )   SYS_PANIC( "Fail to load Config" );
        if( !tlm->Load() ) SYS_PANIC( "Fail to load TestList" );
    }
    delete tlm;
    delete c;

    //X{^Ă狭IɃj[
    pad.UpdatePad();
    if( !pad.IsButtonPress( Pad::BUTTON_X ) )
    {
        TestImport();
    }

    ShowIdentification();

    for(;;)
    {
        StartMenu();

    }
}

/************************************************************************
AvP[VsJn|Cg
 ************************************************************************/
void Application::Execute(void)
{
    // d{^ĎX̋N
    sys::PowerButton().StartMonitoring();

    //jlbłw{^Ńj[ɔ
    if ( "KMC" == UJI_REGION ) ExecuteForKmc();

#if (!(defined(EVA_LCD_RED) || defined(EVA_CAL2CFG)))
    nn::fs::MountSpecialArchive("cardspi:", nn::fs::CTR::ARCHIVE_TYPE_CARD_SPI);

#if (!defined(EVA_BOARD) || defined(EVA_WIFI_ON_BOARD) )
    nn::ndm::Initialize();
    nn::ndm::SuspendScheduler( false );
#endif

#endif

#if (!(defined(EVA_LCD_RED) || defined(EVA_CAL2CFG)))
    //RtBOƌXg̓ǂݍ
    uji::seq::Config  *c = new uji::seq::Config;
    TestListManager *tlm = new TestListManager;

    if( !c->Load() )    c->Initialize();
    if( !tlm->Load() )  tlm->Initialize();

    delete tlm;
    delete c;
#endif

    //Cpj[͂ŕ򂵂āAX^[gj[ɂȂ悤ɂ
#ifdef EVA_REPAIR
       ServiceMenu();
#endif

#ifdef EVA_CAL2CFG
        sec::CalToCfg();
        ServiceMenu();
#endif

    //X^[g{^Ă狭IɃj[
    uji::sys::Pad pad;
    pad.UpdatePad();

    if( !pad.IsButtonPress( Pad::BUTTON_START ) )
    {

#ifdef EVA_BOARD
        Reception_BoardInterface();
#endif

#ifdef EVA_COMPOSITE

        TestComposite();

#else // EVA_COMPOSITEȊO

#ifdef EVA_INTERFACE
        Reception_BoardInterface();
#endif

#ifdef EVA_GYRO_C

        GyroUdsClient* gc = new GyroUdsClient;
        gc->DoReception();
        delete gc;

#endif

#ifdef EVA_GYRO_M
        TestGyroM();
#endif

#ifdef EVA_TP
        uji::eva::TouchPanel::TestTPSequencer();
#endif

#ifdef EVA_WIRELESS
        uji::eva::TestWireless::ExecuteTestWireless();
#endif

#ifdef EVA_WL_AUDIO
        uji::eva::TestWlAudio::ExecuteTestWlAudio();
#endif

#ifdef EVA_PARALLAX
        Reception_Camera();
#endif

#ifdef EVA_OCAM
        Reception_Camera();
#endif

#ifdef EVA_ICAM
        TestInCamera();
#endif

#ifdef EVA_OCAM_WB
        TestOutCameraWB();
#endif

#ifdef EVA_CAM_AND_IF
        uji::eva::TestCamAndIF::ExecuteTestCamAndIF();
#endif

#ifdef EVA_CAM_CAPTURE
        CameraCapture();
#endif

#ifdef EVA_LCD_AND_KEY
        TestLcdAndKey();
#endif

#ifdef EVA_LCD_MODULE
        uji::eva::TestLcd::Execute();
#endif

#ifdef EVA_MIC_TESTER
        TestMicTester();
#endif

#ifdef EVA_MIC_TESTER_QC
        TestMicTester();
#endif

#ifdef EVA_MIC_FPC
        TestMicTester();
#endif

#ifdef EVA_IMPORT
        if( "UPDATE_ONLY" != UJI_REGION )
        {
            TestImport();
        }
        else
        {
            TestUpdate();
        }
#endif

#ifdef EVA_AGING
#if 1//G[WOTestListłȂAڋNꍇ
        uji::eva::AgingSequencer* as = new uji::eva::AgingSequencer;
        as->Test();
#else
        //ToDo. CTR/SPRɂ́AfBXvCobt@TCY400,800؂ւKv
        //ToDo. desct@ČǉKv
        TestAging();
#endif
#endif

#ifdef EVA_SHOCK
        eva::ShockTester::sRun();
#endif

#ifdef EVA_SLIDEPAD
        TestSlidePad();
#endif

#ifdef EVA_SP_AND_TP
        TestSpAndTp();
#endif

#ifdef EVA_AGING_I
#if 0//G[WOC|[gTestListłȂAڋNꍇ
        uji::eva::AgingImporter *ai = new uji::eva::AgingImporter;
        ai->ImportAndRun();
#else
        TestAgingImport();
#endif
#endif

#ifdef EVA_ACC
        AccTest();
#endif

#ifdef EVA_REENTRY
        TestReentry();
#endif

#ifdef EVA_PRE_PROCCHK
        TestPreProcessCheck();
#endif

#ifdef EVA_PROCCHK
        TestProcessCheck();
#endif

#ifdef EVA_COLLECT
       CollectLogData::ExecuteCollectLogData();
#endif

#ifdef EVA_LCD_Q
        eva::TestLcdQuality::ExecuteTestLcdQuality();
#endif

#ifdef EVA_LCD_RED
        eva::TestLcd_RED::Execute();
#endif

#ifdef EVA_APP_JUMP
        uji::eva::ApplicationImporter *ai = new uji::eva::ApplicationImporter;
        ai->ImportAndRun();
#endif

#ifdef EVA_APP_I
        TestAppImport();
#endif

#endif // EVA_COMPOSITEȊO܂

#if (!(defined(EVA_LCD_RED) || defined(EVA_CAL2CFG)))
       //stOĂΎs
        uji::seq::Config config;
        if( config.Get().AutoStart )
        {
            TestSequencer *s = new TestSequencer;
            s->Initialize();
            s->Execute();
            delete s;
        }
#endif
    }

STARTMENU:
#if (!(defined(EVA_LCD_RED) || defined(EVA_CAL2CFG)))
    ShowIdentification();

    for(;;)
    {
        StartMenu();

    }
#endif
}


void Application::StartMenu(void)
{

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    while(1)
    {
        ClassMenu *m = new ClassMenu( "Start Menu" );
        m->Add<Application>(    "Evaluation Menu",  this, &Application::EvaluationMenu, nw::ut::Color8::WHITE, "" );
        m->Add<TestSequencer>(  "Checker Menu",     s, &TestSequencer::OpenMenu, "" );
        m->Add(                 "Cal Menu",         uji::sec::cal::CalMenu );
        m->Add(                 "Cfg Menu",         uji::sec::cfg::CfgMenu );
        m->Add<Application>(    "Test Program",     this, &Application::TestProgram );
        m->Add<Application>(    "Misc Menu",        this, &Application::MiscMenu, "" );
        m->Add(                 "---------------",  NULL );
        m->Add(                 "Demo Window",      Debug1Main );
        m->Add(                 "Debug2",           Debug2Main );
        m->Add(                 "Debug3",           Debug3Main );
        m->Add(                 "Debug4",           Debug4Main );
        m->Add(                 "Debug5",           Debug5Main );
        m->Add(                 "---------------",  NULL );
        m->Add(                 "Show QR Code",     Debug6Main );
        m->Open();
        delete m;
    }

//    delete s;
}

void Application::EvaluationMenu(void)
{
    EvaCARDSPI * ec = new EvaCARDSPI;

    ClassMenu *m = new ClassMenu( "Evaluation Menu");
    m->SetColumn(2);
    m->Add             ( " GPU", eva::gpu::EvaTestGpu );
    m->Add             ( " KEY", eva::OpenKeyMenu );
    m->Add             ( " ANALOGKEY", eva::OpenAnalogStickEvaMenu );
    m->Add             ( " CAMERA", uji::eva::EvaluateCamera );
    m->Add             ( " TP",  uji::eva::TouchPanelMenu );
    m->Add             ( " WRFU", uji::eva::WirelessMenu );
    m->Add             ( " LCD", uji::eva::lcd::TestLcdMenu );
    m->Add             ( " MIC", uji::eva::OpenMicMenu );
    m->Add<EvaCARDSPI> ( " CARDSPI", ec, &EvaCARDSPI::OpenMenu, NULL);
    m->Add             ( " GYRO", uji::eva::OpenGyroMenu );
    m->Add             ( " CODEC" , uji::eva::OpenCodecMenu );
    m->Add             ( " IMPORT", uji::eva::OpenImportMenu);
    m->Add             ( " NAND", uji::eva::OpenNandMenu);
    m->Add             ( " SOUND", uji::eva::OpenSoundMenu);
    m->Add             ( " MCU", uji::eva::mcu::OpenEvaMenu);
    m->Add             ( " IR", uji::eva::OpenIrMenu );
    m->Add             ( " SD", uji::eva::OpenSdMenu );
    m->Add             ( " VOLUME", uji::eva::EvaluateVolume );
    m->Add             ( " Collect", eva::CollectLogData::ExecuteCollectLogData );
    m->Add             ( " PROCCHK", eva::OpenProcCheckMenu );
    m->Add             ( " CAL2CFG", sec::CalToCfg );

    //m->Add<Application>( " Dummy", this, NULL );
    m->Open();
    delete m;

    delete ec;
}

void Application::TestProgram(void)
{
    ClassMenu *m = new ClassMenu( "TEST PROGRAM" );
    m->Add( "LCD&KEY",        TestLcdAndKey );
    m->Add( "IN CAM.",        TestInCamera );
    m->Add( "GYRO_M",         TestGyroM);
    m->Add( "SHOCK TEST",     eva::ShockTester::sRun);
    m->Add( "ACC",            AccTest);
    m->Add( "PRE PROC CHECK", TestPreProcessCheck);
    m->Add( "PROC CHECK",     TestProcessCheck);
    m->Add( "IMPORT",         TestImport);
#ifdef EVA_START_MENU
    m->Add( "Reentry",        TestReentry);
    m->Add( "BACKUP",         TestBackup);
    m->Add( "RESTORE",        TestRestore);
#endif
    m->Add( "OUT CAM WB",     TestOutCameraWB );
    m->Add( "CAMERA CAPTURE", CameraCapture );
    m->Open();
    delete m;
}

void Application::MiscMenu()
{
    ClassMenu *m = new ClassMenu( "MISC MENU" );
    m->Add( " File Viewer   ", uji::sec::FileViewer::FileViewerMenu );
    m->Add( " Create Sys/PreIn TitleList ",  import::MakeAllTitleListOutputToSdmc );
    m->Add( " Create System TitleList ",     import::MakeTitleListOutputToSdmc );
    m->Add( " Create PreInstall TitleList ", import::MakePreInstallTitleListOutputToSdmc );
    m->Open();
    delete m;
}

void Application::ServiceMenu()
{
    ShowIdentification();

    TestSequencer *ts =  new TestSequencer;

   while(1)
    {
        ClassMenu *m = new ClassMenu( "Service Menu" );
        m->SetColumn(2);
        m->Add( "LCD&KEY(LINE) ", TestLcdAndKey );                      m->Add( "KEY         ->", eva::KeyMenuForService );
        m->Add( "--------------", NULL );                               m->Add( "SLIDEPAD    ->", eva::SPMenuForService );
        m->Add( "LCD&KEY(QC)   ", TestLcdAndKey_QC );                   m->Add( "TOUCHPANEL  ->", eva::TouchPanelMenuForService );
        m->Add( "SHOCK TEST(QC)", TestShock_QC);                        m->Add( "SOUND       ->", eva::OpenSoundMenuForService);
        m->Add( "LCD           ", eva::TestLcd::Execute );              m->Add( "CAMERA      ->", CameraMenuForService );
        m->Add( "LED           ", eva::LEDTest );                       m->Add( "MIC         ->", eva::OpenMicMenuForService );
        m->Add( "OPEN/CLOSE    ", eva::mcu::DetectOpenFold );           m->Add( "WRFU        ->", eva::WirelessMenuForSC );
        m->Add( "QR CODE       ", eva::procchk::Invoke_DisplayQRCode);  m->Add( "IR          ->", eva::OpenIrMenu );
        m->Add( "BATTERY       ", eva::mcu::ShowRemainderOfBattery );   m->Add<TestSequencer> ( "INSPECT LOG ->", ts, &TestSequencer::OpenInspectLogMenu , NULL);
        m->Add( "--------------", NULL );                               m->Add<TestSequencer> ( "PRODUCT LOG ->", ts, &TestSequencer::OpenLogMenu , NULL);
        m->Add( "CAL2CFG       ", sec::CalToCfg );                      m->Add( "CALIBRATION ->", CalibrationMenuForService );
        m->Open();
        delete m;
    }

#if 0
    delete ts;
#endif
}

static void CameraMenuForService(void)
{
    ClassMenu *m = new ClassMenu( "Camera Menu" );
    m->Add( " Evaluate  ", eva::EvaluateCameraForService );
    m->Add( " Parallax  ", eva::StereoCameraCheck );
    m->Open();
    delete m;
}

static void CalibrationMenuForService(void)
{
    ClassMenu *m = new ClassMenu( "Calibration Menu" );
    if(uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        m->Add( " Sp&Tp CAL     ", TestSpAndTp );
    }
    else if((uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType()) || (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) )
    {
        m->Add( " Slidepad CAL  ", TestSlidePad );
        m->Add( " TouchPanel CAL", TestTouchPanel );
    }
    else
    {
        m->Add( "---------------", NULL );
    }
    m->Open();
    delete m;
}


/************************************************************************
ʏ̕\
 ************************************************************************/
static void ShowIdentification(void)
{
    const char *REGION_NAME[]=
    {
        "JPN",
        "USA",
        "EUR",
        "AUS",
        "CHN",
        "KOR",
        "TWN"
    };

    static uji::sys::TextWindow *win=0;

    //l`bAhX擾itcrgpj
    bit8 mac[6]={0,0,0,0,0,0};
#ifndef EVA_BOARD
    uji::sys::TryGetMacAddress( mac );
#endif

    //VAio[擾
    char serial[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    uji::sys::GetSerialNumber(serial);

    // ̃j[擾
    nn::cfg::CTR::detail::MenuInfoCfgData menuInfo;
    nn::cfg::CTR::init::GetConfig(
        &menuInfo,
        sizeof(nn::cfg::CTR::detail::MenuInfoCfgData),
        GET_CFG_KEY(nn::cfg::CTR::detail::NN_CFG_MENU, nn::cfg::CTR::detail::NN_CFG_MENU_MENU_INFO));

    // vbgtH[^Cv擾
    string platformTypeString = "---";
    uji::sys::PlatformType type = uji::sys::GetPlatformType();
         if( type==uji::sys::PLATFORM_CTR     ) platformTypeString="CTR";
    else if( type==uji::sys::PLATFORM_SPR     ) platformTypeString="SPR";
    else if( type==uji::sys::PLATFORM_KTR     ) platformTypeString="KTR";
    else if( type==uji::sys::PLATFORM_FTR     ) platformTypeString="FTR";
    else if( type==uji::sys::PLATFORM_UNKNOWN ) platformTypeString="???";

    if( win==0 )
    {
        win = new TextWindow( 46, 6, 12 ); // 46, 6, TCY12
        win->SetTitle( "IDENTIFICATION" );
        Menu::m_WindowManager.CreateWindow( win, NN_GX_DISPLAY1, 30, 154 ); // \JnW(30,154)
        win->Printf( "PLATFORM [%s]  REGION [%s]\n", platformTypeString.c_str(), REGION_NAME[(int)GetRegionCode()] );
        win->Printf( "PRG VERSION  [%s (" __DATE__ " " __TIME__  ")]\n", VERSION_STRING );
        win->Printf( "SDK VERSION  [%d.%d.%d %d(%s)]\n", NN_VERSION_MAJOR, NN_VERSION_MINOR, NN_VERSION_MICRO, NN_VERSION_RELSTEP, NN_VERSION_PATCH );
        win->Printf( "MAC ADDRESS  [%02X-%02X-%02X-%02X-%02X-%02X]\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5] );
        win->Printf( "SERIAL NUM.  [%s]\n", serial );
        win->Printf( "HOMEMENU ID  [%016llX]", menuInfo.programId );
    }
}



/************************************************************************
CJ
 ************************************************************************/
static void TestInCamera(void)
{
    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    TestListManager *tlm = new TestListManager;

    if( !c->Load() )    c->Initialize();
    if( !tlm->Load() )  tlm->Initialize();

    c->SetAlternative().TestList = TESTLIST_ID_ICAM;
    s->Execute();

    delete tlm;
    delete c;
    delete s;

}

/************************************************************************
OUTJWB␳
 ************************************************************************/
static void TestOutCameraWB(void)
{
    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    TestListManager *tlm = new TestListManager;

    if( !c->Load() )    c->Initialize();
    if( !tlm->Load() )  tlm->Initialize();

    c->SetAlternative().TestList = TESTLIST_ID_OCAM_WB;
    s->Execute();

    delete tlm;
    delete c;
    delete s;

}

/************************************************************************
JBHp
 ************************************************************************/
static void CameraCapture(void)
{
    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    TestListManager *tlm = new TestListManager;

    if( !c->Load() )    c->Initialize();
    if( !tlm->Load() )  tlm->Initialize();

    c->SetAlternative().TestList = TESTLIST_ID_CAM_CAPTURE;
    s->Execute();

    delete tlm;
    delete c;
    delete s;

}

/************************************************************************
kbcL[
 ************************************************************************/
static void TestLcdAndKey(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_LCDANDKEY;
    s->Execute();
    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;

}

/************************************************************************
kbcL[ipbj
 ************************************************************************/
static void TestLcdAndKey_QC(void)
{
    u32 previousList;
    u32 previousMode;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;
    previousMode = c->Get().TestMode;

    c->SetAlternative().TestList = TESTLIST_ID_LCDANDKEY;
    c->Set().TestMode = uji::seq::pl::QC;
    s->Execute();
    c->SetAlternative().TestList = previousList;
    c->Set().TestMode = previousMode;

    delete c;
    delete s;

}

/************************************************************************
VbNipbji]j[pj
 ************************************************************************/
static void TestShock_QC(void)
{
    u32 previousMode;

    uji::seq::Config  *c = new uji::seq::Config;
    previousMode = c->Get().TestMode;

    c->Set().TestMode = uji::seq::pl::QC;
    eva::ShockTester::sRun();
    c->Set().TestMode = previousMode;

    delete c;

}


/************************************************************************
xZT[
 ************************************************************************/
static void AccTest(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_ACC;
    s->Execute();
    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;

}

/************************************************************************
WC
 ************************************************************************/
static void TestGyroM(void)
{
    if (sys::Pad().IsButtonPress(Pad::BUTTON_A) &&
        sys::Pad().IsButtonPress(Pad::BUTTON_B))
    {
        mcu::SetRtcTime();
    }

    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_GYRO;
    eva::GyroUdsMaster::GetInstance()->Initialize();
    s->Execute();
    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
i}CN
 ************************************************************************/
static void TestMicTester(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_MIC;
    s->Execute();
    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/***********************************************************************
G[WO
 ************************************************************************/
static void TestAging(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_AGING;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/***********************************************************************
G[WOC|[g+
 ************************************************************************/
static void TestAgingImport(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_AGING_I;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
^b`pli]j[pj
 ************************************************************************/
static void TestTouchPanel(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_TP;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
XChpbh
 ************************************************************************/
static void TestSlidePad(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_SLIDEPAD;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
XChpbh&^b`plLu[V
 ************************************************************************/
static void TestSpAndTp(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_SP_AND_TP;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
  vvZX`FbN
 ************************************************************************/
static void TestPreProcessCheck(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_PRE_PROCCHK;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
  vZX`FbN
 ************************************************************************/
static void TestProcessCheck(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_PROCCHK;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
  C_p
 ************************************************************************/
static void TestUpdate(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_UPDATE;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}
/************************************************************************
  f[^
 ************************************************************************/
static void TestImport(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    /*
       vCXg[Ή

       @PFTestSequencer::Execute1Sequence() œ̌܂ŋ񂵂B
               i_jǔvȊO True/False ŐؑւĂs͋NȂB
               i_jƓDLB
                       ̌΂ȂB˒AAReinitialize() ͂ǂ݂̂K{B
       @QFTestResultManager NXŌ݂̃eXg擾 m_CurrentTest ɓnB
               i_jX}[gȋCH
               i_jV[PXύXʂe True/False ŐؑւƕsNB
                       O̔lɈUނ̂ŌǓDLB

       ͕@PŎB
       @Qɕςꍇ́Å֐ŌO̔lǂ܂Ōi񂾂̂擾B
       ̌ATestSequencer::Execute1Sequence()  m_CurrentTest Ȃ悤ɕύXKvB
       if( false==SpecialHandlingFlagOnReboot() ) m_CurrentTest = 0;
    */

    /*
    // @Q
    // Line[h̍ŏIO "Reboot","START" Ȃ
    // ċN̏ԂƔfāAċN̏ɐi
    {
        int lastTestId = 0;
        uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
        pdl->Initialize();
        int logId = pdl->Get_LatestLogEntryIndex(uji::seq::pl::LINE); // Line[h̍Ō̃O
        pdl->Finalize();
        delete pdl;

        if( logId>=0 )
        {
            LogEntry le;
            le = pdl->Get_LogEntry(logId);

            // Line[h̍ŏIO "Reboot","START" ł邩
            if( (0 == strcmp(le.testerName, "Reboot")) && (0 == strcmp(le.state, "START")) )
            {
                // "CurrentTest=XX"  XX 擾ĕԂ
                lastTestId = atoi(static_cast<std::string>(le.message).substr(12).c_str());
            }
        }
        s->SetCurrentTest(lastTestId);
    }
    */

    c->SetAlternative().TestList = TESTLIST_ID_IMPORT;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}
/************************************************************************
ēiJ[hj
 ************************************************************************/
static void TestReentry(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;


    c->SetAlternative().TestList =TESTLIST_ID_REENTRY;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;

}
/************************************************************************
f[^ޔ
 ************************************************************************/
static void TestBackup(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;


    c->SetAlternative().TestList =TESTLIST_ID_BACKUP;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
f[^A
 ************************************************************************/
static void TestRestore(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;


    c->SetAlternative().TestList =TESTLIST_ID_RESTORE;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
AvP[V
 ************************************************************************/
static void TestComposite(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();
    s->EnableNgLog();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    using namespace nn::os::CTR;
    if(TARGET_HARDWARE_PRODUCT==GetRunningTargetHardware())
    {
        RemoveCard();
    }

    s->Execute();
    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}

/************************************************************************
J[hw
 ************************************************************************/
static void RemoveCard(void)
{
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    jpegDrawer->OpenPicture(L"rom:/aging/EjectCard.jpg");
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

    // J[ho܂ő҂܂
    while (nn::fs::IsCardInserted())
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }

    jpegDrawer->ClosePicture();
    delete jpegDrawer;
}

/***********************************************************************
\tgC|[g
 ************************************************************************/
static void TestAppImport(void)
{
    u32 previousList;

    TestSequencer *s = new TestSequencer;
    s->Initialize();

    uji::seq::Config  *c = new uji::seq::Config;
    previousList = c->GetAlternative().TestList;

    c->SetAlternative().TestList = TESTLIST_ID_APP_I;
    s->Execute();

    c->SetAlternative().TestList = previousList;

    delete c;
    delete s;
}


