# 시작(Breach 타입)
def start_entry():
    time_attack_event_name = "timeattackevent"
    script.NPCSPAWNGROUP(1) # BreachFormationSpawn.ScriptGroupID
    script.STUFFSPAWNGROUP(1) # BreachFormationSpawn.ScriptGroupID    

    # NPC 사망 시 1, Stuff 채집 시 1이 증가하여 최종 2가 되면 클리어 처리
    script.SET_INT("clear_conditions_met", 0)

    def inner_time_attack_send_message(*args):
        sec = args[0]
        send_sec_range_list = [30, 20, 10]
        if sec in send_sec_range_list:
            script.MESSAGE(110001, 380301, *args)

    # 성공 및 실패 처리
    def check_inner_exec(is_success: bool):
        def inner_stage_quit_time_attack_send_message(*args):
            sec = args[0]
            send_sec_range_list = [10]
            if sec in send_sec_range_list:
                script.MESSAGE(110001, 380301, *args)

        script.STOPEVENT(time_attack_event_name)
        if is_success:
            script.STAGECLEAR()
            script.CONTINUOUSCALL("timeattack", 10, 1, partial(inner_stage_quit_time_attack_send_message), partial(script.STAGEQUIT))
        else:
            script.STAGEFAIL(2)           
            script.CONTINUOUSCALL("timeattack", 5, 1, partial(inner_stage_quit_time_attack_send_message), partial(script.STAGEQUIT))

    # 개별 클리어 조건(NPC 사망 또는 Stuff 채집)이 충족될 때 호출되는 함수
    def _on_individual_clear_condition_met():
        script.ADD_INT("clear_conditions_met", 1)
        _check_overall_clear_condition()

    # 전체 클리어 조건을 확인하는 함수
    def _check_overall_clear_condition():
        if script.GET_INT("clear_conditions_met") == 2:
            check_inner_exec(True)     
        
    script.NPCSPAWNGROUPALLDIE(1, partial(_on_individual_clear_condition_met)) # 모든 NPC 죽으면
    script.STUFFSPAWNGROUPALLINTERACTION(1, partial(_on_individual_clear_condition_met)) # 모든 STUFF 채집
    script.PLAYERCOUNTLESSTHAN(0, 1, partial(check_inner_exec, False)) # 생존한 캐릭터가 없으면 실패 함수 호출
    script.CONTINUOUSCALL("timeattack", 120, 1, partial(inner_time_attack_send_message), partial(check_inner_exec, False), time_attack_event_name) # 타이머 120초 설정 (미션 실패)