/*
	Pluginfo.cpp
	This application retrieves the names and other relevant info
	of a 3DSMAX plugin
	aml - 10-18-02
*/

#include "max.h"
#include <windows.h>
#include <stdio.h>

typedef int (*PFLIBNUMBERCLASSES)(void);
typedef ClassDesc* (*PFLIBCLASSDESC)(int);
typedef const TCHAR* (*PFLIBDESCRIPTION)(void);

PFLIBNUMBERCLASSES LibNumberClasses;
PFLIBCLASSDESC     LibClassDesc;
PFLIBDESCRIPTION   LibDescription;

void main(int argc, char* args[])
{
	printf("Pluginfo v1.0 - 3DS MAX Plugin info viewer\n");
	printf("Neversoft Entertainment  aml - 10-18-02\n\n");

	if (argc < 2)
	{
		printf("ERROR: No plugin filename specified.\n");
		return;
	}

	HMODULE hModule = LoadLibrary(args[1]);

	LibNumberClasses = (PFLIBNUMBERCLASSES)GetProcAddress(hModule, "LibNumberClasses");
	LibClassDesc     = (PFLIBCLASSDESC)GetProcAddress(hModule, "LibClassDesc");
	LibDescription   = (PFLIBDESCRIPTION)GetProcAddress(hModule, "LibDescription");

	// LibDescription may be unimplemented
	char* strLibDesc = NULL;
	
	if (LibDescription)
		strLibDesc = (char*)LibDescription();

	if (strLibDesc)
		printf("Plugin Description: %s\n\n", strLibDesc);
	
	printf("Number of classes: %i\n", LibNumberClasses());

	int nClasses = LibNumberClasses();

	for(int i = 0; i < nClasses; i++)
	{
		ClassDesc* cdesc = LibClassDesc(i);

		printf("Class: #%i\n", i);
		printf("\tName: %s\n", cdesc->ClassName());
		printf("\tCategory: %s\n", cdesc->Category());
		printf("\tSuperClass: %x\n", cdesc->SuperClassID());
		printf("\tClassID: (%x,%x)\n", cdesc->ClassID().PartA(), cdesc->ClassID().PartB());
	}

	FreeLibrary(hModule);
}
