// vagwad.cpp :
//

#include "stdafx.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "conio.h"
#include "ctype.h"
#include <windows.h>

#include "pcm.h"

#define _1K 1024


FILE *listfp=NULL;
FILE *wadfp=NULL;
FILE *hedfp=NULL;
char *pBuf=NULL;
//char pPadding[SECTOR_SIZE];

void CleanUp()
{
	if (listfp!=NULL)
	{
		fclose(listfp);
		listfp=NULL;
	}
	if (wadfp!=NULL)
	{
		fclose(wadfp);
		wadfp=NULL;
	}
	if (hedfp!=NULL)
	{
		fclose(hedfp);
		hedfp=NULL;
	}
	if (pBuf!=NULL)
	{
		free(pBuf);
		pBuf=NULL;
	}

}

void Assert(bool Condition, char *pMessage)
{
	if (!Condition)
	{
		printf("VagWad assertion failed:\n%s",pMessage);
		CleanUp();
		exit(1);
	}
}

// Is file 2 newer than file one
bool FileIsNewer( char* file1, char* file2 )
{
	HANDLE file_handle_1, file_handle_2;
	WIN32_FIND_DATA find_data_1, find_data_2;
	
	file_handle_1 = FindFirstFile( file1, &find_data_1 );  
	if( file_handle_1 == INVALID_HANDLE_VALUE )
	{
		return true;
	}

	file_handle_2 = FindFirstFile( file2, &find_data_2 );  
	if( file_handle_2 == INVALID_HANDLE_VALUE )
	{
		FindClose( file_handle_1 );
		return false;
	}
	
	FindClose( file_handle_1 );
	FindClose( file_handle_2 );
	return( CompareFileTime( &find_data_2.ftLastWriteTime, &find_data_1.ftLastWriteTime ) > 0 );
}

bool IncludeInWad(const char *pFilename)
{
	const char *pExtension=strrchr(pFilename,'.');
	Assert(pExtension!=NULL,"File name has no extension.");
	++pExtension;

	const char *pName=strrchr(pFilename,'\\');
	if (pName==NULL)
	{
		pName=pFilename;
	}
	else
	{
		++pName;
	}

	// Q script source files.
	if (stricmp(pExtension,"q")==0) return false;
	if (stricmp(pExtension,"qn")==0) return false;

	// Source safe file.
	if (stricmp(pExtension,"scc")==0) return false;

	// Texture library dependency files.
	if (stricmp(pExtension,"dep")==0) return false;

	// Don't include wav's, since they aren't put in the wad but are
	// stored in a separate directory on the CD.
	if (stricmp(pExtension,"wav")==0) return false;

	// Don't include interleaved .vags
	if (stricmp(pExtension,"ivg")==0) return false;

	// fnt and ska files are stored in .pre files rather than the wad.
	//if (stricmp(pExtension,"fnt")==0) return false;
	//if (stricmp(pExtension,"ska")==0) return false;


	// Various script stuff not needed.
	if (stricmp(pName,"qcomp.map")==0) return false;
	if (stricmp(pName,"scripts.ini")==0) return false;
	if (stricmp(pName,"formats.f")==0) return false;
	if (stricmp(pName,"clist.txt")==0) return false;

	return true;
}

void RemoveLoopDataFromBuffer( char *pB, int bufSize )
{
	bufSize /= 16;
	int i;
	for ( i = 0; i < bufSize; i++ )
	{
		pB[ 1 + i * 16 ] &= ~( 7 );
	}
}

#define MAXFILENAMECHARS	100
char pEmptyVagData[ SB_BUF_HALF ];
char pPadding[ SECTOR_SIZE ];
#define EXTRA_SHIT_ON_VAG 16 // extra vag data that keeps the interrupt from happening.
char DbgMsg[ 255 ];
#define MIN_OVERHANG ( 16 * 5 )

int main(int argc, char* argv[])
{
	bool creatingInterleavedMusicVag = false;
	char *pStripString = NULL;
	long padSize = 0;
	bool hed_only = false;
	bool output_individual_streams = false;

	char *proj_path = getenv( "PROJ_ROOT" );
	if( proj_path == NULL )
	{		
		printf( "You must first define your PROJ_ROOT environment variable\n" );
	}

	char exeName[_MAX_PATH];
	sprintf( exeName, "%s\\bin\\win32\\vagwad.exe", proj_path );

	if (!( ( argc==3 ) || (argc==4 ) || ( argc==5 ) ) )
	{
		printf("\n");
		if (argc>5)
		{
			printf("Too many arguments!\n\n");
		}
		printf("VagWad.exe, %s\n",__DATE__);
		printf("Requires the name of the file listing file,\n");
		printf("followed by the name of the wad file to create,\n");
		printf("followed by the part of the directory to strip\n");
		printf("off of the name.\n");
		printf("For example:\n");
		printf("vagwad c:\\ps2\\data.txt c:\\ps2\\la.vwd c:\\ps2\n\n");
		printf("To create interleaved music vag file, add a -i\n");
		printf("as the final argument.  The text file in this\n");
		printf("case should consist of one file name for each\n");
		printf("song.  The files to be interleaved have the name\n");
		printf("with L or R appended to them (for left and right\n");
		printf("channels)\n");
		exit(1);
	}

	for (int i=0; i < ( SB_BUF_HALF >> 2 ); ++i)
	{
		* ( ( int * )&pEmptyVagData[ i * 4 ] ) = 0;
	}
	Assert( SB_BUF_HALF > SECTOR_SIZE, "Tell matt buf half is less than sector size.\n" );
	
	listfp=fopen(argv[1],"r");
	Assert(listfp!=NULL,"Could not open listing file.");


	// Check that the extension is .wad.
	char *pExtension=strrchr(argv[2],'.');
	Assert(pExtension!=NULL,"VagWad file must have extension .wad");
	++pExtension;
	if (stricmp(pExtension,"hed") == 0)
	{
		hed_only = true;
		printf("%s: Making wadless hed file %s\n", argv[0], argv[2]);
	}
	else
	{
		Assert(stricmp(pExtension,"wad")==0,"VagWad file must have extension .wad");
	}

	if ( argc==4 )
	{
		if ( ( strcmp( argv[3], "-i" ) ) && ( strcmp( argv[3], "-I" ) ) )
		{
			Assert(argv[3][strlen(argv[3])-1]!='\\',"3rd parameter must not end in a '\\'");
			pStripString = argv[3];
		}
		else
		{
			creatingInterleavedMusicVag = true;
		}
	}
	else if ( argc==5 )
	{
		if ( ( strcmp( argv[4], "-i" ) ) && ( strcmp( argv[4], "-I" ) ) )
		{
			Assert( 0, "Last parameter should be -i");
		}
		creatingInterleavedMusicVag = true;
		Assert(argv[3][strlen(argv[3])-1]!='\\',"3rd parameter must not end in a '\\'");
		pStripString = argv[3];
	}

	// Output individual files for interleaved hed-only streams
	output_individual_streams = hed_only && creatingInterleavedMusicVag;
	
	// Open the wad file for writing.
	if (!hed_only)
	{
		wadfp=fopen(argv[2],"wb");
		Assert(wadfp!=NULL,"Could not open wad file for writing.");

		// Change the extension to .hed
		pExtension[0]='h';
		pExtension[1]='e';
	}

	// Open hed for writing.
	hedfp=fopen(argv[2],"wb");
	Assert(hedfp!=NULL,"Could not open hed file for writing.");

	long Offset=0;

    // Check each of the files listed.
    while (true)
    {
        // File name buffer.
        char NameBuf[MAXFILENAMECHARS+1];
        // Make sure it is terminated in case the "too many chars" assert goes off.
        NameBuf[MAXFILENAMECHARS]=0;

        // Load each character into the buffer until end-of-line or end-of-file.
        int i=0;

        while (true)
        {
            Assert(i<=MAXFILENAMECHARS,"Too many chars in filename.");
			char ch=fgetc(listfp);

            // Check if end-of-file or end-of-line.
            if (ch==EOF || ch=='\n')
            {
                // Terminate the current string.
                NameBuf[i]=0;
                break;
            }

			if ( !isspace( ch ) )
			{
				NameBuf[i]=ch;
				++i;
			}
        }

        if (NameBuf[0])
		{
			long FileSize;
			if (IncludeInWad(NameBuf))
			{
				char tempBuf[ 255 ];
				strcpy( tempBuf, NameBuf );
				char *pName=tempBuf;
				// always strip the path off the filename:
				int idx;
				int stringLength;
				stringLength = strlen( tempBuf );
				for ( idx = 0; idx < stringLength; idx++ )
				{
					if ( ( NameBuf[ idx ] == '\\' ) || ( NameBuf[ idx ] == '/' ) )
					{
						pName = &tempBuf[ idx + 1 ];
					}
					else if ( NameBuf[ idx ] == '.' )
					{
						tempBuf[ idx ] = '\0';
					}
				}
				if ( creatingInterleavedMusicVag )
				{
					char NameL[MAXFILENAMECHARS + 1];
					char NameR[MAXFILENAMECHARS + 1];
					strcpy( NameL, NameBuf );
					strcpy( NameR, NameBuf );
					if ( NameBuf[ strlen( NameBuf ) - 4 ] != '.' )
					{
						sprintf( DbgMsg, "File %s should end with '.vag'\n", NameBuf );
						Assert( 0, DbgMsg );
					}
					strcpy( &NameL[ strlen( NameBuf ) - 4 ], "L" );
					strcpy( &NameL[ strlen( NameBuf ) - 3 ], &NameBuf[ strlen( NameBuf ) - 4 ] );
					strcpy( &NameR[ strlen( NameBuf ) - 4 ], "R" );
					strcpy( &NameR[ strlen( NameBuf ) - 3 ], &NameBuf[ strlen( NameBuf ) - 4 ] );

					// Open a new wad file for each song, as well as
					// the main wad:
					if ( output_individual_streams )
					{
						Assert(wadfp == NULL, "Wad file open in hed_only mode");

						char songWadName[ 255 ];
						strncpy( songWadName, NameBuf, 255 );
						char *pExtension=strrchr(songWadName,'.');

						strcpy(pExtension, ".ivg");		// Output filetype

						if (FileIsNewer(songWadName, NameL) || FileIsNewer(songWadName, exeName))
						{
							printf("Updating interleaved file %s\n", songWadName);
							wadfp = fopen(songWadName, "wb");
						}
					}

					Assert(output_individual_streams || wadfp!=NULL,"Could not open wad file for writing.");

					FILE *ifpL=fopen(NameL,"rb");
					FILE *ifpR=fopen(NameR,"rb");
					if ( ifpL == NULL )
					{
						sprintf( DbgMsg, "Couldn't find file '%s' with left channel info.", NameL );
						Assert( 0, DbgMsg );
					}
					if ( ifpR == NULL )
					{
						sprintf( DbgMsg, "Couldn't find file '%s' with right channel info.", NameR );
						Assert( 0, DbgMsg );
					}
					fseek( ifpL, 0, SEEK_END );
					FileSize = ftell( ifpL );
					Assert( FileSize > SIZE_OF_VAGHEADER + EXTRA_SHIT_ON_VAG, "File for left channel too small." );
					fseek( ifpR, 0, SEEK_END );
					long tempFileSize = ftell( ifpR );
					Assert( FileSize == tempFileSize, "Left and right channel files of different size!" );
					Assert( pBuf == NULL, "pBuf not NULL ???" );
					pBuf = ( char * )malloc( MUSIC_HALF_IOP_BUFFER_SIZE );
					fseek( ifpL, SIZE_OF_VAGHEADER, SEEK_SET );
					fseek( ifpR, SIZE_OF_VAGHEADER, SEEK_SET );
					FileSize -= ( SIZE_OF_VAGHEADER + EXTRA_SHIT_ON_VAG );
					if (!hed_only)
					{
						printf( "file size %d\n", FileSize );
					}
					long sizeLeft = FileSize;
					while ( sizeLeft >= MUSIC_HALF_IOP_BUFFER_SIZE )
					{
						if (wadfp)
						{
							Assert( fread( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE, 1, ifpL )==1,"fread failed");
							RemoveLoopDataFromBuffer( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE );
							Assert( fwrite( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE, 1, wadfp)==1,"fwrite failed");

							Assert( fread( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE, 1, ifpR )==1,"fread failed");
							RemoveLoopDataFromBuffer( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE );
							Assert( fwrite( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE, 1, wadfp)==1,"fwrite failed");
						}
						sizeLeft -= MUSIC_HALF_IOP_BUFFER_SIZE;
					}
					padSize = 0;
					if ( sizeLeft > 0 )
					{
						long FilePadSize = MUSIC_HALF_IOP_BUFFER_SIZE - sizeLeft;
						if (!hed_only)
						{
							printf( "pad per channel %d\n", FilePadSize );
						}

						if (wadfp)
						{
							Assert( 1 == fread( pBuf, sizeLeft, 1, ifpL ), "Fread failed");
							for ( i = sizeLeft - 1; i < MUSIC_HALF_IOP_BUFFER_SIZE; i++ )
							{
								pBuf[ i ] = 0;
							}
							RemoveLoopDataFromBuffer( pBuf, sizeLeft );
							Assert( 1 == fwrite( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE, 1, wadfp ), "Fwrite failed" );

							Assert( 1 == fread( pBuf, sizeLeft, 1, ifpR ), "Fread failed");
							RemoveLoopDataFromBuffer( pBuf, sizeLeft );
							Assert( 1 == fwrite( pBuf, MUSIC_HALF_IOP_BUFFER_SIZE, 1, wadfp ), "Fwrite failed" );
						}

						//FileSize += FilePadSize;
						padSize = FilePadSize;
						long overHang = ( sizeLeft & ( SB_BUF_HALF - 1 ) );
						if ( ( overHang > 0 ) && ( overHang < MIN_OVERHANG ) )
						{
							if (!hed_only)
							{
								printf( "fixed end, only %d over buffer boundary\n", overHang );
							}
							padSize -= ( MIN_OVERHANG - overHang );
							FileSize += ( MIN_OVERHANG - overHang );
						}
					}
					padSize *= 2;
					FileSize *= 2;
					fclose(ifpL);
					fclose(ifpR);

					if (output_individual_streams && wadfp)
					{
						fclose(wadfp);
						wadfp = NULL;
					}
				}
				else
				{
					FILE *ifp=fopen(NameBuf,"rb");
					Assert(ifp!=NULL,"Could not open file.");

					fseek(ifp,0,SEEK_END);
					FileSize=ftell(ifp);
					Assert(FileSize > SIZE_OF_VAGHEADER + EXTRA_SHIT_ON_VAG,"File smaller than vag header plus extra shit.");
					FileSize -= ( SIZE_OF_VAGHEADER + EXTRA_SHIT_ON_VAG );
					Assert( !( FileSize & 15 ), "Data size not divisible by 16." );
					padSize = FileSize % SECTOR_SIZE; //SB_BUF_HALF;
					if ( padSize )
					{
						padSize = SECTOR_SIZE - padSize; //SB_BUF_HALF - BufferPadSize;
					}
					Assert(pBuf==NULL,"pBuf not NULL ?");
					pBuf=(char*)malloc(FileSize + padSize);
					if (!hed_only)
					{
						printf( "   pad size %d\n   num half buffers %d\n", padSize, ( FileSize + padSize ) / SB_BUF_HALF );
						fseek(ifp,SIZE_OF_VAGHEADER,SEEK_SET);
						Assert(fread(pBuf,FileSize,1,ifp)==1,"fread failed");
						RemoveLoopDataFromBuffer( pBuf, FileSize );
						Assert(fwrite(pBuf,FileSize,1,wadfp)==1,"fwrite failed");
						if ( padSize )
						{
							Assert( fwrite( pEmptyVagData, padSize, 1, wadfp ) == 1,"fwrite failed (when writing sector padding)");
							//FileSize += BufferPadSize;
						}
					}
					long overHang = ( FileSize & ( SB_BUF_HALF - 1 ) );
					if ( ( overHang > 0 ) && ( overHang < MIN_OVERHANG ) )
					{
						if (!hed_only)
						{
							printf( "fixed end, only %d over buffer boundary\n", overHang );
						}
						padSize -= ( MIN_OVERHANG - overHang );
						FileSize += ( MIN_OVERHANG - overHang );
					}
					//Assert( !( FileSize % SB_BUF_HALF ), "Tell matt to fix this.\n" );
					fclose(ifp);
				}
				free(pBuf);
				pBuf=NULL;

				// Write the .hed entry.
				Assert((ftell(hedfp)&3)==0,"Not long word aligned in hedfp");
				Assert((Offset%SECTOR_SIZE)==0,"Offset not sector aligned.");
//				Assert( !( FileSize % SB_BUF_HALF ), "File size not a multiple of Spu buffer half." );
				Assert(fwrite(&Offset,4,1,hedfp)==1,"fwrite failed writing offset into .hed");
				Assert(fwrite(&FileSize,4,1,hedfp)==1,"fwrite failed writing file size into .hed");

				pName=NameBuf;
				// If a path was specified, strip it off the front.
				if (pStripString)
				{
					char *pPath=pStripString;
					while (*pPath && tolower(*pName)==tolower(*pPath))
					{
						++pName;
						++pPath;
					}
					Assert(*pPath==0,"File name does not start with specified path.");
				}
				// strip off the .vag extension:
				for ( i = strlen( pName ) - 1; i > 0; i-- )
				{
					if ( pName[ i ] == '.' )
					{
						pName[ i ] = '\0';
					}
				}

				int Len=strlen(pName);
				Assert(fwrite(pName,Len+1,1,hedfp)==1,"fwrite failed writing file name into .hed");
				int StringPadSize=(Len+1)&3;
				if (StringPadSize)
				{
					StringPadSize=4-StringPadSize;
				}
				if (StringPadSize)
				{
					Assert(fwrite(pEmptyVagData,StringPadSize,1,hedfp)==1,"fwrite failed when writing string padding to .hed");
				}
				if (!hed_only)
				{
					printf("%s\n",pName);
				}

				Offset+=FileSize;
				Offset+= padSize;
			}
		}
        else
            break;
    }

	long Terminator=0xffffffff;
	Assert((ftell(hedfp)&3)==0,"Not long word aligned in hedfp when writing terminator.");
	Assert(fwrite(&Terminator,4,1,hedfp)==1,"fwrite failed writing .hed terminator.");

	CleanUp();
	return 0;
}