/*
	SpinEdit.h
	A linked spinner Edit Box Control
	4-8-01
*/

#ifndef __SPINEDIT__
#define __SPINEDIT__

#include <windows.h>
#include "max.h"

#define SPIN_EDIT_NAME    "SpinEdit"

class SpinEdit
{
	HWND hwndEdit;				// The MAX Edit part of the control
	HWND hwndSpinner;			// The MAX Spinner part of the control
	HWND hwnd;					// The parent window representing our SpinEdit control

	ISpinnerControl*  ISpin;
	ICustEdit*        IEdit;
	float             value;	// This retains the value of the control before its UI is built

	float min,max,incr;

	WNDCLASS wndclass;

	static LPARAM CALLBACK WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void BuildControlUI();
	void DestroyUI();
	void Resize(int width,int height);

	HWND GetFocusWindow();

public:
	SpinEdit();
	SpinEdit(HWND hwnd,float min,float max);
	SpinEdit(HWND hwnd);
	~SpinEdit();

	SpinEdit(SpinEdit& right);
	SpinEdit& operator = (SpinEdit& right);

	void Attach(HWND hwnd);
	void SetLimits(float min, float max);
	void SetIncr(float incr);

	float GetValue();
	void  GetValue(CStr& str);
	void  SetValue(float val);

	static void Register(HINSTANCE hInstance);
	static void UnRegister(HINSTANCE hInstance);
};

#endif
