/*
	PathSelect.cpp
	Path Selection Dialog
	aml - 1-8-03
*/

#include "PathSelect.h"
#include "Resource.h"
#include <string.h>

PathSelectDlg::PathSelectDlg(HINSTANCE hInstance, HWND hwndParent) :
	ModalDlgWindow(hInstance, MAKEINTRESOURCE(IDD_ADDPATH), hwndParent)
{
	strcpy(path, "c:\\*.*");
	Show();	
}

PathSelectDlg::~PathSelectDlg()
{

}

BOOL PathSelectDlg::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		SendDlgItemMessage(hwnd, IDC_DRIVELIST, CB_DIR, (WPARAM)DDL_DRIVES|DDL_EXCLUSIVE, (LPARAM)"");
		SendDlgItemMessage(hwnd, IDC_DRIVELIST, CB_SELECTSTRING, (WPARAM)-1, (LPARAM)"[-c-]");
		DlgDirList(hwnd, path, IDC_DIRLIST, IDC_DIRPATH, DDL_DIRECTORY|DDL_EXCLUSIVE);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			GetDlgItemText(hwnd, IDC_DIRPATH, path, 2047);
			EndDialog(hwnd, 0);
			break;

		case IDCANCEL:
			strcpy(path, "");
			EndDialog(hwnd, 0);
			break;
		}

		switch(HIWORD(wParam))
		{
		case CBN_SELCHANGE:
			{
				switch(LOWORD(wParam))
				{
				case IDC_DRIVELIST:
					{
						char drive[256];

						int idx = SendDlgItemMessage(hwnd, IDC_DRIVELIST, CB_GETCURSEL, 0, 0);

						if (idx != CB_ERR)
							SendDlgItemMessage(hwnd, IDC_DRIVELIST, CB_GETLBTEXT, (WPARAM)idx, (LPARAM)drive);

						// Convert the drive name to a path format drive name
						drive[0] = drive[2];
						drive[1] = ':';
						drive[2] = '\\';
						drive[3] = '\0';

						strcpy(path, drive);
						DlgDirList(hwnd, path, IDC_DIRLIST, IDC_DIRPATH, DDL_DIRECTORY|DDL_EXCLUSIVE);
					}
				}
				break;
			}

		case LBN_DBLCLK:
			{
				switch(LOWORD(wParam))
				{
				case IDC_DIRLIST:
					{
						DlgDirSelectEx(hwnd, path, 2047, IDC_DIRLIST);
						DlgDirList(hwnd, path, IDC_DIRLIST, IDC_DIRPATH, DDL_DIRECTORY|DDL_EXCLUSIVE);
					}
					break;
				}
			}
			break;
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, 0);
		return TRUE;
	}

	return FALSE;
}

void PathSelectDlg::SetPath(char* usrpath)
{
	strcpy(path, usrpath);
	DlgDirSelectEx(hwnd, path, 2047, IDC_DIRLIST);
	DlgDirList(hwnd, path, IDC_DIRLIST, IDC_DIRPATH, DDL_DIRECTORY|DDL_EXCLUSIVE);
}

CStr PathSelectDlg::GetPath()
{
	return CStr(path);
}

bool PathSelectDlg::WasCancelled()
{
	if (strlen(path) == 0)
		return true;

	return false;
}

