/*
	NodeSelect.h
	Node selector control
	Assigns node name by clicking on a node in the viewport
*/

#ifndef __NODESELECT__
#define __NODESELECT__

#include "UIControl.h"
#include "max.h"

#define NODESELECT_CLASSNAME "NodeSelector"

class NSAddCallback;

class NodeSelect: public UIControl
{
	friend class NodeSelectPicker;

	HWND              hwndButton;		 // Button for selecting a node by picking in the viewports
	HWND              hwndButtonChooser; // Button for bringing up the node selection dialog
	HWND              hwndEdit;          // Edit control window
	HWND              hwndSelect;		 // Button for selecting the current node in the scene
	ICustButton*      ibutton;			 // Button for selecting a node by picking in the viewports
	ICustButton*      ibuttonChooser;	 // Button for bringing up the node selection dialog
	ICustButton*      ibuttonSelect;	 // Button for selecting the current node
	ICustEdit*        iedit;			 // Edit box for manually entering names
	INode*            node;
	CStr              value;
	bool              bLockChooser;		 // True if attempts to use the chooser option should be blocked

	NSAddCallback*    addCB;

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void BuildControlUI();
	HWND GetFocusWindow();

public:
	CLASSNAME(NODESELECT_CLASSNAME)

	CStr GetValue();
	void SetValue(CStr value,bool bNotify=TRUE);

	void SetNode(INode* node);
	INode* GetNode();

	void Select();

	NodeSelect(HINSTANCE hInstance);
	~NodeSelect();

	NodeSelect(NodeSelect& right);
	NodeSelect& operator = (NodeSelect& right);
};

#endif
