/*
	MtlSelect.cpp
	A material selection control
	8-1-01
*/

#include "MtlSelect.h"
#define CUSTIDC_BUTTON 1

extern Interface* gInterface;

MtlSelect::MtlSelect(HINSTANCE hInstance,HWND hwnd) :
	UIControl(hInstance, CLASS)
{
	
}

MtlSelect::MtlSelect(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{

}

MtlSelect::MtlSelect(MtlSelect& right) :
	UIControl(right.hInstance, CLASS)
{
	hwndButton = NULL;
	value = right.value;
}

MtlSelect& MtlSelect::operator = (MtlSelect& right)
{
	hwndButton = NULL;
	SetValue(right.GetValue());

	return *this;
}

void MtlSelect::BuildControlUI()
{
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	hwndButton = CreateWindow("button",
		                      "",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  wndRect.right - wndRect.left,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);
}

LRESULT MtlSelect::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_CREATE:
		SetValue(value);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			DoMtlSelect();
			return TRUE;
		}
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void MtlSelect::DoMtlSelect()
{
	MtlBase* mtl;
	BOOL     bNewMtl;
	BOOL     bCancel;

	mtl = gInterface->DoMaterialBrowseDlg(hwnd, BROWSE_MATSONLY | BROWSE_INSTANCEONLY, bNewMtl, bCancel);
	
	if (mtl)
	{
		if (!bCancel)
		{
			SetValue(mtl->GetName());
		}
	}
}

void MtlSelect::SetValue(CStr name)
{
	value = name;
	SetWindowText(hwndButton,(char*)name);
}

CStr MtlSelect::GetValue()
{
	char buf[256];
	GetWindowText(hwndButton,buf,255);

	return CStr(buf);
}
