/*
	TestPlug.h

	Test plugin temp
	Adam Lippmann
*/

#ifndef TESTPLUG_H
#define TESTPLUG_H

#include "PropEdit.h"
#include "../UI/PropList.h"

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"

#define TESTPLUG_CLASS_ID          Class_ID(0x580f6a2d, 0x18510f20)
#define vTESTPLUG_SHORTCUT_ID      0x18510f20
#define vTESTPLUG_LOD_SHORTCUT_ID  0x63a86d26

ActionTable* GetTestActions( void );
bool RegTestActionAccelerators();
void UnRegTestActionAccelerators();

class TP_ActionCB : public ActionCallback {
public:
	BOOL ExecuteAction(int id);
};

class TP_LODActionCB : public ActionCallback {
public:
	BOOL ExecuteAction(int id);
};

class TestPlug: public UtilityObj
{
	HWND hwnd;			// Window handle for the rollout

	static BOOL __stdcall DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static void CloseNotifyCB(PropEditor* pedit,void* pData);

	Interface*  ip;
	IUtil*      iu;
	//PropList*   proplist;
	//PropEditor* propedit;

public:
	TestPlug();
	~TestPlug();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
	void SetStartupParam(TSTR param) {}
};

class TestPlugClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new TestPlug(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Property Editor"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return TESTPLUG_CLASS_ID;}
	const TCHAR* 	Category() {return _T("PropEditor");}
	const TCHAR*	InternalName() { return _T("PropEditor"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	

	int           NumActionTables()     { return 1; }
	ActionTable*  GetActionTable(int i) { return GetTestActions(); }
};

#endif
