/*
	PropEdit.h
	Adam Lippmann
	12-12-01
*/

#ifndef __PROPEDIT__
#define __PROPEDIT__

//#define  HASHTABLE_NOASSERTIFCLASH			// Prevent the hashtable from asserting if we have duplicates
#define  HASHINCLUDED
#include <core/hashtable.h>
#include "../UI/TreeView.h"
#include "max.h"
#include "notify.h"
#include "../UI/tooltip.h"
#include "../UI/ProgressBar.h"
#include "../UI/RichText.h"
#include "../UI/PropList.h"
#include "TypeData.h"
#include "ConfigData.h"
#include "MultiSearch.h"
#include "ScriptBrowse.h"
#include "FindNode.h"
#include "PropCompareDlg.h"
#include "AddPropDlg.h"
#include "path.h"
#include "ScriptIniParser.h"
#include "RTFEditor.h"
#include "PropTagParser.h"
#include "PropBufGen.h"
#include "ExtScript.h"
#include "NodeRename.h"
#include "PropFlags.h"
#include "SubClassWnd.h"
#include "Preprocessor.h"

#define TITLEMODE_NODE   0
#define TITLEMODE_FILE   1

class FindInFilesDlg;
class PropUpdater;
class LODBrowser;
class ReplaceInNodesDlg;
class MultiPropList;
class PropMergeDlg;
class ClusterFindDlg;

class AddCallback: public HitByNameDlgCallback
{
	Interface  *ip;			// Pointer to MAX interface class

public:
	AddCallback(Interface* ip) { this->ip = ip; }

	TCHAR *dialogTitle()	{ return _T("Select nodes to add for game properties"); }
	TCHAR *buttonText() 	{ return _T("Add"); }
	BOOL singleSelect()		{ return FALSE; }
	BOOL useFilter()		{ return TRUE; }
	int filter(INode *node)	{ return TRUE; }
	BOOL useProc()			{ return TRUE; }
	void proc(INodeTab &nodeTab);
	BOOL doCustomHilite()	{ return FALSE; }
	BOOL doHilite(INode *node)	{ return FALSE; }
	BOOL showHiddenAndFrozen()	{ return FALSE; }
};

enum CompareResult
{
	COMPR_SAMEVALUE,		// The same field exists with the same value
	COMPR_FIELDEXISTS,		// The field exists but with a different value  (inconsistent)
	COMPR_NOFIELDEXISTS,	// The field doesn't exist
};

struct Filter
{
	CStr name;
	CStr filter;
};

class PropEditor: public SubClassWndMan, public DynScriptPreprocessor, public RTFEditor, public PropBufGen
{
	friend class MSearchDlg;
	friend class ScriptBrowse;

	HINSTANCE  hInstance;				// hInstance of the application
	Interface  *ip;						// 3DS MAX Interface pointer
	
	HWND       hwnd;						// Our main Property Editor window
	HMENU      hMenuProps;				// The property list menu containing the below popup menu
	HMENU      hPropsPopupMenu;			// The popup menu when you right click on a property in the property list

	ToolTip    ttip;					// Tool tip manager
	TreeView*  pTreeView;				// The tree view control on the right of the interface
	//PropList*  pDefaultProps;			// Floating Property list to display default properties
	//PropList*  oldPropView;			// The property list before switch to the floating pDefault props (docked UI propView)
	//PropList*  propView;				// The current property viewer
	MultiPropList*  pDefaultProps;		// Floating Property list to display default properties
	MultiPropList*  oldPropView;		// The property list before switch to the floating pDefault props (docked UI propView)
	MultiPropList*  propView;			// The current property viewer

	MultiPropList* multiProp;			// Test multiPropList

	MultiList* classBrowser;
	MultiList* typeBrowser;

	LODBrowser* LODview;				// Floating LOD Browser

	WNDPROC   OldNodeListProc;

	TVItem*    pTVIScripts;				// Refers to root entries in the TreeView control for fast updates
	TVItem*    pTVIIntergers;
	TVItem*    pTVIFloats;
	TVItem*    pTVIVectors;
	TVItem*    pTVIPairs;
	TVItem*    pTVIStrings;
	TVItem*    pTVILocalStrings;
	TVItem*    pTVIArrays;
	TVItem*    pTVIStructs;
	TVItem*    pTVINames;

	ProgressBar*       pProgBar;			// Progress Bar for time consuming operations
	MSearchDlg*        pMSearch;			// The multi search dialog  (MSearchDlg and PropEdit are circularly dependant)
	ScriptBrowse*      pScriptBrowse;		// The script browser dialog
	FindNodeDlg*       pFindNode;			// The FindANode (tm) dialog
	PropCompareDlg*    pCompareDlg;			// The property compare popup dialog
	AddPropDlg*        pAddPropDlg;			// The add property dialog
	ExtScriptDlg*      pExtScriptDlg;		// The external script dialog
	NodeRenameDlg*     pRenameDlg;			// Requester dialog to modify the node name
	FindInFilesDlg*    pFindFilesDlg;		// The find in files dialog
	PropUpdater*       pPropUpdater;		// Updates properties when scripts.ini changes
	ReplaceInNodesDlg* pReplaceInNodesDlg;	// The ReplaceInNodes Dialog
	PropMergeDlg*      pPropMergeDlg;		// The merge properties dialog
	ClusterFindDlg*    pClusterFindDlg;		// The cluster finder sub utility dialog

	LinkList<CStr>  lastProps;			// List for keeping track of the previous set of property data prior to update

	BOOL		    bLockSelection;		// True if selection set updates are to be denied
	BOOL            bLockPropBuffer;	// True if property buffer copy requests are to be denied
	BOOL            bLockClassUpdate;	// True if updating the class information is denied
	BOOL            bLockSelectAdd;		// True if the add button should not be processed (in middle of operation)

	BOOL			bAutoSelect;		// True if auto apply/restore mode is turned on
	BOOL            bSubSelApply;		// Apply changes on nodelist subselection change
	BOOL            bSubSelRestore;		// Changes the current node to the node list's selection
	BOOL            bApplyOnClose;		// Apply changes when the property editor closes automatically
	BOOL            bApplyChangedOnly;	// Apply changes only to fields that have changed
	BOOL            bAddConflict;		// Add new fields when changing accross conflicts

	BOOL            bMapUnloaded;		// True if the map file isn't loaded

	BOOL            bNoTreeview;		// Prevents access to the global treeview list
										// (This significantly speeds up loading time)

	BOOL            bNameExpansion;		// True if tooltip name expansion is enabled

	// Mod flags
	BOOL            bClassChanged;		// True if the class has been changed
	BOOL            bTypeChanged;		// True if the type has been changed
	//////

	// Conflict flags
	BOOL            bClassConflict;		// Conflict between selected object classes ????
	BOOL            bTypeConflict;		// Conflict between selected object types ????
	//////

	BOOL            bDisplayTree;		// True if in TreeView display mode
	BOOL            bForceScriptUpdates;// True if scripts.ini updates should be forced when they occur

	BOOL            bPropertyAutoFill;	// If true properties are automatically filled in for the default class
										// whenever an object is first selected

	BOOL			bImmediateApply;	// If true property buffers will be updated immediately whenever any
										// changes take place

	BOOL            bRefreshViewport;	// If true viewport is redrawn when a property change is applied

	BOOL            bLockImmediateApply;// If any setting operations are going on performing an immediate apply
										// would screw up the original set

	LinkList<Filter>                    filterList;		// List of filters being used
														
	LinkList<INode*>                    selSet;			// The last selected group of nodes
														
	LinkList<ConfigProp>                props;			// The properties parsed for the current MAX selection
	LinkList<CStr>                      delprops;		// List of properties (by name) that should be deleted
														// in all selected nodes
														
	LinkList<ConfigScript>              scripts;		// List to keep track of current alternate scripts
	LinkList<ConfigScript>              editScripts;	// Keeps track of scripts currently being edited
	CStr                                editScript;		// The internal script currently being edited

	CStr                                strCmds;		// Commands that weren't default properties included in obj prop buffer
	CStr                                strCluster;		// Trick object cluster
	CStr                                strLastPanel;	// The name of the last multilist panel being displayed
	LinkList<ConfigProgram>             programs;		// MAXScript program to launch on parameter changes
	DWORD                               flags;			// The flags to be set

	AddCallback addCB;									// Hit by name callback when used with the Add selection button
	
	bool								bOmit;			// True if this node should not be exported to the node array CMD:OMIT

	void AcquireSelSet(BOOL DelOld=TRUE);				// Acquire the MAX selection set and apply to the interface
	void RemoveSelSet();								// Removes items selected in list box from MAX selection set

	void GetScriptDescription(CStr keyword);
	void GoToScriptDefinition(CStr keyword);
	void GoToScriptDefinitionNew(CStr keyword);

	bool UpdateClassSelection(BOOL bWarn=TRUE);
	void AddScript();
	void FindScript();
	void Apply(BOOL bAlert,INode* node=NULL);

	// Search
	void MultiSearchDlg();
	void MultiReplaceDlg();


	void DefaultPropDlg(BOOL bKeepActive=FALSE);
	void GetDefaultProps();
	void GetPropViewProps();

	static void CALLBACK TimerProc(HWND hwnd,UINT msg,UINT id,DWORD time);

	static void PropMergeCB(PropMergeDlg* pMergeDlg,void* pData);
	static void PropViewChangeCB(PropList* pPropList,void* pData);
	static void PropViewDblClickCB(PropList* pPropList,int index,void* pData);
	static void EscapeCB(PropList* pPropList, void* pData);

	static void RenameCB(NodeRenameDlg* renameDlg,void* pData);

	static void AddPropCB(AddPropDlg* pAddProp,void* pData);
	static void ModPropCB(AddPropDlg* pAddProp,void* pData);

	static void ProcEditChange(RTFEditor* rtf,void* pData);

	WNDPROC OldGlobalProc;
	static LRESULT CALLBACK SubGlobalProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);	// Subclassed wndproc for global list
	
	static LRESULT SubPropProc(PropList* plist,HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam,void* pData);

	static LRESULT CALLBACK ttipWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	// Master WndProc for subclassed window registration through sub classed window manager
	// NOTE: The parent of each registered window is assumed to be the Property Editor Window
	static LRESULT CALLBACK SubWndReg(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	bool UpdateDefaultCondition(PropList* pPropList,int ID);

	///////////////  Windows message sink redirection

	// WndProc redirection for the popup menu
	static LRESULT CALLBACK RedirectWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	BOOL WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	// DlgProc redirection for everything else
	static BOOL CALLBACK RedirectDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void (*fpCloseNotify)(PropEditor*,void*);	// Callback function to call when property editor shutsdown
	void* pCloseNotifyData;						// Callback retained data

	///////////////
	CompareResult CompareProp(CStr propName,CStr propVal,LinkList<ConfigProp>* propList);

	void AddConflicts(PropList* plist,int index);		// Update the conflict browser
	bool CompareProps(INode* node);			// Updates the current properties for comparison with the given node
	bool CompareScripts();					// Checks for similarities between the scripts of nodes within subselection
	bool CompareDefaults(CStr className,
		                 CStr typeName);	// Compares the current properties against the defaults for the class/type
	void AddCompareProps();					// Constructs UI with properties from all selected nodes
	void NodeListRestore();					// Sets active node to NodeList selection
	void GetSelNodes();						// Fills selSet table with selected nodes only from nodelist
	bool SubSelApply();						// Toggles subselection auto apply on/off
	bool SubSelRestore();					// Toggles subselection auto restore on/off
	void ProcNodeListSelChange();			// Processes NodeList selection changes

	bool ApplyChangedOnly();				// Toggle apply to changed fields only
	bool AddConflict();						// Toggle add new fields when changing accross conflicts
	void RestoreDefaults();					// Restores the default properties to their default state

	/////////////// MAX Notification message sink
	static void MAXSelChange(void *param,NotifyInfo *info);

	// MAX interface functions
	void SelectionSetChanged(BOOL bNoApply=FALSE);	// To notify editor that the property set has changed

	void CopyProps(BOOL bSetScript=TRUE);			// Copies default properties out of the configDB into
													// props and flags for user modification

	bool ProcOmit(CStr& propBuffer);				// Updates UI to match prop buffer for Omit status

	void CloseChildren();							// Closes all child windows

	bool ErrorCheck();								// Compiles the current script and redirects compiler error output

	void AddFilter();
	int  AddFilter(char* Name,char* Value);
	void RemoveFilter();
	void FilterChange();
	void UpdateGlobalList();
	void RenameNode();

	void ApplyOnClose();
	bool ForceScriptUpdates();
	bool PerformApplyOnClose();
	bool ImmediateApply();
	bool RefreshViewport();

	Link<ConfigProp>* FindProp(LinkList<ConfigProp>* proplist,CStr name);

	void ResetModFlags();

	void ApplyNodeChanges(INode* node);
	void ClearProps(BOOL bWarn=TRUE);

	void RegisterSelChange();
	void UnRegisterSelChange();

	void DeleteProp(PropList* plist,int index);
	void ModifyProp(PropList* plist,int index);

	bool AddNewProp(AddPropDlg* pAddProp);
	void AddPropViewProp(ConfigProp* curProp);

	void FindInFiles();

	void SetTitle(int mode, char* nodename);			// Sets the title of the property editor window

	void  MergeProps(CStr className, CStr typeName, LinkList<ConfigProp>* cprops, LinkList<int>* updateFields);
	void  MergePropsDEF(CStr className, CStr typeName, LinkList<ConfigProp>* cprops, LinkList<int>* updateFields);
	void  AssignUpdated(LinkList<int>* fields);
	DWORD GetPropViewFlags();

	void ResetContext();

	void SubclassMAXClasses();
	void UnSubclassMAXClasses();

	void AssignEmptyPropBuffers();
	void UpdateClassList();

	void UpdateParticleObjVisualization(CStr typeName);

public:
	friend class AddCallback;

	PropEditor(HINSTANCE hInstance,Interface* ip);
	~PropEditor();

	void DispTreeView();
	void DispGlobalList();

	void UpdatePropView();
	inline void Update() { SelectionSetChanged(TRUE); }	// Force reparse of propdata unconditionally

	bool VerifyClassValidity();

	// Takes about 3 secs. to add 10000+ scripts to a TreeView control
	// Do this ONCE with the window hidden
	void Show();
	inline void Hide() { selSet.Clear(); CloseChildren(); ShowWindow(hwnd,SW_HIDE); UnRegisterSelChange(); }

	// Parsing functions
	bool ParseMapFile(char* Filename);
	bool ParseUserProps(INode* node=NULL);	// Parses the MAX user data to load back into the editor

	void SetCloseNotify(void (*Func)(PropEditor*,void*),void* pdata);

	void LoadDlg();								// Pops up a load dialog and loads the requested file
	void SaveDlg();								// Pops up a save dialog and saves the current script to disk

	bool SaveConfig();							// Saves out configuration settings to .ini file
	bool LoadConfig();							// Retrieves configuration settings from .ini file

	bool AutoSelect();							// Enables or Disables the AutoSelect mode
	bool ToggleNameExpansion();					// Enables or Disables the tooltip name expansion mode

	void FindNode();							// Opens the FindANode(tm)  Dialog

	CStr GetClass();							// Gets the currently selected class name
	CStr GetType();								// Gets the currently selected type name

	void AddProp();								// Pops up the add property dialog
	void AddLink();								// Automatically adds the next manual link

	void RefreshScriptIni(bool bWarn=true);		// Reloads script.ini

	void OpenLODBrowser();						// Opens the LOD Browser
	void ReplaceInNodes();						// Opens ReplaceInNodes Dialog

	void AddSFP();								// Add screen facing poly properties
	void StoreProps();							// Saves the current set of properties as a type to scripts.ini

	bool PopupParamsOpen();						// Returns true if popup param complete window is open
	void ClosePopupParams();					// Closes the popup parameter completion window

	void OpenPropMergeDlg();					// Opens the merge properties dialog
	void OpenClusterFinder();					// Opens the cluster finder dialog

	void SetValue( CStr& name, CStr value );	// Sets a value of an element in our propertly list

	inline void LockSelectAdd()   { bLockSelectAdd = TRUE;  }
	inline void UnLockSelectAdd() { bLockSelectAdd = FALSE; }

	inline void EnableAutoPropAssign()  { bPropertyAutoFill = TRUE; }
	inline void DisableAutoPropAssign() { bPropertyAutoFill = FALSE; }

	inline void LockSelChange()   { bLockSelection = TRUE; }
	inline void UnLockSelChange() { bLockSelection = FALSE; }
};

#endif
