/*
	PreProcessor.h
	This class provides a DynUI command // @program | [ms file] | [params]
	where ms file is a MAXScript file that generates a .ntp (Neversoft template)
	file.  The generated template file is filled in by the preprocessor with the
	values of the parameters within the property list in the UIautomatic script generation for an object type in scripts.ini or
	for a parameter set attached to a function (script or C code)

	MAXScript commands
*/

#ifndef __PREPROCESSOR__

#ifdef STRICT
#undef STRICT
#endif

#include "MAXScrpt/MAXScrpt.h"
#include "MAXScrpt/parser.h"
#include "../UI/PropList.h"
#include "../misc/llist.h"
#include "ConfigData.h"
#include "../PropEdit/PropTagParser.h"
#include "SharedData.h"
class PropList;

struct ScriptBuf
{
	CStr scriptName;
	CStr buffer;

	bool operator ==(ScriptBuf& right)
	{
		if (scriptName==right.scriptName)
			return true;

		return false;
	}
};

struct PropertyData
{
	char     name[256];
	char     value[256];
	PropType type;
};

class DynScriptPreprocessor: public PropTagParser
{
	HANDLE       hMemNode;						// Handle to shared memory containing node
	INode**      pMemNode;						// Pointer to shared memory for node

	HANDLE       hMemPropDataSize;				// Handle to shared memory containing property data size
	int*         pMemPropDataSize;				// Pointer to shared memory for the property data size

	HANDLE       hMemPropData;					// Handle to shared memory containing actual property data
	char*        pMemPropData;					// Pointer to shared emory for actual property data

	HANDLE       hMemSharedData;				// Handle to shared memory containing general shared data
	SharedData*  pSharedData;					// Pointer to shared memory for general info

	CharStream*  out;
	CStr         scriptName;					// cached script name
	CStr         scriptData;					// cached script data
	CStr         strTemplate;					// The parsed template generated from the MAXScript script
	CStr         strColorTemplate;				// The parsed template in RTF format
	Value*       scriptComp;					// the compiled script

	BOOL         bLock;

protected:
	void     PostMAXScriptData(PropList* plist);
	void     PostMAXScriptData(LinkList<ConfigProp>* cprops,DWORD flags);
	void     BuildTemplate(PropList* plist);
	void     BuildTemplate(LinkList<ConfigProp>* cprops,DWORD flags);
	void     ReplaceFlags(CStr& buf,CStr& colorbuf,DWORD flags,DWORD mask,CStr name);
	void     FlushMemMaps();

	LinkList<ScriptBuf> scriptBuffers;

public:
	DynScriptPreprocessor();
	~DynScriptPreprocessor();

	void   AllocMemMaps();

	bool   LoadScript(char* filename);
	void   ClearAltScripts();
	void   UpdateDynUIScripts(PropList* plist,CStr strScript);	// Updates DynUI templates through MAXScript
	void   UpdateDynUIScripts(LinkList<ConfigProp>* cprops,DWORD flags,CStr strScript);
	CStr   GetTemplateScript(Link<ScriptBuf>* buf,LinkList<ConfigProp>* cprops);

	CStr   RetrieveMAXScriptData();
	void   RetrieveExtMAXScriptData();

	void   RetrieveMAXScriptValues(PropList* plist);

	void   DumpAltDynScripts(FILE* fp){}
	void   PostMAXScriptNode(INode* node);
	void   AssignSharedData();
	void   AssignSharedParticleMax(int max);
	void   AssignEmitScript(char* buf);

	inline CStr GetTemplate()      { return strTemplate;      }
	inline CStr GetColorTemplate() { return strColorTemplate; }
};

#endif
