/*
	MultiSearch.h
	The multi search dialog window

	Adam Lippmann
	12-20-01
*/

#ifndef __MULTISEARCH__
#define __MULTISEARCH__

#include "PropEdit.h"
#include "../UI/MSWindow.h"

class PropEditor;

enum MSearchMode
{
	MSEARCH_SEARCH,		// Perform search only
	MSEARCH_REPLACE,	// Perform search and replace
};

class MSearchDlg: public MSDlgWindow
{
	MSearchMode mode;		// If we are doing searches or replacements
	Interface*  ip;			// MAX Interface pointer
	PropEditor* pPropEdit;	// Pointer to the Property Editor class

	bool        bAbort;		// True if the multisearch is being aborted
	bool        bReplaceAll;// True if the user has pressed the ReplaceAll button
	
	int         ProcIndex;	// Index into the multisearch list box specifying
							//		what selection node we're currently processing

	int         ListCount;	// Number of items in list

	INode*      LastNode;	// The last node retrieved by GetNextSelNode

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	static void ReplaceAllPressed(void* pData);
	static void ReplaceComplete(void* pData);
	static void SearchComplete(void* pData);
	static void SearchCancelled(void* pData);

	INode* GetNextSelNode();

	void Search();
	void Replace();

public:
	MSearchDlg(Interface* ip,PropEditor* pPropEdit,HINSTANCE hInstance,HWND hwndParent,MSearchMode mode);
	~MSearchDlg();
};

#endif
