/*
	find.cpp
	Traverses directory trees initiating a callback for each wildcard matched file
	From my aniqngen code
	9-9-02 aml
*/

#include <io.h>
#include <sys/stat.h>
#include <direct.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

void LCase(char* str)
{
	int len=strlen(str);

	for(int i=0;i<len;i++)
		str[i]=tolower(str[i]);
}

void Find(char* path,char* prefix,void (*fpCallback)(char* filename,void* data),void* pData)
{
	_finddata_t fdata;
	_chdir(path);

	char WorkingDir[256];
	_getcwd(WorkingDir,255);

	long hFindFirst=_findfirst("*.*",&fdata);

	if (hFindFirst==-1)
		return;

	int  hFile=0;

	while(hFile!=-1)
	{
		if (fdata.attrib & _A_SUBDIR)
		{
			if (strcmp(fdata.name,".")==0 ||
				strcmp(fdata.name,"..")==0)
			{
				hFile=_findnext(hFindFirst,&fdata);
				continue;
			}

			Find(fdata.name,prefix,fpCallback,pData);
			_chdir(WorkingDir);
		}

		char strLName[256];
		char strLPrefix[256];

		strcpy(strLName,fdata.name);
		strcpy(strLPrefix,prefix);

		LCase(strLName);
		LCase(strLPrefix);

		if (strstr(strLName,strLPrefix))
			fpCallback(fdata.name,pData);

		hFile=_findnext(hFindFirst,&fdata);
	}

	_findclose(hFindFirst);
}

void FindFull(char* path,char* prefix,void (*fpCallback)(char* filename,void* data),void* pData)
{
	_finddata_t fdata;
	_chdir(path);

	char WorkingDir[256];
	_getcwd(WorkingDir,255);

	long hFindFirst=_findfirst("*.*",&fdata);

	if (hFindFirst==-1)
		return;

	int  hFile=0;

	while(hFile!=-1)
	{
		if (fdata.attrib & _A_SUBDIR)
		{
			if (strcmp(fdata.name,".")==0 ||
				strcmp(fdata.name,"..")==0)
			{
				hFile=_findnext(hFindFirst,&fdata);
				continue;
			}

			FindFull(fdata.name,prefix,fpCallback,pData);
			_chdir(WorkingDir);
		}

		char strLName[256];
		char strLPrefix[256];

		strcpy(strLName,fdata.name);
		strcpy(strLPrefix,prefix);

		LCase(strLName);
		LCase(strLPrefix);

		if (strstr(strLName,strLPrefix))
		{
			char bufFilename[1024];
			strcpy(bufFilename,WorkingDir);
			strcat(bufFilename,"\\");
			strcat(bufFilename,fdata.name);

			fpCallback(bufFilename,pData);
		}

		hFile=_findnext(hFindFirst,&fdata);
	}

	_findclose(hFindFirst);
}
